/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.Serializable;
import java.util.Vector;

public class HexFieldDescription
extends FieldDescription
implements VariableLengthFieldDescription,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int variableLength_;
    private boolean isVariableLength_;

    public HexFieldDescription() {
    }

    public HexFieldDescription(AS400ByteArray dataType, String name) {
        super(dataType, name);
    }

    public HexFieldDescription(AS400ByteArray dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
    }

    String[] getDDSDescription() {
        Vector<String> v = new Vector<String>();
        StringBuffer desc = new StringBuffer(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        String len = String.valueOf(this.length_);
        int numSpaces = 5 - len.length();
        for (int i = 0; i < numSpaces; ++i) {
            desc.append(' ');
        }
        desc.append(len);
        desc.append("H");
        desc.append("  ");
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (this.isVariableLength_) {
            if (this.variableLength_ > 0) {
                v.addElement("VARLEN(" + new Integer(this.variableLength_).toString() + ") ");
            } else {
                v.addElement("VARLEN ");
            }
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT('" + new String((byte[])this.defaultValue_) + "') ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public int getVARLEN() {
        return this.variableLength_;
    }

    public boolean isVariableLength() {
        return this.isVariableLength_;
    }

    public void setDataType(AS400ByteArray dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getByteLength();
    }

    public void setDFT(byte[] defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        if (defaultValue.length < 1) {
            throw new ExtendedIllegalArgumentException("defaultValue (" + String.valueOf(defaultValue) + ")", 1);
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setVariableLength(boolean value) {
        this.isVariableLength_ = value;
    }

    public void setVARLEN(int varLen) {
        if (varLen < 0) {
            throw new ExtendedIllegalArgumentException("varLen (" + String.valueOf(varLen) + ")", 2);
        }
        this.variableLength_ = varLen;
        this.isVariableLength_ = true;
    }
}

