/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileOutputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class IFSFileOutputStreamImplRemote
extends OutputStream
implements IFSFileOutputStreamImpl {
    private boolean append_ = false;
    private IFSFileDescriptorImplRemote fd_;
    private transient ConverterImplRemote converter_;
    private static final boolean DEBUG = false;

    IFSFileOutputStreamImplRemote() {
    }

    public void close() throws IOException {
        this.fd_.close0();
    }

    public void connectAndOpen(int ccsid) throws AS400SecurityException, IOException {
        this.fd_.connect();
        if (ccsid == -1) {
            this.open(this.fd_.getPreferredCCSID());
        } else {
            this.open(ccsid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            block4: {
                try {
                    if (this.fd_ == null) break block4;
                    this.fd_.finalize0();
                }
                catch (Throwable e) {
                    Trace.log(2, "Error during finalization.", e);
                    Object var3_2 = null;
                    super.finalize();
                    return;
                }
            }
            Object var3_1 = null;
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.finalize();
            throw throwable;
        }
    }

    public void flush() throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        try {
            this.fd_.flush();
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public IFSKey lock(long length) throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        try {
            return this.fd_.lock(length);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void open(int fileDataCCSID) throws IOException {
        if (this.fd_.isOpen_) {
            return;
        }
        if (!this.fd_.isOpenAllowed_) {
            throw new ConnectionDroppedException(3);
        }
        String path = this.fd_.getPath();
        if (path.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, "Security exception", (Throwable)e);
            throw new ExtendedIOException(5);
        }
        byte[] pathname = this.fd_.getConverter().stringToByteArray(path);
        if (fileDataCCSID == -1) {
            fileDataCCSID = this.fd_.getPreferredCCSID();
        }
        IFSOpenReq req = new IFSOpenReq(pathname, this.fd_.getPreferredCCSID(), fileDataCCSID, 2, ~this.fd_.getShareOption(), 0, this.append_ ? 1 : 2, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        if (ds instanceof IFSOpenRep) {
            IFSOpenRep rep = (IFSOpenRep)ds;
            this.fd_.setOpen(true, rep.getFileHandle());
            this.fd_.setOpenAllowed(false);
            if (this.append_) {
                this.fd_.setFileOffset(rep.getFileSize(this.fd_.serverDatastreamLevel_));
            }
        } else {
            if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc == 1) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                    throw new ExtendedIOException(32);
                }
                Trace.log(2, "IFSReturnCodeRep return code", rc);
                throw new ExtendedIOException(rc);
            }
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
    }

    public void setAppend(boolean append) {
        this.append_ = append;
    }

    public void setFD(IFSFileDescriptorImpl fd) {
        this.fd_ = IFSFileDescriptorImplRemote.castImplToImplRemote(fd);
    }

    public void unlock(IFSKey key) throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        try {
            this.fd_.unlock(key);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        this.write(data, 0, 1);
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int dataOffset, int length) throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        int fileHandle = this.fd_.getFileHandle();
        if (this.append_) {
            IFSListAttrsReq req = new IFSListAttrsReq(fileHandle);
            ClientAccessDataStream ds = null;
            try {
                ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost");
                this.fd_.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted", (Throwable)e);
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
            if (ds instanceof IFSListAttrsRep) {
                IFSListAttrsRep rep = (IFSListAttrsRep)ds;
                this.fd_.setFileOffset(rep.getSize(this.fd_.serverDatastreamLevel_));
            } else if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                    throw new ExtendedIOException(rc);
                }
            } else {
                Trace.log(2, "Unknown reply data stream", ds.data_);
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
        }
        try {
            this.fd_.writeBytes(data, dataOffset, length);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void writeText(String data, int ccsid) throws IOException {
        this.open(ccsid);
        if (this.converter_ == null) {
            int fileCCSID = 0;
            if (ccsid == -1) {
                try {
                    ClientAccessDataStream ds = null;
                    IFSListAttrsReq req = new IFSListAttrsReq(this.fd_.getFileHandle(), 2, 0, 0);
                    ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
                    boolean done = false;
                    boolean gotCCSID = false;
                    do {
                        if (ds instanceof IFSListAttrsRep) {
                            if (Trace.traceOn_ && gotCCSID) {
                                Trace.log(1, "Received multiple replies from ListAttributes request.");
                            }
                            fileCCSID = ((IFSListAttrsRep)ds).getCCSID(this.fd_.serverDatastreamLevel_);
                            gotCCSID = true;
                        } else if (ds instanceof IFSReturnCodeRep) {
                            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                            if (rc != 18 && rc != 0) {
                                Trace.log(2, "IFSReturnCodeRep return code", rc);
                                throw new ExtendedIOException(rc);
                            }
                        } else {
                            Trace.log(2, "Unknown reply data stream", ds.data_);
                            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                        }
                        done = ((IFSDataStream)ds).isEndOfChain();
                        if (done) continue;
                        try {
                            ds = (ClientAccessDataStream)this.fd_.getServer().receive(req.getCorrelation());
                        }
                        catch (ConnectionDroppedException e) {
                            Trace.log(2, "Byte stream server connection lost.");
                            this.fd_.connectionDropped(e);
                        }
                        catch (InterruptedException e) {
                            Trace.log(2, "Interrupted");
                            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                            try {
                                throwException.initCause(e);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            throw throwException;
                        }
                    } while (!done);
                    if (!gotCCSID || fileCCSID == 0) {
                        Trace.log(2, "Unable to determine CCSID of file " + this.fd_.path_);
                        throw new ExtendedIOException(25);
                    }
                }
                catch (ConnectionDroppedException e) {
                    this.fd_.connectionDropped(e);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted", (Throwable)e);
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    try {
                        throwException.initCause(e);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwException;
                }
                ccsid = fileCCSID;
            }
            this.converter_ = ConverterImplRemote.getConverter(ccsid, this.fd_.getSystem());
        }
        this.write(this.converter_.stringToByteArray(data));
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

