/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class IFSJavaFile
extends File
implements Serializable {
    static final long serialVersionUID = 4L;
    private IFSFile ifsFile_ = new IFSFile();
    private static final char AS400_SEPARATOR = '/';
    private static final String URL_PROTOCOL = "file";
    private static final boolean replace_ = '/' != separatorChar;
    private boolean absolute_;

    public IFSJavaFile() {
        this(separator);
        this.absolute_ = false;
    }

    private IFSJavaFile(String path) {
        super(path);
        try {
            this.ifsFile_.setPath(replace_ ? path.replace(separatorChar, '/') : path);
            this.absolute_ = IFSJavaFile.isAbsolutePath(path);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private IFSJavaFile(String path, String name) {
        super(path, name);
        try {
            String canon = this.canonicalizeDirectory(path) + name;
            this.ifsFile_.setPath(replace_ ? canon.replace(separatorChar, '/') : canon);
            this.absolute_ = IFSJavaFile.isAbsolutePath(canon);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public IFSJavaFile(AS400 system, String path) {
        this(path);
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(system);
        this.absolute_ = IFSJavaFile.isAbsolutePath(path);
    }

    public IFSJavaFile(AS400 system, String path, String name) {
        this(path, name);
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(system);
        this.absolute_ = IFSJavaFile.isAbsolutePath(path);
    }

    public IFSJavaFile(IFSJavaFile directory, String name) {
        this();
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        String directoryPath = directory.getPath();
        try {
            String canon = this.canonicalizeDirectory(directoryPath) + name;
            this.ifsFile_.setPath(replace_ ? canon.replace(separatorChar, '/') : canon);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        AS400 localSystem = directory.getSystem();
        if (localSystem != null) {
            this.setSystem(localSystem);
        }
        this.absolute_ = directory.isAbsolute();
    }

    public IFSJavaFile(AS400 system, IFSJavaFile directory, String name) {
        this(directory, name);
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(system);
        this.absolute_ = directory.isAbsolute();
    }

    public IFSJavaFile(IFSFile file) {
        super(file.getPath(), file.getName());
        this.ifsFile_ = file;
        this.absolute_ = true;
    }

    private String canonicalizeDirectory(String directory) {
        int separatorIndex = directory.length() - separator.length();
        if (!directory.substring(separatorIndex).equals(separator)) {
            directory = directory + separator;
        }
        return directory;
    }

    public boolean canExecute() throws SecurityException {
        try {
            return this.ifsFile_.canExecute();
        }
        catch (IOException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public boolean canRead() throws SecurityException {
        try {
            return this.ifsFile_.canRead();
        }
        catch (IOException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public boolean canWrite() throws SecurityException {
        try {
            return this.ifsFile_.canWrite();
        }
        catch (IOException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public int compareTo(IFSJavaFile file) {
        return this.getPath().compareTo(file.getPath());
    }

    public int compareTo(File file) {
        return this.getPath().compareTo(file.getPath());
    }

    public int compareTo(IFSFile file) {
        return this.getPath().compareTo(file.getPath());
    }

    public boolean createNewFile() throws IOException {
        return this.ifsFile_.createNewFile();
    }

    public boolean delete() throws SecurityException {
        try {
            int returnCode = this.ifsFile_.delete0();
            if (returnCode == 5 || returnCode == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(returnCode)));
            }
            return returnCode == 0;
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IFSJavaFile)) {
            return false;
        }
        IFSFile otherIfsFile = ((IFSJavaFile)obj).getIfsFile();
        return this.ifsFile_.equals(otherIfsFile);
    }

    public boolean exists() throws SecurityException {
        int returnCode = 2;
        try {
            returnCode = this.ifsFile_.exists0();
            if (returnCode == 5 || returnCode == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(returnCode)));
            }
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
        return returnCode == 0;
    }

    public File getAbsoluteFile() {
        if (this.getSystem() != null) {
            return new IFSJavaFile(this.getSystem(), this.getAbsolutePath());
        }
        return new IFSJavaFile(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        String pathString = this.ifsFile_.getAbsolutePath();
        if (pathString != null && replace_) {
            return pathString.replace('/', separatorChar);
        }
        return pathString;
    }

    public File getCanonicalFile() throws IOException {
        if (this.getSystem() != null) {
            return new IFSJavaFile(this.getSystem(), this.getCanonicalPath());
        }
        return new IFSJavaFile(this.getCanonicalPath());
    }

    public String getCanonicalPath() throws IOException {
        String pathString = this.ifsFile_.getCanonicalPath();
        if (pathString != null && replace_) {
            return pathString.replace('/', separatorChar);
        }
        return pathString;
    }

    public long getFreeSpace() throws SecurityException {
        try {
            return this.ifsFile_.getAvailableSpace(false);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return 0L;
        }
    }

    public long getTotalSpace() throws SecurityException {
        try {
            return this.ifsFile_.getTotalSpace(false);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return 0L;
        }
    }

    public long getUsableSpace() throws SecurityException {
        try {
            return this.ifsFile_.getAvailableSpace(true);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return 0L;
        }
    }

    IFSFile getIfsFile() {
        return this.ifsFile_;
    }

    public String getName() {
        return this.ifsFile_.getName();
    }

    public String getParent() {
        String parentString = this.ifsFile_.getParent();
        if (parentString != null && replace_) {
            return parentString.replace('/', separatorChar);
        }
        return parentString;
    }

    public File getParentFile() {
        if (this.getParent() == null) {
            return null;
        }
        if (this.getSystem() != null) {
            return new IFSJavaFile(this.getSystem(), this.getParent());
        }
        return new IFSJavaFile(this.getParent());
    }

    public String getPath() {
        String pathString = this.ifsFile_.getPath();
        if (pathString != null && replace_) {
            return pathString.replace('/', separatorChar);
        }
        return pathString;
    }

    public int getPatternMatching() throws IOException {
        return this.ifsFile_.getPatternMatching();
    }

    public AS400 getSystem() {
        return this.ifsFile_.getSystem();
    }

    public int hashCode() {
        return this.ifsFile_.hashCode();
    }

    public boolean isAbsolute() {
        return this.absolute_;
    }

    static boolean isAbsolutePath(String path) {
        return path != null && path.length() != 0 && path.charAt(0) == separatorChar;
    }

    public boolean isDirectory() throws SecurityException {
        int returnCode = 2;
        try {
            returnCode = this.ifsFile_.isDirectory0();
            if (returnCode == 5 || returnCode == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(returnCode)));
            }
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
        return returnCode == 0;
    }

    public boolean isFile() throws SecurityException {
        int returnCode = 2;
        try {
            returnCode = this.ifsFile_.isFile0();
            if (returnCode == 5 || returnCode == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(returnCode)));
            }
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
        return returnCode == 0;
    }

    public boolean isHidden() throws SecurityException {
        try {
            return this.ifsFile_.isHidden();
        }
        catch (AS400SecurityException e) {
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public long lastModified() throws SecurityException {
        try {
            return this.ifsFile_.lastModified0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return 0L;
        }
    }

    public long length() throws SecurityException {
        try {
            if (this.ifsFile_.isSymbolicLink()) {
                this.ifsFile_.clearCachedAttributes();
            }
            return this.ifsFile_.length0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return 0L;
        }
    }

    public String[] list() throws SecurityException {
        try {
            return this.ifsFile_.list0(null, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return new String[0];
        }
    }

    public String[] list(FilenameFilter filter) throws SecurityException {
        String[] names = null;
        try {
            names = this.ifsFile_.list0(null, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return null;
        }
        if (names == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < names.length; ++i) {
            if (filter != null && !filter.accept(this, names[i])) continue;
            v.addElement(names[i]);
        }
        Object[] files = new String[v.size()];
        v.copyInto(files);
        return files;
    }

    public String[] list(IFSFileFilter filter) throws SecurityException {
        try {
            return this.ifsFile_.list0(filter, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return new String[0];
        }
    }

    public String[] list(IFSFileFilter filter, String pattern) throws SecurityException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.ifsFile_.list0(filter, pattern);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return new String[0];
        }
    }

    public String[] list(String pattern) throws SecurityException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.ifsFile_.list0(null, pattern);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return new String[0];
        }
    }

    public File[] listFiles() throws SecurityException {
        return this.listFiles(null, "*");
    }

    public File[] listFiles(FilenameFilter filter) throws SecurityException {
        IFSFile[] files = null;
        try {
            files = this.ifsFile_.listFiles0(null, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return null;
        }
        if (files == null) {
            return null;
        }
        Vector<IFSJavaFile> v = new Vector<IFSJavaFile>();
        for (int i = 0; i < files.length; ++i) {
            if (filter != null && !filter.accept(this, files[i].getName())) continue;
            v.addElement(new IFSJavaFile(files[i]));
        }
        Object[] newFiles = new IFSJavaFile[v.size()];
        v.copyInto(newFiles);
        return newFiles;
    }

    public File[] listFiles(FileFilter filter) throws SecurityException {
        IFSFile[] files = null;
        try {
            files = this.ifsFile_.listFiles0(null, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return null;
        }
        if (files == null) {
            return null;
        }
        Vector<IFSJavaFile> v = new Vector<IFSJavaFile>();
        for (int i = 0; i < files.length; ++i) {
            IFSJavaFile file = new IFSJavaFile(files[i]);
            if (filter != null && !filter.accept(file)) continue;
            v.addElement(file);
        }
        Object[] newFiles = new IFSJavaFile[v.size()];
        v.copyInto(newFiles);
        return newFiles;
    }

    public File[] listFiles(IFSFileFilter filter) throws SecurityException {
        return this.listFiles(filter, "*");
    }

    public File[] listFiles(IFSFileFilter filter, String pattern) throws SecurityException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            IFSFile[] files = this.ifsFile_.listFiles0(filter, pattern);
            File[] newFiles = new IFSJavaFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                newFiles[i] = new IFSJavaFile(files[i]);
            }
            return newFiles;
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return new IFSJavaFile[0];
        }
    }

    public File[] listFiles(String pattern) throws SecurityException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        return this.listFiles(null, pattern);
    }

    public static File[] listRoots() {
        File[] roots = new IFSJavaFile[]{new IFSJavaFile(File.separator)};
        return roots;
    }

    private String mapRC(int returnCode) {
        if (returnCode == 5) {
            return "EXC_ACCESS_DENIED";
        }
        if (returnCode == 13) {
            return "EXC_REQUEST_DENIED";
        }
        return "EXC_UNKNOWN";
    }

    public boolean mkdir() throws SecurityException {
        int returnCode = 2;
        try {
            returnCode = this.ifsFile_.mkdir0(this.ifsFile_.getAbsolutePath());
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
        return returnCode == 0;
    }

    public boolean mkdirs() throws SecurityException {
        int returnCode = 2;
        try {
            returnCode = this.ifsFile_.mkdirs0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
        return returnCode == 0;
    }

    public boolean renameTo(IFSJavaFile dest) throws SecurityException {
        if (dest == null) {
            throw new NullPointerException("dest");
        }
        int returnCode = 2;
        IFSFile lFile = new IFSFile();
        try {
            lFile.setSystem(dest.getSystem());
            String destPath = dest.getPath();
            lFile.setPath(replace_ ? destPath.replace(separatorChar, '/') : destPath);
            returnCode = this.ifsFile_.renameTo0(lFile);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (PropertyVetoException e) {
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
        return returnCode == 0;
    }

    public boolean renameTo(File dest) throws SecurityException {
        try {
            return this.renameTo((IFSJavaFile)dest);
        }
        catch (ClassCastException e) {
            Trace.log(2, e);
            return false;
        }
    }

    public boolean setLastModified(long time) throws SecurityException {
        try {
            return this.ifsFile_.setLastModified0(time);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public boolean setLength(int length) throws SecurityException {
        try {
            return this.ifsFile_.setLength0(length);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public boolean setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        try {
            this.ifsFile_.setPath(replace_ ? path.replace(separatorChar, '/') : path);
            this.absolute_ = IFSJavaFile.isAbsolutePath(path);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return true;
    }

    public void setPatternMatching(int patternMatching) throws IOException {
        this.ifsFile_.setPatternMatching(patternMatching);
    }

    public boolean setReadOnly() throws SecurityException {
        try {
            return this.ifsFile_.setReadOnly0(true);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public boolean setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        try {
            this.ifsFile_.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return true;
    }

    public boolean setExecutable(boolean executable) throws SecurityException {
        return this.setExecutable(executable, true);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) throws SecurityException {
        try {
            return this.ifsFile_.setAccess(1, executable, ownerOnly);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public boolean setReadable(boolean readable) throws SecurityException {
        return this.setReadable(readable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) throws SecurityException {
        try {
            return this.ifsFile_.setAccess(4, readable, ownerOnly);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public boolean setWritable(boolean writable) throws SecurityException {
        return this.setWritable(writable, true);
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) throws SecurityException {
        try {
            return this.ifsFile_.setAccess(2, writable, ownerOnly);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, e);
            SecurityException throwException = new SecurityException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        catch (IOException e) {
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            return false;
        }
    }

    public String toString() {
        if (replace_) {
            return this.ifsFile_.toString().replace('/', separatorChar);
        }
        return this.ifsFile_.toString();
    }

    public URL toURL() throws MalformedURLException {
        String objectName = null;
        objectName = this.isDirectory() ? this.getAbsolutePath() + separatorChar : this.getAbsolutePath();
        return new URL(URL_PROTOCOL, this.getSystem().getSystemName(), objectName);
    }
}

