/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSRandomAccessFileImpl;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UTFDataFormatException;

class IFSRandomAccessFileImplRemote
implements IFSRandomAccessFileImpl {
    private int existenceOption_;
    private IFSFileDescriptorImplRemote fd_;
    private String mode_ = "";
    private boolean forceToStorage_ = false;
    private transient byte[] readCache_ = new byte[4096];
    private transient int readCacheIndex_;
    private transient int readCacheLength_;
    private static final int[] twoToThe = new int[]{1, 2, 4, 8, 16};

    IFSRandomAccessFileImplRemote() {
    }

    public void close() throws IOException {
        this.fd_.close0();
    }

    public void connectAndOpen() throws AS400SecurityException, IOException {
        this.fd_.connect();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            block4: {
                try {
                    if (this.fd_ == null) break block4;
                    this.fd_.finalize0();
                }
                catch (Throwable e) {
                    Trace.log(2, "Error during finalization.", e);
                    Object var3_2 = null;
                    super.finalize();
                    return;
                }
            }
            Object var3_1 = null;
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.finalize();
            throw throwable;
        }
    }

    public void flush() throws IOException {
        this.open();
        try {
            this.fd_.flush();
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
    }

    private long getFilePointer() throws IOException {
        this.open();
        return this.fd_.getFileOffset();
    }

    public long length() throws IOException {
        this.open();
        IFSListAttrsRep reply = null;
        IFSListAttrsReq req = new IFSListAttrsReq(this.fd_.getFileHandle());
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost");
            this.fd_.setServer(null);
            throw e;
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        boolean done = false;
        do {
            if (reply == null && ds instanceof IFSListAttrsRep) {
                reply = (IFSListAttrsRep)ds;
            } else if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc != 18) {
                    throw new ExtendedIOException(rc);
                }
            } else {
                Trace.log(2, "Unknown reply data stream", ds.data_);
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
            done = ((IFSDataStream)ds).isEndOfChain();
            if (done) continue;
            try {
                ds = (ClientAccessDataStream)this.fd_.getServer().receive(req.getCorrelation());
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost");
                this.fd_.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted", (Throwable)e);
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        } while (!done);
        if (reply == null) {
            Trace.log(2, "no reply available");
            throw new InternalErrorException(6);
        }
        return reply.getSize(this.fd_.serverDatastreamLevel_);
    }

    public IFSKey lock(long offset, long length) throws IOException {
        this.open();
        try {
            return this.fd_.lock(offset, length);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void open() throws IOException {
        if (this.fd_.isOpen_) {
            return;
        }
        if (!this.fd_.isOpenAllowed_) {
            Trace.log(2, "Attempting to re-open a closed stream.");
            throw new ConnectionDroppedException(3);
        }
        String path = this.fd_.getPath();
        if (path.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        if (this.mode_.length() == 0) {
            throw new ExtendedIllegalStateException("mode", 4);
        }
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)e);
            throw new ExtendedIOException(5);
        }
        byte[] pathname = this.fd_.getConverter().stringToByteArray(path);
        int accessIntent = 0;
        if (this.mode_.indexOf(114) != -1) {
            accessIntent |= 1;
        }
        if (this.mode_.indexOf(119) != -1) {
            accessIntent |= 2;
        }
        int preferredCCSID = this.fd_.getPreferredCCSID();
        IFSOpenReq req = new IFSOpenReq(pathname, preferredCCSID, preferredCCSID, accessIntent, ~this.fd_.getShareOption(), 0, twoToThe[this.existenceOption_], this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost");
            this.fd_.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
        if (!(ds instanceof IFSOpenRep)) {
            if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc == 2 || rc == 3) {
                    Trace.log(2, path + " not found.");
                    throw new FileNotFoundException(path);
                }
                if (rc == 1) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                    throw new ExtendedIOException(32);
                }
                Trace.log(2, "IFSReturnCodeRep return code", rc);
                throw new ExtendedIOException(rc);
            }
            if (ds == null) {
                Trace.log(2, "Null data stream");
                throw new InternalErrorException("null", 2);
            }
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
        IFSOpenRep rep = (IFSOpenRep)ds;
        this.fd_.setOpen(true, rep.getFileHandle());
        this.fd_.setOpenAllowed(false);
    }

    private int read(byte[] data, int dataOffset, int length) throws IOException, AS400SecurityException {
        this.open();
        int bytesRead = this.fd_.read(data, dataOffset, length);
        return bytesRead;
    }

    public int read(byte[] data, int dataOffset, int length, boolean readFully) throws IOException {
        try {
            if (!readFully) {
                return this.read(data, dataOffset, length);
            }
            int totalBytesRead = 0;
            while (totalBytesRead < length) {
                int bytesRead = this.read(data, dataOffset + totalBytesRead, length - totalBytesRead);
                if (bytesRead > 0) {
                    totalBytesRead += bytesRead;
                }
                if (totalBytesRead == data.length) continue;
                try {
                    Thread.sleep(64L);
                }
                catch (Exception e) {}
            }
            return totalBytesRead;
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    private int readFromCache() throws IOException {
        int bytesInCache = this.readCacheLength_ - this.readCacheIndex_;
        if (bytesInCache == 0) {
            try {
                this.readCacheLength_ = this.read(this.readCache_, 0, this.readCache_.length);
            }
            catch (AS400SecurityException e) {
                IOException throwException = new IOException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
            if (this.readCacheLength_ == -1) {
                return -1;
            }
            this.readCacheIndex_ = 0;
        }
        return this.readCache_[this.readCacheIndex_++];
    }

    public final synchronized String readLine() throws IOException {
        int nextByte;
        StringBuffer line = new StringBuffer();
        this.readCacheLength_ = 0;
        this.readCacheIndex_ = 0;
        boolean done = false;
        while (!done && (nextByte = this.readFromCache()) != -1) {
            line.append((char)nextByte);
            if (nextByte == 10) {
                done = true;
                continue;
            }
            if (nextByte != 13) continue;
            int i = this.readFromCache();
            if (i == 10) {
                line.append((char)i);
            } else {
                --this.readCacheIndex_;
            }
            done = true;
        }
        int bytesInCache = this.readCacheLength_ - this.readCacheIndex_;
        if (bytesInCache > 0) {
            this.fd_.setFileOffset((int)this.getFilePointer() - bytesInCache);
        }
        return line.length() == 0 ? null : line.toString();
    }

    public final String readUTF() throws IOException {
        try {
            byte[] data;
            byte[] bytes2 = new byte[2];
            int bytesRead = this.read(bytes2, 0, 2);
            if (bytesRead != 2) {
                throw new EOFException();
            }
            int length = (bytes2[0] & 0xFF) << 8 | bytes2[1] & 0xFF;
            if (length < 0) {
                length += 65536;
            }
            if (this.read(data = new byte[length], 0, length) != length) {
                throw new EOFException();
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length) {
                char c;
                if ((data[i] & 0x80) == 0) {
                    sb.append((char)data[i]);
                    ++i;
                    continue;
                }
                if ((data[i] & 0xE0) == 192) {
                    if (i + 1 < length) {
                        c = (char)((data[i] & 0x1F) << 6 | data[i + 1] & 0x3F);
                        sb.append(c);
                        i += 2;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                if ((data[i] & 0xE0) == 224) {
                    if (i + 2 < length) {
                        c = (char)((data[i] & 0xF) << 12 | (data[i + 1] & 0x3F) << 6 | data[i + 2] & 0x3F);
                        sb.append(c);
                        i += 3;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                throw new UTFDataFormatException();
            }
            return sb.toString();
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void seek(long position) throws IOException {
        this.open();
        this.fd_.setFileOffset((int)position);
    }

    public void setExistenceOption(int existenceOption) {
        if (this.fd_.isOpen_) {
            throw new ExtendedIllegalStateException("existenceOption", 5);
        }
        this.existenceOption_ = existenceOption;
    }

    public void setFD(IFSFileDescriptorImpl fd) {
        this.fd_ = IFSFileDescriptorImplRemote.castImplToImplRemote(fd);
    }

    public void setForceToStorage(boolean forceToStorage) {
        this.forceToStorage_ = forceToStorage;
    }

    public void setLength(long length) throws IOException {
        try {
            this.fd_.setLength(length);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setMode(String mode) {
        if (this.fd_.isOpen_) {
            throw new ExtendedIllegalStateException("mode", 5);
        }
        this.mode_ = mode;
    }

    public void unlock(IFSKey key) throws IOException {
        this.open();
        try {
            this.fd_.unlock(key);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void writeBytes(byte[] data, int dataOffset, int length) throws IOException {
        this.open();
        try {
            this.fd_.writeBytes(data, dataOffset, length, this.forceToStorage_);
        }
        catch (AS400SecurityException e) {
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public final void writeUTF(String s) throws IOException {
        byte[] data = new byte[s.length() * 3];
        int j = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u0000') {
                data[j] = -64;
                data[j + 1] = -128;
                j += 2;
                continue;
            }
            if (c >= '\u0001' && c <= '\u007f') {
                data[j] = (byte)c;
                ++j;
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff') {
                data[j] = (byte)(0xC0 | (c & 0x7C0) >>> 6);
                data[j + 1] = (byte)(0x80 | c & 0x3F);
                j += 2;
                continue;
            }
            data[j] = (byte)(0xE0 | (c & 0xF000) >>> 4);
            data[j + 1] = (byte)(0x80 | (c & 0xFC0) >>> 6);
            data[j + 2] = (byte)(0x80 | c & 0x3F);
            j += 3;
        }
        byte[] bytes2 = new byte[2];
        bytes2[1] = (byte)j;
        bytes2[0] = (byte)(j >>> 8);
        this.writeBytes(bytes2, 0, 2);
        this.writeBytes(data, 0, j);
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

