/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ISeriesNetServerConnection;
import com.ibm.as400.access.ISeriesNetServerFileShare;
import com.ibm.as400.access.ISeriesNetServerPrintShare;
import com.ibm.as400.access.ISeriesNetServerSession;
import com.ibm.as400.access.ISeriesNetServerShare;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JobList;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ISeriesNetServer
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final int ENCRYPTED_PASSWORDS = 0;
    public static final int NETWORK_AUTHENTICATION = 1;
    public static final int KERBEROS_V5_TOKENS = 1;
    public static final int NETWORK_AUTHENTICATION_OR_PASSWORDS = 2;
    public static final int KERBEROS_OR_PASSWORDS = 2;
    public static final int NO_AUTO_DISCONNECT = -1;
    public static final int OPP_LOCK_DISABLED = -1;
    public static final int MSG_AUTH_NOT_SUPPORTED = 0;
    public static final int MSG_AUTH_NEGOTIATED = 1;
    public static final int MSG_AUTH_REQUIRED = 2;
    public static final int NO_ADMIN_ALERTS = -1;
    public static final int PASSWORD_STRONGER = 0;
    public static final int PASSWORD_STRONGER_OR_MISMATCH = 1;
    private static final int BOTH = 2;
    private static final int FILE = 0;
    private static final int PRINT = 1;
    private AS400 system_;
    private int systemVRM_;
    private boolean gotSystemVRM_;
    private static final int ALLOW_SYSTEM_NAME = 0;
    private static final int AUTHENTICATION_METHOD = 1;
    private static final int AUTOSTART = 2;
    private static final int DESCRIPTION = 3;
    private static final int DOMAIN_NAME = 4;
    private static final int GUEST_USER_PROFILE = 5;
    private static final int SERVER_NAME = 6;
    private static final int WINS_PRIMARY_ADDRESS = 7;
    private static final int WINS_SCOPE_ID = 8;
    private static final int WINS_SECONDARY_ADDRESS = 9;
    private static final int BROWSING_INTERVAL = 20;
    private static final int CCSID = 21;
    private static final int IDLE_TIMEOUT = 22;
    private static final int LOGON_SUPPORT = 23;
    private static final int OPP_LOCK_TIMEOUT = 24;
    private static final int WINS_ENABLEMENT = 25;
    private static final int MESSAGE_AUTHENTICATION = 26;
    private static final int MIN_MESSAGE_SEVERITY = 27;
    private static final int LAN_MGR_AUTHENTICATION = 28;
    private static final int MAX_ATTR = 28;
    private static final int ZLSL0101_MAX_RECORD_LENGTH = 1221;
    private String[] effectiveValueStr_ = new String[29];
    private String[] pendingValueStr_ = new String[29];
    private int[] effectiveValueInt_ = new int[29];
    private int[] pendingValueInt_ = new int[29];
    private boolean[] userChangedAttribute_ = new boolean[29];
    private boolean[] userCommittedChange_ = new boolean[29];
    private transient boolean refreshedSinceStart_ = false;
    private boolean changedAutoStartSinceRefresh_ = false;
    private transient boolean determinedSpecialAuthority_ = false;
    private transient boolean userHasSpecialAuthority_ = false;
    private static final boolean DEBUG = false;

    public ISeriesNetServer(AS400 system) {
        if (system == null) {
            throw new NullPointerException();
        }
        this.system_ = system;
    }

    public void createFileShare(String shareName, String path) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createFileShare(shareName, path, "", 1, -1);
    }

    public void createFileShare(String shareName, String path, String desc, int permission) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createFileShare(shareName, path, desc, permission, -1);
    }

    public void createFileShare(String shareName, String path, String desc) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createFileShare(shareName, path, desc, 1, -1);
    }

    public void createFileShare(String shareName, String path, String desc, int permission, int maxUsers) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            throw new NullPointerException("shareName");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (desc == null) {
            desc = "";
        }
        int ccsid = this.system_.getCcsid();
        AS400Text text12 = new AS400Text(12, ccsid);
        AS400Text text50 = new AS400Text(50, ccsid);
        byte[] pathBytes = path.trim().getBytes("UnicodeBigUnmarked");
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(text12.toBytes(shareName.trim())), new ProgramParameter(pathBytes), new ProgramParameter(BinaryConverter.intToByteArray(pathBytes.length)), new ProgramParameter(BinaryConverter.intToByteArray(13488)), new ProgramParameter(text50.toBytes(desc)), new ProgramParameter(BinaryConverter.intToByteArray(permission)), new ProgramParameter(BinaryConverter.intToByteArray(maxUsers)), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSADFS.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    public void createPrintShare(String shareName, String outqLib, String outqName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createPrintShare(shareName, outqLib, outqName, "", 4, null, null, null, false);
    }

    public void createPrintShare(String shareName, String outqLib, String outqName, String desc, int splfType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createPrintShare(shareName, outqLib, outqName, desc, splfType, null, null, null, false);
    }

    public void createPrintShare(String shareName, String outqLib, String outqName, String desc, int splfType, String prtDriver, String prtFileLib, String prtFileName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createPrintShare(shareName, outqLib, outqName, desc, splfType, prtDriver, prtFileLib, prtFileName, false);
    }

    public void createPrintShare(String shareName, String outqLib, String outqName, String desc, int splfType, String prtDriver, String prtFileLib, String prtFileName, boolean publish) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            throw new NullPointerException("shareName");
        }
        if (outqLib == null) {
            throw new NullPointerException("outqLib");
        }
        if (outqName == null) {
            throw new NullPointerException("outqName");
        }
        if (desc == null) {
            desc = "";
        }
        if (splfType < 1 || splfType > 4) {
            throw new ExtendedIllegalArgumentException(Integer.toString(splfType), 2);
        }
        if (prtDriver == null) {
            prtDriver = "";
        }
        if (prtFileLib == null) {
            prtFileLib = "";
        }
        if (prtFileName == null) {
            prtFileName = "";
        }
        int ccsid = this.system_.getCcsid();
        AS400Text text12 = new AS400Text(12, ccsid);
        AS400Text text10 = new AS400Text(10, ccsid);
        AS400Text text50 = new AS400Text(50, ccsid);
        byte[] outqBytes = new byte[20];
        byte[] prtFileBytes = new byte[20];
        byte[] pubBytes = new byte[1];
        text10.toBytes(outqLib, outqBytes, 10);
        text10.toBytes(outqName, outqBytes, 0);
        text10.toBytes(prtFileLib, prtFileBytes, 10);
        text10.toBytes(prtFileName, prtFileBytes, 0);
        pubBytes[0] = publish ? -15 : -16;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(text12.toBytes(shareName.trim())), new ProgramParameter(outqBytes), new ProgramParameter(text50.toBytes(desc)), new ProgramParameter(BinaryConverter.intToByteArray(splfType)), new ProgramParameter(text50.toBytes(prtDriver)), new ErrorCodeParameter(), new ProgramParameter(prtFileBytes), new ProgramParameter(pubBytes)};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSADPS.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private final int getSystemVRM() throws AS400SecurityException, IOException {
        if (!this.gotSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.gotSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    public ISeriesNetServerFileShare[] listFileShares() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (ISeriesNetServerFileShare[])this.listShares(0, null);
    }

    public ISeriesNetServerFileShare[] listFileShares(String shareName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            throw new NullPointerException();
        }
        return (ISeriesNetServerFileShare[])this.listShares(0, shareName);
    }

    public ISeriesNetServerPrintShare[] listPrintShares() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (ISeriesNetServerPrintShare[])this.listShares(1, null);
    }

    public ISeriesNetServerPrintShare[] listPrintShares(String shareName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            throw new NullPointerException();
        }
        return (ISeriesNetServerPrintShare[])this.listShares(1, shareName);
    }

    public ISeriesNetServerShare[] listShares() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (ISeriesNetServerShare[])this.listShares(2, "*ALL");
    }

    private Object listShares(int desiredType, String shareName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            shareName = "*ALL";
        }
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = 8192;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(64), new ProgramParameter(conv.stringToByteArray("ZLSL0101")), new ProgramParameter(text15.toBytes(shareName.trim())), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        byte[] data = parms[0].getOutputData();
        return ISeriesNetServer.parseZLSL0101(data, conv, numRecords, desiredType, null);
    }

    private static int callListProgram(ProgramCall pc, ProgramParameter[] parms, int totalBytesExpected) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] listInfo = parms[2].getOutputData();
        int totalRecordsAvail = BinaryConverter.byteArrayToInt(listInfo, 0);
        int numRecordsReturned = BinaryConverter.byteArrayToInt(listInfo, 4);
        if (Trace.isTraceOn() && numRecordsReturned < totalRecordsAvail) {
            Trace.log(1, "Returned info is incomplete on first API call.");
        }
        while (numRecordsReturned < totalRecordsAvail) {
            int recLength = BinaryConverter.byteArrayToInt(listInfo, 8);
            totalBytesExpected = recLength > 0 ? (totalBytesExpected += recLength * totalRecordsAvail) : (totalBytesExpected *= 1 + totalRecordsAvail / numRecordsReturned);
            try {
                parms[0].setOutputDataLength(totalBytesExpected);
                parms[1].setInputData(BinaryConverter.intToByteArray(totalBytesExpected));
            }
            catch (PropertyVetoException e) {
                Trace.log(2, e);
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            listInfo = parms[2].getOutputData();
            totalRecordsAvail = BinaryConverter.byteArrayToInt(listInfo, 0);
            numRecordsReturned = BinaryConverter.byteArrayToInt(listInfo, 4);
        }
        return numRecordsReturned;
    }

    public ISeriesNetServerSession[] listSessions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.listSessionsForWorkstation("*ALL");
    }

    public ISeriesNetServerSession[] listSessionsForWorkstation(String name) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int vrm = this.getSystemVRM();
        int recordLength = vrm < 393472 ? 64 : 192;
        int len = 20 * recordLength;
        ProgramParameter[] parms = new ProgramParameter[vrm < 393472 ? 6 : 8];
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(64);
        parms[3] = new ProgramParameter(conv.stringToByteArray("ZLSL0300"));
        if (vrm < 393472) {
            parms[4] = new ProgramParameter(text15.toBytes(name));
        } else {
            AS400Text text10 = new AS400Text(10, ccsid);
            AS400Text text50 = new AS400Text(50, ccsid);
            parms[4] = new ProgramParameter(text15.toBytes("*EXPANDED"));
            parms[6] = new ProgramParameter(text10.toBytes("*ALL"));
            parms[7] = new ProgramParameter(text50.toBytes(name));
        }
        parms[5] = new ErrorCodeParameter();
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        byte[] data = parms[0].getOutputData();
        ISeriesNetServerSession[] sessions = new ISeriesNetServerSession[numRecords];
        int offset = 0;
        for (int i = 0; i < numRecords; ++i) {
            ISeriesNetServerSession sess;
            sessions[i] = sess = this.parseZLSL0300(data, offset, conv, null);
            if (this.getSystemVRM() < 393472) {
                offset += 64;
                continue;
            }
            offset += 192;
        }
        return sessions;
    }

    public ISeriesNetServerConnection[] listConnectionsForSession(long sessionID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text10 = new AS400Text(10, ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = 1280;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(64), new ProgramParameter(conv.stringToByteArray("ZLSL0600")), new ProgramParameter(text15.toBytes("*SESSID")), new ErrorCodeParameter(), new ProgramParameter(text10.toBytes("*SESSID")), new ProgramParameter(BinaryConverter.longToByteArray(sessionID))};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        ISeriesNetServerConnection[] connections = new ISeriesNetServerConnection[numRecords];
        int offset = 0;
        byte[] data = parms[0].getOutputData();
        for (int i = 0; i < numRecords; ++i) {
            ISeriesNetServerConnection conn;
            connections[i] = conn = this.parseZLSL0600or0700(data, offset, conv, true, null);
            offset += 64;
        }
        return connections;
    }

    public ISeriesNetServerConnection[] listConnectionsForSession(String workstationName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (workstationName == null) {
            throw new NullPointerException();
        }
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = 1280;
        int vrm = this.getSystemVRM();
        ProgramParameter[] parms = new ProgramParameter[vrm < 393472 ? 6 : 8];
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(64);
        parms[3] = new ProgramParameter(conv.stringToByteArray("ZLSL0600"));
        if (vrm < 393472) {
            parms[4] = new ProgramParameter(text15.toBytes(workstationName));
        } else {
            AS400Text text50 = new AS400Text(50, ccsid);
            AS400Text text10 = new AS400Text(10, ccsid);
            parms[4] = new ProgramParameter(text15.toBytes("*EXPANDED"));
            parms[6] = new ProgramParameter(text10.toBytes("*ALL"));
            parms[7] = new ProgramParameter(text50.toBytes(workstationName));
        }
        parms[5] = new ErrorCodeParameter();
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        ISeriesNetServerConnection[] connections = new ISeriesNetServerConnection[numRecords];
        int offset = 0;
        byte[] data = parms[0].getOutputData();
        for (int i = 0; i < numRecords; ++i) {
            ISeriesNetServerConnection conn;
            connections[i] = conn = this.parseZLSL0600or0700(data, offset, conv, true, null);
            offset += 64;
        }
        return connections;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ISeriesNetServerShare[] parseZLSL0101(byte[] data, CharConverter conv, int numRecords, int desiredType, ISeriesNetServerShare oldShare) {
        ISeriesNetServerShare[] source;
        int entryLength;
        ISeriesNetServerFileShare[] fileShares = desiredType == 0 ? new ISeriesNetServerFileShare[numRecords] : null;
        ISeriesNetServerPrintShare[] printShares = desiredType == 1 ? new ISeriesNetServerPrintShare[numRecords] : null;
        ISeriesNetServerShare[] allShares = desiredType == 2 ? new ISeriesNetServerShare[numRecords] : null;
        int counter = 0;
        int offsetInData = 0;
        for (int recordNum = 0; recordNum < numRecords; offsetInData += entryLength, ++recordNum) {
            boolean isPublished;
            String description;
            String shareName;
            entryLength = BinaryConverter.byteArrayToInt(data, offsetInData + 0);
            int deviceType = BinaryConverter.byteArrayToInt(data, offsetInData + 16);
            int maxUsers = BinaryConverter.byteArrayToInt(data, offsetInData + 24);
            int currentUsers = BinaryConverter.byteArrayToInt(data, offsetInData + 28);
            if (deviceType == 0) {
                if (desiredType != 0 && desiredType != 2) continue;
                shareName = conv.byteArrayToString(data, offsetInData + 4, 12).trim();
                description = conv.byteArrayToString(data, offsetInData + 114, 50).trim();
                int permissions = BinaryConverter.byteArrayToInt(data, offsetInData + 20);
                int pathOffset = BinaryConverter.byteArrayToInt(data, offsetInData + 36);
                int pathLength = BinaryConverter.byteArrayToInt(data, offsetInData + 40);
                String pathName = conv.byteArrayToString(data, pathOffset, pathLength).trim();
                int ccsidForTextConv = BinaryConverter.byteArrayToInt(data, offsetInData + 184);
                String enableTextConv = conv.byteArrayToString(data, offsetInData + 196, 1).trim();
                int extTableOffset = BinaryConverter.byteArrayToInt(data, offsetInData + 188);
                int numExtTableEntries = BinaryConverter.byteArrayToInt(data, offsetInData + 192);
                String[] extensions = new String[numExtTableEntries];
                int offsetToTableEntry = extTableOffset;
                for (int extNum = 0; extNum < numExtTableEntries; offsetToTableEntry += 50, ++extNum) {
                    int extensionLength = BinaryConverter.byteArrayToInt(data, offsetToTableEntry + 0);
                    extensions[extNum] = conv.byteArrayToString(data, offsetToTableEntry + 4, extensionLength).trim();
                }
                if (oldShare != null) {
                    ((ISeriesNetServerFileShare)oldShare).setAttributeValues(shareName, permissions, maxUsers, currentUsers, description, pathName, ccsidForTextConv, enableTextConv, extensions);
                    return null;
                }
                ISeriesNetServerFileShare share = new ISeriesNetServerFileShare(shareName, permissions, maxUsers, currentUsers, description, pathName, ccsidForTextConv, enableTextConv, extensions);
                if (desiredType == 0) {
                    fileShares[counter++] = share;
                    continue;
                }
                allShares[counter++] = share;
                continue;
            }
            if (desiredType != 1 && desiredType != 2) continue;
            shareName = conv.byteArrayToString(data, offsetInData + 4, 12).trim();
            description = conv.byteArrayToString(data, offsetInData + 114, 50).trim();
            int spooledFileType = BinaryConverter.byteArrayToInt(data, offsetInData + 32);
            String outQueue = conv.byteArrayToString(data, offsetInData + 44, 20);
            String printDriverType = conv.byteArrayToString(data, offsetInData + 64, 50).trim();
            String printerFile = conv.byteArrayToString(data, offsetInData + 164, 20);
            String publish = conv.byteArrayToString(data, offsetInData + 197, 1).trim();
            boolean bl = isPublished = publish.equals("1");
            if (oldShare != null) {
                ((ISeriesNetServerPrintShare)oldShare).setAttributeValues(shareName, spooledFileType, outQueue, printDriverType, description, printerFile, isPublished);
                return null;
            }
            ISeriesNetServerPrintShare share = new ISeriesNetServerPrintShare(shareName, spooledFileType, outQueue, printDriverType, description, printerFile, isPublished);
            if (desiredType == 1) {
                printShares[counter++] = share;
                continue;
            }
            allShares[counter++] = share;
        }
        if (desiredType == 2) {
            return allShares;
        }
        ISeriesNetServerShare[] iSeriesNetServerShareArray = source = desiredType == 0 ? fileShares : printShares;
        if (counter >= numRecords) {
            return source;
        }
        ISeriesNetServerShare[] temp = desiredType == 0 ? new ISeriesNetServerFileShare[counter] : new ISeriesNetServerPrintShare[counter];
        System.arraycopy(source, 0, temp, 0, counter);
        return temp;
    }

    private ISeriesNetServerSession parseZLSL0300(byte[] data, int offset, CharConverter conv, ISeriesNetServerSession sess) throws AS400SecurityException, IOException {
        boolean isGuest;
        String workstationName = this.getSystemVRM() < 393472 ? conv.byteArrayToString(data, offset + 0, 15).trim() : conv.byteArrayToString(data, offset + 68, 124).trim();
        String userProfileName = conv.byteArrayToString(data, offset + 15, 10).trim();
        int numberOfConnections = BinaryConverter.byteArrayToInt(data, offset + 28);
        int numberOfFilesOpen = BinaryConverter.byteArrayToInt(data, offset + 32);
        int sessionTime = BinaryConverter.byteArrayToInt(data, offset + 40);
        int sessionIdleTime = BinaryConverter.byteArrayToInt(data, offset + 44);
        String logonType = conv.byteArrayToString(data, offset + 48, 1).trim();
        String encryptedPassword = conv.byteArrayToString(data, offset + 49, 1).trim();
        long sessionID = BinaryConverter.byteArrayToLong(data, offset + 56);
        boolean isPasswordEncrypted = encryptedPassword.equals("1");
        boolean bl = isGuest = logonType.equals("0");
        if (sess == null) {
            sess = new ISeriesNetServerSession(workstationName, sessionID, numberOfConnections, sessionTime, numberOfFilesOpen, sessionIdleTime, isPasswordEncrypted, isGuest, userProfileName);
        } else {
            sess.setAttributeValues(workstationName, sessionID, numberOfConnections, sessionTime, numberOfFilesOpen, sessionIdleTime, isPasswordEncrypted, isGuest, userProfileName);
        }
        return sess;
    }

    private ISeriesNetServerConnection parseZLSL0600or0700(byte[] data, int offset, CharConverter conv, boolean is0600, ISeriesNetServerConnection conn) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int resourceType;
        String resourceName;
        int connectionID = BinaryConverter.byteArrayToInt(data, offset + 0);
        int connectionType = BinaryConverter.byteArrayToInt(data, offset + 4);
        int numberOfFilesOpen = BinaryConverter.byteArrayToInt(data, offset + 8);
        int numberOfConnectionUsers = BinaryConverter.byteArrayToInt(data, offset + 12);
        int connectionTime = BinaryConverter.byteArrayToInt(data, offset + 16);
        String userName = conv.byteArrayToString(data, offset + 20, 10).trim();
        if (is0600) {
            resourceName = conv.byteArrayToString(data, offset + 30, 12).trim();
            resourceType = 1;
        } else {
            resourceName = this.getSystemVRM() < 393472 ? conv.byteArrayToString(data, offset + 30, 15).trim() : conv.byteArrayToString(data, offset + 68, 124).trim();
            resourceType = 0;
        }
        long sessionID = this.getSystemVRM() >= 327936 ? BinaryConverter.byteArrayToLong(data, offset + 48) : 0L;
        if (conn == null) {
            conn = new ISeriesNetServerConnection(connectionID, connectionTime, numberOfFilesOpen, connectionType, resourceName, resourceType, userName, numberOfConnectionUsers, sessionID);
        } else {
            conn.setAttributeValues(connectionID, connectionTime, numberOfFilesOpen, connectionType, resourceName, resourceType, userName, numberOfConnectionUsers, sessionID);
        }
        return conn;
    }

    public ISeriesNetServerConnection[] listConnectionsForShare(String shareName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            throw new NullPointerException();
        }
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int recordLength = this.getSystemVRM() < 393472 ? 64 : 192;
        int len = 20 * recordLength;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(64), new ProgramParameter(conv.stringToByteArray("ZLSL0700")), new ProgramParameter(text15.toBytes(shareName)), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        ISeriesNetServerConnection[] connections = new ISeriesNetServerConnection[numRecords];
        int offset = 0;
        byte[] data = parms[0].getOutputData();
        for (int i = 0; i < numRecords; ++i) {
            ISeriesNetServerConnection conn;
            connections[i] = conn = this.parseZLSL0600or0700(data, offset, conv, false, null);
            if (this.getSystemVRM() < 393472) {
                offset += 64;
                continue;
            }
            offset += 192;
        }
        return connections;
    }

    public void removeShare(String shareName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (shareName == null) {
            throw new NullPointerException();
        }
        int ccsid = this.system_.getCcsid();
        AS400Text text12 = new AS400Text(12, ccsid);
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(text12.toBytes(shareName.trim())), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSRMS.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    public boolean isAllowSystemName() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[0].equals("1");
    }

    public boolean isAllowSystemNamePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[0].equals("1");
    }

    public void setAllowSystemName(boolean value) {
        this.pendingValueStr_[0] = value ? "1" : "0";
        this.userChangedAttribute_[0] = true;
        this.userCommittedChange_[0] = false;
    }

    public int getAuthenticationMethod() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        switch (this.effectiveValueStr_[1].charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 2;
    }

    public int getAuthenticationMethodPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        switch (this.pendingValueStr_[1].charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 2;
    }

    public void setAuthenticationMethod(int value) {
        char[] charArray = new char[1];
        switch (value) {
            case 0: {
                charArray[0] = 48;
                break;
            }
            case 1: {
                charArray[0] = 49;
                break;
            }
            case 2: {
                charArray[0] = 50;
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException(Integer.toString(value), 2);
            }
        }
        this.pendingValueStr_[1] = new String(charArray);
        this.userChangedAttribute_[1] = true;
        this.userCommittedChange_[1] = false;
    }

    public boolean isAutoStart() throws AS400SecurityException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to query the AutoStart attribute.");
            throw new AS400SecurityException(40);
        }
        if (!this.refreshedSinceStart_ || this.changedAutoStartSinceRefresh_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[2].equals("*YES");
    }

    public boolean isAutoStartPending() throws AS400SecurityException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to query the AutoStart attribute.");
            throw new AS400SecurityException(40);
        }
        if (!this.refreshedSinceStart_ || this.changedAutoStartSinceRefresh_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[2].equals("*YES");
    }

    public void setAutoStart(boolean value) {
        this.pendingValueStr_[2] = value ? "*YES" : "*NO";
        this.userChangedAttribute_[2] = true;
        this.userCommittedChange_[2] = false;
    }

    public int getBrowsingInterval() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[20];
    }

    public int getBrowsingIntervalPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[20];
    }

    public void setBrowsingInterval(int value) {
        this.pendingValueInt_[20] = value;
        this.userChangedAttribute_[20] = true;
        this.userCommittedChange_[20] = false;
    }

    public int getCCSID() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[21];
    }

    public int getCCSIDPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[21];
    }

    public void setCCSID(int value) {
        this.pendingValueInt_[21] = value;
        this.userChangedAttribute_[21] = true;
        this.userCommittedChange_[21] = false;
    }

    public String getDescription() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[3];
    }

    public String getDescriptionPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[3];
    }

    public void setDescription(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[3] = value.trim();
        this.userChangedAttribute_[3] = true;
        this.userCommittedChange_[3] = false;
    }

    public String getDomainName() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[4];
    }

    public String getDomainNamePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[4];
    }

    public void setDomainName(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[4] = value.trim();
        this.userChangedAttribute_[4] = true;
        this.userCommittedChange_[4] = false;
    }

    public String getGuestUserProfile() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[5];
    }

    public String getGuestUserProfilePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[5];
    }

    public void setGuestUserProfile(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[5] = value.trim();
        this.userChangedAttribute_[5] = true;
        this.userCommittedChange_[5] = false;
    }

    public int getIdleTimeout() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[22];
    }

    public int getIdleTimeoutPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[22];
    }

    public void setIdleTimeout(int value) {
        this.pendingValueInt_[22] = value;
        this.userChangedAttribute_[22] = true;
        this.userCommittedChange_[22] = false;
    }

    public int getLANManagerAuthentication() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[28];
    }

    public int getLANManagerAuthenticationPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[28];
    }

    public void setLANManagerAuthentication(int value) {
        this.pendingValueInt_[28] = value;
        this.userChangedAttribute_[28] = true;
        this.userCommittedChange_[28] = false;
    }

    public boolean isLogonServer() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[23] == 1;
    }

    public boolean isLogonServerPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[23] == 1;
    }

    public void setLogonServer(boolean value) {
        this.pendingValueInt_[23] = value ? 1 : 0;
        this.userChangedAttribute_[23] = true;
        this.userCommittedChange_[23] = false;
    }

    public int getMessageAuthentication() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[26];
    }

    public int getMessageAuthenticationPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[26];
    }

    public void setMessageAuthentication(int value) {
        this.pendingValueInt_[26] = value;
        this.userChangedAttribute_[26] = true;
        this.userCommittedChange_[26] = false;
    }

    public int getMinimumMessageSeverity() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[27];
    }

    public int getMinimumMessageSeverityPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[27];
    }

    public void setMinimumMessageSeverity(int value) {
        this.pendingValueInt_[27] = value;
        this.userChangedAttribute_[27] = true;
        this.userCommittedChange_[27] = false;
    }

    public String getName() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[6];
    }

    public String getNamePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[6];
    }

    public void setName(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[6] = value.trim();
        this.userChangedAttribute_[6] = true;
        this.userCommittedChange_[6] = false;
    }

    public int getOpportunisticLockTimeout() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[24];
    }

    public int getOpportunisticLockTimeoutPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[24];
    }

    public void setOpportunisticLockTimeout(int value) {
        this.pendingValueInt_[24] = value;
        this.userChangedAttribute_[24] = true;
        this.userCommittedChange_[24] = false;
    }

    public boolean isWINSServer() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[25] == 1;
    }

    public boolean isWINSServerPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[25] == 1;
    }

    public void setWINSServer(boolean value) {
        this.pendingValueInt_[25] = value ? 1 : 0;
        this.userChangedAttribute_[25] = true;
        this.userCommittedChange_[25] = false;
    }

    public String getWINSPrimaryAddress() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[7];
    }

    public String getWINSPrimaryAddressPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[7];
    }

    public void setWINSPrimaryAddress(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[7] = value.trim();
        this.userChangedAttribute_[7] = true;
        this.userCommittedChange_[7] = false;
    }

    public String getWINSScopeID() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[8];
    }

    public String getWINSScopeIDPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[8];
    }

    public void setWINSScopeID(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[8] = value.trim();
        this.userChangedAttribute_[8] = true;
        this.userCommittedChange_[8] = false;
    }

    public String getWINSSecondaryAddress() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[9];
    }

    public String getWINSSecondaryAddressPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[9];
    }

    public void setWINSSecondaryAddress(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[9] = value.trim();
        this.userChangedAttribute_[9] = true;
        this.userCommittedChange_[9] = false;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieveAutostart();
        this.changedAutoStartSinceRefresh_ = false;
        this.openListOfServerInfo();
        this.refreshedSinceStart_ = true;
    }

    private void refreshWithoutException() {
        block2: {
            try {
                this.refresh();
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block2;
                Trace.log(2, "Exception swallowed by refresh(): ", (Throwable)e);
            }
        }
    }

    public void commitChanges() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to change NetServer attributes.");
            throw new AS400SecurityException(40);
        }
        if (!this.refreshedSinceStart_) {
            this.refresh();
        }
        boolean needToChangeServerInfo = false;
        boolean needToChangeServerName = false;
        boolean needToChangeServerGuest = false;
        boolean needToChangeAutostart = false;
        if (this.userChangedAttribute_[0] && !this.userCommittedChange_[0]) {
            needToChangeServerName = true;
        }
        if (this.userChangedAttribute_[1] && !this.userCommittedChange_[1]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[2] && !this.userCommittedChange_[2]) {
            needToChangeAutostart = true;
        }
        if (this.userChangedAttribute_[20] && !this.userCommittedChange_[20]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[21] && !this.userCommittedChange_[21]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[3] && !this.userCommittedChange_[3]) {
            needToChangeServerName = true;
        }
        if (this.userChangedAttribute_[4] && !this.userCommittedChange_[4]) {
            needToChangeServerName = true;
        }
        if (this.userChangedAttribute_[5] && !this.userCommittedChange_[5]) {
            needToChangeServerGuest = true;
        }
        if (this.userChangedAttribute_[22] && !this.userCommittedChange_[22]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[24] && !this.userCommittedChange_[24]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[23] && !this.userCommittedChange_[23]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[6] && !this.userCommittedChange_[6]) {
            needToChangeServerName = true;
        }
        if (this.userChangedAttribute_[25] && !this.userCommittedChange_[25]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[7] && !this.userCommittedChange_[7]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[8] && !this.userCommittedChange_[8]) {
            needToChangeServerInfo = true;
        }
        if (this.userChangedAttribute_[9] && !this.userCommittedChange_[9]) {
            needToChangeServerInfo = true;
        }
        if (this.getSystemVRM() >= 328704) {
            if (this.userChangedAttribute_[26] && !this.userCommittedChange_[26]) {
                needToChangeServerInfo = true;
            }
            if (this.userChangedAttribute_[27] && !this.userCommittedChange_[27]) {
                needToChangeServerInfo = true;
            }
            if (this.userChangedAttribute_[28] && !this.userCommittedChange_[28]) {
                needToChangeServerInfo = true;
            }
        }
        if (needToChangeServerInfo) {
            this.changeServerInfo();
        }
        if (needToChangeServerName) {
            this.changeServerName();
        }
        if (needToChangeServerGuest) {
            this.changeServerGuest();
        }
        if (needToChangeAutostart) {
            this.changeAutostart();
        }
        for (int i = 0; i < this.userCommittedChange_.length; ++i) {
            if (!this.userChangedAttribute_[i]) continue;
            this.userCommittedChange_[i] = true;
        }
    }

    private void changeAutostart() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        AS400Text text4 = new AS400Text(4, ccsid);
        AS400Text text30 = new AS400Text(30, ccsid);
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(text4.toBytes("*CHG")), new ProgramParameter(text30.toBytes("*NETSVR")), new ProgramParameter(text4.toBytes(this.pendingValueStr_[2])), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QTOCAUTO.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        this.changedAutoStartSinceRefresh_ = true;
    }

    private void retrieveAutostart() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        String retrievedValue;
        if (!this.userHasSpecialAuthority()) {
            retrievedValue = "*NO";
        } else {
            int ccsid = this.system_.getCcsid();
            CharConverter conv = new CharConverter(ccsid);
            AS400Text text4 = new AS400Text(4, ccsid);
            AS400Text text30 = new AS400Text(30, ccsid);
            ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(text4.toBytes("*RTV")), new ProgramParameter(text30.toBytes("*NETSVR")), new ProgramParameter(4), new ErrorCodeParameter()};
            ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QTOCAUTO.PGM", parms);
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            byte[] retrievedBytes = parms[2].getOutputData();
            retrievedValue = conv.byteArrayToString(retrievedBytes).trim();
            if (retrievedValue.equals("*ERR")) {
                Trace.log(2, "The QTOCOAUTO API returned *ERR.");
                throw new InternalErrorException(6);
            }
        }
        this.effectiveValueStr_[2] = retrievedValue;
        if (!this.userChangedAttribute_[2]) {
            this.pendingValueStr_[2] = retrievedValue;
        }
    }

    private void changeServerGuest() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        AS400Text text10 = new AS400Text(10, this.system_.getCcsid());
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(text10.toBytes(this.pendingValueStr_[5])), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHSG.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    private void changeServerInfo() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        AS400Text text224 = new AS400Text(224, ccsid);
        ProgramParameter[] parms = new ProgramParameter[4];
        ByteArrayOutputStream stream = new ByteArrayOutputStream(300);
        stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[21]));
        stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[22]));
        stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[24]));
        stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[20]));
        stream.write(text15.toBytes(this.pendingValueStr_[7]));
        stream.write(text15.toBytes(this.pendingValueStr_[9]));
        stream.write(text224.toBytes(this.pendingValueStr_[8]));
        if (this.pendingValueInt_[25] == 1) {
            stream.write(241);
        } else {
            stream.write(240);
        }
        byte[] reserved5 = new byte[]{0, 0, 0, 0, 0};
        stream.write(reserved5);
        stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[23]));
        if (this.getSystemVRM() >= 328192 && (this.getSystemVRM() >= 328704 || this.userChangedAttribute_[1])) {
            switch (this.pendingValueStr_[1].charAt(0)) {
                case '0': {
                    stream.write(240);
                    break;
                }
                case '1': {
                    stream.write(241);
                    break;
                }
                default: {
                    stream.write(242);
                }
            }
        }
        if (this.getSystemVRM() >= 328704) {
            byte[] reserved3 = new byte[]{0, 0, 0};
            stream.write(reserved3);
            stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[26]));
            stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[27]));
            stream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[28]));
        }
        stream.flush();
        byte[] requestVariable = stream.toByteArray();
        parms[0] = new ProgramParameter(requestVariable);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(requestVariable.length));
        parms[2] = new ProgramParameter(conv.stringToByteArray("ZLSS0100"));
        parms[3] = new ErrorCodeParameter();
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHSI.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    private void changeServerName() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        AS400Text text15 = new AS400Text(15, ccsid);
        AS400Text text50 = new AS400Text(50, ccsid);
        ProgramParameter[] parms = new ProgramParameter[5];
        parms[0] = new ProgramParameter(text15.toBytes(this.pendingValueStr_[6].trim()));
        parms[1] = new ProgramParameter(text15.toBytes(this.pendingValueStr_[4].trim()));
        parms[2] = new ProgramParameter(text50.toBytes(this.pendingValueStr_[3].trim()));
        parms[3] = new ErrorCodeParameter();
        byte[] allowSysName = new byte[]{this.pendingValueStr_[0].equals("1") ? (byte)-15 : -16};
        parms[4] = new ProgramParameter(allowSysName);
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHSN.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    private void openListOfServerInfo() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = 772;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(64), new ProgramParameter(conv.stringToByteArray("ZLSL0201")), new ProgramParameter(text15.toBytes("*ALL")), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parms[0].getOutputData();
        this.effectiveValueInt_[21] = BinaryConverter.byteArrayToInt(data, 0);
        if (!this.userChangedAttribute_[21]) {
            this.pendingValueInt_[21] = BinaryConverter.byteArrayToInt(data, 4);
        }
        this.effectiveValueInt_[22] = BinaryConverter.byteArrayToInt(data, 8);
        if (!this.userChangedAttribute_[22]) {
            this.pendingValueInt_[22] = BinaryConverter.byteArrayToInt(data, 12);
        }
        this.effectiveValueInt_[24] = BinaryConverter.byteArrayToInt(data, 16);
        if (!this.userChangedAttribute_[24]) {
            this.pendingValueInt_[24] = BinaryConverter.byteArrayToInt(data, 20);
        }
        this.effectiveValueInt_[20] = BinaryConverter.byteArrayToInt(data, 24);
        if (!this.userChangedAttribute_[20]) {
            this.pendingValueInt_[20] = BinaryConverter.byteArrayToInt(data, 28);
        }
        this.effectiveValueInt_[25] = BinaryConverter.byteArrayToInt(data, 32);
        if (!this.userChangedAttribute_[25]) {
            this.pendingValueInt_[25] = BinaryConverter.byteArrayToInt(data, 36);
        }
        this.effectiveValueStr_[5] = conv.byteArrayToString(data, 48, 10).trim();
        if (!this.userChangedAttribute_[5]) {
            this.pendingValueStr_[5] = conv.byteArrayToString(data, 58, 10).trim();
        }
        this.effectiveValueStr_[6] = conv.byteArrayToString(data, 68, 15).trim();
        if (!this.userChangedAttribute_[6]) {
            this.pendingValueStr_[6] = conv.byteArrayToString(data, 83, 15).trim();
        }
        this.effectiveValueStr_[4] = conv.byteArrayToString(data, 98, 15).trim();
        if (!this.userChangedAttribute_[4]) {
            this.pendingValueStr_[4] = conv.byteArrayToString(data, 113, 15).trim();
        }
        this.effectiveValueStr_[3] = conv.byteArrayToString(data, 128, 50).trim();
        if (!this.userChangedAttribute_[3]) {
            this.pendingValueStr_[3] = conv.byteArrayToString(data, 178, 50).trim();
        }
        this.effectiveValueStr_[7] = conv.byteArrayToString(data, 228, 15).trim();
        if (!this.userChangedAttribute_[7]) {
            this.pendingValueStr_[7] = conv.byteArrayToString(data, 243, 15).trim();
        }
        this.effectiveValueStr_[9] = conv.byteArrayToString(data, 258, 15).trim();
        if (!this.userChangedAttribute_[9]) {
            this.pendingValueStr_[9] = conv.byteArrayToString(data, 273, 15).trim();
        }
        this.effectiveValueStr_[8] = conv.byteArrayToString(data, 288, 224).trim();
        if (!this.userChangedAttribute_[8]) {
            this.pendingValueStr_[8] = conv.byteArrayToString(data, 512, 224).trim();
        }
        this.effectiveValueStr_[0] = conv.byteArrayToString(data, 736, 1);
        if (!this.userChangedAttribute_[0]) {
            this.pendingValueStr_[0] = conv.byteArrayToString(data, 737, 1);
        }
        this.effectiveValueStr_[1] = conv.byteArrayToString(data, 738, 1);
        if (!this.userChangedAttribute_[1]) {
            this.pendingValueStr_[1] = conv.byteArrayToString(data, 739, 1);
        }
        this.effectiveValueInt_[23] = BinaryConverter.byteArrayToInt(data, 740);
        if (!this.userChangedAttribute_[23]) {
            this.pendingValueInt_[23] = BinaryConverter.byteArrayToInt(data, 744);
        }
        if (this.getSystemVRM() >= 328704) {
            this.effectiveValueInt_[26] = BinaryConverter.byteArrayToInt(data, 748);
            if (!this.userChangedAttribute_[26]) {
                this.pendingValueInt_[26] = BinaryConverter.byteArrayToInt(data, 752);
            }
            this.effectiveValueInt_[27] = BinaryConverter.byteArrayToInt(data, 756);
            if (!this.userChangedAttribute_[27]) {
                this.pendingValueInt_[27] = BinaryConverter.byteArrayToInt(data, 760);
            }
            this.effectiveValueInt_[28] = BinaryConverter.byteArrayToInt(data, 764);
            if (!this.userChangedAttribute_[28]) {
                this.pendingValueInt_[28] = BinaryConverter.byteArrayToInt(data, 768);
            }
        }
    }

    private boolean userHasSpecialAuthority() {
        if (!this.determinedSpecialAuthority_) {
            boolean foundAuth = false;
            try {
                User user = new User(this.system_, this.system_.getUserId());
                foundAuth = user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_IO_SYSTEM_CONFIGURATION);
            }
            catch (Exception e) {
                Trace.log(2, e);
            }
            if (!foundAuth) {
                Trace.log(4, "User " + this.system_.getUserId() + " does not have *IOSYSCFG authority.");
            }
            this.userHasSpecialAuthority_ = foundAuth;
            this.determinedSpecialAuthority_ = true;
        }
        return this.userHasSpecialAuthority_;
    }

    public void end() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to end the NetServer process.");
            throw new AS400SecurityException(40);
        }
        ProgramParameter[] parms = new ProgramParameter[]{new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSENDS.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    public void endSession(long sessionID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.endSessions(null, sessionID);
    }

    public void endSessionsForWorkstation(String workstationName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (workstationName == null) {
            throw new NullPointerException();
        }
        this.endSessions(workstationName, 0L);
    }

    private void endSessions(String workstationName, long sessionID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to end a NetServer session.");
            throw new AS400SecurityException(40);
        }
        ProgramParameter[] parms = new ProgramParameter[3];
        AS400Text text15 = new AS400Text(15, this.system_.getCcsid());
        AS400Text text50 = new AS400Text(50, this.system_.getCcsid());
        if (workstationName == null) {
            parms[0] = new ProgramParameter(text15.toBytes("*SESSID"));
            parms[2] = new ProgramParameter(BinaryConverter.longToByteArray(sessionID));
        } else if (this.getSystemVRM() < 393472) {
            parms[0] = new ProgramParameter(text15.toBytes(workstationName));
            parms[2] = new ProgramParameter(BinaryConverter.longToByteArray(0L));
        } else {
            parms[0] = new ProgramParameter(text15.toBytes("*EXPANDED"));
            parms[2] = new ProgramParameter(text50.toBytes(workstationName));
        }
        parms[1] = new ErrorCodeParameter();
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSENSS.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    public boolean isStarted() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        JobList list = new JobList(this.getSystem());
        try {
            list.addJobSelectionCriteria(1, "QZLSSERVER");
            list.addJobSelectionCriteria(5, Boolean.TRUE);
            list.addJobSelectionCriteria(6, Boolean.FALSE);
            list.addJobSelectionCriteria(7, Boolean.FALSE);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
        }
        list.load();
        boolean foundActiveJob = list.getLength() != 0;
        list.close();
        return foundActiveJob;
    }

    private boolean isQserverStarted() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        JobList jobList = new JobList(this.getSystem());
        try {
            jobList.addJobSelectionCriteria(1, "QSERVER");
            jobList.addJobSelectionCriteria(2, "QSYS");
            jobList.addJobSelectionCriteria(5, Boolean.TRUE);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
        }
        jobList.load();
        boolean foundActiveJob = jobList.getLength() != 0;
        jobList.close();
        return foundActiveJob;
    }

    public void start() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.start(false);
    }

    public void start(boolean reset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall cmd;
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to start the NetServer process.");
            throw new AS400SecurityException(40);
        }
        if (this.isStarted()) {
            return;
        }
        if (!this.isQserverStarted() && !(cmd = new CommandCall(this.getSystem(), "STRSBS SBSD(QSERVER)")).run()) {
            Trace.log(2, "Error when starting QSERVER subsystem.");
            throw new AS400Exception(cmd.getMessageList());
        }
        this.refreshedSinceStart_ = false;
        ProgramParameter[] parms = new ProgramParameter[2];
        byte[] resetBytes = new byte[]{reset ? (byte)-15 : -16};
        parms[0] = new ProgramParameter(resetBytes);
        parms[1] = new ErrorCodeParameter();
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSSTRS.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
    }

    public void refresh(ISeriesNetServerConnection connection) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean is0600;
        String format;
        if (connection == null) {
            throw new NullPointerException();
        }
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = 64;
        int vrm = this.getSystemVRM();
        if (connection.getResourceType() == 0) {
            format = "ZLSL0600";
            is0600 = true;
        } else {
            format = "ZLSL0700";
            is0600 = false;
            if (vrm >= 393472) {
                len = 192;
            }
        }
        ProgramParameter[] parms = new ProgramParameter[is0600 && vrm >= 393472 ? 8 : 6];
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(64);
        parms[3] = new ProgramParameter(conv.stringToByteArray(format));
        if (is0600 && vrm >= 393472) {
            AS400Text text10 = new AS400Text(10, ccsid);
            AS400Text text50 = new AS400Text(50, ccsid);
            parms[4] = new ProgramParameter(text15.toBytes("*EXPANDED"));
            parms[6] = new ProgramParameter(text10.toBytes("*ALL"));
            parms[7] = new ProgramParameter(text50.toBytes(connection.getName()));
        } else {
            parms[4] = new ProgramParameter(text15.toBytes(connection.getName()));
        }
        parms[5] = new ErrorCodeParameter();
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        if (numRecords == 0) {
            Trace.log(2, "refresh() failed: Connection not found.");
        } else if (numRecords > 1) {
            Trace.log(2, "refresh() failed: More than one connection returned from QZLSOLST.");
        } else {
            byte[] data = parms[0].getOutputData();
            this.parseZLSL0600or0700(data, 0, conv, is0600, connection);
        }
    }

    public void refresh(ISeriesNetServerSession session) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (session == null) {
            throw new NullPointerException();
        }
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text10 = new AS400Text(10, ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = this.getSystemVRM() < 393472 ? 64 : 113;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(64), new ProgramParameter(conv.stringToByteArray("ZLSL0300")), new ProgramParameter(text15.toBytes("*SESSID")), new ErrorCodeParameter(), new ProgramParameter(text10.toBytes("*SESSID")), new ProgramParameter(BinaryConverter.longToByteArray(session.getID()))};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        if (numRecords == 0) {
            Trace.log(2, "refresh() failed: Session not found.");
        } else if (numRecords > 1) {
            Trace.log(2, "refresh() failed: More than one session returned from QZLSOLST.");
        } else {
            byte[] data = parms[0].getOutputData();
            this.parseZLSL0300(data, 0, conv, session);
        }
    }

    public void refresh(ISeriesNetServerShare share) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (share == null) {
            throw new NullPointerException();
        }
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text15 = new AS400Text(15, ccsid);
        int len = 1221;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(64), new ProgramParameter(conv.stringToByteArray("ZLSL0101")), new ProgramParameter(text15.toBytes(share.getName().trim())), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", parms);
        int numRecords = ISeriesNetServer.callListProgram(pc, parms, len);
        if (numRecords == 0) {
            Trace.log(2, "refresh() failed: Share not found.");
        } else if (numRecords > 1) {
            Trace.log(2, "refresh() failed: More than one share returned from QZLSOLST.");
        } else {
            byte[] data = parms[0].getOutputData();
            int desiredType = share.isFile_ ? 0 : 1;
            ISeriesNetServer.parseZLSL0101(data, conv, 1, desiredType, share);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "De-serializing ISeriesNetServer object.");
        }
        in.defaultReadObject();
        this.refreshedSinceStart_ = false;
        this.determinedSpecialAuthority_ = false;
        this.userHasSpecialAuthority_ = false;
    }

    public String toString() {
        String name = this.refreshedSinceStart_ ? this.effectiveValueStr_[6] : "unknown";
        return "ISeriesNetServer (system: " + this.system_.getSystemName() + "; name: " + name + "): " + super.toString();
    }

    public void commitChanges(ISeriesNetServerFileShare share) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall pc;
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to change share attributes.");
            throw new AS400SecurityException(40);
        }
        int numberOfOptionalParms = share.numOptionalParmsToSet_;
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        AS400Text text12 = new AS400Text(12, ccsid);
        AS400Text text50 = new AS400Text(50, ccsid);
        ProgramParameter[] parms = new ProgramParameter[8 + numberOfOptionalParms];
        parms[0] = new ProgramParameter(text12.toBytes(share.name_));
        byte[] pathAsBytes = conv.stringToByteArray(share.path_);
        parms[1] = new ProgramParameter(pathAsBytes);
        parms[2] = new ProgramParameter(BinaryConverter.intToByteArray(pathAsBytes.length));
        parms[3] = new ProgramParameter(BinaryConverter.intToByteArray(ccsid));
        parms[4] = new ProgramParameter(text50.toBytes(share.description_));
        parms[5] = new ProgramParameter(BinaryConverter.intToByteArray(share.permissions_));
        parms[6] = new ProgramParameter(BinaryConverter.intToByteArray(share.maxNumberOfUsers_));
        parms[7] = new ErrorCodeParameter();
        if (numberOfOptionalParms >= 1) {
            parms[8] = new ProgramParameter(BinaryConverter.intToByteArray(share.ccsidForTextConversion_));
        }
        if (numberOfOptionalParms >= 2) {
            byte[] enableTxtConv = new byte[]{share.textConversionEnablement_.equals("0") ? (byte)-16 : (share.textConversionEnablement_.equals("1") ? (byte)-15 : -14)};
            parms[9] = new ProgramParameter(enableTxtConv);
        }
        if (numberOfOptionalParms >= 4) {
            int numFileExtensions = share.fileExtensions_.length;
            if (numFileExtensions == 0) {
                parms[10] = new ProgramParameter(conv.stringToByteArray(""));
            } else {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(numFileExtensions * 50);
                for (int i = 0; i < numFileExtensions; ++i) {
                    int extensionLength = share.fileExtensions_[i].length();
                    stream.write(BinaryConverter.intToByteArray(extensionLength));
                    stream.write(conv.stringToByteArray(share.fileExtensions_[i]));
                    int numFillBytes = 50 - (4 + extensionLength);
                    for (int j = 0; j < numFillBytes; ++j) {
                        stream.write(0);
                    }
                }
                stream.flush();
                byte[] fileExtensionTable = stream.toByteArray();
                parms[10] = new ProgramParameter(fileExtensionTable);
            }
            parms[11] = new ProgramParameter(BinaryConverter.intToByteArray(numFileExtensions));
        }
        if (!(pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHFS.PGM", parms)).run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        share.numOptionalParmsToSet_ = 0;
    }

    public void commitChanges(ISeriesNetServerPrintShare share) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall pc;
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to change share attributes.");
            throw new AS400SecurityException(40);
        }
        int numberOfOptionalParms = share.numOptionalParmsToSet_;
        int ccsid = this.system_.getCcsid();
        AS400Text text12 = new AS400Text(12, ccsid);
        AS400Text text20 = new AS400Text(20, ccsid);
        AS400Text text50 = new AS400Text(50, ccsid);
        ProgramParameter[] parms = new ProgramParameter[6 + numberOfOptionalParms];
        parms[0] = new ProgramParameter(text12.toBytes(share.name_));
        parms[1] = new ProgramParameter(text20.toBytes(share.outputQueue_));
        parms[2] = new ProgramParameter(text50.toBytes(share.description_));
        parms[3] = new ProgramParameter(BinaryConverter.intToByteArray(share.spooledFileType_));
        parms[4] = new ProgramParameter(text50.toBytes(share.printDriver_));
        parms[5] = new ErrorCodeParameter();
        if (numberOfOptionalParms >= 1) {
            parms[6] = new ProgramParameter(text20.toBytes(share.printerFile_));
        }
        if (numberOfOptionalParms >= 2) {
            byte[] publishPrintShare = new byte[]{share.isPublished_ ? (byte)-15 : -16};
            parms[7] = new ProgramParameter(publishPrintShare);
        }
        if (!(pc = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHPS.PGM", parms)).run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        share.numOptionalParmsToSet_ = 0;
    }
}

