/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBNativeDatabaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import java.sql.SQLException;
import java.util.StringTokenizer;

class JDLibraryList {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    public static final String LIBL_ = "*LIBL";
    public static final String USRLIBL_ = "*USRLIBL";
    private char[] indicators_;
    private String defaultSchema_;
    private String[] list_;
    private String libListType_;

    JDLibraryList(String list, String defaultSchema, String naming) {
        this(list, defaultSchema, naming, null);
    }

    JDLibraryList(String list, String defaultSchema, String naming, String libListType) {
        boolean startsWithComma = false;
        String incomingList = list;
        this.defaultSchema_ = null;
        if (!("".equals(defaultSchema) && defaultSchema == null || defaultSchema.length() <= 0)) {
            this.defaultSchema_ = defaultSchema.startsWith("\"") ? defaultSchema : defaultSchema.toUpperCase();
        }
        if (this.defaultSchema_ != null) {
            if (list != null && list.length() > 0) {
                boolean alreadyInList = false;
                if (list.toUpperCase().indexOf(this.defaultSchema_) >= 0) {
                    StringTokenizer tokenizer = new StringTokenizer(list, " ,:;");
                    while (tokenizer.hasMoreTokens()) {
                        if (!tokenizer.nextToken().toUpperCase().equals(this.defaultSchema_)) continue;
                        alreadyInList = true;
                    }
                }
                if (!alreadyInList) {
                    list = this.defaultSchema_ + "," + list;
                }
            } else {
                list = this.defaultSchema_;
            }
        }
        this.list_ = null;
        int liblPosition = -1;
        this.libListType_ = libListType != null && libListType.length() > 0 ? (libListType.equals(LIBL_) || libListType.equals(USRLIBL_) ? libListType : LIBL_) : LIBL_;
        if (list.length() != 0) {
            String newList;
            if (this.defaultSchema_ == null && (newList = list.trim()).length() > 0 && newList.startsWith(",")) {
                startsWithComma = true;
            }
            boolean includesLibl = list.toUpperCase().indexOf(this.libListType_) != -1;
            StringTokenizer tokenizer = new StringTokenizer(list, " ,:;", true);
            int count = tokenizer.countTokens();
            if (includesLibl) {
                --count;
            }
            this.indicators_ = new char[count];
            this.list_ = new String[count];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.compareTo(" ") == 0 || token.compareTo(",") == 0 || token.compareTo(":") == 0 || token.compareTo(";") == 0) continue;
                if (token.startsWith("\"")) {
                    int nextQuote = token.indexOf("\"", 1);
                    while (tokenizer.hasMoreTokens() && nextQuote == -1) {
                        token = token + tokenizer.nextToken();
                        nextQuote = token.indexOf("\"", 1);
                    }
                } else {
                    token = token.toUpperCase();
                }
                if (token.equalsIgnoreCase(this.libListType_)) {
                    if (liblPosition != -1) continue;
                    liblPosition = i;
                    continue;
                }
                this.indicators_[i] = includesLibl ? (liblPosition == -1 ? 70 : 76) : (incomingList.equals("") && defaultSchema != null && !defaultSchema.equals("") ? (i == 0 ? 70 : 76) : (i == 0 ? 67 : 76));
                this.list_[i] = token;
                ++i;
            }
            if (i != count) {
                String[] tmpList = this.list_;
                this.list_ = new String[i];
                System.arraycopy(tmpList, 0, this.list_, 0, i);
            }
            if (this.defaultSchema_ == null && !startsWithComma && naming.equals("sql") && this.list_.length > 0) {
                this.defaultSchema_ = this.list_[0];
            }
            if (this.list_.length > 0 && this.list_[0].length() > 10 && this.list_[0].equals(this.defaultSchema_)) {
                String[] tmpList = this.list_;
                this.list_ = new String[tmpList.length - 1];
                if (this.list_.length > 0) {
                    System.arraycopy(tmpList, 1, this.list_, 0, this.list_.length);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Schema " + this.defaultSchema_ + " is too long to be in library list by Toolbox (Hostserver will add it), but will still be set as default SQL schema");
                }
            }
            if (liblPosition > 1) {
                int halfPoint = liblPosition / 2 - 1;
                for (int j = 0; j <= halfPoint; ++j) {
                    int j2 = liblPosition - j - 1;
                    String temp = this.list_[j];
                    this.list_[j] = this.list_[j2];
                    this.list_[j2] = temp;
                }
            }
        } else {
            this.list_ = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addOnServer(AS400JDBCConnection connection, int id) throws SQLException {
        DBReplyRequestedDS reply;
        block12: {
            if (this.list_.length <= 0) return;
            DBNativeDatabaseRequestDS request = null;
            reply = null;
            try {
                block11: {
                    try {
                        request = DBDSPool.getDBNativeDatabaseRequestDS(6156, id, Integer.MIN_VALUE, 0);
                        request.setListOfLibraries(this.indicators_, this.list_, connection.getConverter());
                        reply = connection.sendAndReceive(request);
                        int errorClass = reply.getErrorClass();
                        int returnCode = reply.getReturnCode();
                        if (errorClass == 0) break block11;
                        if (errorClass == 5 && returnCode == 1301) {
                            connection.postWarning(JDError.getSQLWarning(connection, id, errorClass, returnCode));
                        } else {
                            JDError.throwSQLException(this, connection, id, errorClass, returnCode);
                        }
                    }
                    catch (DBDataStreamException e) {
                        JDError.throwSQLException("HY000", e);
                        Object var8_9 = null;
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (reply == null) return;
                        reply.returnToPool();
                        return;
                    }
                }
                Object var8_8 = null;
                if (request == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
                if (reply == null) throw throwable;
                reply.returnToPool();
                reply = null;
                throw throwable;
            }
            request.returnToPool();
            request = null;
        }
        if (reply == null) return;
        reply.returnToPool();
    }

    String getDefaultSchema() {
        return this.defaultSchema_;
    }

    public String toString() {
        return "";
    }
}

