/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDTrace;
import java.sql.SQLException;

class JDServerRowCache
implements JDRowCache {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int blockingFactor_;
    private AS400JDBCResultSet resultSet_;
    private AS400JDBCConnection connection_;
    private boolean empty_;
    private boolean emptyChecked_;
    private boolean firstBlock_;
    private JDServerRow row_;
    private int id_;
    private boolean lastBlock_;
    private DBData serverData_;
    private boolean variableFieldCompressionSupported_ = false;
    private int bufferSize_;
    private JDCursor cursor_ = null;
    private DBReplyRequestedDS fetchReply = null;
    private int cached_;
    private int index_;
    private static int NOT_KNOWN = -9999;
    private int cursorPositionOfFirstRowInCache_ = NOT_KNOWN;

    JDServerRowCache(JDServerRow row, AS400JDBCConnection connection, int id, int blockingFactor, boolean lastBlock, int resultSetType) throws SQLException {
        this.blockingFactor_ = blockingFactor;
        this.connection_ = connection;
        this.emptyChecked_ = this.lastBlock_ = lastBlock;
        this.empty_ = this.lastBlock_;
        this.firstBlock_ = true;
        this.id_ = id;
        this.row_ = row;
        this.serverData_ = null;
        this.cached_ = 0;
        this.index_ = -1;
        if (this.connection_.getServerFunctionalLevel() >= 14 && this.connection_.getProperties().getBoolean(65) && resultSetType == 1003) {
            this.variableFieldCompressionSupported_ = true;
        }
        this.bufferSize_ = this.connection_.getProperties().getInt(1);
        this.cursorPositionOfFirstRowInCache_ = 0;
        this.row_.setRowIndex(this.index_);
    }

    JDServerRowCache(JDServerRow row, AS400JDBCConnection connection, int id, int blockingFactor, boolean lastBlock, int resultSetType, JDCursor cursor) throws SQLException {
        this(row, connection, id, blockingFactor, lastBlock, resultSetType);
        this.cursor_ = cursor;
    }

    JDServerRowCache(JDServerRow row, AS400JDBCConnection connection, int id, int blockingFactor, DBData serverData, boolean lastBlock, int resultSetType) throws SQLException {
        this.blockingFactor_ = blockingFactor;
        this.connection_ = connection;
        this.firstBlock_ = true;
        this.id_ = id;
        this.lastBlock_ = lastBlock;
        this.row_ = row;
        this.serverData_ = serverData;
        if (this.connection_.getServerFunctionalLevel() >= 14 && this.connection_.getProperties().getBoolean(65) && resultSetType == 1003) {
            this.variableFieldCompressionSupported_ = true;
        }
        this.bufferSize_ = this.connection_.getProperties().getInt(1);
        try {
            this.cached_ = serverData.getRowCount();
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        this.emptyChecked_ = true;
        this.empty_ = this.cached_ == 0;
        this.cursorPositionOfFirstRowInCache_ = this.cached_ > 0 ? 1 : 0;
        this.index_ = -1;
        this.row_.setRowIndex(this.index_);
        this.row_.setServerData(this.serverData_);
    }

    JDServerRowCache(JDServerRow row, AS400JDBCConnection connection, int id, int blockingFactor, DBData serverData, boolean lastBlock, int resultSetType, JDCursor cursor) throws SQLException {
        this(row, connection, id, blockingFactor, serverData, lastBlock, resultSetType);
        this.cursor_ = cursor;
    }

    private boolean fetch(int fetchScrollOption) throws SQLException {
        return this.fetch(fetchScrollOption, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fetch(int fetchScrollOption, int rows) throws SQLException {
        boolean endBlock = false;
        try {
            DBSQLRequestDS request = null;
            try {
                request = DBDSPool.getDBSQLRequestDS(6155, this.id_, -2080374784, 0);
                request.setFetchScrollOption(fetchScrollOption, rows);
                if (fetchScrollOption == 0 && this.blockingFactor_ > 0 && this.cursorPositionOfFirstRowInCache_ >= 0) {
                    if (this.variableFieldCompressionSupported_) {
                        request.setVariableFieldCompression(true);
                        request.setBufferSize(this.bufferSize_ * 1024);
                    } else {
                        request.setBlockingFactor(this.blockingFactor_);
                    }
                } else {
                    request.setBlockingFactor(1);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Fetching a block of data from the system " + fetchScrollOption + "," + rows);
                }
                if (this.fetchReply != null) {
                    this.fetchReply.returnToPool();
                    this.fetchReply = null;
                }
                this.fetchReply = this.connection_.sendAndReceive(request, this.id_);
                int errorClass = this.fetchReply.getErrorClass();
                int returnCode = this.fetchReply.getReturnCode();
                if (errorClass == 1 && returnCode == 100 || errorClass == 2 && returnCode == 701) {
                    endBlock = true;
                } else if (errorClass == 2 && returnCode == 700) {
                    endBlock = true;
                    if (this.cursor_ != null) {
                        this.cursor_.setState(true);
                    }
                } else if (errorClass != 0) {
                    if (returnCode < 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                    } else if (this.resultSet_ != null) {
                        this.resultSet_.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                    } else {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this.connection_, "posting warning to connection");
                        }
                        this.connection_.postWarning(JDError.getSQLWarning(this.connection_, this.id_, errorClass, returnCode));
                    }
                }
                this.serverData_ = this.fetchReply.getResultData();
                if (this.serverData_ == null) {
                    endBlock = true;
                    this.cached_ = 0;
                } else {
                    this.row_.setServerData(this.serverData_);
                    this.cached_ = this.serverData_.getRowCount();
                }
                if (!this.emptyChecked_) {
                    this.emptyChecked_ = true;
                    this.empty_ = this.cached_ == 0;
                }
                Object var8_8 = null;
                if (request == null) return endBlock;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (request == null) throw throwable;
                request.returnToPool();
                request = null;
                throw throwable;
            }
            request.returnToPool();
            request = null;
            return endBlock;
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        return endBlock;
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        if (this.connection_.getProperties().getInt(1) == 0) {
            this.blockingFactor_ = fetchSize;
        }
    }

    public void open() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.fetchReply != null) {
            this.fetchReply.returnToPool();
            this.fetchReply = null;
        }
    }

    public void flush() throws SQLException {
        this.cached_ = 0;
        this.emptyChecked_ = false;
    }

    public void refreshRow() throws SQLException {
        this.fetch(6);
        this.index_ = 0;
        this.row_.setRowIndex(this.index_);
    }

    public JDRow getRow() {
        return this.row_;
    }

    public boolean isEmpty() throws SQLException {
        if (!this.emptyChecked_) {
            this.firstBlock_ = false;
            this.first(true);
            this.beforeFirst();
        }
        return this.empty_;
    }

    public boolean isValid() {
        return this.serverData_ != null && this.index_ >= 0 && this.index_ < this.cached_;
    }

    public void absolute(int rowNumber) throws SQLException {
        if (rowNumber >= this.cursorPositionOfFirstRowInCache_ && rowNumber < this.cursorPositionOfFirstRowInCache_ + this.cached_ && rowNumber >= 0 && this.cursorPositionOfFirstRowInCache_ != NOT_KNOWN) {
            this.index_ = rowNumber - this.cursorPositionOfFirstRowInCache_;
        } else if (rowNumber < 0 && this.lastBlock_ && this.cached_ >= -rowNumber && this.cursorPositionOfFirstRowInCache_ != NOT_KNOWN) {
            this.index_ = this.cached_ + rowNumber;
        } else {
            this.absolute(rowNumber, true);
            return;
        }
        this.row_.setRowIndex(this.index_);
    }

    void absolute(int rowNumber, boolean mustAccessServer) throws SQLException {
        if (!mustAccessServer) {
            this.absolute(rowNumber);
            return;
        }
        boolean endBlock = false;
        if (rowNumber > 0) {
            if (this.cursor_.isClosed()) {
                return;
            }
            if (this.cursor_.getCursorAttributeSensitive() == 0 && this.cursor_.getCursorAttributeUpdatable() == 0) {
                endBlock = this.fetch(8, rowNumber);
            } else {
                this.first(true);
                this.relative(rowNumber - 1);
            }
        } else if (rowNumber == 0) {
            this.beforeFirst(true);
        } else {
            this.last(true);
            this.relative(rowNumber + 1);
        }
        this.firstBlock_ = false;
        if (!endBlock) {
            this.index_ = 0;
            this.lastBlock_ = endBlock;
        }
        this.cursorPositionOfFirstRowInCache_ = rowNumber;
        this.row_.setRowIndex(this.index_);
    }

    public void afterLast() throws SQLException {
        if (this.lastBlock_) {
            this.index_ = this.cached_;
        } else {
            this.fetch(5);
            this.firstBlock_ = false;
            this.lastBlock_ = true;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = NOT_KNOWN;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void beforeFirst(boolean mustAccessServer) throws SQLException {
        if (!mustAccessServer) {
            this.beforeFirst();
            return;
        }
        this.fetch(4);
        this.firstBlock_ = true;
        this.lastBlock_ = false;
        this.index_ = -1;
        this.cursorPositionOfFirstRowInCache_ = 0;
        this.row_.setRowIndex(this.index_);
    }

    public void beforeFirst() throws SQLException {
        if (this.firstBlock_) {
            this.index_ = -1;
        } else {
            this.fetch(4);
            this.firstBlock_ = true;
            this.lastBlock_ = false;
            this.index_ = -1;
            this.cursorPositionOfFirstRowInCache_ = 0;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void first() throws SQLException {
        this.first(false);
    }

    void first(boolean mustAccessServer) throws SQLException {
        boolean done = false;
        if (this.emptyChecked_ && !mustAccessServer && this.firstBlock_) {
            this.index_ = 0;
            done = true;
        }
        if (!done || !this.isValid()) {
            this.fetch(2);
            this.firstBlock_ = true;
            this.lastBlock_ = false;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = 1;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void last() throws SQLException {
        this.last(false);
    }

    void last(boolean mustGoToServer) throws SQLException {
        if (this.lastBlock_ && this.cached_ > 0 && !mustGoToServer) {
            this.index_ = this.cached_ - 1;
        } else {
            this.fetch(3);
            this.firstBlock_ = false;
            this.lastBlock_ = true;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = NOT_KNOWN;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void next() throws SQLException {
        if (this.index_ < this.cached_ - 1) {
            ++this.index_;
        } else if (this.lastBlock_) {
            this.index_ = this.cached_;
        } else {
            boolean wasBeforeFirst = this.index_ == -1;
            int oldCached = this.cached_;
            this.lastBlock_ = this.fetch(0);
            this.firstBlock_ = false;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = this.cursorPositionOfFirstRowInCache_ > 0 ? (this.cursorPositionOfFirstRowInCache_ += oldCached) : (wasBeforeFirst ? 1 : NOT_KNOWN);
        }
        this.row_.setRowIndex(this.index_);
    }

    public void previous() throws SQLException {
        if (this.index_ >= 1 && this.cached_ > 0) {
            --this.index_;
        } else if (!this.firstBlock_) {
            if (this.cached_ > 1) {
                if (this.cursorPositionOfFirstRowInCache_ > 0) {
                    this.absolute(this.cursorPositionOfFirstRowInCache_, true);
                } else {
                    JDError.throwSQLException("HY000");
                }
            }
            this.firstBlock_ = this.fetch(1);
            this.lastBlock_ = false;
            this.index_ = this.cached_ - 1;
            this.cursorPositionOfFirstRowInCache_ = this.firstBlock_ ? 1 : --this.cursorPositionOfFirstRowInCache_;
        } else {
            this.index_ = -1;
        }
        if (this.index_ == -1 && this.cached_ == 0) {
            this.cursorPositionOfFirstRowInCache_ = 0;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void relative(int rowNumber) throws SQLException {
        if (rowNumber != 0) {
            int newIndex = this.index_ + rowNumber;
            if (newIndex >= 0 && newIndex < this.cached_) {
                this.index_ = newIndex;
            } else if (newIndex >= 0 && newIndex == this.cached_ && this.cursor_.isClosed()) {
                this.index_ = newIndex;
            } else {
                if (this.cached_ > 1) {
                    if (this.cursorPositionOfFirstRowInCache_ > 0) {
                        this.absolute(this.cursorPositionOfFirstRowInCache_ + this.index_, true);
                    } else {
                        JDError.throwSQLException("HY000");
                    }
                }
                if (this.index_ == -1 && this.cached_ > 0) {
                    --rowNumber;
                } else if (this.index_ == this.cached_) {
                    rowNumber += this.index_;
                }
                boolean endBlock = this.fetch(7, rowNumber);
                this.firstBlock_ = false;
                if (!endBlock) {
                    this.index_ = 0;
                    this.lastBlock_ = endBlock;
                } else if (rowNumber < 0) {
                    this.index_ = -1;
                    this.cursorPositionOfFirstRowInCache_ = 0;
                } else {
                    this.cursorPositionOfFirstRowInCache_ = NOT_KNOWN;
                }
                this.cursorPositionOfFirstRowInCache_ = this.cursorPositionOfFirstRowInCache_ >= 0 ? (this.cursorPositionOfFirstRowInCache_ += rowNumber) : NOT_KNOWN;
            }
        }
        this.row_.setRowIndex(this.index_);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.fetchReply != null) {
            this.fetchReply.returnToPool();
            this.fetchReply = null;
        }
    }

    public void setResultSet(AS400JDBCResultSet resultSet) {
        this.resultSet_ = resultSet;
    }
}

