/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDTransactionManager {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int COMMIT_SERVER_MODE_CS_ = 1;
    private static final int COMMIT_SERVER_MODE_CHG_ = 2;
    static final int COMMIT_MODE_NOT_SET_ = -1;
    private static final int COMMIT_MODE_NONE_ = 0;
    private static final int COMMIT_MODE_CHG_ = 1;
    private static final int COMMIT_MODE_CS_ = 2;
    private static final int COMMIT_MODE_ALL_ = 3;
    private static final int COMMIT_MODE_RR_ = 4;
    private static final String[] COMMIT_MODE_ = new String[]{"NONE", "CHG", "CS", "ALL", "RR"};
    static final int CURSOR_HOLD_FALSE = 0;
    static final int CURSOR_HOLD_TRUE = 1;
    private boolean activeLocal_ = false;
    private boolean activeGlobal_ = false;
    private boolean autoCommit_;
    private AS400JDBCConnection connection_;
    private int holdIndicator_;
    private int currentCommitMode_;
    private int currentIsolationLevel_;
    private int id_;
    private int initialCommitMode_;
    private boolean localAutoCommit_ = true;
    private boolean localTransaction_ = true;
    private int serverCommitMode_;
    private int currentLocatorPersistence_ = -1;
    private int requestedLocatorPersistence_ = -1;
    private boolean serverAllowsLocatorPersistenceChange_ = true;

    JDTransactionManager(AS400JDBCConnection connection, int id, String initialLevel, boolean autoCommit) throws SQLException {
        this.autoCommit_ = autoCommit;
        this.connection_ = connection;
        this.holdIndicator_ = 1;
        this.id_ = id;
        this.currentIsolationLevel_ = JDTransactionManager.mapStringToLevel(initialLevel);
        this.initialCommitMode_ = this.currentCommitMode_ = JDTransactionManager.mapLevelToCommitMode(this.currentIsolationLevel_);
        this.serverCommitMode_ = this.connection_.getNewAutoCommitSupport() == 1 && autoCommit ? 0 : this.currentCommitMode_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws SQLException {
        try {
            DBReplyRequestedDS reply;
            block8: {
                DBSQLRequestDS request = null;
                reply = null;
                try {
                    request = DBDSPool.getDBSQLRequestDS(6151, this.id_, Integer.MIN_VALUE, 0);
                    request.setHoldIndicator(this.getHoldIndicator());
                    reply = this.connection_.sendAndReceive(request);
                    int errorClass = reply.getErrorClass();
                    if (errorClass != 0) {
                        int returnCode = reply.getReturnCode();
                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                    }
                    Object var6_6 = null;
                    if (request == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        this.resetServer();
        this.activeLocal_ = false;
    }

    boolean getAutoCommit() {
        return this.autoCommit_;
    }

    int getCommitMode() {
        if (this.serverCommitMode_ == 1) {
            return 2;
        }
        if (this.serverCommitMode_ == 2) {
            return 1;
        }
        return this.serverCommitMode_;
    }

    int getHoldIndicator() {
        return this.holdIndicator_;
    }

    int getIsolation() {
        return this.currentIsolationLevel_;
    }

    boolean isGlobalActive() {
        return this.activeGlobal_;
    }

    boolean isLocalActive() {
        return this.activeLocal_;
    }

    boolean isLocalTransaction() {
        return this.localTransaction_;
    }

    private static int mapLevelToCommitMode(int level) throws SQLException {
        int result;
        switch (level) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            case 4: {
                result = 3;
                break;
            }
            case 8: {
                result = 4;
                break;
            }
            default: {
                JDError.throwSQLException("HY024");
                result = -1;
            }
        }
        return result;
    }

    static int mapStringToLevel(String levelAsString) throws SQLException {
        int result;
        if (levelAsString.equalsIgnoreCase("none")) {
            result = 0;
        } else if (levelAsString.equalsIgnoreCase("read committed")) {
            result = 2;
        } else if (levelAsString.equalsIgnoreCase("read uncommitted")) {
            result = 1;
        } else if (levelAsString.equalsIgnoreCase("repeatable read")) {
            result = 4;
        } else if (levelAsString.equalsIgnoreCase("serializable")) {
            result = 8;
        } else {
            JDError.throwSQLException("HY024");
            result = -1;
        }
        return result;
    }

    void markGlobalTransactionBoundary() {
        this.activeGlobal_ = false;
    }

    void processCommitOnReturn(DBBaseReplyDS reply) throws DBDataStreamException {
        DBReplySQLCA sqlca = reply.getSQLCA();
        if (sqlca.getEyecatcherBit54()) {
            this.activeLocal_ = false;
        }
    }

    private void resetServer() throws SQLException {
        if (this.connection_.getNewAutoCommitSupport() == 0) {
            this.serverCommitMode_ = this.initialCommitMode_;
            this.setCommitMode(this.currentCommitMode_);
        }
    }

    void resetXAServer() throws SQLException {
        this.resetServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws SQLException {
        try {
            DBReplyRequestedDS reply;
            block8: {
                DBSQLRequestDS request = null;
                reply = null;
                try {
                    request = DBDSPool.getDBSQLRequestDS(6152, this.id_, Integer.MIN_VALUE, 0);
                    request.setHoldIndicator(this.getHoldIndicator());
                    reply = this.connection_.sendAndReceive(request);
                    int errorClass = reply.getErrorClass();
                    if (errorClass != 0) {
                        int returnCode = reply.getReturnCode();
                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                    }
                    Object var6_6 = null;
                    if (request == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        this.resetServer();
        this.activeLocal_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setAutoCommit(boolean autoCommit) throws SQLException {
        DBReplyRequestedDS reply;
        block12: {
            if (!this.localTransaction_) {
                if (autoCommit) {
                    JDError.throwSQLException("25000");
                    return;
                }
                this.localAutoCommit_ = false;
                return;
            }
            if (!this.autoCommit_ && autoCommit && this.activeLocal_) {
                this.commit();
                this.connection_.postWarning(JDError.getSQLWarning("01H30"));
            }
            this.autoCommit_ = autoCommit;
            if (this.connection_.getNewAutoCommitSupport() == 0) {
                this.setCommitMode(this.currentCommitMode_);
                return;
            }
            DBSQLAttributesDS request = null;
            reply = null;
            try {
                try {
                    request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    request.setAutoCommit(autoCommit ? 232 : 213);
                    request.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                    this.serverCommitMode_ = this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1 ? 0 : this.currentCommitMode_;
                    boolean changed = this.setRequestLocatorPersistence(request, this.getIsolationLevel());
                    reply = this.connection_.sendAndReceive(request);
                    int errorClass = reply.getErrorClass();
                    int returnCode = reply.getReturnCode();
                    if (errorClass != 0 && changed) {
                        this.serverAllowsLocatorPersistenceChange_ = false;
                        request.returnToPool();
                        request = null;
                        reply.returnToPool();
                        reply = null;
                        request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        request.setAutoCommit(autoCommit ? 232 : 213);
                        request.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        this.serverCommitMode_ = this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1 ? 0 : this.currentCommitMode_;
                        reply = this.connection_.sendAndReceive(request);
                        errorClass = reply.getErrorClass();
                        returnCode = reply.getReturnCode();
                    }
                    if (errorClass != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                    }
                    this.persistenceUpdated();
                }
                catch (DBDataStreamException e) {
                    JDError.throwSQLException("HY000", e);
                    Object var8_9 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply == null) return;
                    reply.returnToPool();
                    return;
                }
                Object var8_8 = null;
                if (request == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
                if (reply == null) throw throwable;
                reply.returnToPool();
                reply = null;
                throw throwable;
            }
            request.returnToPool();
            request = null;
        }
        if (reply == null) return;
        reply.returnToPool();
    }

    private boolean setRequestLocatorPersistence(DBSQLAttributesDS request, int commitMode) throws DBDataStreamException {
        this.requestedLocatorPersistence_ = -1;
        if (this.serverAllowsLocatorPersistenceChange_) {
            if (commitMode == 0) {
                if (this.currentLocatorPersistence_ != 0) {
                    request.setLocatorPersistence(0);
                    this.requestedLocatorPersistence_ = 0;
                    return true;
                }
            } else if (this.currentLocatorPersistence_ != 1) {
                request.setLocatorPersistence(1);
                this.requestedLocatorPersistence_ = 1;
                return true;
            }
        }
        return false;
    }

    private void persistenceUpdated() {
        if (this.serverAllowsLocatorPersistenceChange_ && this.requestedLocatorPersistence_ != -1) {
            this.currentLocatorPersistence_ = this.requestedLocatorPersistence_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCommitMode(int commitMode) throws SQLException {
        if (this.autoCommit_) {
            commitMode = 0;
        }
        if (commitMode != this.serverCommitMode_) {
            JDSQLStatement sqlStatement = new JDSQLStatement("SET TRANSACTION ISOLATION LEVEL " + COMMIT_MODE_[commitMode]);
            try {
                DBReplyRequestedDS reply;
                block11: {
                    DBSQLRequestDS request = null;
                    reply = null;
                    try {
                        request = DBDSPool.getDBSQLRequestDS(6150, this.id_, -2113929216, 0);
                        boolean extended = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            extended = true;
                        }
                        request.setStatementText(sqlStatement.toString(), this.connection_.getPackageCCSID_Converter(), extended);
                        request.setStatementType(sqlStatement.getNativeType());
                        request.setCursorName("MURCH", this.connection_.getConverter());
                        reply = this.connection_.sendAndReceive(request);
                        int errorClass = reply.getErrorClass();
                        int returnCode = reply.getReturnCode();
                        if (errorClass != 0) {
                            JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                        }
                        Object var9_9 = null;
                        if (request == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (reply != null) {
                            reply.returnToPool();
                            reply = null;
                        }
                        throw throwable;
                    }
                    request.returnToPool();
                    request = null;
                }
                if (reply != null) {
                    reply.returnToPool();
                    reply = null;
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
            this.serverCommitMode_ = commitMode;
        }
    }

    void setHoldIndicator(String hold) throws SQLException {
        if (hold.equalsIgnoreCase("TRUE")) {
            this.holdIndicator_ = 1;
        } else if (hold.equalsIgnoreCase("FALSE")) {
            this.holdIndicator_ = 0;
        } else {
            JDError.throwSQLException("HY024");
            this.holdIndicator_ = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setIsolation(int level) throws SQLException {
        int commitMode;
        block14: {
            DBReplyRequestedDS reply;
            block15: {
                if (this.activeLocal_ && this.connection_.getNewAutoCommitSupport() == 0) {
                    JDError.throwSQLException("25000");
                }
                this.currentCommitMode_ = JDTransactionManager.mapLevelToCommitMode(level);
                this.currentIsolationLevel_ = level;
                if (this.connection_.getNewAutoCommitSupport() == 0) {
                    this.setCommitMode(this.currentCommitMode_);
                    return;
                }
                DBBaseRequestDS request = null;
                reply = null;
                commitMode = this.currentCommitMode_;
                try {
                    block13: {
                        try {
                            if (this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1) {
                                commitMode = 0;
                            }
                            if (this.serverCommitMode_ == commitMode) break block13;
                            request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                            ((DBSQLAttributesDS)request).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                            boolean changed = this.setRequestLocatorPersistence((DBSQLAttributesDS)request, this.getIsolationLevel());
                            reply = this.connection_.sendAndReceive(request);
                            int errorClass = reply.getErrorClass();
                            int returnCode = reply.getReturnCode();
                            if (errorClass != 0 && changed) {
                                this.serverAllowsLocatorPersistenceChange_ = false;
                                request.returnToPool();
                                request = null;
                                reply.returnToPool();
                                reply = null;
                                request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                                ((DBSQLAttributesDS)request).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                                reply = this.connection_.sendAndReceive(request);
                                errorClass = reply.getErrorClass();
                                returnCode = reply.getReturnCode();
                            }
                            if (errorClass != 0) {
                                JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                            }
                            this.persistenceUpdated();
                        }
                        catch (DBDataStreamException e) {
                            JDError.throwSQLException("HY000", e);
                            Object var9_10 = null;
                            if (request != null) {
                                request.returnToPool();
                                request = null;
                            }
                            if (reply != null) {
                                reply.returnToPool();
                                reply = null;
                            }
                            break block14;
                        }
                    }
                    Object var9_9 = null;
                    if (request == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply == null) throw throwable;
                    reply.returnToPool();
                    reply = null;
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
        }
        this.serverCommitMode_ = commitMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setLocalTransaction(boolean enableLocalTransaction) throws SQLException {
        block26: {
            DBReplyRequestedDS reply;
            block27: {
                this.localTransaction_ = enableLocalTransaction;
                if (this.localTransaction_) {
                    DBReplyRequestedDS reply2;
                    block25: {
                        this.autoCommit_ = this.localAutoCommit_;
                        if (this.connection_.getNewAutoCommitSupport() == 0) {
                            this.setCommitMode(this.currentCommitMode_);
                            return;
                        }
                        DBSQLAttributesDS request2 = null;
                        reply2 = null;
                        try {
                            try {
                                request2 = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                                request2.setAutoCommit(this.autoCommit_ ? 232 : 213);
                                boolean changed = false;
                                if (this.connection_.getNewAutoCommitSupport() == 1 && this.autoCommit_) {
                                    request2.setCommitmentControlLevelParserOption(0);
                                    changed = this.setRequestLocatorPersistence(request2, 0);
                                    this.serverCommitMode_ = 0;
                                }
                                reply2 = this.connection_.sendAndReceive(request2);
                                int errorClass = reply2.getErrorClass();
                                int returnCode = reply2.getReturnCode();
                                if (errorClass != 0 && changed) {
                                    this.serverAllowsLocatorPersistenceChange_ = false;
                                    request2.returnToPool();
                                    request2 = null;
                                    reply2.returnToPool();
                                    reply2 = null;
                                    request2 = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                                    request2.setAutoCommit(this.autoCommit_ ? 232 : 213);
                                    if (this.connection_.getNewAutoCommitSupport() == 1 && this.autoCommit_) {
                                        request2.setCommitmentControlLevelParserOption(0);
                                        this.serverCommitMode_ = 0;
                                    }
                                    reply2 = this.connection_.sendAndReceive(request2);
                                    errorClass = reply2.getErrorClass();
                                    returnCode = reply2.getReturnCode();
                                }
                                if (errorClass != 0) {
                                    JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                                }
                                this.persistenceUpdated();
                            }
                            catch (DBDataStreamException e) {
                                JDError.throwSQLException("HY000", e);
                                Object var8_15 = null;
                                if (request2 != null) {
                                    request2.returnToPool();
                                    request2 = null;
                                }
                                if (reply2 == null) return;
                                reply2.returnToPool();
                                return;
                            }
                            Object var8_14 = null;
                            if (request2 == null) break block25;
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            if (request2 != null) {
                                request2.returnToPool();
                                request2 = null;
                            }
                            if (reply2 == null) throw throwable;
                            reply2.returnToPool();
                            reply2 = null;
                            throw throwable;
                        }
                        request2.returnToPool();
                        request2 = null;
                    }
                    if (reply2 == null) return;
                    reply2.returnToPool();
                    return;
                }
                this.localAutoCommit_ = this.autoCommit_;
                this.autoCommit_ = false;
                if (this.connection_.getNewAutoCommitSupport() == 0) {
                    this.setCommitMode(this.currentCommitMode_);
                    return;
                }
                DBSQLAttributesDS request = null;
                reply = null;
                try {
                    try {
                        request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        request.setAutoCommit(213);
                        if (this.serverCommitMode_ != this.currentCommitMode_) {
                            request.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        }
                        boolean changed = this.setRequestLocatorPersistence(request, this.getIsolationLevel());
                        reply = this.connection_.sendAndReceive(request);
                        int errorClass = reply.getErrorClass();
                        int returnCode = reply.getReturnCode();
                        if (errorClass != 0 && changed) {
                            this.serverAllowsLocatorPersistenceChange_ = false;
                            request.returnToPool();
                            request = null;
                            reply.returnToPool();
                            reply = null;
                            request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                            request.setAutoCommit(213);
                            if (this.serverCommitMode_ != this.currentCommitMode_) {
                                request.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                            }
                            reply = this.connection_.sendAndReceive(request);
                            errorClass = reply.getErrorClass();
                            returnCode = reply.getReturnCode();
                        }
                        if (errorClass != 0) {
                            JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                        }
                        this.persistenceUpdated();
                    }
                    catch (DBDataStreamException e) {
                        JDError.throwSQLException("HY000", e);
                        Object var10_19 = null;
                        if (request != null) {
                            request.returnToPool();
                            request = null;
                        }
                        if (reply != null) {
                            reply.returnToPool();
                            reply = null;
                        }
                        break block26;
                    }
                    Object var10_18 = null;
                    if (request == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var10_20 = null;
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply == null) throw throwable;
                    reply.returnToPool();
                    reply = null;
                    throw throwable;
                }
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
        }
        this.serverCommitMode_ = this.currentCommitMode_;
    }

    void statementExecuted() {
        if (this.localTransaction_) {
            this.activeLocal_ = !this.autoCommit_;
        } else {
            this.activeGlobal_ = true;
        }
    }

    private int getIsolationLevel() {
        int isolationLevel = this.currentCommitMode_;
        if (isolationLevel == 1) {
            isolationLevel = 2;
        } else if (isolationLevel == 2) {
            isolationLevel = 1;
        }
        if (this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1) {
            isolationLevel = 0;
        }
        return isolationLevel;
    }
}

