/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CallStackEntry;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IntegerHashtable;
import com.ibm.as400.access.JobHashtable;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Job
implements Serializable {
    static final long serialVersionUID = 6L;
    private static final byte[] BLANKS16_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    private static final Boolean ON_THREAD = ProgramCall.THREADSAFE_TRUE;
    private static final Boolean OFF_THREAD = ProgramCall.THREADSAFE_FALSE;
    private boolean cacheChanges_ = true;
    private boolean isConnected_ = false;
    private final JobHashtable values_ = new JobHashtable();
    private JobHashtable cachedChanges_ = null;
    private String name_;
    private String user_;
    private String number_;
    private String status_;
    private String type_;
    private String subtype_;
    private AS400 system_;
    private String internalJobID_;
    private byte[] realInternalJobID_;
    private transient PropertyChangeSupport propertyChangeListeners_;
    private transient VetoableChangeSupport vetoableChangeListeners_;
    private transient CommandCall cmdCall_;
    private transient ProgramCall pgmCall_;
    private transient ProgramCall pgmCall_onThread_;
    private transient ProgramCall pgmCall_offThread_;
    private transient Object remoteCommandLock_ = new Object();
    private transient AS400Timestamp timestampConverter_;
    public static final int ACCOUNTING_CODE = 1001;
    public static final String ACCOUNTING_CODE_BLANK = "*BLANK";
    public static final int ACTIVE_JOB_STATUS = 101;
    public static final String ACTIVE_JOB_STATUS_NONE = "    ";
    public static final String ACTIVE_JOB_STATUS_WAIT_BIN_SYNCH_DEVICE_AND_ACTIVE = "BSCA";
    public static final String ACTIVE_JOB_STATUS_WAIT_BIN_SYNCH_DEVICE = "BSCW";
    public static final String ACTIVE_JOB_STATUS_WAIT_COMM_DEVICE_AND_ACTIVE = "CMNA";
    public static final String ACTIVE_JOB_STATUS_WAIT_COMM_DEVICE = "CMNW";
    public static final String ACTIVE_JOB_STATUS_WAIT_CHECKPOINT = "CMTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_CONDITION = "CNDW";
    public static final String ACTIVE_JOB_STATUS_WAIT_CPI_COMM = "CPCW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DEQUEUE_AND_ACTIVE = "DEQA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DEQUEUE = "DEQW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISKETTE_AND_ACTIVE = "DKTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISKETTE = "DKTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DELAYED = "DLYW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DELAY = "DLYW";
    public static final String ACTIVE_JOB_STATUS_DISCONNECTED = "DSC ";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISPLAY_AND_ACTIVE = "DSPA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISPLAY = "DSPW";
    public static final String ACTIVE_JOB_STATUS_ENDED = "END ";
    public static final String ACTIVE_JOB_STATUS_WAIT_DATABASE_EOF_AND_ACTIVE = "EOFA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DATABASE_EOF = "EOFW";
    public static final String ACTIVE_JOB_STATUS_ENDING = "EOJ ";
    public static final String ACTIVE_JOB_STATUS_WAIT_EVENT = "EVTW";
    public static final String ACTIVE_JOB_STATUS_SUSPENDED = "GRP ";
    public static final String ACTIVE_JOB_STATUS_HELD = "HLD ";
    public static final String ACTIVE_JOB_STATUS_HELD_THREAD = "HLDT";
    public static final String ACTIVE_JOB_STATUS_WAIT_ICF_FILE_AND_ACTIVE = "ICFA";
    public static final String ACTIVE_JOB_STATUS_WAIT_ICF_FILE = "ICFW";
    public static final String ACTIVE_JOB_STATUS_INELIGIBLE = "INEL";
    public static final String ACTIVE_JOB_STATUS_WAIT_JAVA_AND_ACTIVE = "JVAA";
    public static final String ACTIVE_JOB_STATUS_WAIT_JAVA = "JVAW";
    public static final String ACTIVE_JOB_STATUS_WAIT_LOCK = "LCKW";
    public static final String ACTIVE_JOB_STATUS_WAIT_LOCK_SPACE_AND_ACTIVE = "LSPA";
    public static final String ACTIVE_JOB_STATUS_WAIT_LOCK_SPACE = "LSPW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MULTIPLE_FILES_AND_ACTIVE = "MLTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_MULTIPLE_FILES = "MLTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MESSAGE = "MSGW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MUTEX = "MTXW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MIXED_DEVICE_FILE = "MXDW";
    public static final String ACTIVE_JOB_STATUS_WAIT_OPTICAL_DEVICE_AND_ACTIVE = "OPTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_OPTICAL_DEVICE = "OPTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_OSI = "OSIW";
    public static final String ACTIVE_JOB_STATUS_WAIT_PRINT_AND_ACTIVE = "PRTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_PRINT = "PRTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_PRESTART = "PSRW";
    public static final String ACTIVE_JOB_STATUS_RUNNING = "RUN ";
    public static final String ACTIVE_JOB_STATUS_WAIT_SELECTION = "SELW";
    public static final String ACTIVE_JOB_STATUS_WAIT_SEMAPHORE = "SEMW";
    public static final String ACTIVE_JOB_STATUS_STOPPED = "SIGS";
    public static final String ACTIVE_JOB_STATUS_WAIT_SIGNAL = "SIGW";
    public static final String ACTIVE_JOB_STATUS_SUSPENDED_SYSTEM_REQUEST = "SRQ ";
    public static final String ACTIVE_JOB_STATUS_WAIT_SAVE_FILE_AND_ACTIVE = "SVFA";
    public static final String ACTIVE_JOB_STATUS_WAIT_SAVE_FILE = "SVFW";
    public static final String ACTIVE_JOB_STATUS_WAIT_TAPE_DEVICE_AND_ACTIVE = "TAPA";
    public static final String ACTIVE_JOB_STATUS_WAIT_TAPE_DEVICE = "TAPW";
    public static final String ACTIVE_JOB_STATUS_WAIT_THREAD = "THDW";
    public static final String ACTIVE_JOB_STATUS_WAIT_TIME_INTERVAL_AND_ACTIVE = "TIMA";
    public static final String ACTIVE_JOB_STATUS_WAIT_TIME_INTERVAL = "TIMW";
    public static final int ACTIVE_JOB_STATUS_FOR_JOBS_ENDING = 103;
    public static final int ASP_GROUP = 104;
    public static final int ALLOW_MULTIPLE_THREADS = 102;
    public static final String ALLOW_MULTIPLE_THREADS_NO = "0";
    public static final String ALLOW_MULTIPLE_THREADS_YES = "1";
    public static final int AUXILIARY_IO_REQUESTS = 1401;
    public static final int AUXILIARY_IO_REQUESTS_LARGE = 1406;
    public static final int BREAK_MESSAGE_HANDLING = 201;
    public static final String BREAK_MESSAGE_HANDLING_NORMAL = "*NORMAL";
    public static final String BREAK_MESSAGE_HANDLING_HOLD = "*HOLD";
    public static final String BREAK_MESSAGE_HANDLING_NOTIFY = "*NOTIFY";
    public static final int CCSID = 302;
    public static final int CCSID_SYSTEM_VALUE = -1;
    public static final int CCSID_INITIAL_USER = -2;
    public static final int CHARACTER_ID_CONTROL = 311;
    public static final String CHARACTER_ID_CONTROL_DEVICE = "*DEVD";
    public static final String CHARACTER_ID_CONTROL_JOB = "*JOBCCSID";
    public static final String CHARACTER_ID_CONTROL_SYSTEM_VALUE = "*SYSVAL";
    public static final String CHARACTER_ID_CONTROL_INITIAL_USER = "*USRPRF";
    public static final int CLIENT_IP_ADDRESS = 318;
    public static final int COMPLETION_STATUS = 306;
    public static final String COMPLETION_STATUS_NOT_COMPLETED = " ";
    public static final String COMPLETION_STATUS_COMPLETED_NORMALLY = "0";
    public static final String COMPLETION_STATUS_COMPLETED_ABNORMALLY = "1";
    public static final int CONTROLLED_END_REQUESTED = 502;
    public static final String END_STATUS_CANCELLED = "1";
    public static final String END_STATUS_NOT_CANCELLED = "0";
    public static final String END_STATUS_JOB_NOT_RUNNING = " ";
    public static final int ELAPSED_CPU_PERCENT_USED = 314;
    public static final int ELAPSED_CPU_PERCENT_USED_FOR_DATABASE = 316;
    public static final int ELAPSED_CPU_TIME_USED = 315;
    public static final int ELAPSED_CPU_TIME_USED_FOR_DATABASE = 317;
    public static final int ELAPSED_DISK_IO = 414;
    public static final int ELAPSED_DISK_IO_ASYNCH = 416;
    public static final int ELAPSED_DISK_IO_SYNCH = 417;
    public static final int ELAPSED_INTERACTIVE_RESPONSE_TIME = 904;
    public static final int ELAPSED_INTERACTIVE_TRANSACTIONS = 905;
    public static final int ELAPSED_LOCK_WAIT_TIME = 10008;
    public static final int ELAPSED_PAGE_FAULTS = 1609;
    public static final int ELAPSED_TIME = 10007;
    public static final int COUNTRY_ID = 303;
    public static final String COUNTRY_ID_SYSTEM_VALUE = "*SYSVAL";
    public static final String COUNTRY_ID_INITIAL_USER = "*USRPRF";
    public static final int CPU_TIME_USED = 304;
    public static final int CPU_TIME_USED_LARGE = 312;
    public static final int CPU_TIME_USED_FOR_DATABASE = 313;
    public static final int CURRENT_LIBRARY = 10000;
    public static final int CURRENT_LIBRARY_EXISTENCE = 10001;
    public static final int CURRENT_SYSTEM_POOL_ID = 307;
    public static final int CURRENT_USER = 305;
    public static final int DATE_ENDED = 418;
    public static final int DATE_ENTERED_SYSTEM = 402;
    public static final int DATE_FORMAT = 405;
    public static final String DATE_FORMAT_SYSTEM_VALUE = "*SYS";
    public static final String DATE_FORMAT_YMD = "*YMD";
    public static final String DATE_FORMAT_MDY = "*MDY";
    public static final String DATE_FORMAT_DMY = "*DMY";
    public static final String DATE_FORMAT_JULIAN = "*JUL";
    public static final int DATE_SEPARATOR = 406;
    public static final String DATE_SEPARATOR_SYSTEM_VALUE = "S";
    public static final String DATE_SEPARATOR_SLASH = "/";
    public static final String DATE_SEPARATOR_DASH = "-";
    public static final String DATE_SEPARATOR_PERIOD = ".";
    public static final String DATE_SEPARATOR_BLANK = " ";
    public static final String DATE_SEPARATOR_COMMA = ",";
    public static final int DATE_STARTED = 401;
    public static final int DBCS_CAPABLE = 407;
    public static final String DBCS_CAPABLE_NO = "0";
    public static final String DBCS_CAPABLE_YES = "1";
    public static final int DECIMAL_FORMAT = 413;
    public static final String DECIMAL_FORMAT_SYSTEM_VALUE = "*SYSVAL";
    public static final String DECIMAL_FORMAT_PERIOD = "";
    public static final String DECIMAL_FORMAT_COMMA_J = "J";
    public static final String DECIMAL_FORMAT_COMMA_I = "I";
    public static final int DEFAULT_CCSID = 412;
    public static final int DEFAULT_WAIT_TIME = 409;
    public static final int DEVICE_RECOVERY_ACTION = 410;
    public static final String DEVICE_RECOVERY_ACTION_SYSTEM_VALUE = "*SYSVAL";
    public static final String DEVICE_RECOVERY_ACTION_MESSAGE = "*MSG";
    public static final String DEVICE_RECOVERY_ACTION_DISCONNECT_MESSAGE = "*DSCMSG";
    public static final String DEVICE_RECOVERY_ACTION_DISCONNECT_END_REQUEST = "*DSCENDRQS";
    public static final String DEVICE_RECOVERY_ACTION_END_JOB = "*ENDJOB";
    public static final String DEVICE_RECOVERY_ACTION_END_JOB_NO_LIST = "*ENDJOBNOLIST";
    public static final int ELIGIBLE_FOR_PURGE = 1604;
    public static final String ELIGIBLE_FOR_PURGE_YES = "*YES";
    public static final String ELIGIBLE_FOR_PURGE_NO = "*NO";
    public static final String ELIGIBLE_FOR_PURGE_IGNORED = "";
    public static final int END_SEVERITY = 501;
    public static final int FUNCTION_NAME = 601;
    public static final int FUNCTION_TYPE = 602;
    public static final String FUNCTION_TYPE_BLANK = "";
    public static final String FUNCTION_TYPE_COMMAND = "C";
    public static final String FUNCTION_TYPE_DELAY = "D";
    public static final String FUNCTION_TYPE_GROUP = "G";
    public static final String FUNCTION_TYPE_INDEX = "I";
    public static final String FUNCTION_TYPE_JAVA = "J";
    public static final String FUNCTION_TYPE_LOG = "L";
    public static final String FUNCTION_TYPE_MRT = "M";
    public static final String FUNCTION_TYPE_MENU = "N";
    public static final String FUNCTION_TYPE_IO = "O";
    public static final String FUNCTION_TYPE_PROCEDURE = "R";
    public static final String FUNCTION_TYPE_PROGRAM = "P";
    public static final String FUNCTION_TYPE_SPECIAL = "*";
    public static final long INITIAL_THREAD = -1L;
    public static final int INQUIRY_MESSAGE_REPLY = 901;
    public static final String INQUIRY_MESSAGE_REPLY_REQUIRED = "*RQD";
    public static final String INQUIRY_MESSAGE_REPLY_DEFAULT = "*DFT";
    public static final String INQUIRY_MESSAGE_REPLY_SYSTEM_REPLY_LIST = "*SYSRPYL";
    public static final int INTERACTIVE_TRANSACTIONS = 1402;
    public static final int INTERNAL_JOB_ID = 11000;
    public static final int INTERNAL_JOB_IDENTIFIER = 11007;
    public static final int JOB_DATE = 1002;
    public static final int JOB_DESCRIPTION = 1003;
    public static final int JOB_END_REASON = 1014;
    public static final int JOB_LOG_OUTPUT = 1018;
    public static final String JOB_LOG_OUTPUT_SYSTEM_VALUE = "*SYSVAL";
    public static final String JOB_LOG_OUTPUT_JOB_LOG_SERVER = "*JOBLOGSVR";
    public static final String JOB_LOG_OUTPUT_JOB_END = "*JOBEND";
    public static final String JOB_LOG_OUTPUT_PENDING = "*PND";
    public static final int JOB_LOG_PENDING = 1015;
    public static final String JOB_LOG_PENDING_NO = "0";
    public static final String JOB_LOG_PENDING_YES = "1";
    public static final int JOB_NAME = 11001;
    public static final String JOB_NAME_INTERNAL = "*INT";
    public static final String JOB_NAME_CURRENT = "*";
    public static final int JOB_NUMBER = 11002;
    public static final String JOB_NUMBER_BLANK = "";
    public static final int JOB_QUEUE = 1004;
    public static final int JOB_QUEUE_DATE = 404;
    public static final int JOB_QUEUE_PRIORITY = 1005;
    public static final int JOB_QUEUE_STATUS = 1903;
    public static final String JOB_QUEUE_STATUS_BLANK = "";
    public static final String JOB_QUEUE_STATUS_SCHEDULED = "SCD";
    public static final String JOB_QUEUE_STATUS_HELD = "HLD";
    public static final String JOB_QUEUE_STATUS_READY = "RLS";
    public static final int JOB_STATUS = 11003;
    public static final String JOB_STATUS_ACTIVE = "*ACTIVE";
    public static final String JOB_STATUS_JOBQ = "*JOBQ";
    public static final String JOB_STATUS_OUTQ = "*OUTQ";
    public static final int JOB_SUBTYPE = 11004;
    public static final String JOB_SUBTYPE_BLANK = "";
    public static final String JOB_SUBTYPE_IMMEDIATE = "D";
    public static final String JOB_SUBTYPE_PROCEDURE_START_REQUEST = "E";
    public static final String JOB_SUBTYPE_MACHINE_SERVER_JOB = "F";
    public static final String JOB_SUBTYPE_PRESTART = "J";
    public static final String JOB_SUBTYPE_PRINT_DRIVER = "P";
    public static final String JOB_SUBTYPE_MRT = "T";
    public static final String JOB_SUBTYPE_ALTERNATE_SPOOL_USER = "U";
    public static final int JOB_SWITCHES = 1006;
    public static final int JOB_TYPE = 11005;
    public static final String JOB_TYPE_NOT_VALID = "";
    public static final String JOB_TYPE_AUTOSTART = "A";
    public static final String JOB_TYPE_BATCH = "B";
    public static final String JOB_TYPE_INTERACTIVE = "I";
    public static final String JOB_TYPE_SUBSYSTEM_MONITOR = "M";
    public static final String JOB_TYPE_SPOOLED_READER = "R";
    public static final String JOB_TYPE_SYSTEM = "S";
    public static final String JOB_TYPE_SPOOLED_WRITER = "W";
    public static final String JOB_TYPE_SCPF_SYSTEM = "X";
    public static final int JOB_TYPE_ENHANCED = 1016;
    public static final Integer JOB_TYPE_ENHANCED_AUTOSTART = new Integer(110);
    public static final Integer JOB_TYPE_ENHANCED_BATCH = new Integer(210);
    public static final Integer JOB_TYPE_ENHANCED_BATCH_IMMEDIATE = new Integer(220);
    public static final Integer JOB_TYPE_ENHANCED_BATCH_MRT = new Integer(230);
    public static final Integer JOB_TYPE_ENHANCED_BATCH_ALTERNATE_SPOOL_USER = new Integer(240);
    public static final Integer JOB_TYPE_ENHANCED_COMM_PROCEDURE_START_REQUEST = new Integer(310);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE = new Integer(910);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE_GROUP = new Integer(920);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE_SYSREQ = new Integer(930);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE_SYSREQ_AND_GROUP = new Integer(940);
    public static final Integer JOB_TYPE_ENHANCED_PRESTART = new Integer(1610);
    public static final Integer JOB_TYPE_ENHANCED_PRESTART_BATCH = new Integer(1620);
    public static final Integer JOB_TYPE_ENHANCED_PRESTART_COMM = new Integer(1630);
    public static final Integer JOB_TYPE_ENHANCED_READER = new Integer(1810);
    public static final Integer JOB_TYPE_ENHANCED_SUBSYSTEM = new Integer(1910);
    public static final Integer JOB_TYPE_ENHANCED_SYSTEM = new Integer(1920);
    public static final Integer JOB_TYPE_ENHANCED_WRITER = new Integer(2310);
    public static final int JOB_USER_IDENTITY = 1012;
    public static final int JOB_USER_IDENTITY_SETTING = 1013;
    public static final String JOB_USER_IDENTITY_SETTING_DEFAULT = "0";
    public static final String JOB_USER_IDENTITY_SETTING_APPLICATION = "1";
    public static final String JOB_USER_IDENTITY_SETTING_SYSTEM = "2";
    public static final int KEEP_DDM_CONNECTIONS_ACTIVE = 408;
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE_KEEP = "*KEEP";
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE_DROP = "*DROP";
    public static final int LANGUAGE_ID = 1201;
    public static final String LANGUAGE_ID_SYSTEM_VALUE = "*SYSVAL";
    public static final String LANGUAGE_ID_INITIAL_USER = "*USRPRF";
    public static final int LOG_CL_PROGRAMS = 1203;
    public static final String LOG_CL_PROGRAMS_YES = "*YES";
    public static final String LOG_CL_PROGRAMS_NO = "*NO";
    public static final int LOGGING_LEVEL = 1202;
    public static final String LOGGING_LEVEL_NONE = "0";
    public static final String LOGGING_LEVEL_MESSAGES_BY_SEVERITY = "1";
    public static final String LOGGING_LEVEL_REQUESTS_BY_SEVERITY_AND_ASSOCIATED_MESSAGES = "2";
    public static final String LOGGING_LEVEL_ALL_REQUESTS_AND_ASSOCIATED_MESSAGES = "3";
    public static final String LOGGING_LEVEL_ALL_REQUESTS_AND_MESSAGES = "4";
    public static final int LOGGING_SEVERITY = 1204;
    public static final int LOGGING_TEXT = 1205;
    public static final String LOGGING_TEXT_MESSAGE = "*MSG";
    public static final String LOGGING_TEXT_SECLVL = "*SECLVL";
    public static final String LOGGING_TEXT_NO_LIST = "*NOLIST";
    public static final int MAX_CPU_TIME = 1302;
    public static final int MAX_TEMP_STORAGE = 1303;
    public static final int MAX_TEMP_STORAGE_LARGE = 1305;
    public static final int MAX_THREADS = 1304;
    public static final int MEMORY_POOL = 1306;
    public static final String MEMORY_POOL_MACHINE = "*MACHINE";
    public static final String MEMORY_POOL_BASE = "*BASE";
    public static final String MEMORY_POOL_INTERACTIVE = "*INTERACT";
    public static final String MEMORY_POOL_SPOOL = "*SPOOL";
    public static final int MESSAGE_REPLY = 1307;
    public static final String MESSAGE_REPLY_NOT_IN_MESSAGE_WAIT = "0";
    public static final String MESSAGE_REPLY_WAITING = "1";
    public static final String MESSAGE_REPLY_NOT_WAITING = "2";
    public static final int MESSAGE_QUEUE_ACTION = 1007;
    public static final String MESSAGE_QUEUE_ACTION_SYSTEM_VALUE = "*SYSVAL";
    public static final String MESSAGE_QUEUE_ACTION_NO_WRAP = "*NOWRAP";
    public static final String MESSAGE_QUEUE_ACTION_WRAP = "*WRAP";
    public static final String MESSAGE_QUEUE_ACTION_PRINT_WRAP = "*PRTWRAP";
    public static final int MESSAGE_QUEUE_MAX_SIZE = 1008;
    public static final int MODE = 1301;
    public static final int OUTPUT_QUEUE = 1501;
    public static final String OUTPUT_QUEUE_DEVICE = "*DEV";
    public static final String OUTPUT_QUEUE_WORK_STATION = "*WRKSTN";
    public static final String OUTPUT_QUEUE_INITIAL_USER = "*USRPRF";
    public static final int OUTPUT_QUEUE_PRIORITY = 1502;
    public static final int PRINT_KEY_FORMAT = 1601;
    public static final String PRINT_KEY_FORMAT_SYSTEM_VALUE = "*SYSVAL";
    public static final String PRINT_KEY_FORMAT_NONE = "*NONE";
    public static final String PRINT_KEY_FORMAT_BORDER = "*PRTBDR";
    public static final String PRINT_KEY_FORMAT_HEADER = "*PRTHDR";
    public static final String PRINT_KEY_FORMAT_ALL = "*PRTALL";
    public static final int PRINT_TEXT = 1602;
    public static final String PRINT_TEXT_SYSTEM_VALUE = "*SYSVAL";
    public static final String PRINT_TEXT_BLANK = "*BLANK";
    public static final int PRINTER_DEVICE_NAME = 1603;
    public static final String PRINTER_DEVICE_NAME_SYSTEM_VALUE = "*SYSVAL";
    public static final String PRINTER_DEVICE_NAME_WORK_STATION = "*WRKSTN";
    public static final String PRINTER_DEVICE_NAME_INITIAL_USER = "*USRPRF";
    public static final int PRODUCT_LIBRARIES = 10002;
    public static final int PRODUCT_RETURN_CODE = 1605;
    public static final int PROGRAM_RETURN_CODE = 1606;
    public static final int ROUTING_DATA = 1803;
    public static final int RUN_PRIORITY = 1802;
    public static final int SCHEDULE_DATE = 1920;
    public static final String SCHEDULE_DATE_CURRENT = "*CURRENT";
    public static final String SCHEDULE_DATE_MONTH_START = "*MONTHSTR";
    public static final String SCHEDULE_DATE_MONTH_END = "*MONTHEND";
    public static final String SCHEDULE_DATE_MONDAY = "*MON";
    public static final String SCHEDULE_DATE_TUESDAY = "*TUE";
    public static final String SCHEDULE_DATE_WEDNESDAY = "*WED";
    public static final String SCHEDULE_DATE_THURSDAY = "*THU";
    public static final String SCHEDULE_DATE_FRIDAY = "*FRI";
    public static final String SCHEDULE_DATE_SATURDAY = "*SAT";
    public static final String SCHEDULE_DATE_SUNDAY = "*SUN";
    public static final int SCHEDULE_TIME = 1921;
    public static final String SCHEDULE_TIME_CURRENT = "*CURRENT";
    static final int SCHEDULE_DATE_GETTER = 403;
    public static final int SERVER_TYPE = 1911;
    public static final int SIGNED_ON_JOB = 701;
    public static final String SIGNED_ON_JOB_TRUE = "0";
    public static final String SIGNED_ON_JOB_FALSE = "1";
    public static final int SORT_SEQUENCE_TABLE = 1901;
    public static final String SORT_SEQUENCE_TABLE_SYSTEM_VALUE = "*SYSVAL";
    public static final String SORT_SEQUENCE_TABLE_INITIAL_USER = "*USRPRF";
    public static final String SORT_SEQUENCE_TABLE_NONE = "*HEX";
    public static final String SORT_SEQUENCE_TABLE_LANGUAGE_SHARED_WEIGHT = "*LANGIDSHR";
    public static final String SORT_SEQUENCE_TABLE_LANGUAGE_UNIQUE_WEIGHT = "*LANGIDUNQ";
    public static final int SPECIAL_ENVIRONMENT = 1908;
    public static final String SPECIAL_ENVIRONMENT_NONE = "*NONE";
    public static final String SPECIAL_ENVIRONMENT_SYSTEM_36 = "*S36";
    public static final String SPECIAL_ENVIRONMENT_NOT_ACTIVE = "";
    public static final int SPOOLED_FILE_ACTION = 1982;
    public static final String SPOOLED_FILE_ACTION_KEEP = "*KEEP";
    public static final String SPOOLED_FILE_ACTION_DETACH = "*DETACH";
    public static final String SPOOLED_FILE_ACTION_SYSTEM_VALUE = "*SYSVAL";
    public static final int STATUS_MESSAGE_HANDLING = 1902;
    public static final String STATUS_MESSAGE_HANDLING_SYSTEM_VALUE = "*SYSVAL";
    public static final String STATUS_MESSAGE_HANDLING_INITIAL_USER = "*USRPRF";
    public static final String STATUS_MESSAGE_HANDLING_NONE = "*NONE";
    public static final String STATUS_MESSAGE_HANDLING_NORMAL = "*NORMAL";
    public static final int SUBMITTED_BY_JOB_NAME = 1904;
    public static final int SUBMITTED_BY_USER = 10006;
    public static final int SUBMITTED_BY_JOB_NUMBER = 10005;
    public static final int SUBSYSTEM = 1906;
    public static final int SYSTEM_POOL_ID = 1907;
    public static final int SYSTEM_LIBRARY_LIST = 10003;
    public static final int TEMP_STORAGE_USED = 2004;
    public static final int TEMP_STORAGE_USED_LARGE = 2009;
    public static final int THREAD_COUNT = 2008;
    public static final int TIME_SEPARATOR = 2001;
    public static final String TIME_SEPARATOR_SYSTEM_VALUE = "S";
    public static final String TIME_SEPARATOR_COLON = ":";
    public static final String TIME_SEPARATOR_PERIOD = ".";
    public static final String TIME_SEPARATOR_BLANK = " ";
    public static final String TIME_SEPARATOR_COMMA = ",";
    public static final int TIME_SLICE = 2002;
    public static final int TIME_SLICE_END_POOL = 2003;
    public static final String TIME_SLICE_END_POOL_SYSTEM_VALUE = "*SYSVAL";
    public static final String TIME_SLICE_END_POOL_NONE = "*NONE";
    public static final String TIME_SLICE_END_POOL_BASE = "*BASE";
    public static final int TOTAL_RESPONSE_TIME = 1801;
    public static final int UNIT_OF_WORK_ID = 2101;
    public static final int LOCATION_NAME = 21012;
    public static final int NETWORK_ID = 21013;
    public static final int INSTANCE = 21011;
    public static final int SEQUENCE_NUMBER = 21014;
    public static final int USER_LIBRARY_LIST = 10004;
    public static final int USER_NAME = 11006;
    public static final String USER_NAME_BLANK = "";
    public static final int USER_RETURN_CODE = 2102;
    static final IntegerHashtable setterKeys_ = new IntegerHashtable();
    private static final int FORMAT_DTS = 1;

    private static boolean isTypeBinary(int key) {
        switch (key) {
            case 302: 
            case 409: 
            case 1204: 
            case 1802: 
            case 2002: {
                return true;
            }
        }
        return false;
    }

    public Job() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object.");
        }
    }

    public Job(AS400 system) {
        this(system, "*", "", "");
    }

    public Job(AS400 system, String jobName, String userName, String jobNumber) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + system + ", job name: " + jobName + ", user name: " + userName + ", job number: " + jobNumber);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (jobName == null) {
            Trace.log(2, "Parameter 'jobName' is null.");
            throw new NullPointerException("jobName");
        }
        if (jobName.length() > 10) {
            Trace.log(2, "Length of parameter 'jobName' is not valid: '" + jobName + "'");
            throw new ExtendedIllegalArgumentException("jobName (" + jobName + ")", 1);
        }
        if (userName == null) {
            Trace.log(2, "Parameter 'userName' is null.");
            throw new NullPointerException("userName");
        }
        if (userName.length() > 10) {
            Trace.log(2, "Length of parameter 'userName' is not valid: '" + userName + "'");
            throw new ExtendedIllegalArgumentException("userName (" + userName + ")", 1);
        }
        if (jobNumber == null) {
            Trace.log(2, "Parameter 'jobNumber' is null.");
            throw new NullPointerException("jobNumber");
        }
        if (jobNumber.length() > 6) {
            Trace.log(2, "Length of parameter 'jobNumber' is not valid: '" + jobNumber + "'");
            throw new ExtendedIllegalArgumentException("jobNumber (" + jobNumber + ")", 1);
        }
        if (jobName.equals("*")) {
            if (userName.trim().length() != 0) {
                Trace.log(2, "Value of parameter 'userName' is not valid: " + userName);
                throw new ExtendedIllegalArgumentException("userName (" + userName + ")", 2);
            }
            if (jobNumber.trim().length() != 0) {
                Trace.log(2, "Value of parameter 'jobNumber' is not valid: " + jobNumber);
                throw new ExtendedIllegalArgumentException("jobNumber (" + jobNumber + ")", 2);
            }
        }
        this.system_ = system;
        this.name_ = jobName;
        this.setValueInternal(11001, jobName);
        this.user_ = userName;
        this.setValueInternal(11006, userName);
        this.number_ = jobNumber;
        this.setValueInternal(11002, jobNumber);
        this.internalJobID_ = "";
        this.realInternalJobID_ = null;
        this.setValueInternal(11000, "");
    }

    public Job(AS400 system, String internalJobID) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + system + ", job identifier: '" + internalJobID + "'");
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (internalJobID == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (internalJobID.length() != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: '" + internalJobID + "'");
            throw new ExtendedIllegalArgumentException("internalJobID (" + internalJobID + ")", 1);
        }
        this.system_ = system;
        this.internalJobID_ = internalJobID;
        this.realInternalJobID_ = new byte[16];
        for (int i = 0; i < 16; ++i) {
            this.realInternalJobID_[i] = (byte)internalJobID.charAt(i);
        }
        this.setValueInternal(11000, internalJobID);
        this.setValueInternal(11007, this.realInternalJobID_);
        this.name_ = JOB_NAME_INTERNAL;
        this.setValueInternal(11001, null);
        this.user_ = "";
        this.setValueInternal(11006, null);
        this.number_ = "";
        this.setValueInternal(11002, null);
    }

    public Job(AS400 system, byte[] internalJobID) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + system + ", job identifier:", internalJobID);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (internalJobID == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (internalJobID.length != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: " + internalJobID.length);
            throw new ExtendedIllegalArgumentException("internalJobID.length {" + internalJobID.length + ")", 1);
        }
        this.system_ = system;
        this.realInternalJobID_ = internalJobID;
        char[] oldID = new char[16];
        for (int i = 0; i < 16; ++i) {
            oldID[i] = (char)(internalJobID[i] & 0xFF);
        }
        this.internalJobID_ = new String(oldID);
        this.setValueInternal(11000, internalJobID);
        this.setValueInternal(11007, this.realInternalJobID_);
        this.name_ = JOB_NAME_INTERNAL;
        this.setValueInternal(11001, null);
        this.user_ = "";
        this.setValueInternal(11006, null);
        this.number_ = "";
        this.setValueInternal(11002, null);
    }

    Job(AS400 system, String name, String user, String number, String status, String type, String subtype) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + system + ", job name: " + name + ", user name: " + user + ", job number: " + number + ", status: " + status + ", type: " + type + ", subtype: " + subtype);
        }
        this.system_ = system;
        this.name_ = name;
        this.setValueInternal(11001, name);
        this.user_ = user;
        this.setValueInternal(11006, user);
        this.number_ = number;
        this.setValueInternal(11002, number);
        this.status_ = status;
        this.setValueInternal(11003, status);
        this.type_ = type;
        this.setValueInternal(11005, type);
        this.subtype_ = subtype;
        this.setValueInternal(11004, subtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        Job job = this;
        synchronized (job) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        Job job = this;
        synchronized (job) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    private void connect() {
        if (!this.isConnected_) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect to server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.name_ == null) {
                Trace.log(2, "Cannot connect to server before setting name.");
                throw new ExtendedIllegalStateException("name", 4);
            }
            if (this.user_ == null) {
                Trace.log(2, "Cannot connect to server before setting user.");
                throw new ExtendedIllegalStateException("user", 4);
            }
            if (this.number_ == null) {
                Trace.log(2, "Cannot connect to server before setting number.");
                throw new ExtendedIllegalStateException("number", 4);
            }
            this.isConnected_ = true;
        }
    }

    private byte[] createQualifiedJobName() throws IOException {
        if (this.realInternalJobID_ != null) {
            return new byte[]{92, -55, -43, -29, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        }
        byte[] qualifiedJobName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        conv.stringToByteArray(this.name_, qualifiedJobName);
        conv.stringToByteArray(this.user_, qualifiedJobName, 10);
        conv.stringToByteArray(this.number_, qualifiedJobName, 20);
        return qualifiedJobName;
    }

    public void commitChanges() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.commitChanges(false);
    }

    public void commitChanges(boolean callOnThread) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing job.");
        }
        this.connect();
        if (this.cachedChanges_ == null || this.cachedChanges_.size_ == 0) {
            return;
        }
        int numChanges = this.cachedChanges_.size_;
        int totalLength = 0;
        int[][] keyTable = this.cachedChanges_.keys_;
        for (int i = 0; i < keyTable.length; ++i) {
            int[] keys = keyTable[i];
            if (keys == null) continue;
            for (int j = 0; j < keys.length; ++j) {
                int dataLength = setterKeys_.get(keys[j]);
                int pad = (4 - dataLength % 4) % 4;
                totalLength += 16 + dataLength + pad;
            }
        }
        byte[] jobChangeInformation = new byte[4 + totalLength];
        BinaryConverter.intToByteArray(numChanges, jobChangeInformation, 0);
        int ccsid = this.system_.getCcsid();
        Converter conv = new Converter(ccsid, this.system_);
        int offset = 4;
        for (int i = 0; i < keyTable.length; ++i) {
            int[] keys = keyTable[i];
            if (keys == null) continue;
            for (int j = 0; j < keys.length; ++j) {
                int dataLength = setterKeys_.get(keys[j]);
                int pad = (4 - dataLength % 4) % 4;
                BinaryConverter.intToByteArray(16 + dataLength + pad, jobChangeInformation, offset);
                BinaryConverter.intToByteArray(keys[j], jobChangeInformation, offset += 4);
                offset += 4;
                boolean isBin = Job.isTypeBinary(keys[j]);
                jobChangeInformation[offset++] = isBin ? -62 : -61;
                jobChangeInformation[offset++] = 64;
                jobChangeInformation[offset++] = 64;
                jobChangeInformation[offset++] = 64;
                BinaryConverter.intToByteArray(dataLength, jobChangeInformation, offset);
                offset += 4;
                Object data = this.cachedChanges_.get(keys[j]);
                if (isBin) {
                    BinaryConverter.intToByteArray((Integer)data, jobChangeInformation, offset);
                } else {
                    try {
                        String stringValue = (String)data;
                        int endPosition = offset + dataLength + pad;
                        for (int pos = offset; pos < endPosition; ++pos) {
                            jobChangeInformation[pos] = 64;
                        }
                        conv.stringToByteArray(stringValue, jobChangeInformation, offset, dataLength);
                    }
                    catch (ClassCastException cce) {
                        System.arraycopy((byte[])data, 0, jobChangeInformation, offset, 8);
                    }
                }
                offset += dataLength + pad;
            }
        }
        ProgramParameter[] parmList = new ProgramParameter[]{new ProgramParameter(this.createQualifiedJobName()), new ProgramParameter(this.realInternalJobID_ == null ? BLANKS16_ : this.realInternalJobID_), new ProgramParameter(new byte[]{-47, -42, -62, -61, -16, -15, -16, -16}), new ProgramParameter(jobChangeInformation), new ProgramParameter(new byte[8])};
        Boolean threadMode = callOnThread ? ON_THREAD : OFF_THREAD;
        ProgramCall program = this.getProgramCall("/QSYS.LIB/QWTCHGJB.PGM", parmList, threadMode);
        if (Trace.traceOn_) {
            Trace.log(1, "Setting job information for job: " + this.toString());
        }
        if (!program.run()) {
            AS400Message[] msgList = program.getMessageList();
            throw new AS400Exception(msgList);
        }
        this.cachedChanges_ = null;
    }

    public void end(int delay) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Ending job.");
        }
        if (delay < -1) {
            Trace.log(2, "Value of parameter 'delay' is not valid:", delay);
            throw new ExtendedIllegalArgumentException("delay (" + delay + ")", 4);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("QSYS/ENDJOB JOB(");
        buf.append(this.number_);
        buf.append('/');
        buf.append(this.user_);
        buf.append('/');
        buf.append(this.name_);
        buf.append(") OPTION(");
        if (delay == 0) {
            buf.append("*IMMED)");
        } else {
            buf.append("*CNTRLD)");
            if (delay > 0) {
                buf.append(" DELAY(");
                buf.append(delay);
                buf.append(")");
            }
        }
        String toRun = buf.toString();
        CommandCall cmd = this.getCommandCall(toRun);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CommandCall getCommandCall(String cmd) {
        if (this.cmdCall_ == null) {
            Object object = this.remoteCommandLock_;
            synchronized (object) {
                if (this.cmdCall_ == null) {
                    this.cmdCall_ = new CommandCall(this.system_);
                }
            }
        }
        try {
            this.cmdCall_.setCommand(cmd);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return this.cmdCall_;
    }

    private final ProgramCall getProgramCall(String pgm, ProgramParameter[] parms) {
        return this.getProgramCall(pgm, parms, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProgramCall getProgramCall(String pgm, ProgramParameter[] parms, Boolean callOnThread) {
        if (ON_THREAD.equals(callOnThread)) {
            if (this.pgmCall_onThread_ == null) {
                Object object = this.remoteCommandLock_;
                synchronized (object) {
                    if (this.pgmCall_onThread_ == null) {
                        this.pgmCall_onThread_ = new ProgramCall(this.system_);
                        this.pgmCall_onThread_.setThreadSafe(true);
                    }
                }
            }
            try {
                this.pgmCall_onThread_.setProgram(pgm, parms);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            return this.pgmCall_onThread_;
        }
        if (OFF_THREAD.equals(callOnThread)) {
            if (this.pgmCall_offThread_ == null) {
                Object e = this.remoteCommandLock_;
                synchronized (e) {
                    if (this.pgmCall_offThread_ == null) {
                        this.pgmCall_offThread_ = new ProgramCall(this.system_);
                        this.pgmCall_offThread_.setThreadSafe(false);
                    }
                }
            }
            try {
                this.pgmCall_offThread_.setProgram(pgm, parms);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            return this.pgmCall_offThread_;
        }
        if (this.pgmCall_ == null) {
            Object e = this.remoteCommandLock_;
            synchronized (e) {
                if (this.pgmCall_ == null) {
                    this.pgmCall_ = new ProgramCall(this.system_);
                }
            }
        }
        try {
            this.pgmCall_.setProgram(pgm, parms);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return this.pgmCall_;
    }

    private Date getAsDate(int key) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String str = (String)this.getValue(key);
        Calendar dateTime = AS400Calendar.getGregorianInstance();
        dateTime.clear();
        Date date = null;
        switch (str.trim().length()) {
            case 7: {
                dateTime.set(Integer.parseInt(str.substring(0, 3)) + 1900, Integer.parseInt(str.substring(3, 5)) - 1, Integer.parseInt(str.substring(5, 7)));
                date = dateTime.getTime();
                break;
            }
            case 13: {
                dateTime.set(Integer.parseInt(str.substring(0, 3)) + 1900, Integer.parseInt(str.substring(3, 5)) - 1, Integer.parseInt(str.substring(5, 7)), Integer.parseInt(str.substring(7, 9)), Integer.parseInt(str.substring(9, 11)), Integer.parseInt(str.substring(11, 13)));
                date = dateTime.getTime();
            }
        }
        return date;
    }

    private int getAsInt(int key) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Integer.parseInt(this.getValue(key).toString().trim());
    }

    private Date getAsSystemDate(int key) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        AS400Timestamp conv = this.getTimestampConverter(1);
        return conv.toDate(conv.toTimestamp((byte[])this.getValue(key)), TimeZone.getDefault());
    }

    public int getAuxiliaryIORequests() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1401);
    }

    public String getBreakMessageHandling() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(201)).trim();
    }

    public boolean getCacheChanges() {
        return this.cacheChanges_;
    }

    public CallStackEntry[] getCallStack(long threadID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (threadID < 0L && threadID != -1L) {
            throw new ExtendedIllegalArgumentException("threadID", 2);
        }
        if (!this.isConnected_) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.name_ == null) {
                throw new ExtendedIllegalStateException("name", 4);
            }
            if (this.user_ == null) {
                throw new ExtendedIllegalStateException("user", 4);
            }
            if (this.number_ == null) {
                throw new ExtendedIllegalStateException("number", 4);
            }
        }
        ProgramParameter[] parms = new ProgramParameter[6];
        int ccsid = this.system_.getCcsid();
        CharConverter conv = new CharConverter(ccsid);
        int len = 2000;
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(conv.stringToByteArray("CSTK0100"));
        byte[] threadJobId = new byte[56];
        AS400Text text10 = new AS400Text(10, ccsid);
        AS400Text text6 = new AS400Text(6, ccsid);
        byte[] internal = this.getInternalJobIdentifier();
        if (!this.name_.equals(JOB_NAME_INTERNAL)) {
            internal = new byte[16];
            for (int i = 0; i < 16; ++i) {
                internal[i] = 64;
            }
        }
        text10.toBytes(this.name_, threadJobId, 0);
        text10.toBytes(this.user_, threadJobId, 10);
        text6.toBytes(this.number_, threadJobId, 20);
        System.arraycopy(internal, 0, threadJobId, 26, 16);
        int threadType = threadID == -1L ? 2 : 0;
        long specifiedThread = threadID == -1L ? 0L : threadID;
        BinaryConverter.intToByteArray(threadType, threadJobId, 44);
        BinaryConverter.longToByteArray(specifiedThread, threadJobId, 48);
        parms[3] = new ProgramParameter(threadJobId);
        parms[4] = new ProgramParameter(conv.stringToByteArray("JIDF0100"));
        parms[5] = new ProgramParameter(new byte[4]);
        ProgramCall pc = this.getProgramCall("/QSYS.LIB/QWVRCSTK.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
        int bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
        while (bytesAvailable > bytesReturned) {
            try {
                len = bytesAvailable * 2;
                if (Trace.traceOn_) {
                    Trace.log(1, "Calling QWVRCSTK again with receiver size of " + len);
                }
                parms[0].setOutputDataLength(len);
                parms[1].setInputData(BinaryConverter.intToByteArray(len));
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parms[0].getOutputData();
            bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
            bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
        }
        int numEntriesAll = BinaryConverter.byteArrayToInt(data, 8);
        int offset = BinaryConverter.byteArrayToInt(data, 12);
        int numEntriesReturned = BinaryConverter.byteArrayToInt(data, 16);
        if (numEntriesReturned != numEntriesAll && Trace.traceOn_) {
            Trace.log(4, "Not all call stack entries were returned: total: " + numEntriesAll + ", returned: " + numEntriesReturned);
        }
        threadID = BinaryConverter.byteArrayToLong(data, 20);
        if (data[28] != 64 && Trace.traceOn_) {
            Trace.log(4, "Call stack entry information incomplete due to status: " + Integer.toHexString(0xFF & data[28]));
        }
        CallStackEntry[] entries = new CallStackEntry[numEntriesReturned];
        int vrm530 = AS400.generateVRM(5, 3, 0);
        boolean isV5R3 = this.system_.getVRM() >= vrm530;
        for (int i = 0; i < numEntriesReturned; ++i) {
            int entryLength = BinaryConverter.byteArrayToInt(data, offset);
            int stmtIDDisp = BinaryConverter.byteArrayToInt(data, offset + 4);
            int numStmtID = BinaryConverter.byteArrayToInt(data, offset + 8);
            int procNameDisp = BinaryConverter.byteArrayToInt(data, offset + 12);
            int procNameLen = BinaryConverter.byteArrayToInt(data, offset + 16);
            int reqLevel = BinaryConverter.byteArrayToInt(data, offset + 20);
            String progName = conv.byteArrayToString(data, offset + 24, 10).trim();
            String progLib = conv.byteArrayToString(data, offset + 34, 10).trim();
            int miInstrNum = BinaryConverter.byteArrayToInt(data, offset + 44);
            String modName = conv.byteArrayToString(data, offset + 48, 10).trim();
            String modLib = conv.byteArrayToString(data, offset + 58, 10).trim();
            byte controlBound = data[offset + 68];
            long actGroupNum = BinaryConverter.byteArrayToUnsignedInt(data, offset + 72);
            String actGroupName = conv.byteArrayToString(data, offset + 76, 10).trim();
            String progASPName = conv.byteArrayToString(data, offset + 88, 10).trim();
            String progLibASP = conv.byteArrayToString(data, offset + 98, 10).trim();
            int progASPNum = BinaryConverter.byteArrayToInt(data, offset + 108);
            int progLibASPNum = BinaryConverter.byteArrayToInt(data, offset + 112);
            long actGroupNumLong = isV5R3 ? BinaryConverter.byteArrayToLong(data, offset + 116) : 0L;
            String[] statementIdentifiers = new String[numStmtID];
            for (int c = 0; c < numStmtID; ++c) {
                statementIdentifiers[c] = conv.byteArrayToString(data, offset + stmtIDDisp + c * 10, 10).trim();
            }
            String procName = procNameDisp > 0 ? conv.byteArrayToString(data, offset + procNameDisp, procNameLen).trim() : null;
            entries[i] = new CallStackEntry(this, threadID, reqLevel, progName, progLib, miInstrNum, modName, modLib, controlBound, actGroupNum, actGroupName, progASPName, progLibASP, progASPNum, progLibASPNum, actGroupNumLong, statementIdentifiers, procName);
            offset += entryLength;
        }
        return entries;
    }

    public int getCodedCharacterSetID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(302);
    }

    public String getCompletionStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(306);
    }

    public String getCountryID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(303)).trim();
    }

    public int getCPUUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(304);
    }

    public String getCurrentLibrary() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(10000)).trim();
    }

    public boolean getCurrentLibraryExistence() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(10001) == 1;
    }

    public Date getDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(402);
    }

    public String getDateFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(405)).trim();
    }

    public String getDateSeparator() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(406);
    }

    public String getDDMConversationHandling() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(408)).trim();
    }

    public String getDecimalFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(413)).trim();
    }

    public int getDefaultCodedCharacterSetIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(412);
    }

    public int getDefaultWait() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(409);
    }

    public String getDeviceRecoveryAction() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(410)).trim();
    }

    public int getEndSeverity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(501);
    }

    public String getFunctionName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(601)).trim();
    }

    public String getFunctionType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(602);
    }

    public String getInquiryMessageReply() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(901)).trim();
    }

    public int getInteractiveTransactions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1402);
    }

    public String getInternalJobID() {
        return this.internalJobID_;
    }

    public byte[] getInternalJobIdentifier() {
        return this.realInternalJobID_;
    }

    public String getJobAccountingCode() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1001)).trim();
    }

    public Date getJobActiveDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(401);
    }

    public Date getJobDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(1002);
    }

    public String getJobDescription() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String jobd = ((String)this.getValue(1003)).trim();
        if (jobd.length() > 0 && !jobd.startsWith("*")) {
            String name = jobd.substring(0, 10).trim();
            String lib = jobd.substring(10, jobd.length());
            String path = QSYSObjectPathName.toPath(lib, name, "JOBD");
            return path;
        }
        return jobd;
    }

    public Date getJobEndedDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(418);
    }

    public Date getJobEnterSystemDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(402);
    }

    public JobLog getJobLog() {
        try {
            return new JobLog(this.system_, (String)this.getValue(11001), (String)this.getValue(11006), (String)this.getValue(11002));
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(2, "Error retrieving values to create job log: " + e);
            }
            return null;
        }
    }

    public String getJobMessageQueueFullAction() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1007)).trim();
    }

    public int getJobMessageQueueMaximumSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1008);
    }

    public Date getJobPutOnJobQueueDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsSystemDate(404);
    }

    public Date getScheduleDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.cachedChanges_ != null && (this.cachedChanges_.contains(1920) || this.cachedChanges_.contains(1921))) {
            Calendar calendar = AS400Calendar.getGregorianInstance();
            calendar.clear();
            String scheduleDate = (String)this.cachedChanges_.get(1920);
            if (scheduleDate != null) {
                int century = Integer.parseInt(scheduleDate.substring(0, 1));
                int year = Integer.parseInt(scheduleDate.substring(1, 3));
                int month = Integer.parseInt(scheduleDate.substring(3, 5));
                int day = Integer.parseInt(scheduleDate.substring(5, 7));
                calendar.set(1, year + (century == 0 ? 1900 : 2000));
                calendar.set(2, month - 1);
                calendar.set(5, day);
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
            }
            String scheduleTime = (String)this.cachedChanges_.get(1921);
            if (scheduleTime != null) {
                int hours = Integer.parseInt(scheduleTime.substring(0, 2));
                int minutes = Integer.parseInt(scheduleTime.substring(2, 4));
                int seconds = Integer.parseInt(scheduleTime.substring(4, 6));
                calendar.set(11, hours);
                calendar.set(12, minutes);
                calendar.set(13, seconds);
            } else {
                calendar.set(1, 0);
                calendar.set(2, 0);
                calendar.set(5, 0);
            }
            return calendar.getTime();
        }
        return this.getAsSystemDate(403);
    }

    public String getJobStatusInJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1903)).trim();
    }

    public String getJobSwitches() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(1006);
    }

    public String getLanguageID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(1201);
    }

    public String getLoggingCLPrograms() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1203)).trim();
    }

    public int getLoggingLevel() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Integer.parseInt((String)this.getValue(1202));
    }

    public int getLoggingSeverity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1204);
    }

    public String getLoggingText() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1205)).trim();
    }

    public String getModeName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1301)).trim();
    }

    public String getName() {
        return this.name_;
    }

    public String getNumber() {
        return this.number_;
    }

    public int getNumberOfLibrariesInSYSLIBL() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getSystemLibraryList().length;
    }

    public int getNumberOfLibrariesInUSRLIBL() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getUserLibraryList().length;
    }

    public int getNumberOfProductLibraries() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getProductLibraries().length;
    }

    public String getOutputQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String queue = ((String)this.getValue(1501)).trim();
        if (queue.length() > 0 && !queue.startsWith("*")) {
            String name = queue.substring(0, 10).trim();
            String lib = queue.substring(10, queue.length());
            String path = QSYSObjectPathName.toPath(lib, name, "OUTQ");
            return path;
        }
        return queue;
    }

    public int getOutputQueuePriority() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1502);
    }

    public int getPoolIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1907);
    }

    public String getPrinterDeviceName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1603)).trim();
    }

    public String getPrintKeyFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1601)).trim();
    }

    public String getPrintText() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1602)).trim();
    }

    public String[] getProductLibraries() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String val = (String)this.getValue(10002);
        StringTokenizer st = new StringTokenizer(val, " ");
        String[] libraries = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            libraries[i++] = st.nextToken();
        }
        return libraries;
    }

    public boolean getPurge() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1604)).trim().equals("*YES");
    }

    public String getQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String queue = ((String)this.getValue(1004)).trim();
        if (queue.length() > 0 && !queue.startsWith("*")) {
            String name = queue.substring(0, 10).trim();
            String lib = queue.substring(10, queue.length());
            String path = QSYSObjectPathName.toPath(lib, name, "JOBQ");
            return path;
        }
        return queue;
    }

    public int getQueuePriority() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String p = ((String)this.getValue(1005)).trim();
        if (p.length() == 0) {
            return -1;
        }
        return new Integer(p);
    }

    public String getRoutingData() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1803)).trim();
    }

    public int getRunPriority() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1802);
    }

    public boolean getSignedOnJob() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(701)).trim().equals("0");
    }

    public String getSortSequenceTable() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String table = ((String)this.getValue(1901)).trim();
        if (table.length() > 0 && !table.startsWith("*")) {
            String name = table.substring(0, 10).trim();
            String lib = table.substring(10, table.length());
            String path = QSYSObjectPathName.toPath(lib, name, "FILE");
            return path;
        }
        return table;
    }

    public String getStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(11003)).trim();
    }

    public String getStatusMessageHandling() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1902)).trim();
    }

    public String getStringValue(int attribute) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object obj = this.getValue(attribute);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return ((String)obj).trim();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Returning a string representation of the value of a non-String attribute:", attribute);
        }
        return obj.toString();
    }

    public String getSubsystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String subsystem = ((String)this.getValue(1906)).trim();
        if (subsystem.length() > 10) {
            String name = subsystem.substring(0, 10).trim();
            String lib = subsystem.substring(10, subsystem.length());
            String path = QSYSObjectPathName.toPath(lib, name, "SBSD");
            return path;
        }
        return subsystem;
    }

    public String getSubtype() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(11004);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String[] getSystemLibraryList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String val = (String)this.getValue(10003);
        StringTokenizer st = new StringTokenizer(val, " ");
        String[] libraries = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            libraries[i++] = st.nextToken();
        }
        return libraries;
    }

    public String getTimeSeparator() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(2001);
    }

    public int getTimeSlice() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(2002);
    }

    private synchronized AS400Timestamp getTimestampConverter(int format) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(format);
        } else if (format != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(format);
        }
        return this.timestampConverter_;
    }

    public String getTimeSliceEndPool() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(2003)).trim();
    }

    public int getTotalResponseTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1801);
    }

    public String getType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(11005);
    }

    public String getUser() {
        return this.user_;
    }

    public String[] getUserLibraryList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String val = (String)this.getValue(10004);
        StringTokenizer st = new StringTokenizer(val, " ");
        String[] libraries = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            libraries[i++] = st.nextToken();
        }
        return libraries;
    }

    public Object getValue(int attribute) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object obj = this.values_.get(attribute);
        if (obj == null) {
            this.retrieve(attribute);
            obj = this.values_.get(attribute);
            if (obj == null && (attribute == 1920 || attribute == 1921)) {
                Date d = this.getAsSystemDate(403);
                this.setValueInternal(1920, d);
                this.setValueInternal(1921, d);
                return d;
            }
        }
        return obj;
    }

    public String getWorkIDUnit() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(2101)).trim();
    }

    public void hold(boolean holdSpooledFiles) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("QSYS/HLDJOB JOB(");
        buf.append(this.number_);
        buf.append('/');
        buf.append(this.user_);
        buf.append('/');
        buf.append(this.name_);
        buf.append(") SPLFILE(");
        buf.append(holdSpooledFiles ? "*YES)" : "*NO)");
        buf.append(" DUPJOBOPT(*MSG)");
        String toRun = buf.toString();
        CommandCall cmd = this.getCommandCall(toRun);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    private static boolean isReadOnly(int attribute) {
        return setterKeys_.get(attribute) == -1;
    }

    public void loadInformation() {
        try {
            this.values_.clear();
            this.setValueInternal(11001, this.name_);
            this.setValueInternal(11006, this.user_);
            this.setValueInternal(11002, this.number_);
            this.setValueInternal(11005, this.type_);
            this.setValueInternal(11004, this.subtype_);
            this.retrieve(2008);
            this.retrieve(307);
            this.retrieve(1002);
            this.retrieve(1911);
            this.retrieve(1205);
            this.retrieve(1908);
            this.retrieve(10004);
            this.retrieve(315);
        }
        catch (Exception e) {
            Trace.log(2, "Error loading job information:", (Throwable)e);
        }
    }

    public void loadInformation(int[] attributes) {
        block18: {
            try {
                boolean[] formats = new boolean[8];
                block9: for (int i = 0; i < attributes.length; ++i) {
                    int attr = attributes[i];
                    byte[] format = Job.lookupFormatName(attr);
                    formats[format[5] & 0xF] = true;
                    this.values_.remove(attr);
                    switch (attr) {
                        case 11001: {
                            this.setValueInternal(11001, this.name_);
                            continue block9;
                        }
                        case 11006: {
                            this.setValueInternal(11006, this.user_);
                            continue block9;
                        }
                        case 11002: {
                            this.setValueInternal(11002, this.number_);
                            continue block9;
                        }
                        case 11005: {
                            this.setValueInternal(11005, this.type_);
                            continue block9;
                        }
                        case 11004: {
                            this.setValueInternal(11004, this.subtype_);
                            continue block9;
                        }
                    }
                }
                if (formats[1]) {
                    this.retrieve(2008);
                }
                if (formats[2]) {
                    this.retrieve(307);
                }
                if (formats[3]) {
                    this.retrieve(1002);
                }
                if (formats[4]) {
                    this.retrieve(1911);
                }
                if (formats[5]) {
                    this.retrieve(1205);
                }
                if (formats[6]) {
                    this.retrieve(1908);
                }
                if (formats[7]) {
                    this.retrieve(10004);
                }
                if (formats[0]) {
                    this.retrieve(315);
                }
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block18;
                Trace.log(2, "Error loading job information: ", (Throwable)e);
            }
        }
    }

    public void loadStatistics() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(315);
    }

    private static int lookupFormatLength(byte[] format) {
        switch (format[5] & 0xF) {
            case 1: {
                return 144;
            }
            case 2: {
                return 191;
            }
            case 3: {
                return 187;
            }
            case 4: {
                return 584;
            }
            case 5: {
                return 83;
            }
            case 6: {
                return 322;
            }
            case 7: {
                return 3028;
            }
            case 0: {
                return 144;
            }
        }
        return -1;
    }

    private static byte[] lookupFormatName(int key) {
        switch (key) {
            case 304: 
            case 312: 
            case 409: 
            case 1302: 
            case 1303: 
            case 1304: 
            case 1305: 
            case 1604: 
            case 1802: 
            case 1907: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2008: 
            case 2009: 
            case 11000: 
            case 11001: 
            case 11002: 
            case 11003: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11007: {
                return new byte[]{-47, -42, -62, -55, -16, -15, -11, -16};
            }
            case 101: 
            case 103: 
            case 307: 
            case 313: 
            case 601: 
            case 602: 
            case 1306: 
            case 1307: 
            case 1401: 
            case 1402: 
            case 1406: 
            case 1801: {
                return new byte[]{-47, -42, -62, -55, -16, -14, -16, -16};
            }
            case 404: 
            case 1002: 
            case 1004: 
            case 1005: 
            case 1501: 
            case 1502: 
            case 1603: 
            case 1903: {
                return new byte[]{-47, -42, -62, -55, -16, -13, -16, -16};
            }
            case 102: 
            case 104: 
            case 201: 
            case 302: 
            case 303: 
            case 306: 
            case 311: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 413: 
            case 418: 
            case 701: 
            case 901: 
            case 1001: 
            case 1003: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1018: 
            case 1201: 
            case 1203: 
            case 1301: 
            case 1601: 
            case 1602: 
            case 1803: 
            case 1901: 
            case 1902: 
            case 1904: 
            case 1911: 
            case 1920: 
            case 1921: 
            case 1982: 
            case 2001: 
            case 2101: 
            case 10005: 
            case 10006: 
            case 21011: 
            case 21012: 
            case 21013: 
            case 21014: {
                return new byte[]{-47, -42, -62, -55, -16, -12, -16, -16};
            }
            case 501: 
            case 1202: 
            case 1204: 
            case 1205: {
                return new byte[]{-47, -42, -62, -55, -16, -11, -16, -16};
            }
            case 305: 
            case 318: 
            case 407: 
            case 502: 
            case 1012: 
            case 1013: 
            case 1605: 
            case 1606: 
            case 1906: 
            case 1908: 
            case 2102: {
                return new byte[]{-47, -42, -62, -55, -16, -10, -16, -16};
            }
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: {
                return new byte[]{-47, -42, -62, -55, -16, -9, -16, -16};
            }
            case -1: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 414: 
            case 416: 
            case 417: 
            case 904: 
            case 905: 
            case 1609: 
            case 10007: 
            case 10008: {
                return new byte[]{-47, -42, -62, -55, -15, -16, -16, -16};
            }
        }
        return null;
    }

    private void parseData(byte[] format, byte[] data) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        this.name_ = conv.byteArrayToString(data, 8, 10).trim();
        this.user_ = conv.byteArrayToString(data, 18, 10).trim();
        this.number_ = conv.byteArrayToString(data, 28, 6);
        this.realInternalJobID_ = new byte[16];
        System.arraycopy(data, 34, this.realInternalJobID_, 0, 16);
        char[] oldID = new char[16];
        for (int i = 0; i < 16; ++i) {
            oldID[i] = (char)(this.realInternalJobID_[i] & 0xFF);
        }
        this.internalJobID_ = new String(oldID);
        this.status_ = conv.byteArrayToString(data, 50, 10).trim();
        this.type_ = conv.byteArrayToString(data, 60, 1);
        this.subtype_ = conv.byteArrayToString(data, 61, 1);
        this.setValueInternal(11001, this.name_);
        this.setValueInternal(11006, this.user_);
        this.setValueInternal(11002, this.number_);
        this.setValueInternal(11000, this.internalJobID_);
        this.setValueInternal(11007, this.realInternalJobID_);
        this.setValueInternal(11003, this.status_);
        this.setValueInternal(11005, this.type_);
        this.setValueInternal(11004, this.subtype_);
        byte[] val = new byte[8];
        switch (format[5] & 0xF) {
            case 1: {
                this.setAsInt(1802, BinaryConverter.byteArrayToInt(data, 64));
                this.setAsInt(2002, BinaryConverter.byteArrayToInt(data, 68));
                this.setAsInt(409, BinaryConverter.byteArrayToInt(data, 72));
                this.setValueInternal(1604, conv.byteArrayToString(data, 76, 10));
                this.setValueInternal(2003, conv.byteArrayToString(data, 86, 10));
                this.setAsInt(304, BinaryConverter.byteArrayToInt(data, 96));
                this.setAsInt(1907, BinaryConverter.byteArrayToInt(data, 100));
                this.setAsInt(1302, BinaryConverter.byteArrayToInt(data, 104));
                this.setAsInt(2004, BinaryConverter.byteArrayToInt(data, 108));
                this.setAsInt(1303, BinaryConverter.byteArrayToInt(data, 112));
                this.setAsInt(2008, BinaryConverter.byteArrayToInt(data, 116));
                this.setAsInt(1304, BinaryConverter.byteArrayToInt(data, 120));
                this.setAsLong(2009, BinaryConverter.byteArrayToUnsignedInt(data, 124));
                this.setAsLong(1305, BinaryConverter.byteArrayToUnsignedInt(data, 128));
                this.setAsLong(312, BinaryConverter.byteArrayToLong(data, 136));
                break;
            }
            case 2: {
                this.setAsInt(1802, BinaryConverter.byteArrayToInt(data, 72));
                this.setAsInt(1907, BinaryConverter.byteArrayToInt(data, 76));
                this.setAsInt(304, BinaryConverter.byteArrayToInt(data, 80));
                this.setAsInt(1401, BinaryConverter.byteArrayToInt(data, 84));
                this.setAsInt(1402, BinaryConverter.byteArrayToInt(data, 88));
                this.setAsInt(1801, BinaryConverter.byteArrayToInt(data, 92));
                this.setValueInternal(602, conv.byteArrayToString(data, 96, 1));
                this.setValueInternal(601, conv.byteArrayToString(data, 97, 10));
                this.setValueInternal(101, conv.byteArrayToString(data, 107, 4));
                this.setAsInt(307, BinaryConverter.byteArrayToInt(data, 136));
                this.setAsInt(2008, BinaryConverter.byteArrayToInt(data, 140));
                this.setAsLong(1406, BinaryConverter.byteArrayToLong(data, 152));
                this.setAsLong(313, BinaryConverter.byteArrayToLong(data, 160));
                this.setValueInternal(103, conv.byteArrayToString(data, 176, 4));
                this.setValueInternal(1306, conv.byteArrayToString(data, 180, 10));
                this.setValueInternal(1307, conv.byteArrayToString(data, 190, 1));
                break;
            }
            case 3: {
                this.setValueInternal(1004, conv.byteArrayToString(data, 62, 20));
                this.setValueInternal(1005, conv.byteArrayToString(data, 82, 2));
                this.setValueInternal(1501, conv.byteArrayToString(data, 84, 20));
                this.setValueInternal(1502, conv.byteArrayToString(data, 104, 2));
                this.setValueInternal(1603, conv.byteArrayToString(data, 106, 10));
                this.setValueInternal(1904, conv.byteArrayToString(data, 116, 10));
                this.setValueInternal(10006, conv.byteArrayToString(data, 126, 10));
                this.setValueInternal(10005, conv.byteArrayToString(data, 136, 6));
                this.setValueInternal(1903, conv.byteArrayToString(data, 162, 10));
                System.arraycopy(data, 172, val, 0, 8);
                this.setValueInternal(404, val);
                this.setValueInternal(1002, conv.byteArrayToString(data, 180, 7));
                break;
            }
            case 4: {
                this.setValueInternal(402, conv.byteArrayToString(data, 62, 13));
                this.setValueInternal(401, conv.byteArrayToString(data, 75, 13));
                this.setValueInternal(1001, conv.byteArrayToString(data, 88, 15));
                this.setValueInternal(1003, conv.byteArrayToString(data, 103, 20));
                this.setValueInternal(2101, conv.byteArrayToString(data, 123, 24));
                this.setValueInternal(21012, conv.byteArrayToString(data, 123, 8));
                this.setValueInternal(21013, conv.byteArrayToString(data, 131, 8));
                this.setValueInternal(21011, conv.byteArrayToString(data, 139, 6));
                this.setValueInternal(21014, conv.byteArrayToString(data, 145, 2));
                this.setValueInternal(1301, conv.byteArrayToString(data, 147, 8));
                this.setValueInternal(901, conv.byteArrayToString(data, 155, 10));
                this.setValueInternal(1203, conv.byteArrayToString(data, 165, 10));
                this.setValueInternal(201, conv.byteArrayToString(data, 175, 10));
                this.setValueInternal(1902, conv.byteArrayToString(data, 185, 10));
                this.setValueInternal(410, conv.byteArrayToString(data, 195, 13));
                this.setValueInternal(408, conv.byteArrayToString(data, 208, 10));
                this.setValueInternal(406, conv.byteArrayToString(data, 218, 1));
                this.setValueInternal(405, conv.byteArrayToString(data, 219, 4));
                this.setValueInternal(1602, conv.byteArrayToString(data, 223, 30));
                this.setValueInternal(1904, conv.byteArrayToString(data, 253, 10));
                this.setValueInternal(10006, conv.byteArrayToString(data, 263, 10));
                this.setValueInternal(10005, conv.byteArrayToString(data, 273, 6));
                this.setValueInternal(2001, conv.byteArrayToString(data, 299, 1));
                this.setAsInt(302, BinaryConverter.byteArrayToInt(data, 300));
                System.arraycopy(data, 304, val, 0, 8);
                this.setValueInternal(403, val);
                this.setValueInternal(1601, conv.byteArrayToString(data, 312, 10));
                this.setValueInternal(1901, conv.byteArrayToString(data, 322, 20));
                this.setValueInternal(1201, conv.byteArrayToString(data, 342, 3));
                this.setValueInternal(303, conv.byteArrayToString(data, 345, 2));
                this.setValueInternal(306, conv.byteArrayToString(data, 347, 1));
                this.setValueInternal(701, conv.byteArrayToString(data, 348, 1));
                this.setValueInternal(1006, conv.byteArrayToString(data, 349, 8));
                this.setValueInternal(1007, conv.byteArrayToString(data, 357, 10));
                this.setAsInt(1008, BinaryConverter.byteArrayToInt(data, 368));
                this.setAsInt(412, BinaryConverter.byteArrayToInt(data, 372));
                this.setValueInternal(1803, conv.byteArrayToString(data, 376, 80));
                this.setValueInternal(413, conv.byteArrayToString(data, 456, 1));
                this.setValueInternal(311, conv.byteArrayToString(data, 457, 10));
                this.setValueInternal(1911, conv.byteArrayToString(data, 467, 30));
                this.setValueInternal(102, conv.byteArrayToString(data, 497, 1));
                this.setValueInternal(1015, conv.byteArrayToString(data, 498, 1));
                this.setAsInt(1014, BinaryConverter.byteArrayToInt(data, 500));
                this.setAsInt(1016, BinaryConverter.byteArrayToInt(data, 504));
                this.setValueInternal(418, conv.byteArrayToString(data, 508, 13));
                this.setValueInternal(1982, conv.byteArrayToString(data, 522, 10));
                int offset_to_ASP = BinaryConverter.byteArrayToInt(data, 532);
                if (offset_to_ASP > 0) {
                    this.setValueInternal(104, conv.byteArrayToString(data, offset_to_ASP, 10));
                } else {
                    this.setValueInternal(104, "");
                }
                this.setValueInternal(1018, conv.byteArrayToString(data, 554, 10));
                break;
            }
            case 5: {
                this.setAsInt(501, BinaryConverter.byteArrayToInt(data, 64));
                this.setAsInt(1204, BinaryConverter.byteArrayToInt(data, 68));
                this.setValueInternal(1202, conv.byteArrayToString(data, 72, 1));
                this.setValueInternal(1205, conv.byteArrayToString(data, 73, 10));
                break;
            }
            case 6: {
                this.setValueInternal(1006, conv.byteArrayToString(data, 62, 8));
                this.setValueInternal(502, conv.byteArrayToString(data, 70, 1));
                this.setValueInternal(1906, conv.byteArrayToString(data, 71, 20));
                this.setValueInternal(305, conv.byteArrayToString(data, 91, 10));
                this.setValueInternal(407, conv.byteArrayToString(data, 101, 1));
                this.setAsInt(1605, BinaryConverter.byteArrayToInt(data, 104));
                this.setAsInt(2102, BinaryConverter.byteArrayToInt(data, 108));
                this.setAsInt(1606, BinaryConverter.byteArrayToInt(data, 112));
                this.setValueInternal(1908, conv.byteArrayToString(data, 116, 10));
                this.setValueInternal(1012, conv.byteArrayToString(data, 296, 10));
                this.setValueInternal(1013, conv.byteArrayToString(data, 306, 1));
                this.setValueInternal(318, conv.byteArrayToString(data, 307, 15));
                break;
            }
            case 7: {
                int currentLibraryExistence = BinaryConverter.byteArrayToInt(data, 72);
                this.setAsInt(10001, currentLibraryExistence);
                int numberOfSystemLibraries = BinaryConverter.byteArrayToInt(data, 64);
                this.setValueInternal(10003, conv.byteArrayToString(data, 80, 11 * numberOfSystemLibraries));
                int offset = 80 + 11 * numberOfSystemLibraries;
                int numberOfProductLibraries = BinaryConverter.byteArrayToInt(data, 68);
                this.setValueInternal(10002, conv.byteArrayToString(data, offset, 11 * numberOfProductLibraries));
                offset += 11 * numberOfProductLibraries;
                if (currentLibraryExistence == 1) {
                    this.setValueInternal(10000, conv.byteArrayToString(data, offset, 11));
                    offset += 11;
                } else {
                    this.setValueInternal(10000, "");
                }
                int numberOfUserLibraries = BinaryConverter.byteArrayToInt(data, 76);
                this.setValueInternal(10004, conv.byteArrayToString(data, offset, 11 * numberOfUserLibraries));
                break;
            }
            case 0: {
                this.setAsLong(10007, BinaryConverter.byteArrayToLong(data, 64));
                this.setAsLong(414, BinaryConverter.byteArrayToLong(data, 72));
                this.setAsLong(416, BinaryConverter.byteArrayToLong(data, 80));
                this.setAsLong(417, BinaryConverter.byteArrayToLong(data, 88));
                this.setAsInt(904, BinaryConverter.byteArrayToInt(data, 96));
                this.setAsInt(905, BinaryConverter.byteArrayToInt(data, 100));
                this.setAsInt(314, BinaryConverter.byteArrayToInt(data, 104));
                this.setAsInt(316, BinaryConverter.byteArrayToInt(data, 108));
                this.setAsLong(315, BinaryConverter.byteArrayToLong(data, 112));
                this.setAsLong(317, BinaryConverter.byteArrayToLong(data, 120));
                this.setAsLong(10008, BinaryConverter.byteArrayToLong(data, 128));
                this.setAsLong(1609, BinaryConverter.byteArrayToLong(data, 136));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing Job object.");
        }
        in.defaultReadObject();
        this.remoteCommandLock_ = new Object();
    }

    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("QSYS/RLSJOB JOB(");
        buf.append(this.number_);
        buf.append('/');
        buf.append(this.user_);
        buf.append('/');
        buf.append(this.name_);
        buf.append(") DUPJOBOPT(*MSG)");
        String toRun = buf.toString();
        CommandCall cmd = this.getCommandCall(toRun);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void resetStatistics() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(-1);
    }

    private void retrieve(int key) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.connect();
        byte[] format = Job.lookupFormatName(key);
        if (Trace.traceOn_) {
            Trace.log(1, "QUSRJOBI format:", format);
        }
        int receiverLength = Job.lookupFormatLength(format);
        ProgramParameter[] parmList = key == -1 ? new ProgramParameter[7] : new ProgramParameter[5];
        parmList[0] = new ProgramParameter(receiverLength);
        parmList[1] = new ProgramParameter(BinaryConverter.intToByteArray(receiverLength));
        parmList[2] = new ProgramParameter(format);
        parmList[3] = new ProgramParameter(this.createQualifiedJobName());
        parmList[4] = new ProgramParameter(this.realInternalJobID_ == null ? BLANKS16_ : this.realInternalJobID_);
        if (key == -1) {
            parmList[5] = new ProgramParameter(new byte[8]);
            parmList[6] = new ProgramParameter(new byte[]{-15});
        }
        ProgramCall pc = this.getProgramCall("/QSYS.LIB/QUSRJOBI.PGM", parmList);
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job information for job: " + this.toString());
        }
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        this.parseData(format, parmList[0].getOutputData());
    }

    private void setAsDate(int key, Date val) {
        Calendar dateTime = AS400Calendar.getGregorianInstance();
        dateTime.setTime(val);
        StringBuffer buf = new StringBuffer();
        switch (setterKeys_.get(key)) {
            case 7: {
                int year = dateTime.get(1) - 1900;
                if (year >= 100) {
                    buf.append('1');
                    year -= 100;
                } else {
                    buf.append('0');
                }
                if (year < 10) {
                    buf.append('0');
                }
                buf.append(year);
                int month = dateTime.get(2) + 1;
                if (month < 10) {
                    buf.append('0');
                }
                buf.append(month);
                int day = dateTime.get(5);
                if (day < 10) {
                    buf.append('0');
                }
                buf.append(day);
                break;
            }
            case 6: {
                int hour = dateTime.get(11);
                if (hour < 10) {
                    buf.append('0');
                }
                buf.append(hour);
                int minute = dateTime.get(12);
                if (minute < 10) {
                    buf.append('0');
                }
                buf.append(minute);
                int second = dateTime.get(13);
                if (second < 10) {
                    buf.append('0');
                }
                buf.append(second);
            }
        }
        this.setValueInternal(key, buf.toString());
    }

    private void setAsDateToChange(int key, Date val) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsDate(key, val);
        if (this.cachedChanges_ == null) {
            this.cachedChanges_ = new JobHashtable();
        }
        this.cachedChanges_.put(key, this.getValue(key));
        if (!this.cacheChanges_) {
            this.commitChanges();
        }
    }

    final void setAsInt(int key, int val) {
        this.setValueInternal(key, new Integer(val));
    }

    private void setAsIntToChange(int key, int val) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsInt(key, val);
        if (this.cachedChanges_ == null) {
            this.cachedChanges_ = new JobHashtable();
        }
        this.cachedChanges_.put(key, this.getValue(key));
        if (!this.cacheChanges_) {
            this.commitChanges();
        }
    }

    final void setAsLong(int key, long val) {
        this.setValueInternal(key, new Long(val));
    }

    public void setBreakMessageHandling(String breakMessageHandling) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (breakMessageHandling == null) {
            Trace.log(2, "Parameter 'breakMessageHandling' is null.");
            throw new NullPointerException("breakMessageHandling");
        }
        if (!(breakMessageHandling.equals("*NORMAL") || breakMessageHandling.equals(BREAK_MESSAGE_HANDLING_HOLD) || breakMessageHandling.equals(BREAK_MESSAGE_HANDLING_NOTIFY))) {
            Trace.log(2, "Value of parameter 'breakMessageHandling' is not valid: " + breakMessageHandling);
            throw new ExtendedIllegalArgumentException("breakMessageHandling (" + breakMessageHandling + ")", 2);
        }
        this.setValue(201, breakMessageHandling);
    }

    public void setCacheChanges(boolean cacheChanges) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting cache changes:", cacheChanges);
        }
        if (!cacheChanges) {
            this.cachedChanges_ = null;
        }
        this.cacheChanges_ = cacheChanges;
    }

    public void setCodedCharacterSetID(int codedCharacterSetID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(302, codedCharacterSetID);
    }

    public void setCountryID(String countryID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (countryID == null) {
            Trace.log(2, "Parameter 'countryID' is null.");
            throw new NullPointerException("countryID");
        }
        this.setValue(303, countryID);
    }

    public void setDateFormat(String dateFormat) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dateFormat == null) {
            Trace.log(2, "Parameter 'dateFormat' is null.");
            throw new NullPointerException("dateFormat");
        }
        if (!(dateFormat.equals(DATE_FORMAT_SYSTEM_VALUE) || dateFormat.equals(DATE_FORMAT_YMD) || dateFormat.equals(DATE_FORMAT_MDY) || dateFormat.equals(DATE_FORMAT_DMY) || dateFormat.equals(DATE_FORMAT_JULIAN))) {
            Trace.log(2, "Value of parameter 'dateFormat' is not valid: " + dateFormat);
            throw new ExtendedIllegalArgumentException("dateFormat (" + dateFormat + ")", 2);
        }
        this.setValue(405, dateFormat);
    }

    public void setDateSeparator(String dateSeparator) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dateSeparator == null) {
            Trace.log(2, "Parameter 'dateSeparator' is null.");
            throw new NullPointerException("dateSeparator");
        }
        int len = setterKeys_.get(406);
        if (dateSeparator.length() > len) {
            dateSeparator = dateSeparator.substring(0, len);
        }
        this.setValue(406, dateSeparator);
    }

    public void setDDMConversationHandling(String ddmConversationHandling) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (ddmConversationHandling == null) {
            Trace.log(2, "Parameter 'ddmConversationHandling' is null.");
            throw new NullPointerException("ddmConversationHandling");
        }
        if (!ddmConversationHandling.equals("*KEEP") && !ddmConversationHandling.equals(KEEP_DDM_CONNECTIONS_ACTIVE_DROP)) {
            Trace.log(2, "Value of parameter 'ddmConversationHandling' is not valid: " + ddmConversationHandling);
            throw new ExtendedIllegalArgumentException("ddmConversationHandling (" + ddmConversationHandling + ")", 2);
        }
        this.setValue(408, ddmConversationHandling);
    }

    public void setDecimalFormat(String decimalFormat) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (decimalFormat == null) {
            Trace.log(2, "Parameter 'decimalFormat' is null.");
            throw new NullPointerException("decimalFormat");
        }
        if (!(decimalFormat.equals("") || decimalFormat.equals("I") || decimalFormat.equals("J") || decimalFormat.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'decimalFormat' is not valid: " + decimalFormat);
            throw new ExtendedIllegalArgumentException("decimalFormat (" + decimalFormat + ")", 2);
        }
        this.setValue(413, decimalFormat);
    }

    public void setDefaultWait(int defaultWait) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(409, defaultWait);
    }

    public void setDeviceRecoveryAction(String deviceRecoveryAction) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (deviceRecoveryAction == null) {
            Trace.log(2, "Parameter 'deviceRecoveryAction' is null.");
            throw new NullPointerException("deviceRecoveryAction");
        }
        if (!(deviceRecoveryAction.equals("*MSG") || deviceRecoveryAction.equals(DEVICE_RECOVERY_ACTION_DISCONNECT_MESSAGE) || deviceRecoveryAction.equals(DEVICE_RECOVERY_ACTION_DISCONNECT_END_REQUEST) || deviceRecoveryAction.equals(DEVICE_RECOVERY_ACTION_END_JOB) || deviceRecoveryAction.equals(DEVICE_RECOVERY_ACTION_END_JOB_NO_LIST) || deviceRecoveryAction.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'deviceRecoveryAction' is not valid: " + deviceRecoveryAction);
            throw new ExtendedIllegalArgumentException("deviceRecoveryAction (" + deviceRecoveryAction + ")", 2);
        }
        this.setValue(410, deviceRecoveryAction);
    }

    public void setInquiryMessageReply(String inquiryMessageReply) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (inquiryMessageReply == null) {
            Trace.log(2, "Parameter 'inquiryMessageReply' is null.");
            throw new NullPointerException("inquiryMessageReply");
        }
        if (!(inquiryMessageReply.equals(INQUIRY_MESSAGE_REPLY_REQUIRED) || inquiryMessageReply.equals(INQUIRY_MESSAGE_REPLY_DEFAULT) || inquiryMessageReply.equals(INQUIRY_MESSAGE_REPLY_SYSTEM_REPLY_LIST))) {
            Trace.log(2, "Value of parameter 'inquiryMessageReply' is not valid: " + inquiryMessageReply);
            throw new ExtendedIllegalArgumentException("inquiryMessageReply (" + inquiryMessageReply + ")", 2);
        }
        this.setValue(901, inquiryMessageReply);
    }

    public void setInternalJobID(String internalJobID) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting internal job ID: " + internalJobID);
        }
        if (internalJobID == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (internalJobID.length() != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: '" + internalJobID + "'");
            throw new ExtendedIllegalArgumentException("internalJobID (" + internalJobID + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'internalJobID' after connect.");
            throw new ExtendedIllegalStateException("internalJobID", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.internalJobID_ = internalJobID;
            this.realInternalJobID_ = new byte[16];
            for (int i = 0; i < 16; ++i) {
                this.realInternalJobID_[i] = (byte)internalJobID.charAt(i);
            }
        } else {
            String oldValue = this.internalJobID_;
            String newValue = internalJobID;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("internalJobID", oldValue, newValue);
            }
            this.internalJobID_ = internalJobID;
            this.realInternalJobID_ = new byte[16];
            for (int i = 0; i < 16; ++i) {
                this.realInternalJobID_[i] = (byte)internalJobID.charAt(i);
            }
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("internalJobID", oldValue, newValue);
            }
        }
    }

    public void setInternalJobIdentifier(byte[] internalJobID) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting internal job identifier:", internalJobID);
        }
        if (internalJobID == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (internalJobID.length != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: " + internalJobID.length);
            throw new ExtendedIllegalArgumentException("internalJobID.length {" + internalJobID.length + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'internalJobID' after connect.");
            throw new ExtendedIllegalStateException("internalJobID", 5);
        }
        this.realInternalJobID_ = internalJobID;
        char[] oldID = new char[16];
        for (int i = 0; i < 16; ++i) {
            oldID[i] = (char)(internalJobID[i] & 0xFF);
        }
        this.internalJobID_ = new String(oldID);
    }

    public void setJobAccountingCode(String jobAccountingCode) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (jobAccountingCode == null) {
            Trace.log(2, "Parameter 'jobAccountingCode' is null.");
            throw new NullPointerException("jobAccountingCode");
        }
        this.setValue(1001, jobAccountingCode);
    }

    public void setJobDate(Date jobDate) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (jobDate == null) {
            Trace.log(2, "Parameter 'jobAccountingCode' is null.");
            throw new NullPointerException("jobDate");
        }
        this.setAsDateToChange(1002, jobDate);
    }

    public void setJobMessageQueueFullAction(String jobMessageQueueFullAction) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (jobMessageQueueFullAction == null) {
            Trace.log(2, "Parameter 'jobMessageQueueFullAction' is null.");
            throw new NullPointerException("jobMessageQueueFullAction");
        }
        if (!(jobMessageQueueFullAction.equals(MESSAGE_QUEUE_ACTION_NO_WRAP) || jobMessageQueueFullAction.equals(MESSAGE_QUEUE_ACTION_WRAP) || jobMessageQueueFullAction.equals(MESSAGE_QUEUE_ACTION_PRINT_WRAP) || jobMessageQueueFullAction.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'jobMessageQueueFullAction' is not valid: " + jobMessageQueueFullAction);
            throw new ExtendedIllegalArgumentException("jobMessageQueueFullAction (" + jobMessageQueueFullAction + ")", 2);
        }
        this.setValue(1007, jobMessageQueueFullAction);
    }

    public void setJobSwitches(String jobSwitches) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (jobSwitches == null) {
            Trace.log(2, "Parameter 'jobSwitches' is null.");
            throw new NullPointerException("jobSwitches");
        }
        int len = setterKeys_.get(1006);
        if (jobSwitches.length() > len) {
            jobSwitches = jobSwitches.substring(0, len);
        }
        this.setValue(1006, jobSwitches);
    }

    public void setLanguageID(String languageID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (languageID == null) {
            Trace.log(2, "Parameter 'languageID' is null.");
            throw new NullPointerException("languageID");
        }
        this.setValue(1201, languageID);
    }

    public void setLoggingCLPrograms(String loggingCLPrograms) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (loggingCLPrograms == null) {
            Trace.log(2, "Parameter 'loggingCLPrograms' is null.");
            throw new NullPointerException("loggingCLPrograms");
        }
        if (!loggingCLPrograms.equals("*YES") && !loggingCLPrograms.equals("*NO")) {
            Trace.log(2, "Value of parameter 'loggingCLPrograms' is not valid: " + loggingCLPrograms);
            throw new ExtendedIllegalArgumentException("loggingCLPrograms (" + loggingCLPrograms + ")", 2);
        }
        this.setValue(1203, loggingCLPrograms);
    }

    public void setLoggingLevel(int loggingLevel) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (loggingLevel < 0 || loggingLevel > 4) {
            Trace.log(2, "Value of parameter 'loggingLevel' is not valid:", loggingLevel);
            throw new ExtendedIllegalArgumentException("loggingLevel " + loggingLevel + ")", 4);
        }
        this.setValue(1202, Integer.toString(loggingLevel));
    }

    public void setLoggingSeverity(int loggingSeverity) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(1204, loggingSeverity);
    }

    public void setLoggingText(String loggingText) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (loggingText == null) {
            Trace.log(2, "Parameter 'loggingText' is null.");
            throw new NullPointerException("loggingText");
        }
        if (!(loggingText.equals("*MSG") || loggingText.equals(LOGGING_TEXT_SECLVL) || loggingText.equals(LOGGING_TEXT_NO_LIST))) {
            Trace.log(2, "Value of parameter 'loggingText' is not valid: " + loggingText);
            throw new ExtendedIllegalArgumentException("loggingText (" + loggingText + ")", 2);
        }
        this.setValue(1205, loggingText);
    }

    public void setName(String name) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (name.length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + name + "'");
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'name' after connect.");
            throw new ExtendedIllegalStateException("name", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.name_ = name;
            this.setValueInternal(11001, name);
        } else {
            String oldValue = this.name_;
            String newValue = name;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("name", oldValue, newValue);
            }
            this.name_ = newValue;
            this.setValueInternal(11001, name);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("name", oldValue, newValue);
            }
        }
    }

    public void setNumber(String number) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting number: " + number);
        }
        if (number == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (number.length() > 6) {
            Trace.log(2, "Length of parameter 'number' is not valid: '" + number + "'");
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'number' after connect.");
            throw new ExtendedIllegalStateException("number", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.number_ = number;
            this.setValueInternal(11002, number);
        } else {
            String oldValue = this.number_;
            String newValue = number;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("number", oldValue, newValue);
            }
            this.number_ = number;
            this.setValueInternal(11002, number);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("number", oldValue, newValue);
            }
        }
    }

    public void setOutputQueue(String outputQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (outputQueue == null) {
            Trace.log(2, "Parameter 'outputQueue' is null.");
            throw new NullPointerException("outputQueue");
        }
        if (!outputQueue.startsWith("*")) {
            QSYSObjectPathName path = new QSYSObjectPathName(outputQueue, "OUTQ");
            StringBuffer buf = new StringBuffer();
            String name = path.getObjectName();
            buf.append(name);
            for (int i = name.length(); i < 10; ++i) {
                buf.append(' ');
            }
            buf.append(path.getLibraryName());
            this.setValue(1501, buf.toString());
        } else {
            this.setValue(1501, outputQueue);
        }
    }

    public void setOutputQueuePriority(int outputQueuePriority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(1502, Integer.toString(outputQueuePriority));
    }

    public void setPrinterDeviceName(String printerDeviceName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (printerDeviceName == null) {
            Trace.log(2, "Parameter 'printerDeviceName' is null.");
            throw new NullPointerException("printerDeviceName");
        }
        int len = setterKeys_.get(1603);
        if (printerDeviceName.length() > len) {
            printerDeviceName = printerDeviceName.substring(0, len);
        }
        this.setValue(1603, printerDeviceName);
    }

    public void setPrintKeyFormat(String printKeyFormat) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (printKeyFormat == null) {
            Trace.log(2, "Parameter 'printKeyFormat' is null.");
            throw new NullPointerException("printKeyFormat");
        }
        if (!(printKeyFormat.equals("*NONE") || printKeyFormat.equals(PRINT_KEY_FORMAT_BORDER) || printKeyFormat.equals(PRINT_KEY_FORMAT_HEADER) || printKeyFormat.equals(PRINT_KEY_FORMAT_ALL) || printKeyFormat.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'printKeyFormat' is not valid: " + printKeyFormat);
            throw new ExtendedIllegalArgumentException("printKeyFormat (" + printKeyFormat + ")", 2);
        }
        this.setValue(1601, printKeyFormat);
    }

    public void setPrintText(String printText) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (printText == null) {
            Trace.log(2, "Parameter 'printText' is null.");
            throw new NullPointerException("printText");
        }
        this.setValue(1602, printText);
    }

    public void setPurge(boolean purge) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValueInternal(1604, purge ? "*YES" : "*NO");
    }

    public void setQueue(String jobQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (jobQueue == null) {
            Trace.log(2, "Parameter 'jobQueue' is null.");
            throw new NullPointerException("jobQueue");
        }
        if (!jobQueue.startsWith("*")) {
            QSYSObjectPathName path = new QSYSObjectPathName(jobQueue, "JOBQ");
            StringBuffer buf = new StringBuffer();
            String name = path.getObjectName();
            buf.append(name);
            for (int i = name.length(); i < 10; ++i) {
                buf.append(' ');
            }
            buf.append(path.getLibraryName());
            this.setValue(1004, buf.toString());
        } else {
            this.setValue(1004, jobQueue);
        }
    }

    public void setQueuePriority(int queuePriority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(1005, Integer.toString(queuePriority));
    }

    public void setRunPriority(int runPriority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(1802, runPriority);
    }

    public void setScheduleDate(Date scheduleDate) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (scheduleDate == null) {
            Trace.log(2, "Parameter 'scheduleDate' is null.");
            throw new NullPointerException("scheduleDate");
        }
        Calendar dateTime = AS400Calendar.getGregorianInstance();
        dateTime.clear();
        dateTime.setTime(scheduleDate);
        StringBuffer buf = new StringBuffer();
        int year = dateTime.get(1) - 1900;
        if (year >= 100) {
            buf.append('1');
            year -= 100;
        } else {
            buf.append('0');
        }
        if (year < 10) {
            buf.append('0');
        }
        buf.append(year);
        int month = dateTime.get(2) + 1;
        if (month < 10) {
            buf.append('0');
        }
        buf.append(month);
        int day = dateTime.get(5);
        if (day < 10) {
            buf.append('0');
        }
        buf.append(day);
        String dateToSet = buf.toString();
        buf = new StringBuffer();
        int hour = dateTime.get(11);
        if (hour < 10) {
            buf.append('0');
        }
        buf.append(hour);
        int minute = dateTime.get(12);
        if (minute < 10) {
            buf.append('0');
        }
        buf.append(minute);
        int second = dateTime.get(13);
        if (second < 10) {
            buf.append('0');
        }
        buf.append(second);
        String timeToSet = buf.toString();
        this.setValue(1920, dateToSet);
        this.setValue(1921, timeToSet);
        this.setValueInternal(403, null);
    }

    public void setScheduleDate(String scheduleDate) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (scheduleDate == null) {
            Trace.log(2, "Parameter 'scheduleDate' is null.");
            throw new NullPointerException("scheduleDate");
        }
        if (scheduleDate.length() != 7) {
            Trace.log(2, "Value of parameter 'scheduleDate' is not valid: " + scheduleDate);
            throw new ExtendedIllegalArgumentException("scheduleDate (" + scheduleDate + ")", 2);
        }
        this.setValue(1920, scheduleDate);
        this.setValueInternal(403, null);
    }

    public void setScheduleTime(Date scheduleTime) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (scheduleTime == null) {
            Trace.log(2, "Parameter 'scheduleTime' is null.");
            throw new NullPointerException("scheduleTime");
        }
        this.setScheduleDate(scheduleTime);
    }

    public void setScheduleTime(String scheduleTime) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (scheduleTime == null) {
            Trace.log(2, "Parameter 'scheduleTime' is null.");
            throw new NullPointerException("scheduleTime");
        }
        if (scheduleTime.length() != 6) {
            Trace.log(2, "Value of parameter 'scheduleTime' is not valid: " + scheduleTime);
            throw new ExtendedIllegalArgumentException("scheduleTime (" + scheduleTime + ")", 2);
        }
        this.setValue(1921, scheduleTime);
        this.setValueInternal(403, null);
    }

    public void setSortSequenceTable(String sortSequenceTable) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (sortSequenceTable == null) {
            Trace.log(2, "Parameter 'scheduleTime' is null.");
            throw new NullPointerException("sortSequenceTable");
        }
        if (!sortSequenceTable.startsWith("*")) {
            QSYSObjectPathName path = new QSYSObjectPathName(sortSequenceTable, "FILE");
            StringBuffer buf = new StringBuffer();
            String name = path.getObjectName();
            buf.append(name);
            for (int i = name.length(); i < 10; ++i) {
                buf.append(' ');
            }
            buf.append(path.getLibraryName());
            this.setValue(1901, buf.toString());
        } else {
            this.setValue(1901, sortSequenceTable);
        }
    }

    public void setStatusMessageHandling(String statusMessageHandling) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (statusMessageHandling == null) {
            Trace.log(2, "Parameter 'statusMessageHandling' is null.");
            throw new NullPointerException("statusMessageHandling");
        }
        this.setValue(1902, statusMessageHandling);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    public void setTimeSeparator(String timeSeparator) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (timeSeparator == null) {
            Trace.log(2, "Parameter 'timeSeparator' is null.");
            throw new NullPointerException("timeSeparator");
        }
        int len = setterKeys_.get(2001);
        if (timeSeparator.length() > len) {
            timeSeparator = timeSeparator.substring(0, len);
        }
        this.setValue(2001, timeSeparator);
    }

    public void setTimeSlice(int timeSlice) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(2002, timeSlice);
    }

    public void setTimeSliceEndPool(String timeSliceEndPool) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (timeSliceEndPool == null) {
            Trace.log(2, "Parameter 'timeSliceEndPool' is null.");
            throw new NullPointerException("timeSliceEndPool");
        }
        this.setValue(2003, timeSliceEndPool);
    }

    public void setUser(String user) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user: " + user);
        }
        if (user == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (user.length() > 10) {
            Trace.log(2, "Length of parameter 'user' is not valid: '" + user + "'");
            throw new ExtendedIllegalArgumentException("user (" + user + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'user' after connect.");
            throw new ExtendedIllegalStateException("user", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.user_ = user;
            this.setValueInternal(11006, user);
        } else {
            String oldValue = this.user_;
            String newValue = user;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("user", oldValue, newValue);
            }
            this.user_ = user;
            this.setValueInternal(11006, user);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("user", oldValue, newValue);
            }
        }
    }

    public void setValue(int attribute, Object value) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting value, attribute: " + attribute + ", value: " + value);
        }
        if (attribute < 0 || Job.isReadOnly(attribute)) {
            Trace.log(2, "Value of parameter 'attribute' is not valid:", attribute);
            throw new ExtendedIllegalArgumentException("attribute (" + attribute + ")", 2);
        }
        if (attribute == 1920 || attribute == 1921) {
            this.setValueInternal(403, null);
        }
        if (this.cachedChanges_ == null) {
            this.cachedChanges_ = new JobHashtable();
        }
        this.cachedChanges_.put(attribute, value);
        if (!this.cacheChanges_) {
            this.commitChanges();
        }
        this.values_.put(attribute, value);
    }

    final void setValueInternal(int key, Object value) {
        this.values_.put(key, value);
    }

    public String toString() {
        if (this.number_ == null || this.user_ == null || this.name_ == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.number_);
        buf.append('/');
        buf.append(this.user_);
        buf.append('/');
        buf.append(this.name_);
        return buf.toString();
    }

    public String getJobAsp() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(104);
        return ((String)this.values_.get(104)).trim();
    }

    static {
        setterKeys_.put(201, 10);
        setterKeys_.put(302, 4);
        setterKeys_.put(303, 8);
        setterKeys_.put(311, 10);
        setterKeys_.put(405, 4);
        setterKeys_.put(406, 1);
        setterKeys_.put(408, 5);
        setterKeys_.put(409, 4);
        setterKeys_.put(410, 13);
        setterKeys_.put(413, 8);
        setterKeys_.put(901, 10);
        setterKeys_.put(1001, 15);
        setterKeys_.put(1002, 7);
        setterKeys_.put(1018, 10);
        setterKeys_.put(1004, 20);
        setterKeys_.put(1005, 2);
        setterKeys_.put(1006, 8);
        setterKeys_.put(1007, 10);
        setterKeys_.put(1201, 8);
        setterKeys_.put(1202, 1);
        setterKeys_.put(1203, 10);
        setterKeys_.put(1204, 4);
        setterKeys_.put(1205, 7);
        setterKeys_.put(1501, 20);
        setterKeys_.put(1502, 2);
        setterKeys_.put(1601, 10);
        setterKeys_.put(1602, 30);
        setterKeys_.put(1603, 10);
        setterKeys_.put(1604, 4);
        setterKeys_.put(1802, 4);
        setterKeys_.put(1901, 20);
        setterKeys_.put(1902, 10);
        setterKeys_.put(1920, 10);
        setterKeys_.put(1921, 8);
        setterKeys_.put(1982, 10);
        setterKeys_.put(2001, 1);
        setterKeys_.put(2002, 4);
        setterKeys_.put(2003, 10);
    }
}

