/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.Serializable;

final class JobHashtable
implements Serializable {
    static final long serialVersionUID = 5L;
    private static final int HASH = 4;
    final Object[][] values_ = new Object[4][];
    final int[][] keys_ = new int[4][];
    int size_ = 0;

    JobHashtable() {
    }

    final void clear() {
        for (int i = 0; i < 4; ++i) {
            this.values_[i] = null;
            this.keys_[i] = null;
        }
        this.size_ = 0;
    }

    final boolean contains(int key) {
        if (key == 0) {
            return false;
        }
        int hash = key % 4;
        int[] keyChain = this.keys_[hash];
        if (keyChain == null) {
            return false;
        }
        for (int i = 0; i < keyChain.length; ++i) {
            if (keyChain[i] != key) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object get(int key) {
        if (key == 0) {
            return null;
        }
        int hash = key % 4;
        int[][] nArray = this.keys_;
        synchronized (this.keys_) {
            int[] keyChain = this.keys_[hash];
            if (keyChain == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            for (int i = 0; i < keyChain.length; ++i) {
                if (keyChain[i] != key) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.values_[hash][i];
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void put(int key, Object value) {
        if (key == 0) {
            return;
        }
        int hash = key % 4;
        int[][] nArray = this.keys_;
        synchronized (this.keys_) {
            Object[] valueChain = this.values_[hash];
            int[] keyChain = this.keys_[hash];
            if (keyChain == null) {
                keyChain = new int[]{key};
                valueChain = new Object[]{value};
                this.keys_[hash] = keyChain;
                this.values_[hash] = valueChain;
                ++this.size_;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            int len = keyChain.length;
            for (int i = 0; i < len; ++i) {
                if (keyChain[i] == key) {
                    valueChain[i] = value;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                if (keyChain[i] != 0) continue;
                keyChain[i] = key;
                valueChain[i] = value;
                ++this.size_;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            int[] newKeyChain = new int[len * 2];
            System.arraycopy(keyChain, 0, newKeyChain, 0, len);
            Object[] newValueChain = new Object[len * 2];
            System.arraycopy(valueChain, 0, newValueChain, 0, len);
            newKeyChain[len] = key;
            newValueChain[len] = value;
            this.keys_[hash] = newKeyChain;
            this.values_[hash] = newValueChain;
            ++this.size_;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object remove(int key) {
        if (key == 0) {
            return null;
        }
        int hash = key % 4;
        int[][] nArray = this.keys_;
        synchronized (this.keys_) {
            int[] keyChain = this.keys_[hash];
            if (keyChain == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            for (int i = 0; i < keyChain.length; ++i) {
                int j;
                if (keyChain[i] != key) continue;
                Object value = this.values_[hash][i];
                for (j = i + 1; j < keyChain.length; ++j) {
                    keyChain[j - 1] = keyChain[j];
                    this.values_[hash][j - 1] = this.values_[hash][j];
                    if (keyChain[j] == 0) break;
                }
                if (j == keyChain.length) {
                    keyChain[j - 1] = 0;
                    this.values_[hash][j - 1] = null;
                }
                --this.size_;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return value;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }
}

