/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.MemberDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MemberList {
    private static final SimpleDateFormat dateTimeFormat_ = new SimpleDateFormat("yyMMddHHmmss");
    private static final String QUSLMBR_FORMAT_100 = "MBRL0100";
    private static final String QUSLMBR_FORMAT_200 = "MBRL0200";
    private static final QSYSObjectPathName USERSPACE_PATH = new QSYSObjectPathName("QTEMP", "JT4QUSLMBR", "USRSPC");
    private AS400 system_;
    private QSYSObjectPathName path_;
    private String memberSelection_ = "*ALL";
    private final Map memberDescriptions_ = new HashMap();
    private final List attributes_ = new ArrayList();
    private static final int OFFSET_MEMBER_NAME = 0;
    private static final int OFFSET_SOURCE_TYPE = 10;
    private static final int OFFSET_CREATION_DATE_TIME = 20;
    private static final int OFFSET_LAST_SOURCE_CHANGE_DATE = 33;
    private static final int OFFSET_MEMBER_TEXT_DESCRIPTION = 46;
    private static final int OFFSET_MEMBER_TEXT_DESCRIPTION_CCSID = 96;
    private final AS400Bin4 intConverter_ = new AS400Bin4();

    public MemberList(AS400File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.system_ = file.getSystem();
        this.path_ = new QSYSObjectPathName(file.getLibraryName(), file.getFileName(), "FILE");
        String memberName = file.getMemberName();
        if (memberName != null && memberName.length() != 0) {
            if (memberName.startsWith("*")) {
                this.memberSelection_ = "*ALL";
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting member selection to *ALL.  Member name from AS400File object:", memberName);
                }
            } else {
                this.memberSelection_ = memberName;
            }
        }
    }

    public MemberList(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.path_ = path;
        String memberName = this.path_.getMemberName();
        if (memberName == null || memberName.length() == 0) {
            this.memberSelection_ = "*ALL";
            if (Trace.traceOn_) {
                Trace.log(1, "Setting member selection to *ALL.  Member name from QSYSObjectPathName object is: " + memberName);
            }
        } else {
            this.memberSelection_ = memberName;
        }
    }

    public MemberList(AS400 system, String libraryName, String objectName) {
        this(system, new QSYSObjectPathName(libraryName, objectName, "FILE"));
    }

    private String lookupFormat(int attribute) {
        String format;
        switch (attribute) {
            case 3: {
                format = QUSLMBR_FORMAT_100;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: {
                format = QUSLMBR_FORMAT_200;
                break;
            }
            default: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unrecognized attribute key:", attribute);
                }
                format = QUSLMBR_FORMAT_200;
            }
        }
        return format;
    }

    public void clear() {
        this.memberDescriptions_.clear();
    }

    public void clearAttributeList() {
        this.attributes_.clear();
    }

    public void addAttribute(int attribute) {
        this.attributes_.add(new Integer(attribute));
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        ProgramCall program = new ProgramCall(this.system_, "/QSYS.LIB/QUSLMBR.PGM", this.buildProgramParameters(this.getFormat()));
        boolean willRunProgramsOnThread = program.isStayOnThread();
        Serializable lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
        Serializable serializable = lockObject;
        synchronized (serializable) {
            UserSpace us = new UserSpace(this.system_, USERSPACE_PATH.getPath());
            us.setMustUseProgramCall(true);
            if (!willRunProgramsOnThread) {
                us.setMustUseSockets(true);
            }
            try {
                us.create(65535, true, "JT400", (byte)0, "Userspace for loading members", "*ALL");
                if (!program.run()) {
                    throw new AS400Exception(program.getMessageList());
                }
                byte[] usBuf = new byte[65535];
                int numBytesRead = us.read(usBuf, 0, 0, 144);
                if (numBytesRead < 144) {
                    Trace.log(2, "Failed to read the generic header.  Number of bytes read: " + numBytesRead);
                    throw new InternalErrorException(6, numBytesRead);
                }
                int offsetToHeaderSection = BinaryConverter.byteArrayToInt(usBuf, 116);
                int headerSectionSize = BinaryConverter.byteArrayToInt(usBuf, 120);
                int offsetToListDataSection = BinaryConverter.byteArrayToInt(usBuf, 124);
                int listDataSectionSize = BinaryConverter.byteArrayToInt(usBuf, 128);
                int numberOfListEntries = BinaryConverter.byteArrayToInt(usBuf, 132);
                int sizeOfEachEntry = BinaryConverter.byteArrayToInt(usBuf, 136);
                int entryCCSID = BinaryConverter.byteArrayToInt(usBuf, 140);
                if (entryCCSID == 0) {
                    entryCCSID = this.system_.getCcsid();
                }
                CharConverter conv = new CharConverter(entryCCSID);
                numBytesRead = us.read(usBuf, offsetToHeaderSection, 0, headerSectionSize);
                if (numBytesRead < headerSectionSize) {
                    Trace.log(2, "Failed to read the header section.  Number of bytes read: " + numBytesRead);
                    throw new InternalErrorException(6, numBytesRead);
                }
                String libraryNameUsed = conv.byteArrayToString(usBuf, 10, 10).trim();
                if (listDataSectionSize > usBuf.length) {
                    usBuf = new byte[listDataSectionSize + 1];
                }
                if ((numBytesRead = us.read(usBuf, offsetToListDataSection, 0, listDataSectionSize)) < listDataSectionSize) {
                    Trace.log(2, "Failed to read the list data section.  Number of bytes read: " + numBytesRead);
                    throw new InternalErrorException(6, numBytesRead);
                }
                String format = this.getFormat();
                for (int i = 0; i < numberOfListEntries; ++i) {
                    byte[] entryBuf = new byte[sizeOfEachEntry];
                    System.arraycopy(usBuf, i * sizeOfEachEntry, entryBuf, 0, sizeOfEachEntry);
                    this.readMemberInfoFromUserspaceEntry(entryBuf, format, conv, libraryNameUsed);
                }
                Object var21_20 = null;
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                try {
                    us.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
                throw throwable;
            }
            try {
                us.delete();
            }
            catch (Exception e) {
                Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
            }
        }
    }

    private ProgramParameter[] buildProgramParameters(String format) throws UnsupportedEncodingException {
        ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(CharConverter.stringToByteArray(this.system_, USERSPACE_PATH.toQualifiedObjectName())), new ProgramParameter(CharConverter.stringToByteArray(this.system_, format)), new ProgramParameter(CharConverter.stringToByteArray(this.system_, this.path_.toQualifiedObjectName())), new ProgramParameter(new AS400Text(10).toBytes(this.memberSelection_)), new ProgramParameter(CharConverter.stringToByteArray(this.system_, "1")), new ErrorCodeParameter()};
        return parameterList;
    }

    private void readMemberInfoFromUserspaceEntry(byte[] entryBuf, String format, CharConverter charConverter, String usedLibraryName) {
        String memberName = charConverter.byteArrayToString(entryBuf, 0, 10).trim();
        MemberDescription memberDescription = (MemberDescription)this.memberDescriptions_.get(memberName);
        if (memberDescription == null) {
            QSYSObjectPathName memberPath = new QSYSObjectPathName(this.path_.getPath());
            try {
                memberPath.setMemberName(memberName);
                memberPath.setLibraryName(usedLibraryName);
            }
            catch (PropertyVetoException pve) {
                Trace.log(2, "Error ignored.", (Throwable)pve);
            }
            memberDescription = new MemberDescription(this.system_, memberPath);
            memberDescription.setAttribute(3, memberName);
            this.memberDescriptions_.put(memberName, memberDescription);
        }
        if (QUSLMBR_FORMAT_200.equals(format)) {
            memberDescription.setAttribute(5, charConverter.byteArrayToString(entryBuf, 10, 10).trim());
            memberDescription.setAttribute(8, charConverter.byteArrayToString(entryBuf, 46, 50).trim());
            memberDescription.setAttribute(26, new Integer(this.intConverter_.toInt(entryBuf, 96)));
            memberDescription.setAttribute(7, this.transformDate(charConverter.byteArrayToString(entryBuf, 33, 13)));
            memberDescription.setAttribute(6, this.transformDate(charConverter.byteArrayToString(entryBuf, 20, 13)));
        }
    }

    public MemberDescription[] getMemberDescriptions() {
        return this.memberDescriptions_.values().toArray(new MemberDescription[this.memberDescriptions_.size()]);
    }

    private String getFormat() {
        String format = QUSLMBR_FORMAT_100;
        Iterator iter = this.attributes_.iterator();
        while (iter.hasNext()) {
            String tmpFormat = this.lookupFormat((Integer)iter.next());
            if (format.compareTo(tmpFormat) >= 0) continue;
            format = tmpFormat;
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date transformDate(String dateString) {
        Date retVal;
        block6: {
            retVal = null;
            if (dateString != null && dateString.length() != 0) {
                try {
                    SimpleDateFormat simpleDateFormat = dateTimeFormat_;
                    synchronized (simpleDateFormat) {
                        retVal = dateTimeFormat_.parse(dateString.substring(1));
                    }
                }
                catch (ParseException pe) {
                    if (!Trace.traceOn_) break block6;
                    Trace.log(2, "Ignored error while parsing date string: " + dateString, (Throwable)pe);
                }
            }
        }
        return retVal;
    }
}

