/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPAttribute;
import java.io.Serializable;

class NPAttrString
extends NPAttribute
implements Cloneable,
Serializable {
    static final long serialVersionUID = 4L;
    private String attrValue_;

    NPAttrString(NPAttrString attr) {
        super(attr);
        this.attrValue_ = attr.attrValue_;
    }

    NPAttrString(int ID) {
        super(ID, 5);
    }

    NPAttrString(int ID, String value) {
        super(ID, 5);
        this.set(value);
    }

    NPAttrString(int ID, byte[] hostDataStream, int offset, int length, ConverterImpl hostConverter) {
        super(ID, 5, hostDataStream, offset, length, hostConverter);
        this.buildStringFromHostData(hostConverter);
    }

    private void buildHostString(ConverterImpl converter) {
        byte[] hostValue = new byte[this.attrValue_.length() + 1];
        byte[] temp = converter.stringToByteArray(this.attrValue_);
        System.arraycopy(temp, 0, hostValue, 0, hostValue.length - 1);
        hostValue[hostValue.length - 1] = 0;
        super.setHostData(hostValue, converter);
    }

    private void buildStringFromHostData(ConverterImpl converter) {
        byte[] hostValue = super.getHostData(converter);
        if (hostValue == null || hostValue.length == 0) {
            this.attrValue_ = "";
        } else {
            this.attrValue_ = converter.byteArrayToString(hostValue, 0, hostValue.length - 1);
            this.attrValue_ = this.attrValue_.trim();
        }
    }

    protected Object clone() {
        NPAttrString attr = new NPAttrString(this);
        return attr;
    }

    String get() {
        return this.attrValue_;
    }

    byte[] getHostData(ConverterImpl converter) {
        this.buildHostString(converter);
        return super.getHostData(converter);
    }

    int getHostLength(ConverterImpl converter) {
        this.buildHostString(converter);
        return super.getHostLength(converter);
    }

    void set(String value) {
        this.attrValue_ = value;
        if (this.getID() != 115 && this.getID() != 116 && this.getID() != 93 && this.getID() != 250 && this.getID() != 229 && this.getID() != 230 && this.getID() != 231 && this.getID() != 232 && this.getID() != 233 && this.getID() != 96 && this.getID() != 48 && this.getID() != 162 && this.getID() != 163 && this.getID() != 109 && value.length() != 0 && !value.startsWith("\"")) {
            String sAlphabet = "abcdefghijklmnopqrstuvwxyz";
            StringBuffer sbOutput = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                if (sAlphabet.lastIndexOf(value.substring(i, i + 1)) == -1) {
                    sbOutput.append(value.charAt(i));
                    continue;
                }
                sbOutput.append(Character.toUpperCase(value.charAt(i)));
            }
            this.attrValue_ = sbOutput.toString();
        }
    }

    void setHostData(byte[] data, ConverterImpl converter) {
        super.setHostData(data, converter);
        this.buildStringFromHostData(converter);
    }
}

