/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.NPAttribute;
import com.ibm.as400.access.NPAttributeIFS;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.PrintObject;

class NPCPAttributeIDList
extends NPCodePoint
implements Cloneable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final int LEN_ATTRLIST_HEADER = 4;
    private byte[] idList_;
    private boolean fDataOutOfDate_;
    private boolean fListOutOfDate_;

    protected Object clone() {
        NPCPAttributeIDList cp = new NPCPAttributeIDList(this);
        return cp;
    }

    NPCPAttributeIDList(NPCPAttributeIDList cp) {
        super(cp);
        this.fDataOutOfDate_ = cp.fDataOutOfDate_;
        this.fListOutOfDate_ = cp.fListOutOfDate_;
        this.idList_ = new byte[336];
        System.arraycopy(cp.idList_, 0, this.idList_, 0, this.idList_.length);
    }

    public NPCPAttributeIDList() {
        super(7);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = false;
        this.idList_ = new byte[336];
    }

    NPCPAttributeIDList(byte[] data) {
        super(7, data);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = true;
        this.idList_ = new byte[336];
    }

    int getLength() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getLength();
    }

    void setDataBuffer(byte[] dataBuffer, int datalen, int offset) {
        this.fListOutOfDate_ = true;
        this.fDataOutOfDate_ = false;
        super.setDataBuffer(dataBuffer, datalen, offset);
    }

    byte[] getDataBuffer() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getDataBuffer();
    }

    byte[] getDataBuffer(int dataLength) {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        this.fListOutOfDate_ = true;
        return super.getDataBuffer(dataLength);
    }

    void reset() {
        this.zeroIDList();
        this.fListOutOfDate_ = false;
        this.fDataOutOfDate_ = false;
        super.reset();
    }

    void addAttrID(int ID) {
        if (!NPAttribute.idIsValid(ID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(ID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (ID < 0) {
            ID = Math.abs(ID) - 1;
            NPAttributeIFS ifsAttr = NPAttributeIFS.ifsAttrs[ID];
            this.idList_[ifsAttr.nameID_] = 1;
            this.idList_[ifsAttr.libraryID_] = 1;
            if (ifsAttr.typeID_ != 0) {
                this.idList_[ifsAttr.typeID_] = 1;
            }
        } else {
            this.idList_[ID] = 1;
        }
        this.fDataOutOfDate_ = true;
    }

    boolean containsID(int ID) {
        boolean fRC = false;
        if (NPAttribute.idIsValid(ID)) {
            if (this.fListOutOfDate_) {
                this.updateList();
            }
            if (ID < 0) {
                ID = Math.abs(ID) - 1;
                NPAttributeIFS ifsAttr = NPAttributeIFS.ifsAttrs[ID];
                if (this.idList_[ifsAttr.nameID_] != 0 && this.idList_[ifsAttr.libraryID_] != 0) {
                    if (ifsAttr.typeID_ != 0) {
                        if (this.idList_[ifsAttr.typeID_] != 0) {
                            fRC = true;
                        }
                    } else {
                        fRC = true;
                    }
                }
            } else if (this.idList_[ID] != 0) {
                fRC = true;
            }
        }
        return fRC;
    }

    private void updateData() {
        int index;
        int elements = 0;
        int dataLength = 4;
        for (index = 0; index < this.idList_.length; ++index) {
            if (this.idList_[index] == 0) continue;
            ++elements;
        }
        byte[] data = super.getDataBuffer(dataLength += 2 * elements);
        int dataOffset = super.getOffset();
        BinaryConverter.unsignedShortToByteArray(elements, data, dataOffset);
        BinaryConverter.unsignedShortToByteArray(2, data, dataOffset += 2);
        dataOffset += 2;
        for (index = 0; index < this.idList_.length && elements != 0; ++index) {
            if (this.idList_[index] == 0) continue;
            BinaryConverter.unsignedShortToByteArray(index, data, dataOffset);
            dataOffset += 2;
            --elements;
        }
        this.fDataOutOfDate_ = false;
    }

    private void updateList() {
        this.zeroIDList();
        byte[] data = super.getDataBuffer();
        if (data != null && data.length >= 4) {
            long dataLength = super.getDataLength();
            int offset = super.getOffset();
            if (dataLength > 4L) {
                int size;
                int elements = BinaryConverter.byteArrayToUnsignedShort(data, offset);
                offset += 2;
                if (elements != 0 && (size = BinaryConverter.byteArrayToUnsignedShort(data, offset)) == 2 && dataLength >= (long)((offset += 2) + elements * 2)) {
                    while (elements != 0) {
                        int ID = BinaryConverter.byteArrayToUnsignedShort(data, offset);
                        offset += 2;
                        --elements;
                        if (ID < 0 || ID >= this.idList_.length) continue;
                        this.idList_[ID] = 1;
                    }
                }
            }
        }
        this.fListOutOfDate_ = false;
    }

    private void zeroIDList() {
        int length = this.idList_.length;
        for (int index = 0; index < length; ++index) {
            this.idList_[index] = 0;
        }
    }
}

