/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class NPSystem
implements Runnable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int CONVERSATION_TIMEOUT = 300000;
    private static Hashtable NPSystemTable_ = new Hashtable();
    private AS400ImplRemote as400System_;
    private Vector availConversations_;
    private Vector inuseConversations_;
    private Vector deadConversations_;
    private Thread cleanupThread_;

    private NPSystem(AS400ImplRemote aSystem) {
        this.as400System_ = aSystem;
        this.availConversations_ = new Vector();
        this.inuseConversations_ = new Vector();
        this.deadConversations_ = new Vector();
    }

    static NPSystem getSystem(AS400ImplRemote aSystem) {
        NPSystem npSystem = null;
        npSystem = (NPSystem)NPSystemTable_.get(aSystem);
        if (npSystem == null) {
            npSystem = new NPSystem(aSystem);
            NPSystemTable_.put(aSystem, npSystem);
        }
        return npSystem;
    }

    synchronized NPConversation getConversation() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPConversation conversation = null;
        do {
            if (this.availConversations_.isEmpty()) {
                if (!this.deadConversations_.isEmpty()) {
                    conversation = (NPConversation)this.deadConversations_.firstElement();
                    this.deadConversations_.removeElement(conversation);
                } else {
                    AS400Server server;
                    if (this.inuseConversations_.isEmpty()) {
                        server = this.as400System_.getConnection(1, false, false);
                    } else {
                        server = this.as400System_.getConnection(1, true, false);
                        if (this.as400System_.isThreadUsed()) {
                            this.startCleanupThread();
                        }
                    }
                    conversation = new NPConversation(this.as400System_, server);
                }
            } else {
                conversation = (NPConversation)this.availConversations_.firstElement();
                this.availConversations_.removeElement(conversation);
            }
            if (conversation.getServer().isConnected()) continue;
            Trace.log(1, "Conversation was not connected.");
            this.as400System_.disconnectServer(conversation.getServer());
        } while (!conversation.getServer().isConnected());
        this.inuseConversations_.addElement(conversation);
        return conversation;
    }

    synchronized void returnConversation(NPConversation conversation) {
        int index = this.inuseConversations_.indexOf(conversation);
        if (index != -1) {
            this.inuseConversations_.removeElementAt(index);
            if (conversation.getServer().isConnected()) {
                if (this.as400System_.isThreadUsed()) {
                    this.availConversations_.addElement(conversation);
                } else if (this.availConversations_.size() < 1) {
                    this.availConversations_.addElement(conversation);
                } else {
                    this.as400System_.disconnectServer(conversation.getServer());
                }
            }
        }
    }

    int makeRequest(NPDataStream request, NPDataStream reply) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        int rc;
        NPConversation conversation = this.getConversation();
        try {
            try {
                rc = conversation.makeRequest(request, reply);
            }
            catch (RequestNotSupportedException e) {
                throw new ErrorCompletingRequestException(1);
            }
            Object var7_5 = null;
            this.returnConversation(conversation);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.returnConversation(conversation);
            throw throwable;
        }
        return rc;
    }

    private synchronized boolean cleanUpDeadConversations() {
        int numberOfConversationsToDestroy = this.deadConversations_.size() - 1;
        int activeConversations = this.inuseConversations_.size() + this.availConversations_.size();
        if (activeConversations > 0) {
            ++numberOfConversationsToDestroy;
        }
        Enumeration e = this.deadConversations_.elements();
        for (int i = 0; i < numberOfConversationsToDestroy; ++i) {
            NPConversation conv = (NPConversation)e.nextElement();
            if (conv == null) continue;
            this.as400System_.disconnectServer(conv.getServer());
        }
        if (e.hasMoreElements()) {
            this.availConversations_.addElement((NPConversation)e.nextElement());
        }
        this.deadConversations_ = this.availConversations_;
        this.availConversations_ = new Vector();
        return activeConversations > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                boolean fMoreConversations;
                do {
                    Thread.sleep(300000L);
                } while (fMoreConversations = this.cleanUpDeadConversations());
            }
            catch (InterruptedException interruptedException) {
                Object var3_4 = null;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            throw throwable;
        }
    }

    synchronized void startCleanupThread() {
        if (this.cleanupThread_ == null) {
            this.cleanupThread_ = new Thread(this);
            this.cleanupThread_.setDaemon(true);
            this.cleanupThread_.start();
        }
    }

    synchronized void stopCleanupThread() {
        if (this.cleanupThread_ != null) {
            this.cleanupThread_.stop();
            this.cleanupThread_ = null;
        }
    }
}

