/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.Trace;

class PoolMaintenance
extends Thread {
    private boolean run_ = false;
    private boolean stayAlive_ = true;
    private transient long lastRun_;
    private transient ConnectionPool pool_;
    private final Object waitLock_ = new Object();

    public PoolMaintenance(ConnectionPool pool) {
        super("AS400ConnectionPoolMaintenanceThread");
        this.setDaemon(true);
        this.pool_ = pool;
        this.lastRun_ = System.currentTimeMillis();
    }

    public long getLastTime() {
        return this.lastRun_;
    }

    public boolean isRunning() {
        return this.run_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (Trace.traceOn_) {
            Trace.log(3, "Connection pool maintenance daemon is started...");
        }
        this.run_ = true;
        try {
            while (this.stayAlive_) {
                if (this.run_) {
                    try {
                        Object object = this.waitLock_;
                        synchronized (object) {
                            this.waitLock_.wait(this.pool_.getCleanupInterval());
                        }
                    }
                    catch (InterruptedException ie) {
                        Trace.log(2, "Connection pool maintenance daemon failed.");
                    }
                    this.pool_.cleanupConnections();
                    this.lastRun_ = System.currentTimeMillis();
                    continue;
                }
                try {
                    Object ie = this.waitLock_;
                    synchronized (ie) {
                        this.waitLock_.wait();
                    }
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Connection pool maintenance daemon failed.");
                }
            }
            Object var5_6 = null;
            if (!Trace.traceOn_) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.traceOn_) throw throwable;
            Trace.log(3, "Connection pool maintenance daemon has ended.");
            throw throwable;
        }
        Trace.log(3, "Connection pool maintenance daemon has ended.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) {
        if (this.run_ != running) {
            Object object = this.waitLock_;
            synchronized (object) {
                this.run_ = running;
                this.waitLock_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.run_ = false;
        this.stayAlive_ = false;
        Object object = this.waitLock_;
        synchronized (object) {
            this.waitLock_.notify();
        }
    }
}

