/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinter;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterImpl;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class Printer
extends PrintObject
implements Serializable {
    static final long serialVersionUID = 4L;
    private static boolean fAttrIDsToRtvBuilt_ = false;
    private static final String NAME = "name";

    Printer(AS400 system, NPCPIDPrinter id, NPCPAttribute attrs) {
        super(system, id, attrs, 3);
    }

    public Printer() {
        super(null, null, 3);
    }

    public Printer(AS400 system, String printerName) {
        super(system, new NPCPIDPrinter(printerName), null, 3);
        this.checkPrinterName(printerName);
    }

    void checkPrinterName(String printerName) {
        if (printerName == null) {
            Trace.log(2, "Parameter 'printerName' is null.");
            throw new NullPointerException("printerName");
        }
        if (printerName.length() > 10 || printerName.length() < 1) {
            Trace.log(2, "Parameter 'printerName' is greater than 10 or less than 1 characters in length " + printerName);
            throw new ExtendedIllegalArgumentException("printerName(" + printerName + ")", 1);
        }
    }

    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Printer name has not been set.");
            throw new ExtendedIllegalStateException(NAME, 4);
        }
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use Printer before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrinterImpl)system.loadImpl2("com.ibm.as400.access.PrinterImplRemote", "com.ibm.as400.access.PrinterImplProxy");
        super.setImpl();
    }

    public String getName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(89);
    }

    public void setAttributes(PrintParameterList attributes) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (attributes == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((PrinterImpl)this.impl_).setAttributes(attributes);
        this.attrs = this.impl_.getAttrValue();
    }

    public void setName(String name) throws PropertyVetoException {
        this.checkPrinterName(name);
        String oldName = this.getName();
        this.vetos.fireVetoableChange(NAME, oldName, name);
        this.setIDCodePoint(new NPCPIDPrinter(name));
        this.changes.firePropertyChange(NAME, oldName, name);
    }
}

