/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCallCancelThread;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ProgramCall
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.ProgramCall";
    static final long serialVersionUID = 4L;
    private static final int UNSPECIFIED = 0;
    private static final int SPECIFIED_BY_PROPERTY = 1;
    private static final int SPECIFIED_BY_SETTER = 2;
    static final Boolean THREADSAFE_TRUE;
    static final Boolean THREADSAFE_FALSE;
    AS400 system_ = null;
    String program_ = "";
    Job job_ = null;
    String library_ = "";
    String name_ = "";
    ProgramParameter[] parameterList_ = new ProgramParameter[0];
    AS400Message[] messageList_ = new AS400Message[0];
    transient Boolean threadSafetyValue_ = THREADSAFE_FALSE;
    boolean threadSafety_ = false;
    private int threadSafetyDetermined_ = 0;
    int messageOption_ = 0;
    transient RemoteCommandImpl impl_ = null;
    transient Vector actionCompletedListeners_ = null;
    transient PropertyChangeSupport propertyChangeListeners_ = null;
    transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private int timeOut_ = 0;
    private boolean running_ = false;
    private boolean cancelling_ = false;
    private ProgramCallCancelThread cancelThread_;
    private Object cancelLock_ = new CancelLock();

    public void setTimeOut(int timeOut) {
        this.timeOut_ = timeOut;
    }

    public int getTimeout() {
        return this.timeOut_;
    }

    public boolean isRunning() {
        return this.running_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.cancelLock_;
        synchronized (object) {
            this.cancelling_ = true;
            if (Trace.traceOn_) {
                Trace.log(3, this, "Cancelling program " + this.getProgram());
            }
            try {
                Job job = new Job(new AS400(this.system_), this.job_.getName(), this.job_.getUser(), this.job_.getNumber());
                job.end(0);
            }
            catch (Exception e) {
                if (Trace.traceOn_) {
                    Trace.log(3, (Object)this, "Cancelling program " + this.getProgram(), (Throwable)e);
                }
            }
            finally {
                this.cancelling_ = false;
                this.cancelLock_.notifyAll();
            }
        }
    }

    private void startCancelThread() {
        if (this.timeOut_ != 0) {
            this.running_ = true;
            this.cancelThread_ = new ProgramCallCancelThread(this);
            this.cancelThread_.setDaemon(true);
            this.cancelThread_.start();
        }
    }

    private void endCancelThread() {
        if (this.timeOut_ != 0) {
            this.running_ = false;
            this.cancelThread_.programCall_ = null;
            this.cancelThread_.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancel() {
        Object object = this.cancelLock_;
        synchronized (object) {
            while (this.cancelling_) {
                try {
                    this.cancelLock_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public ProgramCall() {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Constructing ProgramCall object.");
        }
        this.checkThreadSafetyProperty();
    }

    public ProgramCall(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Constructing ProgramCall object, system: " + system);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
        this.checkThreadSafetyProperty();
    }

    public ProgramCall(AS400 system, String program, ProgramParameter[] parameterList) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Constructing ProgramCall object, system: " + system + " program: " + program);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
        this.checkThreadSafetyProperty();
        try {
            this.setProgram(program, parameterList);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, (Object)this, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionCompletedListener(ActionCompletedListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Adding action completed listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ProgramCall programCall = this;
        synchronized (programCall) {
            if (this.actionCompletedListeners_ == null) {
                this.actionCompletedListeners_ = new Vector();
            }
            this.actionCompletedListeners_.addElement(listener);
        }
    }

    public void addParameter(ProgramParameter parameter) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Adding parameter to parameter list.");
        }
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        int oldLength = this.parameterList_.length;
        ProgramParameter[] newParameterList = new ProgramParameter[oldLength + 1];
        System.arraycopy(this.parameterList_, 0, newParameterList, 0, oldLength);
        newParameterList[oldLength] = parameter;
        this.setParameterList(newParameterList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Adding property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ProgramCall programCall = this;
        synchronized (programCall) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Adding vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ProgramCall programCall = this;
        synchronized (programCall) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, this, "Attempt to connect to command server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (RemoteCommandImpl)this.system_.loadImpl3("com.ibm.as400.access.RemoteCommandImplNative", "com.ibm.as400.access.RemoteCommandImplRemote", "com.ibm.as400.access.RemoteCommandImplProxy");
            this.impl_.setSystem(this.system_.getImpl());
        }
    }

    void fireActionCompleted() {
        Vector targets = (Vector)this.actionCompletedListeners_.clone();
        ActionCompletedEvent event = new ActionCompletedEvent(this);
        for (int i = 0; i < targets.size(); ++i) {
            ActionCompletedListener target = (ActionCompletedListener)targets.elementAt(i);
            target.actionCompleted(event);
        }
    }

    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Getting message list.");
        }
        return this.messageList_;
    }

    public int getMessageOption() {
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Getting message option:", this.messageOption_);
        }
        return this.messageOption_;
    }

    public ProgramParameter[] getParameterList() {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Getting parameter list.");
        }
        return this.parameterList_;
    }

    public String getProgram() {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Getting program: " + this.program_);
        }
        return this.program_;
    }

    public Job getServerJob() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Getting job.");
        }
        this.chooseImpl();
        String jobInfo = this.impl_.getJobInfo(this.threadSafetyValue_);
        if (Trace.traceOn_) {
            Trace.log(1, this, "Constructing Job for job: " + jobInfo);
        }
        return new Job(this.system_, jobInfo.substring(0, 10).trim(), jobInfo.substring(10, 20).trim(), jobInfo.substring(20, 26).trim());
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public Thread getSystemThread() throws AS400SecurityException, IOException {
        Thread currentThread;
        if (Trace.traceOn_) {
            Trace.log(1, this, "Getting system thread.");
        }
        this.chooseImpl();
        Thread thread = currentThread = this.impl_.isNative() ? Thread.currentThread() : null;
        if (Trace.traceOn_) {
            Trace.log(1, this, "System thread: " + currentThread);
        }
        return currentThread;
    }

    static String getThreadSafetyProperty() {
        String val = SystemProperties.getProperty("com.ibm.as400.access.ProgramCall.threadSafe");
        return val == null || val.length() == 0 ? null : val.toLowerCase();
    }

    static Boolean getDefaultThreadSafety() {
        return new Boolean(ProgramCall.getThreadSafetyProperty());
    }

    private void checkThreadSafetyProperty() {
        String property = ProgramCall.getThreadSafetyProperty();
        if (property == null) {
            if (Trace.traceOn_) {
                Trace.log(1, this, "Thread safe system property not set, thread safety property remains unspecified.");
            }
        } else {
            this.threadSafetyValue_ = property.equals("true") ? THREADSAFE_TRUE : THREADSAFE_FALSE;
            this.threadSafety_ = THREADSAFE_TRUE.equals(this.threadSafetyValue_);
            this.threadSafetyDetermined_ = 1;
            if (Trace.traceOn_) {
                Trace.log(1, this, "Thread safe system property: " + property);
            }
        }
    }

    public boolean isStayOnThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        boolean isStayOnThread;
        if (Trace.traceOn_) {
            Trace.log(1, this, "Checking if program will actually get run on the current thread.");
        }
        this.chooseImpl();
        boolean bl = isStayOnThread = THREADSAFE_TRUE.equals(this.threadSafetyValue_) && this.impl_.isNative();
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Will program actually get run on the current thread:", isStayOnThread);
        }
        return isStayOnThread;
    }

    public boolean isThreadSafe() {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Checking if program will be assumed thread-safe.");
        }
        return this.threadSafetyValue_;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, this, "De-serializing ProgramCall object.");
        }
        in.defaultReadObject();
        if (this.cancelLock_ == null) {
            if (Trace.traceOn_) {
                Trace.log(1, this, "cancelLock is NULL, recreate it.");
            }
            this.cancelLock_ = new CancelLock();
        }
        if (this.threadSafetyDetermined_ == 2) {
            this.threadSafetyValue_ = this.threadSafety_ ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        } else {
            String property = ProgramCall.getThreadSafetyProperty();
            if (property == null) {
                this.threadSafetyValue_ = THREADSAFE_FALSE;
                this.threadSafetyDetermined_ = 0;
                if (Trace.traceOn_) {
                    Trace.log(1, this, "Thread safe system property not set, thread safety property changed to unspecified.");
                }
            } else {
                this.threadSafetyValue_ = property.equals("true") ? THREADSAFE_TRUE : THREADSAFE_FALSE;
                this.threadSafetyDetermined_ = 1;
                if (Trace.traceOn_) {
                    Trace.log(1, this, "Thread safe system property: " + property);
                }
            }
            this.threadSafety_ = THREADSAFE_TRUE.equals(this.threadSafetyValue_);
        }
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Removing action completed listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.actionCompletedListeners_ != null) {
            this.actionCompletedListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Removing property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Removing vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public boolean run() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String iasp;
        if (Trace.traceOn_) {
            Trace.log(3, this, "Running program: " + this.program_);
        }
        if (this.program_.length() == 0) {
            Trace.log(2, this, "Attempt to run before setting program.");
            throw new ExtendedIllegalStateException("program", 4);
        }
        String prg = this.program_.toUpperCase();
        if (!prg.startsWith("/QSYS.LIB") && !this.system_.aspName.equalsIgnoreCase(iasp = prg.substring(1, prg.indexOf("/QSYS.LIB")))) {
            try {
                String currentASP;
                String SetASPGrp = "SETASPGRP ASPGRP(" + iasp + ") CURLIB(*CURUSR) USRLIBL(*CURUSR)";
                CommandCall commandCall = new CommandCall(this.system_);
                Job job = commandCall.getServerJob();
                this.system_.aspName = currentASP = job.getJobAsp();
                if (currentASP != null && !currentASP.equalsIgnoreCase(iasp)) {
                    Trace.log(1, "ProgramCall call command of setaspgrp " + SetASPGrp);
                    if (!commandCall.run(SetASPGrp)) {
                        Trace.log(2, this, "Command SETASPGRP Failed with iasp " + iasp);
                    } else {
                        this.system_.aspName = iasp;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.parameterList_.length; ++i) {
            if (this.parameterList_[i] != null) continue;
            throw new ExtendedIllegalArgumentException("parameterList[" + i + "] (" + this.parameterList_[i] + ")", 2);
        }
        this.chooseImpl();
        try {
            boolean result;
            if (this.impl_ instanceof RemoteCommandImplRemote) {
                this.job_ = this.getServerJob();
                this.checkCancel();
                this.startCancelThread();
                result = this.impl_.runProgram(this.library_, this.name_, this.parameterList_, this.threadSafetyValue_, this.messageOption_);
                this.endCancelThread();
            } else {
                result = this.impl_.runProgram(this.library_, this.name_, this.parameterList_, this.threadSafetyValue_, this.messageOption_);
            }
            this.messageList_ = this.impl_.getMessageList();
            if (this.system_ != null) {
                for (int i = 0; i < this.messageList_.length; ++i) {
                    this.messageList_[i].setSystem(this.system_);
                }
            }
            if (this.actionCompletedListeners_ != null) {
                this.fireActionCompleted();
            }
            return result;
        }
        catch (ObjectDoesNotExistException e) {
            this.messageList_ = this.impl_.getMessageList();
            if (this.system_ != null) {
                for (int i = 0; i < this.messageList_.length; ++i) {
                    this.messageList_[i].setSystem(this.system_);
                }
            }
            throw e;
        }
    }

    public boolean run(String program, ProgramParameter[] parameterList) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        this.setProgram(program, parameterList);
        return this.run();
    }

    public void setParameterList(ProgramParameter[] parameterList) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Setting parameter list.");
        }
        if (parameterList == null) {
            throw new NullPointerException("parameterList");
        }
        boolean isSupport255 = false;
        try {
            isSupport255 = this.system_.getVRM() >= 459008;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isSupport255 && parameterList.length > 255) {
            Trace.log(2, (Object)this, "Parameter list length exceeds limit of 255 parameters:", parameterList.length);
            throw new ExtendedIllegalArgumentException("parameterList.length (" + parameterList.length + ")", 1);
        }
        if (!isSupport255 && parameterList.length > 35) {
            Trace.log(2, (Object)this, "Parameter list length exceeds limit of 35 parameters:", parameterList.length);
            throw new ExtendedIllegalArgumentException("parameterList.length (" + parameterList.length + ")", 1);
        }
        ProgramParameter[] oldValue = this.parameterList_;
        ProgramParameter[] newValue = parameterList;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("parameterList", oldValue, newValue);
        }
        this.parameterList_ = newValue;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("parameterList", oldValue, newValue);
        }
    }

    public void setProgram(String program, ProgramParameter[] parameterList) throws PropertyVetoException {
        this.setProgram(program);
        this.setParameterList(parameterList);
    }

    public void setProgram(String program) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Setting program: " + program);
        }
        if (program == null) {
            throw new NullPointerException("program");
        }
        if (Trace.traceOn_ && program.length() == 0) {
            Trace.log(4, this, "Parameter 'program' is has length of 0.");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(program, "PGM");
        String oldValue = this.program_;
        String newValue = program;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("program", oldValue, newValue);
        }
        this.library_ = ifs.getLibraryName();
        this.name_ = ifs.getObjectName();
        this.program_ = newValue;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("program", oldValue, newValue);
        }
    }

    public void setMessageOption(int messageOption) {
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Setting message option:", messageOption);
        }
        if (messageOption < 0 || messageOption > 2) {
            throw new ExtendedIllegalArgumentException("messageOption (" + messageOption + ")", 2);
        }
        this.messageOption_ = messageOption;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, this, "Setting system: " + system);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, this, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldValue = this.system_;
        AS400 newValue = system;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
        }
        this.system_ = newValue;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
        }
    }

    public void setThreadSafe(boolean threadSafe) {
        Boolean newValue;
        if (Trace.traceOn_) {
            Trace.log(1, this, "Setting thread safe: " + threadSafe);
        }
        Boolean bl = newValue = threadSafe ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        if (this.propertyChangeListeners_ != null) {
            Boolean oldValue = this.threadSafetyValue_;
            this.propertyChangeListeners_.firePropertyChange("threadSafe", oldValue, newValue);
        }
        this.threadSafetyValue_ = newValue;
        this.threadSafety_ = threadSafe;
        this.threadSafetyDetermined_ = 2;
    }

    public void suggestThreadsafe() {
        if (ProgramCall.getThreadSafetyProperty() == null) {
            this.setThreadSafe(true);
        }
    }

    public String toString() {
        return "ProgramCall (system: " + this.system_ + " program: " + this.program_ + "):" + super.toString();
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        THREADSAFE_TRUE = CommandCall.THREADSAFE_TRUE;
        THREADSAFE_FALSE = CommandCall.THREADSAFE_FALSE;
    }

    private class CancelLock
    implements Serializable {
        static final long serialVersionUID = 4L;

        private CancelLock() {
        }
    }
}

