/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class QSYSPermission
extends UserPermission {
    static final long serialVersionUID = 4L;

    public QSYSPermission(String userProfileName) {
        super(userProfileName);
        this.dataAuthority_ = "*EXCLUDE";
        this.objectAuthority_ = 1;
        this.authorities_ = new boolean[10];
        for (int i = 0; i < 10; ++i) {
            this.authorities_[i] = false;
        }
    }

    static String adjustLength(String s, int desiredLength) {
        int sLength;
        if (s == null) {
            s = "";
        }
        if ((sLength = s.length()) == desiredLength) {
            return s;
        }
        if (sLength < desiredLength) {
            StringBuffer buffer = new StringBuffer(s);
            for (int i = sLength; i < desiredLength; ++i) {
                buffer.append(' ');
            }
            return buffer.toString();
        }
        return s.substring(0, desiredLength);
    }

    String getAuthorities(boolean objectIsAuthList) {
        String authority = "";
        if (this.isManagement()) {
            authority = authority + "*OBJMGT ";
        }
        if (this.isExistence()) {
            authority = authority + "*OBJEXIST ";
        }
        if (this.isAlter()) {
            authority = authority + "*OBJALTER ";
        }
        if (this.isReference()) {
            authority = authority + "*OBJREF ";
        }
        if (this.isOperational()) {
            authority = authority + "*OBJOPR ";
        }
        if (this.isAdd()) {
            authority = authority + "*ADD ";
        }
        if (this.isDelete()) {
            authority = authority + "*DLT ";
        }
        if (this.isRead()) {
            authority = authority + "*READ ";
        }
        if (this.isUpdate()) {
            authority = authority + "*UPD ";
        }
        if (this.isExecute()) {
            authority = authority + "*EXECUTE ";
        }
        if (objectIsAuthList && this.isAuthorizationListManagement()) {
            authority = authority + "*AUTLMGT";
        }
        if (authority.equals("")) {
            authority = "*EXCLUDE";
        }
        return authority;
    }

    public String getObjectAuthority() {
        this.parseBasic();
        if (this.isFromAuthorizationList()) {
            return "*AUTL";
        }
        switch (this.objectAuthority_) {
            case 0: {
                return "*ALL";
            }
            case 1: {
                return "*EXCLUDE";
            }
            case 2: {
                return "*USE";
            }
            case 3: {
                return "*CHANGE";
            }
        }
        return "USER DEFINED";
    }

    public static boolean hasObjectAuthorities(AS400 system, String userProfileName, String objectPath, String[] authorityList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (userProfileName == null) {
            throw new NullPointerException("userProfileName");
        }
        if (objectPath == null) {
            throw new NullPointerException("objectPath");
        }
        if (authorityList == null) {
            throw new NullPointerException("authorityList");
        }
        if (authorityList.length == 0) {
            Trace.log(2, "No authorities were specified.");
            throw new ExtendedIllegalArgumentException("authorityList", 1);
        }
        boolean rcStatus = true;
        String program = "/QSYS.LIB/QSYCUSRA.PGM";
        String profile = QSYSPermission.adjustLength(userProfileName, 10);
        QSYSObjectPathName qsysObjPath = new QSYSObjectPathName(objectPath);
        String attribute = "*" + QSYSPermission.adjustLength(qsysObjPath.getObjectType(), 9);
        String qualObj = QSYSPermission.adjustLength(qsysObjPath.getObjectName(), 10) + QSYSPermission.adjustLength(qsysObjPath.getLibraryName(), 10);
        StringBuffer authorities = new StringBuffer();
        for (int i = 0; i < authorityList.length; ++i) {
            authorities.append(QSYSPermission.adjustLength(authorityList[i], 10));
        }
        try {
            ProgramCall newCall = new ProgramCall(system);
            ProgramParameter[] paramList = new ProgramParameter[8];
            paramList[0] = new ProgramParameter(1);
            paramList[0].setParameterType(2);
            paramList[1] = new ProgramParameter(CharConverter.stringToByteArray(system, profile));
            paramList[2] = new ProgramParameter(CharConverter.stringToByteArray(system, qualObj));
            paramList[3] = new ProgramParameter(CharConverter.stringToByteArray(system, attribute));
            paramList[4] = new ProgramParameter(CharConverter.stringToByteArray(system, authorities.toString()));
            paramList[5] = new ProgramParameter(BinaryConverter.intToByteArray(authorityList.length));
            paramList[6] = new ProgramParameter(BinaryConverter.intToByteArray(1));
            byte[] parmByt7 = new byte[16];
            System.arraycopy(BinaryConverter.intToByteArray(16), 0, parmByt7, 0, 4);
            paramList[7] = new ProgramParameter(parmByt7, 16);
            paramList[7].setParameterType(2);
            newCall.setProgram(program, paramList);
            if (!newCall.run()) {
                AS400Message[] msgList = newCall.getMessageList();
                throw new AS400Exception(msgList);
            }
            byte[] errCode = paramList[7].getOutputData();
            if (BinaryConverter.byteArrayToInt(errCode, 4) > 0) {
                byte[] message = new byte[7];
                System.arraycopy(errCode, 8, message, 0, 7);
                String msgId = CharConverter.byteArrayToString(system, message);
                Trace.log(2, "Error code from QSYCUSRA: " + msgId);
                throw new AS400Exception(new AS400Message(msgId, ""));
            }
            String output = CharConverter.byteArrayToString(system, paramList[0].getOutputData());
            if (!output.startsWith("Y")) {
                rcStatus = false;
            }
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e.toString());
        }
        return rcStatus;
    }

    public boolean isAdd() {
        return this.authorities_[6];
    }

    public boolean isAlter() {
        return this.authorities_[3];
    }

    public boolean isDelete() {
        return this.authorities_[8];
    }

    public boolean isExecute() {
        return this.authorities_[9];
    }

    public boolean isExistence() {
        return this.authorities_[2];
    }

    public boolean isManagement() {
        return this.authorities_[1];
    }

    public boolean isOperational() {
        return this.authorities_[0];
    }

    public boolean isRead() {
        return this.authorities_[5];
    }

    public boolean isReference() {
        return this.authorities_[4];
    }

    public boolean isUpdate() {
        return this.authorities_[7];
    }

    private synchronized void parseBasic() {
        for (int j = 0; j < 4; ++j) {
            boolean match = true;
            for (int i = 0; i < 10; ++i) {
                if (this.authorities_[i] == basicAutMapping[j][i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            this.objectAuthority_ = j;
            return;
        }
        this.objectAuthority_ = -1;
    }

    public synchronized void setAdd(boolean authority) {
        this.changeAuthority();
        this.authorities_[6] = authority;
    }

    public synchronized void setAlter(boolean authority) {
        this.changeAuthority();
        this.authorities_[3] = authority;
    }

    public synchronized void setDelete(boolean authority) {
        this.changeAuthority();
        this.authorities_[8] = authority;
    }

    public synchronized void setExecute(boolean authority) {
        this.changeAuthority();
        this.authorities_[9] = authority;
    }

    public synchronized void setExistence(boolean authority) {
        this.changeAuthority();
        this.authorities_[2] = authority;
    }

    public synchronized void setManagement(boolean authority) {
        this.changeAuthority();
        this.authorities_[1] = authority;
    }

    public synchronized void setObjectAuthority(String authority) {
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        String aut = authority.trim().toUpperCase();
        this.changeAuthority();
        if (this.getObjectAuthority().equals(aut)) {
            return;
        }
        if (aut.equals("*ALL")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[0][i];
            }
            this.objectAuthority_ = 0;
        } else if (aut.equals("*EXCLUDE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[1][i];
            }
            this.objectAuthority_ = 1;
        } else if (aut.equals("*USE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[2][i];
            }
            this.objectAuthority_ = 2;
        } else if (aut.equals("*CHANGE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[3][i];
            }
            this.objectAuthority_ = 3;
        } else if (aut.equals("*AUTL")) {
            this.setFromAuthorizationList(true);
        } else {
            Trace.log(2, "Invalid object authority was specified: " + authority);
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
    }

    public synchronized void setOperational(boolean authority) {
        this.changeAuthority();
        this.authorities_[0] = authority;
    }

    public synchronized void setRead(boolean authority) {
        this.changeAuthority();
        this.authorities_[5] = authority;
    }

    public synchronized void setReference(boolean authority) {
        this.changeAuthority();
        this.authorities_[4] = authority;
    }

    public synchronized void setUpdate(boolean authority) {
        this.changeAuthority();
        this.authorities_[7] = authority;
    }
}

