/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordDescriptionEvent;
import com.ibm.as400.access.RecordDescriptionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class RecordFormat
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int FIXED_LAYOUT_LENGTH = 1;
    public static final int VARIABLE_LAYOUT_LENGTH = 2;
    private char delimiter_;
    private Vector fieldDescriptions_ = new Vector();
    private Hashtable fieldNameToIndexMap_ = new Hashtable();
    private boolean hasDependentFields_;
    private Vector keyFieldDescriptions_ = new Vector();
    private Hashtable keyFieldNameToIndexMap_ = new Hashtable();
    private Vector lengthDependentFields_ = new Vector();
    private String name_ = "";
    private static final Integer NOT_DEPENDENT_ = new Integer(-1);
    private Vector offsetDependentFields_ = new Vector();
    private int recordFormatType_;
    private String recordFormatID_ = "";
    private transient PropertyChangeSupport changes_;
    private transient Vector rdListeners_;
    private transient VetoableChangeSupport vetos_;

    public RecordFormat() {
        this.initializeTransient();
    }

    public RecordFormat(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name_ = name.toUpperCase();
        this.initializeTransient();
    }

    public void addFieldDescription(FieldDescription field) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        this.fieldNameToIndexMap_.put(field.getFieldName(), new Integer(this.fieldDescriptions_.size()));
        this.fieldDescriptions_.addElement(field);
        this.lengthDependentFields_.addElement(NOT_DEPENDENT_);
        this.offsetDependentFields_.addElement(NOT_DEPENDENT_);
        this.fireEvent(1);
    }

    public void addKeyFieldDescription(int index) {
        if (index < 0 || index > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        FieldDescription f = (FieldDescription)this.fieldDescriptions_.elementAt(index);
        this.keyFieldNameToIndexMap_.put(f.getFieldName(), new Integer(this.keyFieldDescriptions_.size()));
        this.keyFieldDescriptions_.addElement(f);
        this.fireEvent(2);
    }

    public void addKeyFieldDescription(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.equals("*NONE")) {
            this.addKeyFieldDescription(this.getIndexOfFieldName(name));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addRecordDescriptionListener(RecordDescriptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rdListeners_ == null) {
            this.rdListeners_ = new Vector();
        }
        this.rdListeners_.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void fireEvent(int index) {
        if (this.rdListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.rdListeners_.clone();
        RecordDescriptionEvent event = new RecordDescriptionEvent(this, index);
        block4: for (int i = 0; i < targets.size(); ++i) {
            RecordDescriptionListener target = (RecordDescriptionListener)targets.elementAt(i);
            switch (index) {
                case 1: {
                    target.fieldDescriptionAdded(event);
                    continue block4;
                }
                case 2: {
                    target.keyFieldDescriptionAdded(event);
                    continue block4;
                }
            }
        }
    }

    public char getDelimiter() {
        return this.delimiter_;
    }

    public FieldDescription getFieldDescription(int index) {
        if (index < 0 || index > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (FieldDescription)this.fieldDescriptions_.elementAt(index);
    }

    public FieldDescription getFieldDescription(String name) {
        return (FieldDescription)this.fieldDescriptions_.elementAt(this.getIndexOfFieldName(name));
    }

    public FieldDescription[] getFieldDescriptions() {
        Object[] fds = new FieldDescription[this.fieldDescriptions_.size()];
        this.fieldDescriptions_.copyInto(fds);
        return fds;
    }

    public String[] getFieldNames() {
        int size = this.fieldDescriptions_.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = ((FieldDescription)this.fieldDescriptions_.elementAt(i)).getFieldName();
        }
        return names;
    }

    boolean getHasDependentFields() {
        return this.hasDependentFields_;
    }

    public int getIndexOfFieldName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Integer i = (Integer)this.fieldNameToIndexMap_.get(name);
        if (i == null) {
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 5);
        }
        return i;
    }

    public int getIndexOfKeyFieldName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Integer i = (Integer)this.keyFieldNameToIndexMap_.get(name);
        if (i == null) {
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 5);
        }
        return i;
    }

    public FieldDescription getKeyFieldDescription(int index) {
        if (index < 0 || index > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (FieldDescription)this.keyFieldDescriptions_.elementAt(index);
    }

    public FieldDescription getKeyFieldDescription(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return (FieldDescription)this.keyFieldDescriptions_.elementAt(this.getIndexOfKeyFieldName(name));
    }

    public FieldDescription[] getKeyFieldDescriptions() {
        Object[] fds = new FieldDescription[this.keyFieldDescriptions_.size()];
        this.keyFieldDescriptions_.copyInto(fds);
        return fds;
    }

    public String[] getKeyFieldNames() {
        int size = this.keyFieldDescriptions_.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = ((FieldDescription)this.keyFieldDescriptions_.elementAt(i)).getFieldName();
        }
        return names;
    }

    public int getLengthDependency(int index) {
        if (index < 0 || index > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (Integer)this.lengthDependentFields_.elementAt(index);
    }

    public int getLengthDependency(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return (Integer)this.lengthDependentFields_.elementAt(this.getIndexOfFieldName(name));
    }

    public String getName() {
        return this.name_;
    }

    public Record getNewRecord() {
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this);
    }

    public Record getNewRecord(String recordName) {
        if (recordName == null) {
            throw new NullPointerException("recordName");
        }
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this, recordName);
    }

    public Record getNewRecord(byte[] contents) throws UnsupportedEncodingException {
        return this.getNewRecord(contents, 0);
    }

    public Record getNewRecord(byte[] contents, String recordName) throws UnsupportedEncodingException {
        return this.getNewRecord(contents, 0, recordName);
    }

    public Record getNewRecord(byte[] contents, int offset) throws UnsupportedEncodingException {
        if (contents == null) {
            throw new NullPointerException("contents");
        }
        if (contents.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (offset < 0) {
            throw new ExtendedIllegalArgumentException("offset", 2);
        }
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this, contents, offset);
    }

    public Record getNewRecord(byte[] contents, int offset, String recordName) throws UnsupportedEncodingException {
        if (contents == null) {
            throw new NullPointerException("contents");
        }
        if (contents.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (offset < 0) {
            throw new ExtendedIllegalArgumentException("offset", 2);
        }
        if (recordName == null) {
            throw new NullPointerException("recordName");
        }
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this, contents, offset, recordName);
    }

    public int getNumberOfFields() {
        return this.fieldDescriptions_.size();
    }

    public int getNumberOfKeyFields() {
        return this.keyFieldDescriptions_.size();
    }

    public int getOffsetDependency(int index) {
        if (index < 0 || index > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (Integer)this.offsetDependentFields_.elementAt(index);
    }

    public int getOffsetDependency(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return (Integer)this.offsetDependentFields_.elementAt(this.getIndexOfFieldName(name));
    }

    public String getRecordFormatID() {
        return this.recordFormatID_;
    }

    public int getRecordFormatType() {
        return this.recordFormatType_;
    }

    void initializeTextObjects(AS400 system) {
        for (int i = 0; i < this.fieldDescriptions_.size(); ++i) {
            AS400DataType dt = ((FieldDescription)this.fieldDescriptions_.elementAt((int)i)).dataType_;
            if (dt.getInstanceType() != 9) continue;
            ((AS400Text)dt).setConverter(system);
        }
    }

    private void initializeTransient() {
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeRecordDescriptionListener(RecordDescriptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rdListeners_ != null) {
            this.rdListeners_.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setDelimiter(char delimiter) {
        this.delimiter_ = delimiter;
    }

    public void setLengthDependency(int dependentField, int fieldDependedOn) {
        if (dependentField < 0) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (dependentField > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (fieldDependedOn < 0) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 4);
        }
        if (dependentField > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (fieldDependedOn >= dependentField) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 2);
        }
        this.lengthDependentFields_.setElementAt(new Integer(fieldDependedOn), dependentField);
        this.hasDependentFields_ = true;
    }

    public void setLengthDependency(String dependentField, String fieldDependedOn) {
        if (dependentField == null) {
            throw new NullPointerException("dependentField");
        }
        if (fieldDependedOn == null) {
            throw new NullPointerException("fieldDependedOn");
        }
        int depOnIndex = this.getIndexOfFieldName(fieldDependedOn);
        int depIndex = this.getIndexOfFieldName(dependentField);
        this.setLengthDependency(depIndex, depOnIndex);
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", old, name.toUpperCase());
        }
        this.name_ = name.toUpperCase();
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, this.name_);
        }
    }

    public void setOffsetDependency(int dependentField, int fieldDependedOn) {
        if (dependentField < 0) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (fieldDependedOn < 0) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 4);
        }
        if (dependentField > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (fieldDependedOn >= dependentField) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 2);
        }
        this.offsetDependentFields_.setElementAt(new Integer(fieldDependedOn), dependentField);
        this.hasDependentFields_ = true;
    }

    public void setOffsetDependency(String dependentField, String fieldDependedOn) {
        if (dependentField == null) {
            throw new NullPointerException("dependentField");
        }
        if (fieldDependedOn == null) {
            throw new NullPointerException("fieldDependedOn");
        }
        int depOnIndex = this.getIndexOfFieldName(fieldDependedOn);
        int depIndex = this.getIndexOfFieldName(dependentField);
        this.setOffsetDependency(depIndex, depOnIndex);
    }

    public void setRecordFormatID(String id) {
        String pad = "          ";
        if (id.length() > 10) {
            throw new ExtendedIllegalArgumentException("id", 1);
        }
        if (id.length() < 10) {
            int padl = 10 - id.length();
            this.recordFormatID_ = id + pad.substring(0, padl);
        } else {
            this.recordFormatID_ = id;
        }
    }

    public void setRecordFormatType(int type) {
        if (type != 2 && type != 1) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        this.recordFormatType_ = type;
    }
}

