/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBinary
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int maxLength_;
    private AS400ByteArray typeConverter_;
    private byte[] value_;

    SQLBinary(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.typeConverter_ = new AS400ByteArray(maxLength);
        this.value_ = new byte[maxLength];
    }

    public Object clone() {
        return new SQLBinary(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.value_ = (byte[])this.typeConverter_.toObject(rawBytes, offset);
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        this.typeConverter_.toBytes(this.value_, rawBytes, offset);
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            InputStream stream;
            int length = scale;
            if (length >= 0) {
                stream = (InputStream)object;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int blockSize = length < 1000000 ? length : 1000000;
                byte[] byteBuffer = new byte[blockSize];
                try {
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1 && totalBytesRead < length) {
                        baos.write(byteBuffer, 0, bytesRead);
                        int bytesRemaining = length - (totalBytesRead += bytesRead);
                        if (bytesRemaining < blockSize) {
                            blockSize = bytesRemaining;
                        }
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                }
                catch (IOException ie) {
                    JDError.throwSQLException((Object)this, "HY000", ie);
                }
                this.value_ = baos.toByteArray();
                if (this.value_.length < length) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (length == -2 || length == -1) {
                stream = (InputStream)object;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int blockSize = 1000000;
                byte[] byteBuffer = new byte[blockSize];
                try {
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1) {
                        baos.write(byteBuffer, 0, bytesRead);
                        totalBytesRead += bytesRead;
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                }
                catch (IOException ie) {
                    JDError.throwSQLException((Object)this, "HY000", ie);
                }
                this.value_ = baos.toByteArray();
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Reader) {
            int length = scale;
            if (length >= 0) {
                try {
                    int blockSize = length < 1000000 ? length : 1000000;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    HexReaderInputStream stream = new HexReaderInputStream((Reader)object);
                    byte[] byteBuffer = new byte[blockSize];
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1 && totalBytesRead < length) {
                        baos.write(byteBuffer, 0, bytesRead);
                        int bytesRemaining = length - (totalBytesRead += bytesRead);
                        if (bytesRemaining < blockSize) {
                            blockSize = bytesRemaining;
                        }
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                    this.value_ = baos.toByteArray();
                    if (this.value_.length < length) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    stream.close();
                }
                catch (ExtendedIOException eie) {
                    JDError.throwSQLException((Object)this, "07006", eie);
                }
                catch (IOException ie) {
                    JDError.throwSQLException((Object)this, "HY000", ie);
                }
            } else if (length == -2 || length == -1) {
                try {
                    int blockSize = 1000000;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    HexReaderInputStream stream = new HexReaderInputStream((Reader)object);
                    byte[] byteBuffer = new byte[blockSize];
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1) {
                        baos.write(byteBuffer, 0, bytesRead);
                        totalBytesRead += bytesRead;
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                    this.value_ = baos.toByteArray();
                    stream.close();
                }
                catch (ExtendedIOException eie) {
                    JDError.throwSQLException((Object)this, "07006", eie);
                }
                catch (IOException ie) {
                    JDError.throwSQLException((Object)this, "HY000", ie);
                }
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int valueLength = this.value_.length;
        if (valueLength < this.maxLength_) {
            byte[] newValue = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, newValue, 0, valueLength);
            this.value_ = newValue;
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (valueLength > this.maxLength_) {
            byte[] newValue = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
            this.value_ = newValue;
            this.truncated_ = valueLength - this.maxLength_;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
    }

    public int getSQLType() {
        return 2;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getLiteralPrefix() {
        return "BINARY(X'";
    }

    public String getLiteralSuffix() {
        return "')";
    }

    public String getLocalName() {
        return "BINARY";
    }

    public int getMaximumPrecision() {
        return 32765;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 912;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -2;
    }

    public String getTypeName() {
        return "BINARY";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public String getJavaClassName() {
        return "[B";
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public Blob getBlob() throws SQLException {
        return new AS400JDBCBlob(this.getBytes(), this.maxLength_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() {
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length > maxFieldSize && maxFieldSize > 0) {
            byte[] truncatedValue = new byte[maxFieldSize];
            System.arraycopy(this.value_, 0, truncatedValue, 0, maxFieldSize);
            return truncatedValue;
        }
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        return new AS400JDBCClob(BinaryConverter.bytesToHexString(this.getBytes()), this.maxLength_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public NClob getNClob() throws SQLException {
        return new AS400JDBCNClob(BinaryConverter.bytesToHexString(this.getBytes()), this.maxLength_);
    }

    public String getNString() throws SQLException {
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

