/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class SQLDataBase
implements SQLData {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    protected int truncated_;
    protected boolean outOfBounds_;
    protected SQLConversionSettings settings_;
    Object savedValue_ = null;

    public SQLDataBase(SQLConversionSettings settings) {
        this.settings_ = settings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
    }

    public abstract Object clone();

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    public abstract void convertFromRawBytes(byte[] var1, int var2, ConvTable var3, boolean var4) throws SQLException;

    public abstract void convertToRawBytes(byte[] var1, int var2, ConvTable var3) throws SQLException;

    public abstract void set(Object var1, Calendar var2, int var3) throws SQLException;

    public abstract int getSQLType();

    public abstract String getCreateParameters();

    public abstract int getDisplaySize();

    public abstract String getJavaClassName();

    public abstract String getLiteralPrefix();

    public abstract String getLiteralSuffix();

    public abstract String getLocalName();

    public abstract int getMaximumPrecision();

    public abstract int getMaximumScale();

    public abstract int getMinimumScale();

    public abstract int getNativeType();

    public abstract int getPrecision();

    public abstract int getRadix();

    public abstract int getScale();

    public abstract int getType();

    public abstract String getTypeName();

    public abstract boolean isSigned();

    public abstract boolean isText();

    public abstract int getActualSize();

    public abstract int getTruncated();

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public abstract boolean getOutOfBounds();

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.getString()));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        try {
            BigDecimal bigDecimal = new BigDecimal(SQLDataFactory.convertScientificNotation(this.getString().trim(), this.settings_));
            if (scale >= 0) {
                if (scale >= bigDecimal.scale()) {
                    this.truncated_ = 0;
                    this.outOfBounds_ = false;
                    return bigDecimal.setScale(scale);
                }
                this.truncated_ = bigDecimal.scale() - scale;
                this.outOfBounds_ = false;
                return bigDecimal.setScale(scale, 4);
            }
            return bigDecimal;
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return null;
        }
    }

    public abstract InputStream getBinaryStream() throws SQLException;

    public abstract Blob getBlob() throws SQLException;

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String trimmedValue = this.getString().trim();
        return trimmedValue.length() > 0 && !trimmedValue.equalsIgnoreCase("false") && !trimmedValue.equals("0");
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double doubleValue = new Double(this.getString().trim());
            double d = doubleValue;
            if (d > 127.0 || d < -128.0) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return doubleValue.byteValue();
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1;
        }
    }

    public abstract byte[] getBytes() throws SQLException;

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getString());
    }

    public Clob getClob() throws SQLException {
        String string = this.getString();
        return new AS400JDBCClob(string);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        return SQLDate.stringToDate(this.getString(), this.settings_, calendar);
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new Double(this.getString().trim());
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1.0;
        }
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new Double(this.getString().trim()).floatValue();
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1.0f;
        }
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double doubleValue = new Double(this.getString().trim());
            double d = doubleValue;
            if (d > 2.147483647E9 || d < -2.147483648E9) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return doubleValue.intValue();
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1;
        }
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double doubleValue = new Double(this.getString().trim());
            double d = doubleValue;
            if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return doubleValue.longValue();
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1L;
        }
    }

    public abstract Object getObject() throws SQLException;

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double doubleValue = new Double(this.getString().trim());
            double d = doubleValue;
            if (d > 32767.0 || d < -32768.0) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return doubleValue.shortValue();
        }
        catch (NumberFormatException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return -1;
        }
    }

    public abstract String getString() throws SQLException;

    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        return SQLTime.stringToTime(this.getString(), this.settings_, calendar);
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        return SQLTimestamp.stringToTimestamp(this.getString(), calendar);
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ReaderInputStream((Reader)new StringReader(this.getString()), 13488);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(this.getNString());
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = this.getNString();
        return new AS400JDBCNClob(string, string.length());
    }

    public String getNString() throws SQLException {
        return this.getString();
    }

    public abstract SQLXML getSQLXML() throws SQLException;

    public abstract RowId getRowId() throws SQLException;

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings settings) {
        this.settings_ = settings;
    }

    static String getStringFromReader(Reader stream, int length, Object exceptionObject) throws SQLException {
        String value = null;
        if (length >= 0) {
            try {
                int blockSize = length < 1000000 ? length : 1000000;
                StringBuffer buf = new StringBuffer();
                char[] charBuffer = new char[blockSize];
                int totalCharsRead = 0;
                int charsRead = stream.read(charBuffer, 0, blockSize);
                while (charsRead > -1 && totalCharsRead < length) {
                    buf.append(charBuffer, 0, charsRead);
                    int charsRemaining = length - (totalCharsRead += charsRead);
                    if (charsRemaining < blockSize) {
                        blockSize = charsRemaining;
                    }
                    charsRead = stream.read(charBuffer, 0, blockSize);
                }
                value = buf.toString();
                if (value.length() < length) {
                    JDError.throwSQLException(exceptionObject, "07006");
                }
            }
            catch (IOException ie) {
                JDError.throwSQLException(exceptionObject, "HY000", ie);
            }
        } else if (length == -2) {
            try {
                int blockSize = 1000000;
                StringBuffer buf = new StringBuffer();
                char[] charBuffer = new char[blockSize];
                int charsRead = stream.read(charBuffer, 0, blockSize);
                while (charsRead > -1) {
                    buf.append(charBuffer, 0, charsRead);
                    charsRead = stream.read(charBuffer, 0, blockSize);
                }
                value = buf.toString();
            }
            catch (IOException ie) {
                JDError.throwSQLException(exceptionObject, "HY000", ie);
            }
        } else {
            JDError.throwSQLException(exceptionObject, "07006");
        }
        return value;
    }

    static byte[] getBytesFromInputStream(InputStream object, int length, Object exceptionObject) throws SQLException {
        byte[] value = null;
        if (length >= 0) {
            InputStream stream = object;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int blockSize = length < 1000000 ? length : 1000000;
            byte[] byteBuffer = new byte[blockSize];
            try {
                int totalBytesRead = 0;
                int bytesRead = stream.read(byteBuffer, 0, blockSize);
                while (bytesRead > -1 && totalBytesRead < length) {
                    baos.write(byteBuffer, 0, bytesRead);
                    int bytesRemaining = length - (totalBytesRead += bytesRead);
                    if (bytesRemaining < blockSize) {
                        blockSize = bytesRemaining;
                    }
                    bytesRead = stream.read(byteBuffer, 0, blockSize);
                }
            }
            catch (IOException ie) {
                JDError.throwSQLException(exceptionObject, "HY000", ie);
            }
            value = baos.toByteArray();
            if (value.length < length) {
                JDError.throwSQLException(exceptionObject, "07006");
            }
        } else if (length == -2) {
            InputStream stream = object;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int blockSize = 1000000;
            byte[] byteBuffer = new byte[blockSize];
            try {
                int totalBytesRead = 0;
                int bytesRead = stream.read(byteBuffer, 0, blockSize);
                while (bytesRead > -1) {
                    baos.write(byteBuffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    bytesRead = stream.read(byteBuffer, 0, blockSize);
                }
            }
            catch (IOException ie) {
                JDError.throwSQLException(exceptionObject, "HY000", ie);
            }
            value = baos.toByteArray();
        } else {
            JDError.throwSQLException(exceptionObject, "07006");
        }
        return value;
    }

    static byte[] getBytesFromReader(Reader object, int length, Object exceptionObject) throws SQLException {
        byte[] value = null;
        if (length >= 0) {
            try {
                int blockSize = length < 1000000 ? length : 1000000;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                HexReaderInputStream stream = new HexReaderInputStream(object);
                byte[] byteBuffer = new byte[blockSize];
                int totalBytesRead = 0;
                int bytesRead = stream.read(byteBuffer, 0, blockSize);
                while (bytesRead > -1 && totalBytesRead < length) {
                    baos.write(byteBuffer, 0, bytesRead);
                    int bytesRemaining = length - (totalBytesRead += bytesRead);
                    if (bytesRemaining < blockSize) {
                        blockSize = bytesRemaining;
                    }
                    bytesRead = stream.read(byteBuffer, 0, blockSize);
                }
                value = baos.toByteArray();
                if (value.length < length) {
                    JDError.throwSQLException(exceptionObject, "07006");
                }
                stream.close();
            }
            catch (ExtendedIOException eie) {
                JDError.throwSQLException(exceptionObject, "07006", eie);
            }
            catch (IOException ie) {
                JDError.throwSQLException(exceptionObject, "HY000", ie);
            }
        } else if (length == -2 || length == -1) {
            try {
                int blockSize = 1000000;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                HexReaderInputStream stream = new HexReaderInputStream(object);
                byte[] byteBuffer = new byte[blockSize];
                int totalBytesRead = 0;
                int bytesRead = stream.read(byteBuffer, 0, blockSize);
                while (bytesRead > -1) {
                    baos.write(byteBuffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    bytesRead = stream.read(byteBuffer, 0, blockSize);
                }
                value = baos.toByteArray();
                stream.close();
            }
            catch (ExtendedIOException eie) {
                JDError.throwSQLException(exceptionObject, "07006", eie);
            }
            catch (IOException ie) {
                JDError.throwSQLException(exceptionObject, "HY000", ie);
            }
        } else {
            JDError.throwSQLException(exceptionObject, "07006");
        }
        return value;
    }

    public static boolean isCharacterType(int sqlType) {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

