/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DecFloat;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDecFloat34
extends SQLDataBase {
    static final String copyright = "Copyright (C) 2006 International Business Machines Corporation and others.";
    private static final BigDecimal default_ = BigDecimal.valueOf(0L);
    private static final BigDecimal BYTE_MAX_VALUE = BigDecimal.valueOf(127L);
    private static final BigDecimal BYTE_MIN_VALUE = BigDecimal.valueOf(-128L);
    private static final BigDecimal SHORT_MAX_VALUE = BigDecimal.valueOf(32767L);
    private static final BigDecimal SHORT_MIN_VALUE = BigDecimal.valueOf(-32768L);
    private static final BigDecimal INTEGER_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal INTEGER_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal FLOAT_MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal FLOAT_MIN_VALUE = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal DOUBLE_MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN_VALUE = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal DECFLOAT34_MAX_VALUE = new BigDecimal("9.999999999999999999999999999999999E6144");
    private static final BigDecimal DECFLOAT34_MIN_VALUE = new BigDecimal("-9.999999999999999999999999999999999E6144");
    static final int DECFLOAT34_MIN_EXP = -6143;
    private int precision_ = 34;
    String specialValue_ = null;
    private AS400DecFloat typeConverter_;
    private BigDecimal value_;
    private JDProperties properties_;
    private int roundingMode;
    private String roundingModeStr;
    private int vrm_;

    SQLDecFloat34(SQLConversionSettings settings, int vrm, JDProperties properties) {
        super(settings);
        this.roundingModeStr = properties.getString(74);
        this.typeConverter_ = new AS400DecFloat(this.precision_);
        this.value_ = default_;
        this.vrm_ = vrm;
        this.properties_ = properties;
        if (this.roundingModeStr.equals("up")) {
            this.roundingMode = 0;
        } else if (this.roundingModeStr.equals("down")) {
            this.roundingMode = 1;
        } else if (this.roundingModeStr.equals("ceiling")) {
            this.roundingMode = 2;
        } else if (this.roundingModeStr.equals("floor")) {
            this.roundingMode = 3;
        } else if (this.roundingModeStr.equals("half up")) {
            this.roundingMode = 4;
        } else if (this.roundingModeStr.equals("half down")) {
            this.roundingMode = 5;
        } else if (this.roundingModeStr.equals("half even")) {
            this.roundingMode = 6;
        }
        this.roundingModeStr = "ROUND_" + this.roundingModeStr.toUpperCase().replace(' ', '_');
    }

    public Object clone() {
        return new SQLDecFloat34(this.settings_, this.vrm_, this.properties_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccisdConverter, boolean ignoreConversionErrors) throws SQLException {
        block2: {
            try {
                this.value_ = (BigDecimal)this.typeConverter_.toObject(rawBytes, offset);
                this.specialValue_ = null;
            }
            catch (ExtendedIllegalArgumentException e) {
                this.specialValue_ = this.getSpecialValue(e.toString());
                if (this.specialValue_ != null || ignoreConversionErrors) break block2;
                throw e;
            }
        }
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        try {
            if (this.specialValue_ == null) {
                this.typeConverter_.toBytes(this.value_, rawBytes, offset);
            } else {
                this.typeConverter_.toBytes(this.specialValue_, rawBytes, offset);
            }
        }
        catch (ExtendedIllegalArgumentException e) {
            JDError.throwSQLException((Object)this, "07006", e);
        }
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        BigDecimal bigDecimal;
        block15: {
            bigDecimal = null;
            this.specialValue_ = null;
            if (object instanceof String) {
                try {
                    this.specialValue_ = this.getSpecialValue((String)object);
                    if (this.specialValue_ != null) break block15;
                    if (((String)object).indexOf(44) != -1) {
                        bigDecimal = new BigDecimal(((String)object).replace(',', '.'));
                        break block15;
                    }
                    bigDecimal = new BigDecimal((String)object);
                }
                catch (NumberFormatException e) {
                    JDError.throwSQLException((Object)this, "07006", e);
                }
                catch (StringIndexOutOfBoundsException e) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (object instanceof Number) {
                this.specialValue_ = this.getSpecialValue(object.toString());
                if (this.specialValue_ == null) {
                    bigDecimal = new BigDecimal(object.toString());
                }
            } else if (object instanceof Boolean) {
                bigDecimal = (Boolean)object == true ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            this.value_ = null;
            return;
        }
        this.value_ = AS400DecFloat.roundByMode(bigDecimal, 34, this.roundingModeStr);
        if (this.value_.compareTo(DECFLOAT34_MAX_VALUE) > 0) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
            this.value_ = DECFLOAT34_MAX_VALUE;
        } else if (this.value_.compareTo(DECFLOAT34_MIN_VALUE) < 0) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
            this.value_ = DECFLOAT34_MIN_VALUE;
        }
    }

    public int getSQLType() {
        return 38;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 42;
    }

    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "DECFLOAT";
    }

    public int getMaximumPrecision() {
        return this.precision_;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 996;
    }

    public int getPrecision() {
        return this.precision_;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 1111;
    }

    public String getTypeName() {
        return "DECFLOAT";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        if (this.specialValue_ == null) {
            return SQLDataFactory.getPrecision(this.value_);
        }
        return this.specialValue_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
            return null;
        }
        if (scale >= 0) {
            if (scale >= this.value_.scale()) {
                return this.value_.setScale(scale);
            }
            this.truncated_ = this.value_.scale() - scale;
            return this.value_.setScale(scale, this.roundingMode);
        }
        return this.value_;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return false;
        }
        return this.value_.compareTo(BigDecimal.valueOf(0L)) != 0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Double("-NaN").byteValue();
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Double("NaN").byteValue();
            }
            return new Double(this.specialValue_).byteValue();
        }
        if (this.value_.compareTo(BYTE_MAX_VALUE) > 0 || this.value_.compareTo(BYTE_MIN_VALUE) < 0) {
            if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
                if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
                    if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
                        this.truncated_ = 15;
                        this.outOfBounds_ = true;
                    } else {
                        this.truncated_ = 7;
                        this.outOfBounds_ = true;
                    }
                } else {
                    this.truncated_ = 3;
                    this.outOfBounds_ = true;
                }
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.byteValue();
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Double("-NaN");
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Double("NaN");
            }
            return new Double(this.specialValue_);
        }
        if (this.value_.compareTo(DOUBLE_MAX_VALUE) > 0 || this.value_.compareTo(DOUBLE_MIN_VALUE) < 0) {
            this.truncated_ = 8;
            this.outOfBounds_ = true;
        }
        return this.value_.doubleValue();
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Float("-NaN").floatValue();
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Float("NaN").floatValue();
            }
            return new Float(this.specialValue_).floatValue();
        }
        if (this.value_.compareTo(FLOAT_MAX_VALUE) > 0 || this.value_.compareTo(FLOAT_MIN_VALUE) < 0) {
            if (this.value_.compareTo(DOUBLE_MAX_VALUE) > 0 || this.value_.compareTo(DOUBLE_MIN_VALUE) < 0) {
                this.truncated_ = 12;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 4;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.floatValue();
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
            if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
                this.truncated_ = 12;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 4;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.intValue();
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
            this.truncated_ = 8;
            this.outOfBounds_ = true;
        }
        return this.value_.longValue();
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        return this.value_;
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
            if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
                if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
                    this.truncated_ = 14;
                    this.outOfBounds_ = true;
                } else {
                    this.truncated_ = 6;
                    this.outOfBounds_ = true;
                }
            } else {
                this.truncated_ = 2;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.shortValue();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        String stringRep = this.value_.toString();
        int decimal = stringRep.indexOf(46);
        if (decimal == -1) {
            return stringRep;
        }
        return stringRep.substring(0, decimal) + this.settings_.getDecimalSeparator() + stringRep.substring(decimal + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    private String getSpecialValue(String number) {
        int startOfValue = -1;
        startOfValue = number.toUpperCase().indexOf("SNAN");
        if (startOfValue != -1) {
            if (startOfValue > 0 && number.charAt(startOfValue - 1) == '-') {
                return "-SNaN";
            }
            return "SNaN";
        }
        startOfValue = number.toUpperCase().indexOf("NAN");
        if (startOfValue != -1) {
            if (startOfValue > 0 && number.charAt(startOfValue - 1) == '-' || startOfValue > 1 && number.charAt(startOfValue - 2) == '-') {
                return "-NaN";
            }
            return String.valueOf(Double.NaN);
        }
        startOfValue = number.toUpperCase().indexOf("INF");
        if (startOfValue != -1) {
            if (startOfValue != 0 && number.charAt(startOfValue - 1) == '-') {
                return String.valueOf(Double.NEGATIVE_INFINITY);
            }
            return String.valueOf(Double.POSITIVE_INFINITY);
        }
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        String stringRep = this.value_.toString();
        int decimal = stringRep.indexOf(46);
        if (decimal == -1) {
            return stringRep;
        }
        return stringRep.substring(0, decimal) + this.settings_.getDecimalSeparator() + stringRep.substring(decimal + 1);
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

