/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

final class SQLNChar
extends SQLDataBase {
    private int maxLength_;
    private String value_;
    private String originalValue_;
    private int ccsid_;

    SQLNChar(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.value_ = "";
        this.originalValue_ = "";
        this.ccsid_ = 1200;
    }

    public Object clone() {
        return new SQLNChar(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.originalValue_ = this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset, this.maxLength_, bidiConversionProperties);
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.truncated_ = ccsidConverter.stringToByteArray(this.value_, rawBytes, offset, this.maxLength_, bidiConversionProperties);
        }
        catch (CharConversionException e) {
            this.maxLength_ = ccsidConverter.stringToByteArray(this.value_, bidiConversionProperties).length;
            JDError.throwSQLException((Object)this, "HY000", e);
        }
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        int exactLength;
        String value = null;
        if (object instanceof String) {
            value = (String)object;
        } else if (object instanceof Character) {
            value = object.toString();
        } else if (object instanceof Number) {
            value = object.toString();
        } else if (object instanceof Boolean) {
            value = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            value = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            value = SQLTimestamp.timestampToStringTrimTrailingZeros((Timestamp)object, calendar, this.settings_);
        } else if (object instanceof Date) {
            value = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            value = object.toString();
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            value = clob.getSubString(1L, (int)clob.length());
        } else if (object instanceof Reader) {
            value = SQLNChar.getStringFromReader((Reader)object, -2, this);
        } else if (object instanceof SQLXML) {
            SQLXML xml = (SQLXML)object;
            value = xml.getString();
        }
        if (value == null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.value_ = value;
        this.originalValue_ = value;
        int valueLength = this.value_.length();
        if (valueLength < (exactLength = this.getDisplaySize())) {
            StringBuffer buffer = new StringBuffer(this.value_);
            char c = ' ';
            for (int i = valueLength; i < exactLength; ++i) {
                buffer.append(c);
            }
            this.value_ = buffer.toString();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (valueLength > exactLength) {
            this.originalValue_ = this.value_ = this.value_.substring(0, exactLength);
            this.truncated_ = valueLength - exactLength;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
    }

    public int getSQLType() {
        return 35;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "java.lang.String";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "NCHAR";
    }

    public int getMaximumPrecision() {
        return 16382;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 468;
    }

    public int getPrecision() {
        return this.maxLength_ / 2;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -15;
    }

    public String getTypeName() {
        return "NCHAR";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    public Object getBatchableObject() throws SQLException {
        return this.originalValue_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getString();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    public void trim() {
        this.originalValue_ = this.value_ = this.value_.trim();
    }

    public String getNString() throws SQLException {
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.getString());
    }

    public void saveValue() {
        this.savedValue_ = this.originalValue_;
    }
}

