/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCRowId;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLRowID
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private int length_ = 0;
    private byte[] value_ = default_;

    SQLRowID(SQLConversionSettings settings) {
        super(settings);
    }

    public Object clone() {
        return new SQLRowID(this.settings_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(rawBytes, offset);
        this.value_ = new byte[this.length_];
        System.arraycopy(rawBytes, offset + 2, this.value_, 0, this.length_);
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.unsignedShortToByteArray(this.length_, rawBytes, offset);
        int len = this.value_.length < rawBytes.length ? this.value_.length : rawBytes.length;
        System.arraycopy(this.value_, 0, rawBytes, offset + 2, len);
        for (int i = offset + 2 + len; i < rawBytes.length; ++i) {
            rawBytes[i] = 0;
        }
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof RowId) {
            this.value_ = ((RowId)object).getBytes();
        } else if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            int length = scale;
            if (length >= 0) {
                InputStream stream = (InputStream)object;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int blockSize = length < 1000000 ? length : 1000000;
                byte[] byteBuffer = new byte[blockSize];
                try {
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1 && totalBytesRead < length) {
                        baos.write(byteBuffer, 0, bytesRead);
                        int bytesRemaining = length - (totalBytesRead += bytesRead);
                        if (bytesRemaining < blockSize) {
                            blockSize = bytesRemaining;
                        }
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                }
                catch (IOException ie) {
                    JDError.throwSQLException((Object)this, "HY000", ie);
                }
                this.value_ = baos.toByteArray();
                int objectLength = this.value_.length;
                if (this.value_.length > 40) {
                    byte[] newValue = new byte[40];
                    System.arraycopy(this.value_, 0, newValue, 0, 40);
                    this.value_ = newValue;
                }
                this.truncated_ = objectLength - this.value_.length;
                this.outOfBounds_ = false;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Reader) {
            int length = scale;
            if (length >= 0) {
                try {
                    int blockSize = length < 1000000 ? length : 1000000;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    HexReaderInputStream stream = new HexReaderInputStream((Reader)object);
                    byte[] byteBuffer = new byte[blockSize];
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1 && totalBytesRead < length) {
                        baos.write(byteBuffer, 0, bytesRead);
                        int bytesRemaining = length - (totalBytesRead += bytesRead);
                        if (bytesRemaining < blockSize) {
                            blockSize = bytesRemaining;
                        }
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                    this.value_ = baos.toByteArray();
                    int objectLength = this.value_.length;
                    if (this.value_.length > 40) {
                        byte[] newValue = new byte[40];
                        System.arraycopy(this.value_, 0, newValue, 0, 40);
                        this.value_ = newValue;
                    }
                    stream.close();
                    this.truncated_ = objectLength - this.value_.length;
                    this.outOfBounds_ = false;
                }
                catch (ExtendedIOException eie) {
                    JDError.throwSQLException((Object)this, "07006", eie);
                }
                catch (IOException ie) {
                    JDError.throwSQLException((Object)this, "HY000", ie);
                }
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int valueLength = this.value_.length;
        if (valueLength > 40) {
            byte[] newValue = new byte[40];
            System.arraycopy(this.value_, 0, newValue, 0, 40);
            this.value_ = newValue;
            this.truncated_ = valueLength - 40;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length;
    }

    public int getSQLType() {
        return 25;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 40;
    }

    public String getJavaClassName() {
        return "[B";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "ROWID";
    }

    public int getMaximumPrecision() {
        return 40;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 904;
    }

    public int getPrecision() {
        return 40;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -8;
    }

    public String getTypeName() {
        return "ROWID";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new ByteArrayInputStream(this.getBytes());
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        byte[] bytes = this.getBytes();
        return new AS400JDBCBlob(bytes, bytes.length);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length > maxFieldSize && maxFieldSize > 0) {
            byte[] truncatedValue = new byte[maxFieldSize];
            System.arraycopy(this.value_, 0, truncatedValue, 0, maxFieldSize);
            return truncatedValue;
        }
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCRowId(this.getBytes());
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCNClob(string, string.length());
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public RowId getRowId() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCRowId(this.getBytes());
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() throws SQLException {
        this.savedValue_ = this.value_;
    }
}

