/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCFieldedTimestamp;
import com.ibm.as400.access.AS400JDBCTimestamp;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.CharConversionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLTimestamp
extends SQLDataBase {
    static final String copyright2 = "Copyright (C) 1997-2013 International Business Machines Corporation and others.";
    static boolean jdk14 = false;
    private int year_;
    private int month_;
    private int day_;
    private int hour_;
    private int minute_;
    private int second_;
    private long picos_;
    private int length_;

    SQLTimestamp(int length, SQLConversionSettings settings) {
        super(settings);
        this.length_ = length;
        this.year_ = 0;
        this.month_ = 0;
        this.day_ = 0;
        this.hour_ = 0;
        this.minute_ = 0;
        this.second_ = 0;
        this.picos_ = 0L;
    }

    public Object clone() {
        return new SQLTimestamp(this.length_, this.settings_);
    }

    public void setTimestampFieldsFromString(String s) throws SQLException {
        try {
            int stringLength = s.length();
            if (stringLength < 10) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Invalid timestamp length " + s);
                }
                JDError.throwSQLException("07006", s);
            }
            if (s.charAt(4) != '-' || s.charAt(7) != '-') {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Timestamp missing - " + s);
                }
                JDError.throwSQLException("07006", s);
            }
            this.year_ = Integer.parseInt(s.substring(0, 4));
            this.month_ = Integer.parseInt(s.substring(5, 7)) - 1;
            this.day_ = Integer.parseInt(s.substring(8, 10));
            this.hour_ = stringLength >= 13 ? Integer.parseInt(s.substring(11, 13)) : 0;
            this.minute_ = stringLength >= 16 ? Integer.parseInt(s.substring(14, 16)) : 0;
            this.second_ = stringLength >= 19 ? Integer.parseInt(s.substring(17, 19)) : 0;
            long picos = 0L;
            if (stringLength > 20) {
                String picosString = s.substring(20).trim() + "00000000000000";
                this.picos_ = Long.parseLong(picosString.substring(0, 12));
            } else {
                this.picos_ = 0L;
            }
        }
        catch (NumberFormatException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
    }

    public static Timestamp stringToTimestamp(String s, Calendar calendar) throws SQLException {
        try {
            int stringLength = s.length();
            if (stringLength < 10) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Invalid timestamp length " + s);
                }
                JDError.throwSQLException("07006", s);
            }
            if (s.charAt(4) != '-' || s.charAt(7) != '-') {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Timestamp missing - " + s);
                }
                JDError.throwSQLException("07006", s);
            }
            int year = Integer.parseInt(s.substring(0, 4));
            if (calendar == null) {
                calendar = AS400Calendar.getGregorianInstance();
                calendar.setLenient(false);
            } else {
                calendar = AS400Calendar.getConversionCalendar(calendar);
            }
            calendar.set(1, year);
            calendar.set(2, Integer.parseInt(s.substring(5, 7)) - 1);
            calendar.set(5, Integer.parseInt(s.substring(8, 10)));
            if (stringLength >= 13) {
                calendar.set(11, Integer.parseInt(s.substring(11, 13)));
            } else {
                calendar.set(11, 0);
            }
            if (stringLength >= 16) {
                calendar.set(12, Integer.parseInt(s.substring(14, 16)));
            } else {
                calendar.set(12, 0);
            }
            if (stringLength >= 19) {
                calendar.set(13, Integer.parseInt(s.substring(17, 19)));
            } else {
                calendar.set(13, 0);
            }
            long picos = 0L;
            if (stringLength > 20) {
                String picosString = s.substring(20).trim() + "00000000000000";
                picos = Long.parseLong(picosString.substring(0, 12));
            } else {
                picos = 0L;
            }
            Timestamp ts = null;
            try {
                long millis = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
                if (picos % 1000L == 0L) {
                    ts = new Timestamp(millis);
                    ts.setNanos((int)(picos / 1000L));
                } else {
                    AS400JDBCTimestamp aTs = new AS400JDBCTimestamp(millis, 32);
                    aTs.setPicos(picos);
                    ts = aTs;
                }
            }
            catch (Exception e) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(null, "Error parsing timestamp " + s, e);
                }
                JDError.throwSQLException(null, "07006", e, s);
                return null;
            }
            return ts;
        }
        catch (NumberFormatException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
        return new Timestamp(0L);
    }

    public static String timestampToString(Timestamp ts, Calendar calendar, SQLConversionSettings settings) {
        return SQLTimestamp.timestampToString(ts, calendar, -1, 26, settings);
    }

    public static String timestampToStringTrimTrailingZeros(Timestamp ts, Calendar calendar, SQLConversionSettings settings) {
        int lastZero;
        String tsString = SQLTimestamp.timestampToString(ts, calendar, -1, 32, settings);
        for (lastZero = 32; tsString.charAt(lastZero - 1) == '0' && lastZero > 21; --lastZero) {
        }
        if (lastZero < 32) {
            tsString = tsString.substring(0, lastZero);
        }
        return tsString;
    }

    public static String timestampToString(Timestamp ts, Calendar calendar, int hourIn, SQLConversionSettings settings) {
        return SQLTimestamp.timestampToString(ts, calendar, hourIn, 26, settings);
    }

    public static String timestampToString(Timestamp ts, Calendar calendar, int hourIn, int length, SQLConversionSettings settings) {
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.setTime(ts);
        int hour = calendar.get(11);
        if (hourIn == 24 && hour == 0) {
            calendar.add(5, -1);
        }
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        long picos = 0L;
        if (length > 20) {
            picos = ts instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)ts).getPicos() : (long)ts.getNanos() * 1000L;
        }
        if (hourIn == 24 && hour == 0) {
            hour = 24;
        }
        return SQLTimestamp.buildString(year, month, day, hour, minute, second, picos, length, settings);
    }

    private static String buildString(int year, int month, int day, int hour, int minute, int second, long picos, int length, SQLConversionSettings settings) {
        StringBuffer buffer = new StringBuffer();
        char dayHourSep = ' ';
        char hourMinuteSep = ':';
        char minuteSecondSep = ':';
        if (settings.getTimestampFormat() == 1) {
            dayHourSep = '-';
            hourMinuteSep = '.';
            minuteSecondSep = '.';
        }
        buffer.append(JDUtilities.padZeros(year, 4));
        buffer.append('-');
        buffer.append(JDUtilities.padZeros(month + 1, 2));
        buffer.append('-');
        buffer.append(JDUtilities.padZeros(day, 2));
        buffer.append(dayHourSep);
        buffer.append(JDUtilities.padZeros(hour, 2));
        buffer.append(hourMinuteSep);
        buffer.append(JDUtilities.padZeros(minute, 2));
        buffer.append(minuteSecondSep);
        buffer.append(JDUtilities.padZeros(second, 2));
        if (length > 20) {
            buffer.append('.');
            buffer.append(JDUtilities.padZeros(picos, 12));
            buffer.setLength(length);
        }
        buffer.setLength(length);
        return buffer.toString();
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.year_ = (rawBytes[offset] & 0xF) * 1000 + (rawBytes[offset + 1] & 0xF) * 100 + (rawBytes[offset + 2] & 0xF) * 10 + (rawBytes[offset + 3] & 0xF);
        this.month_ = (rawBytes[offset + 5] & 0xF) * 10 + (rawBytes[offset + 6] & 0xF) - 1;
        this.day_ = (rawBytes[offset + 8] & 0xF) * 10 + (rawBytes[offset + 9] & 0xF);
        this.hour_ = (rawBytes[offset + 11] & 0xF) * 10 + (rawBytes[offset + 12] & 0xF);
        this.minute_ = (rawBytes[offset + 14] & 0xF) * 10 + (rawBytes[offset + 15] & 0xF);
        this.second_ = (rawBytes[offset + 17] & 0xF) * 10 + (rawBytes[offset + 18] & 0xF);
        long multiplier = 100000000000L;
        this.picos_ = 0L;
        for (int picoOffset = 20; picoOffset < this.length_; ++picoOffset) {
            this.picos_ += (long)(rawBytes[offset + picoOffset] & 0xF) * multiplier;
            multiplier /= 10L;
        }
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        StringBuffer buffer = new StringBuffer(this.getString().replace(':', '.'));
        buffer.setCharAt(10, '-');
        if (buffer.length() > this.length_) {
            buffer.setLength(this.length_);
        }
        try {
            ccsidConverter.stringToByteArray(buffer.toString(), rawBytes, offset);
        }
        catch (CharConversionException e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    public int getSQLType() {
        return 28;
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        if (object instanceof String) {
            this.setTimestampFieldsFromString((String)object);
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = object instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)object).getPicos() : (long)((Timestamp)object).getNanos() * 1000L;
        } else if (object instanceof java.util.Date) {
            calendar.setTime((java.util.Date)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = (long)calendar.get(14) * 1000000000L;
        } else if (object instanceof AS400JDBCFieldedTimestamp) {
            AS400JDBCFieldedTimestamp ts = (AS400JDBCFieldedTimestamp)object;
            this.year_ = ts.getYear();
            this.month_ = ts.getMonth();
            this.day_ = ts.getDay();
            this.hour_ = ts.getHour();
            this.minute_ = ts.getMinute();
            this.second_ = ts.getSecond();
            this.picos_ = ts.getPicos();
            this.length_ = ts.getLength();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return this.length_;
    }

    public String getJavaClassName() {
        return "java.sql.Timestamp";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "TIMESTAMP";
    }

    public int getMaximumPrecision() {
        return this.length_;
    }

    public int getMaximumScale() {
        return this.getScale();
    }

    public int getMinimumScale() {
        return this.getScale();
    }

    public int getNativeType() {
        return 392;
    }

    public int getPrecision() {
        return this.length_;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        int scale = this.length_ - 20;
        if (scale >= 0) {
            return scale;
        }
        return 0;
    }

    public int getType() {
        return 93;
    }

    public String getTypeName() {
        return "TIMESTAMP";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return this.length_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 16;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long millis = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Date(millis);
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long millis = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp ts = new Timestamp(millis);
            ts.setNanos((int)(this.picos_ / 1000L));
            return ts;
        }
        AS400JDBCTimestamp ts = new AS400JDBCTimestamp(millis);
        ts.setPicos(this.picos_);
        return ts;
    }

    public Object getBatchableObject() {
        return new AS400JDBCFieldedTimestamp(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_, this.picos_, this.length_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return SQLTimestamp.buildString(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_, this.picos_, this.length_, this.settings_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 18;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(0, 0, 0, this.hour_, this.minute_, this.second_);
        long millis = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Time(millis);
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long millis = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp ts = new Timestamp(millis);
            ts.setNanos((int)(this.picos_ / 1000L));
            return ts;
        }
        AS400JDBCTimestamp ts = new AS400JDBCTimestamp(millis);
        ts.setPicos(this.picos_);
        return ts;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() throws SQLException {
        this.savedValue_ = SQLTimestamp.buildString(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_, this.picos_, this.length_, this.settings_);
    }

    static {
        jdk14 = JVMInfo.isJDK14();
    }
}

