/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class ServiceProgramCall
extends ProgramCall {
    static final long serialVersionUID = 4L;
    public static final int NO_RETURN_VALUE = 0;
    public static final int RETURN_INTEGER = 1;
    static final int RETURN_INTEGER_AND_ERRNO = 3;
    private String procedureName_ = "";
    private byte[] returnValue_ = null;
    private int returnValueFormat_ = 0;
    private int procedureNameCCSID_ = 37;
    private boolean alignOn16Bytes_ = false;

    public ServiceProgramCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object.");
        }
    }

    public ServiceProgramCall(AS400 system) {
        super(system);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object.");
        }
    }

    public ServiceProgramCall(AS400 system, String serviceProgram, ProgramParameter[] parameterList) {
        super(system, serviceProgram, parameterList);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object.");
        }
    }

    public ServiceProgramCall(AS400 system, String serviceProgram, String procedureName, ProgramParameter[] parameterList) {
        super(system, serviceProgram, parameterList);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object, procedureName: " + procedureName);
        }
        if (procedureName == null) {
            throw new NullPointerException("procedureName");
        }
        this.procedureName_ = procedureName;
    }

    public ServiceProgramCall(AS400 system, String serviceProgram, String procedureName, int returnValueFormat, ProgramParameter[] parameterList) {
        super(system, serviceProgram, parameterList);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object, procedureName: " + procedureName + " return value format:", returnValueFormat);
        }
        if (procedureName == null) {
            throw new NullPointerException("procedureName");
        }
        if (returnValueFormat < 0 || returnValueFormat > 1) {
            throw new ExtendedIllegalArgumentException("returnValueFormat (" + returnValueFormat + ")", 2);
        }
        this.procedureName_ = procedureName;
        this.returnValueFormat_ = returnValueFormat;
    }

    public int getErrno() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting error number.");
        }
        if (this.returnValue_ == null || this.returnValueFormat_ != 1) {
            Trace.log(2, "Attempt to get error number before running service program.");
            throw new ExtendedIllegalStateException("returnValueFormat", 4);
        }
        if (this.returnValue_.length > 7) {
            return BinaryConverter.byteArrayToInt(this.returnValue_, 4);
        }
        return 0;
    }

    public int getIntegerReturnValue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting integer return value.");
        }
        if (this.returnValue_ == null || this.returnValueFormat_ != 1) {
            Trace.log(2, "Attempt to get integer return value before running service program.");
            throw new ExtendedIllegalStateException("returnValueFormat", 4);
        }
        return BinaryConverter.byteArrayToInt(this.returnValue_, 0);
    }

    public String getProcedureName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting procedure name: " + this.procedureName_);
        }
        return this.procedureName_;
    }

    public byte[] getReturnValue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting return value:", this.returnValue_);
        }
        return this.returnValue_;
    }

    public int getReturnValueFormat() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting return value format:", this.returnValueFormat_);
        }
        return this.returnValueFormat_;
    }

    public boolean run() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String iasp;
        if (Trace.traceOn_) {
            Trace.log(3, "Running service program: " + this.program_ + " procedure name: " + this.procedureName_);
        }
        if (this.program_.length() == 0) {
            Trace.log(2, "Attempt to run before setting program.");
            throw new ExtendedIllegalStateException("program", 4);
        }
        if (this.procedureName_.length() == 0) {
            Trace.log(2, "Attempt to run before setting procedure name.");
            throw new ExtendedIllegalStateException("procedureName", 4);
        }
        if (this.parameterList_.length > 7) {
            Trace.log(2, "Parameter list length exceeds limit of 7 parameters:", this.parameterList_.length);
            throw new ExtendedIllegalArgumentException("parameterList.length (" + this.parameterList_.length + ")", 2);
        }
        String prg = this.program_.toUpperCase();
        if (!prg.startsWith("/QSYS.LIB") && !this.system_.aspName.equalsIgnoreCase(iasp = prg.substring(1, prg.indexOf("/QSYS.LIB")))) {
            try {
                String currentASP;
                String SetASPGrp = "SETASPGRP ASPGRP(" + iasp + ") CURLIB(*CURUSR) USRLIBL(*CURUSR)";
                CommandCall commandCall = new CommandCall(this.system_);
                Job job = commandCall.getServerJob();
                this.system_.aspName = currentASP = job.getJobAsp();
                if (currentASP != null && !currentASP.equalsIgnoreCase(iasp)) {
                    Trace.log(1, "ServiceProgram call command of setaspgrp " + SetASPGrp);
                    if (!commandCall.run(SetASPGrp)) {
                        Trace.log(2, this, "Command SETASPGRP Failed with iasp " + iasp);
                    } else {
                        this.system_.aspName = iasp;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.chooseImpl();
        int rvf = this.returnValueFormat_;
        if (rvf == 1) {
            rvf = 3;
        }
        this.returnValue_ = this.impl_.runServiceProgram(this.library_, this.name_, this.procedureName_, rvf, this.parameterList_, this.threadSafetyValue_, this.procedureNameCCSID_, this.messageOption_, this.alignOn16Bytes_);
        this.messageList_ = this.impl_.getMessageList();
        if (this.system_ != null) {
            for (int i = 0; i < this.messageList_.length; ++i) {
                this.messageList_[i].setSystem(this.system_);
            }
        }
        if (this.messageList_.length != 0 && this.messageList_[0].getID().startsWith("MCH3401")) {
            throw new ObjectDoesNotExistException(this.program_, 2);
        }
        if (this.actionCompletedListeners_ != null) {
            this.fireActionCompleted();
        }
        return this.returnValue_ != null;
    }

    public boolean run(String serviceProgram, ProgramParameter[] parameterList) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        this.setProgram(serviceProgram, parameterList);
        return this.run();
    }

    public boolean run(AS400 system, String serviceProgram, String procedureName, int returnValueFormat, ProgramParameter[] parameterList) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        this.setSystem(system);
        this.setProgram(serviceProgram);
        this.setProcedureName(procedureName);
        this.setReturnValueFormat(returnValueFormat);
        this.setParameterList(parameterList);
        return this.run();
    }

    public void setAlignOn16Bytes(boolean align) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting alignment: " + align);
        }
        this.alignOn16Bytes_ = align;
    }

    public void setProcedureName(String procedureName) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting procedure name: " + procedureName);
        }
        if (procedureName == null) {
            throw new NullPointerException("procedureName");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.procedureName_ = procedureName;
        } else {
            String oldValue = this.procedureName_;
            String newValue = procedureName;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("procedureName", oldValue, newValue);
            }
            this.procedureName_ = procedureName;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("procedureName", oldValue, newValue);
            }
        }
    }

    public void setProcedureName(String procedureName, int procedureNameCCSID) throws PropertyVetoException {
        this.setProcedureName(procedureName);
        this.procedureNameCCSID_ = procedureNameCCSID;
    }

    public void setProgram(String serviceProgram) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service program: " + serviceProgram);
        }
        if (serviceProgram == null) {
            throw new NullPointerException("program");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(serviceProgram, "SRVPGM");
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.program_ = serviceProgram;
        } else {
            String oldValue = this.program_;
            String newValue = serviceProgram;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("program", oldValue, newValue);
            }
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.program_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("program", oldValue, newValue);
            }
        }
    }

    public void setReturnValueFormat(int returnValueFormat) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting return value format:", returnValueFormat);
        }
        if (returnValueFormat < 0 || returnValueFormat > 1) {
            throw new ExtendedIllegalArgumentException("returnValueFormat (" + returnValueFormat + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.returnValueFormat_ = returnValueFormat;
        } else {
            Integer oldValue = new Integer(this.returnValueFormat_);
            Integer newValue = new Integer(returnValueFormat);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("returnValueFormat", oldValue, newValue);
            }
            this.returnValueFormat_ = returnValueFormat;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("returnValueFormat", oldValue, newValue);
            }
        }
    }
}

