/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

class ToolboxLogger {
    private static final String copyright = "Copyright (C) 2005-2005 International Business Machines Corporation and others.";
    private static Logger logger_ = null;
    private static Logger[] parentLoggers_ = null;
    private static final Object loggerLock_ = new Object();
    private static boolean JDK14_OR_HIGHER;

    private ToolboxLogger() {
    }

    final void config(String msg) {
        logger_.config(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ToolboxLogger getLogger() {
        if (logger_ == null && JDK14_OR_HIGHER) {
            Object object = loggerLock_;
            synchronized (object) {
                if (logger_ == null) {
                    Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
                    while (loggerNames.hasMoreElements() && logger_ == null) {
                        String name = loggerNames.nextElement();
                        if (!name.equals("com.ibm.as400.access")) continue;
                        logger_ = LogManager.getLogManager().getLogger("com.ibm.as400.access");
                    }
                    if (logger_ != null) {
                        Vector<Logger> parents = new Vector<Logger>();
                        for (Logger parent = logger_.getParent(); parent != null; parent = parent.getParent()) {
                            parents.add(parent);
                        }
                        if (!parents.isEmpty()) {
                            parentLoggers_ = parents.toArray(new Logger[0]);
                        }
                    }
                }
            }
        }
        if (logger_ != null) {
            return new ToolboxLogger();
        }
        return null;
    }

    final void info(String msg) {
        logger_.info(msg);
    }

    final boolean isLoggable(int category) {
        return logger_.isLoggable(ToolboxLogger.mapTracingLevel(category));
    }

    final boolean isLoggingOn() {
        if (logger_ == null) {
            return false;
        }
        if (logger_.getLevel() == Level.OFF) {
            return false;
        }
        if (logger_.getLevel() != null) {
            return true;
        }
        if (parentLoggers_ != null) {
            for (int i = 0; i < parentLoggers_.length; ++i) {
                if (parentLoggers_[i].getLevel() == null) continue;
                return parentLoggers_[i].getLevel() != Level.OFF;
            }
        }
        return false;
    }

    final void log(int category, String msg) {
        logger_.log(ToolboxLogger.mapTracingLevel(category), msg);
    }

    final void log(int category, String msg, Throwable thrown) {
        logger_.log(ToolboxLogger.mapTracingLevel(category), msg, thrown);
    }

    private static final Level mapTracingLevel() {
        Level level = null;
        if (Trace.traceOn_) {
            if (Trace.traceError_) {
                level = Level.SEVERE;
            }
            if (Trace.traceWarning_) {
                level = Level.WARNING;
            }
            if (Trace.traceInfo_) {
                level = Level.INFO;
            }
            if (Trace.traceDiagnostic_) {
                level = Level.FINE;
            }
            if (Trace.traceJDBC_ || Trace.tracePCML_ || Trace.traceProxy_) {
                level = Level.FINER;
            }
            if (Trace.traceConversion_ || Trace.traceDatastream_) {
                level = Level.FINEST;
            }
            if (level == null) {
                level = Level.OFF;
            }
        } else {
            level = Level.OFF;
        }
        return level;
    }

    private static final Level mapTracingLevel(int category) {
        switch (category) {
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.WARNING;
            }
            case 2: {
                return Level.SEVERE;
            }
            case 1: {
                return Level.FINE;
            }
            case 6: 
            case 7: 
            case 8: {
                return Level.FINER;
            }
            case 0: 
            case 5: {
                return Level.FINEST;
            }
        }
        throw new ExtendedIllegalArgumentException("category (" + Integer.toString(category) + ")", 2);
    }

    final void setLevel() throws SecurityException {
        logger_.setLevel(ToolboxLogger.mapTracingLevel());
    }

    static {
        try {
            Class.forName("java.util.logging.LogManager");
            JDK14_OR_HIGHER = true;
        }
        catch (Throwable e) {
            JDK14_OR_HIGHER = false;
        }
    }
}

