/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ChangePasswordDialog;
import com.ibm.as400.access.MessageDialog;
import com.ibm.as400.access.PasswordDialog;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SignonEvent;
import com.ibm.as400.access.SignonHandlerAdapter;
import com.ibm.as400.access.Trace;
import java.awt.Frame;
import java.beans.PropertyVetoException;
import java.io.IOException;

final class ToolboxSignonHandler
extends SignonHandlerAdapter {
    private static final boolean DEBUG = false;
    private static final boolean PASSWORD_TRACE = false;
    private String systemName_ = "";
    private String userId_ = "";
    private boolean changingPassword_ = false;

    ToolboxSignonHandler() {
    }

    public boolean connectionInitiated(SignonEvent event, boolean forceUpdate) {
        return this.handleSignon((AS400)event.getSource(), forceUpdate, false);
    }

    public void exceptionOccurred(SignonEvent event) throws AS400SecurityException {
        AS400SecurityException exc = event.getException();
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            throw exc;
        }
        this.handleException(system, exc);
    }

    public boolean passwordAboutToExpire(SignonEvent event, int daysUntilExpiration) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return true;
        }
        boolean response = this.displayMessage(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("DLG_PASSWORD_EXP_WARNING"), Integer.toString(daysUntilExpiration)) + "  " + ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_PROMPT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), true);
        if (response) {
            this.handlePasswordChange(system);
        }
        return true;
    }

    public boolean passwordExpired(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        boolean response = this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_EXPIRED") + "\n" + ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_PROMPT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), true);
        if (response) {
            return this.handlePasswordChange(system);
        }
        return false;
    }

    public boolean passwordIncorrect(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_INCORRECT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    public boolean passwordLengthIncorrect(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    public boolean passwordMissing(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_PASSWORD"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.connectionInitiated(event, true);
    }

    public boolean systemNameMissing(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_USERID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, true);
    }

    public boolean userIdAboutToBeDisabled(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_INCORRECT_USERID_DISABLE"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    public boolean userIdDefaultAlreadyAssigned(SignonEvent event, String defaultUser) {
        this.displayMessage(ResourceBundleLoader.getText("DLG_DEFAULT_USER_EXISTS"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        this.displayMessage(ResourceBundleLoader.getText("DLG_SET_DEFAULT_USER_FAILED"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return true;
    }

    public boolean userIdDisabled(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_USERID_DISABLE"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    public boolean userIdLengthIncorrect(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_USERID_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    public boolean userIdMissing(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_USERID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    public boolean userIdUnknown(SignonEvent event) {
        AS400 system = (AS400)event.getSource();
        if (!system.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_USERID_UNKNOWN"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(system, true, false);
    }

    private void displayMessage(String message, String dialogTitle) {
        this.displayMessage(message, dialogTitle, false);
    }

    private boolean displayMessage(String message, String dialogTitle, boolean getResponse) {
        MessageDialog md = new MessageDialog(new Frame(), message, dialogTitle, getResponse);
        return md.display();
    }

    private void handleException(AS400 system, AS400SecurityException exc) throws AS400SecurityException {
        switch (exc.getReturnCode()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 39: 
            case 44: 
            case 63: 
            case 65: {
                if (this.changingPassword_) {
                    this.displayMessage(exc.getMessage(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
                    if (this.handlePasswordChange(system)) break;
                    throw exc;
                }
                this.displayMessage(exc.getMessage(), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
                if (this.handleSignon(system, true, false)) break;
                throw exc;
            }
            case 7: {
                boolean response = this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_EXPIRED") + "\n" + ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_PROMPT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), true);
                if (response) {
                    if (this.handlePasswordChange(system)) break;
                    throw exc;
                }
                throw exc;
            }
            default: {
                String title = this.changingPassword_ ? ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE") : ResourceBundleLoader.getText("DLG_SIGNON_TITLE");
                this.displayMessage(exc.getMessage(), title);
                throw exc;
            }
        }
    }

    private boolean handlePasswordChange(AS400 system) {
        ChangePasswordDialog cpd = new ChangePasswordDialog(new Frame(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
        boolean changedPassword = false;
        boolean done = false;
        do {
            String confirmPassword;
            String newPassword;
            if (!cpd.prompt(system.getSystemName(), system.getUserId())) {
                this.changingPassword_ = false;
                break;
            }
            String oldPassword = cpd.getOldPassword();
            if (!this.validatePasswordInfo(oldPassword, newPassword = cpd.getNewPassword(), confirmPassword = cpd.getConfirmPassword())) continue;
            this.changingPassword_ = true;
            try {
                system.changePassword(oldPassword, newPassword);
            }
            catch (AS400SecurityException e) {
                this.displayMessage(e.getMessage(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
                return this.handlePasswordChange(system);
            }
            catch (IOException e) {
                this.displayMessage(e.getMessage(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
                return this.handlePasswordChange(system);
            }
            this.changingPassword_ = false;
            changedPassword = true;
            done = true;
        } while (!done);
        return changedPassword;
    }

    private boolean handleSignon(AS400 system, boolean forceUpdate, boolean enableSystemNameField) {
        if (!forceUpdate && system.getSystemName().length() != 0 && system.getUserId().length() != 0) {
            return true;
        }
        if (system.isGuiAvailable()) {
            if (Trace.traceOn_) {
                Trace.log(1, "Signing-on with prompting turned on.");
            }
            boolean done = false;
            do {
                String password;
                String userId;
                PasswordDialog pd = this.setupPasswordDialog(system);
                if (enableSystemNameField) {
                    pd.enableSystemNameField();
                }
                if (!pd.prompt()) {
                    return false;
                }
                String systemName = pd.getSystemName().trim();
                if (!this.validateInfo(systemName, userId = pd.getUserId().trim().toUpperCase(), password = pd.getPassword(), system)) continue;
                try {
                    this.systemName_ = systemName;
                    system.setSystemName(this.systemName_);
                    if (userId.length() != 0) {
                        this.userId_ = userId;
                        system.setUserId(this.userId_);
                    }
                    if (password.length() != 0) {
                        system.setPassword(password);
                    }
                    if (pd.getDefaultState() && this.userId_.length() != 0) {
                        if (Trace.traceOn_) {
                            Trace.log(1, "Setting default user from dialog...");
                        }
                        if (!AS400.setDefaultUser(this.systemName_, this.userId_)) {
                            if (Trace.traceOn_) {
                                Trace.log(4, "Failed to set default user.");
                            }
                            if (system.isGuiAvailable()) {
                                this.displayMessage(ResourceBundleLoader.getText("DLG_DEFAULT_USER_EXISTS") + "\n\n" + ResourceBundleLoader.getText("DLG_SET_DEFAULT_USER_FAILED"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
                            }
                        }
                    }
                    if (Trace.traceOn_) {
                        Trace.log(1, "Setting password cache entry from dialog...");
                    }
                    system.setUsePasswordCache(pd.getPasswordCacheState());
                    done = true;
                }
                catch (PropertyVetoException e) {
                    this.displayMessage(e.getMessage(), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
                    return this.handleSignon(system, forceUpdate, enableSystemNameField);
                }
            } while (!done);
        } else if (Trace.traceOn_) {
            Trace.log(3, "No GUI is available to sign-on handler.");
        }
        return true;
    }

    private boolean noGuiAvailable() {
        Trace.log(2, "The internal Toolbox sign-on handler requires a GUI in order to gather new information.");
        return false;
    }

    private PasswordDialog setupPasswordDialog(AS400 system) {
        String defaultUser;
        PasswordDialog pd = new PasswordDialog(new Frame(), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), system.isShowCheckboxes());
        String systemName = system.getSystemName();
        if (systemName.length() == 0) {
            systemName = this.systemName_;
        }
        if (systemName.length() == 0) {
            pd.enableDefaultUserCheckbox();
            pd.setDefaultUserState(false);
        } else {
            pd.setSystemName(systemName);
            this.systemName_ = systemName;
            if (AS400.getDefaultUser(systemName) == null) {
                pd.enableDefaultUserCheckbox();
                pd.setDefaultUserState(true);
            } else {
                pd.disableDefaultUserCheckbox();
            }
        }
        pd.setPasswordCacheState(system.isUsePasswordCache());
        String userId = system.getUserId();
        if (userId.length() == 0) {
            userId = this.userId_;
        }
        if (userId.length() == 0 && systemName.length() != 0 && (defaultUser = AS400.getDefaultUser(systemName)) != null) {
            userId = defaultUser;
        }
        if (userId.length() != 0) {
            pd.setUserId(userId);
            this.userId_ = userId;
        }
        return pd;
    }

    private boolean validateInfo(String systemName, String userId, String password, AS400 system) {
        boolean valid = true;
        if (systemName.length() == 0 || !system.isUseDefaultUser() && userId.length() == 0 || !system.isUsePasswordCache() && password.length() == 0) {
            this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_PASSWORD"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
            valid = false;
        } else if (password.length() > 128) {
            Trace.log(2, "Length of password is greater than 128 characters: " + password.length());
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
            valid = false;
        }
        return valid;
    }

    private boolean validatePasswordInfo(String oldPassword, String newPassword, String confirmPassword) {
        if (oldPassword.length() == 0 || newPassword.length() == 0 || confirmPassword.length() == 0) {
            this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_PASSWORD"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        if (!newPassword.equals(confirmPassword)) {
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_NOT_MATCH"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        if (oldPassword.length() > 128) {
            Trace.log(2, "Length of old password is greater than 128 characters: " + oldPassword.length());
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        if (newPassword.length() > 128) {
            Trace.log(2, "Length of new password is greater than 128 characters: " + newPassword.length());
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_NEW_NOT_VALID"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        return true;
    }
}

