/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSRandomAccessFileImplRemote;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpaceImpl;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.IOException;

class UserSpaceImplRemote
implements UserSpaceImpl {
    protected AS400ImplRemote system_ = null;
    protected String path_ = null;
    protected String library_ = null;
    protected String name_ = null;
    protected boolean mustUseProgramCall_ = false;
    protected boolean mustUseSockets_ = false;
    protected ConverterImplRemote converter_;
    private ProgramParameter nameParameter_ = null;
    private ProgramParameter errorCodeParameter_ = null;
    protected RemoteCommandImpl remoteCommand_;
    private Boolean runOnThread_ = RemoteCommandImpl.OFF_THREAD;
    private IFSRandomAccessFileImplRemote file_;

    UserSpaceImplRemote() {
    }

    private AS400Exception buildException() throws AS400SecurityException, ObjectDoesNotExistException {
        AS400Message[] messageList = this.remoteCommand_.getMessageList();
        String id = messageList[0].getID();
        if (id.equals("CPF9801") || id.equals("CPF2105")) {
            Trace.log(2, "Object does not exist: " + this.path_);
            throw new ObjectDoesNotExistException(this.path_, 2);
        }
        if (id.equals("CPF9802") || id.equals("CPF2189")) {
            Trace.log(2, "User is not authorized to object: " + this.path_);
            throw new AS400SecurityException(this.path_, 4);
        }
        if (id.equals("CPF9810") || id.equals("CPF2209") || id.equals("CPF2110")) {
            Trace.log(2, "Library does not exist: " + this.path_);
            throw new ObjectDoesNotExistException(this.path_, 1);
        }
        if (id.equals("CPF9820") || id.equals("CPF2182")) {
            Trace.log(2, "User is not authorized to library: " + this.path_);
            throw new AS400SecurityException(this.path_, 3);
        }
        if (id.equals("CPF2283")) {
            String authorizationListName = "/QSYS.LIB/" + this.converter_.byteArrayToString(messageList[0].getSubstitutionData()).trim() + ".AUTL";
            Trace.log(2, "Object does not exist: " + authorizationListName);
            throw new ObjectDoesNotExistException(authorizationListName, 2);
        }
        return new AS400Exception(messageList);
    }

    public void close() throws IOException {
        if (this.file_ != null) {
            this.file_.close();
            this.file_ = null;
        }
    }

    public void create(byte[] domainBytes, int length, boolean replace, String extendedAttribute, byte initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray;
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] programParameterArray = new ProgramParameter[11];
        programParameterArray[0] = this.nameParameter_;
        programParameterArray[1] = new ProgramParameter(UserSpaceImplRemote.padByteArray(this.converter_.stringToByteArray(extendedAttribute), 10));
        programParameterArray[2] = new ProgramParameter(BinaryConverter.intToByteArray(length));
        programParameterArray[3] = new ProgramParameter(new byte[]{initialValue});
        programParameterArray[4] = new ProgramParameter(UserSpaceImplRemote.padByteArray(this.converter_.stringToByteArray(authority), 10));
        programParameterArray[5] = new ProgramParameter(UserSpaceImplRemote.padByteArray(this.converter_.stringToByteArray(textDescription), 50));
        if (replace) {
            byte[] byArray2 = new byte[10];
            byArray2[0] = 92;
            byArray2[1] = -24;
            byArray2[2] = -59;
            byArray2[3] = -30;
            byArray2[4] = 64;
            byArray2[5] = 64;
            byArray2[6] = 64;
            byArray2[7] = 64;
            byArray2[8] = 64;
            byArray = byArray2;
            byArray2[9] = 64;
        } else {
            byte[] byArray3 = new byte[10];
            byArray3[0] = 92;
            byArray3[1] = -43;
            byArray3[2] = -42;
            byArray3[3] = 64;
            byArray3[4] = 64;
            byArray3[5] = 64;
            byArray3[6] = 64;
            byArray3[7] = 64;
            byArray3[8] = 64;
            byArray = byArray3;
            byArray3[9] = 64;
        }
        programParameterArray[6] = new ProgramParameter(byArray);
        programParameterArray[7] = this.errorCodeParameter_;
        programParameterArray[8] = new ProgramParameter(domainBytes);
        programParameterArray[9] = new ProgramParameter(new byte[]{0, 0, 0, 0});
        programParameterArray[10] = new ProgramParameter(new byte[]{length > 0xFFF000 ? (byte)-16 : -15});
        ProgramParameter[] parameters = programParameterArray;
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSCRTUS", parameters, this.runOnThread_)) {
            throw this.buildException();
        }
    }

    private static byte[] padByteArray(byte[] bytes, int length) {
        byte[] result = new byte[length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        for (int i = bytes.length; i < length; ++i) {
            result[i] = 64;
        }
        return result;
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] parameters = new ProgramParameter[]{this.nameParameter_, this.errorCodeParameter_};
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSDLTUS", parameters, this.runOnThread_)) {
            throw this.buildException();
        }
    }

    public byte getInitialValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.retrieveAttributes()[13];
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return BinaryConverter.byteArrayToInt(this.retrieveAttributes(), 8);
    }

    public boolean isAutoExtendible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.retrieveAttributes()[12] == -15;
    }

    protected byte[] retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(24), new ProgramParameter(new byte[]{0, 0, 0, 24}), new ProgramParameter(new byte[]{-30, -41, -61, -63, -16, -15, -16, -16}), this.nameParameter_, this.errorCodeParameter_};
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSRUSAT", parameters, this.runOnThread_)) {
            throw this.buildException();
        }
        return parameters[0].getOutputData();
    }

    public int read(byte[] dataBuffer, int userSpaceOffset, int dataOffset, int length) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.mustUseProgramCall_) {
            this.setupNameParameter();
            ProgramParameter[] parameters = new ProgramParameter[]{this.nameParameter_, new ProgramParameter(BinaryConverter.intToByteArray(userSpaceOffset + 1)), new ProgramParameter(BinaryConverter.intToByteArray(length)), new ProgramParameter(length)};
            if (this.remoteCommand_ == null) {
                this.setupRemoteCommand();
            }
            if (!this.remoteCommand_.runProgram("QSYS", "QUSRTVUS", parameters, this.runOnThread_)) {
                String id = this.remoteCommand_.getMessageList()[0].getID();
                if (!id.equals("CPF3C14") && !id.equals("CPD3C14")) {
                    throw this.buildException();
                }
                int userSpaceLength = this.getLength();
                if (userSpaceLength < userSpaceOffset) {
                    return -1;
                }
                length = userSpaceLength - userSpaceOffset;
                try {
                    parameters[2].setInputData(BinaryConverter.intToByteArray(length));
                    parameters[3].setOutputDataLength(length);
                }
                catch (PropertyVetoException e) {
                    Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
                    throw new InternalErrorException(10);
                }
                if (!this.remoteCommand_.runProgram("QSYS", "QUSRTVUS", parameters, this.runOnThread_)) {
                    throw this.buildException();
                }
            }
            System.arraycopy(parameters[3].getOutputData(), 0, dataBuffer, dataOffset, length);
            return length;
        }
        this.setupFile();
        this.file_.seek(userSpaceOffset);
        return this.file_.read(dataBuffer, dataOffset, length, false);
    }

    public void setAutoExtendible(boolean autoExtendibility) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.changeAttributes(new byte[]{0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 1, autoExtendibility ? (byte)-15 : -16});
    }

    public void setInitialValue(byte initialValue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.changeAttributes(new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, initialValue});
    }

    public void setLength(int length) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attributeBytes = new byte[]{0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 0};
        BinaryConverter.intToByteArray(length, attributeBytes, 12);
        this.changeAttributes(attributeBytes);
    }

    protected void changeAttributes(byte[] attributeBytes) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(10), this.nameParameter_, new ProgramParameter(attributeBytes), this.errorCodeParameter_};
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSCUSAT", parameters, this.runOnThread_)) {
            throw this.buildException();
        }
    }

    public void setProperties(AS400Impl system, String path, String name, String library, boolean mustUseProgramCall, boolean mustUseSockets) {
        this.system_ = (AS400ImplRemote)system;
        this.path_ = path;
        this.library_ = library;
        this.name_ = name;
        this.mustUseProgramCall_ = mustUseProgramCall;
        this.mustUseSockets_ = mustUseSockets;
    }

    private void setupErrorCodeParameter() {
        if (this.errorCodeParameter_ == null) {
            this.errorCodeParameter_ = new ProgramParameter(new byte[8]);
        }
    }

    private synchronized void setupFile() throws AS400SecurityException, IOException, ObjectDoesNotExistException {
        if (this.file_ == null) {
            try {
                IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();
                fd_.initialize(0L, this, this.path_, -1, this.system_);
                this.file_ = new IFSRandomAccessFileImplRemote();
                this.file_.setFD(fd_);
                this.file_.setMode("rw");
                this.file_.setExistenceOption(3);
                this.file_.open();
            }
            catch (FileNotFoundException e) {
                Trace.log(2, "Object does not exist: " + this.path_, (Throwable)e);
                throw new ObjectDoesNotExistException(this.path_, 2);
            }
            catch (ExtendedIOException e) {
                if (e.getReturnCode() == 5) {
                    Trace.log(2, "User is not authorized to object: " + this.path_, (Throwable)e);
                    throw new AS400SecurityException(this.path_, 4);
                }
                if (e.getReturnCode() == 23 && this.library_.equals("QTEMP")) {
                    Trace.log(4, "File server cannot access QTEMP, use mustUseProgramCall option.");
                }
                Trace.log(2, "Error opening file: " + this.path_, (Throwable)e);
                throw e;
            }
        }
    }

    private synchronized void setupNameParameter() throws IOException {
        if (this.nameParameter_ == null) {
            this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
            byte[] qualifiedUserSpaceName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            this.converter_.stringToByteArray(this.name_, qualifiedUserSpaceName, 0);
            this.converter_.stringToByteArray(this.library_, qualifiedUserSpaceName, 10);
            this.nameParameter_ = new ProgramParameter(qualifiedUserSpaceName);
        }
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.remoteCommand_ == null) {
            String propVal;
            boolean runningNatively = false;
            if (this.system_.canUseNativeOptimizations()) {
                try {
                    this.remoteCommand_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                    runningNatively = true;
                }
                catch (Throwable e) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", e);
                }
            }
            if (this.remoteCommand_ == null) {
                this.remoteCommand_ = new RemoteCommandImplRemote();
            }
            this.remoteCommand_.setSystem(this.system_);
            if (!(!runningNatively || this.mustUseSockets_ || (propVal = ProgramCall.getThreadSafetyProperty()) != null && propVal.equals("false"))) {
                this.runOnThread_ = RemoteCommandImpl.ON_THREAD;
            }
        }
    }

    public void write(byte[] dataBuffer, int userSpaceOffset, int dataOffset, int length, int force) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.mustUseProgramCall_) {
            this.setupNameParameter();
            byte[] inputData = new byte[length];
            System.arraycopy(dataBuffer, dataOffset, inputData, 0, length);
            ProgramParameter[] parameters = new ProgramParameter[]{this.nameParameter_, new ProgramParameter(BinaryConverter.intToByteArray(userSpaceOffset + 1)), new ProgramParameter(BinaryConverter.intToByteArray(length)), new ProgramParameter(inputData), new ProgramParameter(new byte[]{(byte)(0xF0 | force)})};
            if (this.remoteCommand_ == null) {
                this.setupRemoteCommand();
            }
            if (!this.remoteCommand_.runProgram("QSYS", "QUSCHGUS", parameters, this.runOnThread_)) {
                throw this.buildException();
            }
        } else {
            this.setupFile();
            this.file_.seek(userSpaceOffset);
            switch (force) {
                case 2: {
                    this.file_.setForceToStorage(true);
                    break;
                }
                case 1: {
                    this.file_.setForceToStorage(false);
                }
            }
            this.file_.writeBytes(dataBuffer, dataOffset, length);
        }
    }
}

