/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlMessageLog;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlStruct;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class PcmlProgram
extends PcmlDocNode {
    static final long serialVersionUID = 7278339230268347333L;
    private static final String[] PROGRAMATTRIBUTES = new String[]{"name", "path", "parseorder", "entrypoint", "returnvalue", "threadsafe", "epccsid"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 3;
    private static final int VERSION_2_ATTRIBUTE_COUNT = 5;
    private static final int VERSION_3_ATTRIBUTE_COUNT = 6;
    private static final int VERSION_4_ATTRIBUTE_COUNT = 7;
    private String m_Path;
    private String m_Parseorder;
    private String m_EntrypointStr;
    private String m_ReturnvalueStr;
    private String m_ThreadsafeStr;
    private boolean m_ThreadsafeOverride;
    private boolean m_ThreadsafeOverrideCalled;
    private String m_EpCcsidStr;
    private int m_EpCcsid;
    private ProgramCall m_pgmCall;
    private boolean m_pgmRc;
    private int m_pgmCCSID;
    private AS400Message[] msgList;
    private int m_IntReturnValue;
    private int m_Errno;

    public PcmlProgram() {
        this.m_pgmRc = false;
        this.m_pgmCCSID = -1;
        this.msgList = null;
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        this.m_ThreadsafeOverrideCalled = false;
    }

    public PcmlProgram(PcmlAttributeList attrs) {
        super(attrs);
        this.setNodeType(2);
        this.m_pgmRc = false;
        this.m_pgmCCSID = -1;
        this.msgList = null;
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        this.m_ThreadsafeOverrideCalled = false;
        this.setPath(this.getAttributeValue("path"));
        this.setParseorder(this.getAttributeValue("parseorder"));
        this.setEntrypoint(this.getAttributeValue("entrypoint"));
        this.setReturnvalue(this.getAttributeValue("returnvalue"));
        this.setThreadsafe(this.getAttributeValue("threadsafe"));
        this.setEpCcsid(this.getAttributeValue("epccsid"));
    }

    public Object clone() {
        PcmlProgram node = (PcmlProgram)super.clone();
        node.m_pgmRc = false;
        node.m_pgmCCSID = -1;
        node.msgList = null;
        node.m_IntReturnValue = 0;
        node.m_Errno = 0;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        PcmlProgram pcmlProgram = this;
        synchronized (pcmlProgram) {
            boolean localPgmRc = this.m_pgmRc;
            int localPgmCCSID = this.m_pgmCCSID;
            AS400Message[] localMsgList = this.msgList;
            int localIntReturnValue = this.m_IntReturnValue;
            int localErrno = this.m_Errno;
            if (!this.getDoc().isSerializingWithData()) {
                this.m_pgmRc = false;
                this.m_pgmCCSID = -1;
                this.msgList = null;
                this.m_IntReturnValue = 0;
                this.m_Errno = 0;
            }
            out.defaultWriteObject();
            this.m_pgmRc = localPgmRc;
            this.m_pgmCCSID = localPgmCCSID;
            this.msgList = localMsgList;
            this.m_IntReturnValue = localIntReturnValue;
            this.m_Errno = localErrno;
        }
    }

    String getEntrypoint() {
        return this.m_EntrypointStr;
    }

    String getPath() {
        if (this.m_Path != null) {
            return this.m_Path;
        }
        return "/QSYS.LIB/" + this.getName() + ".PGM";
    }

    String getParseorder() {
        return this.m_Parseorder;
    }

    String getReturnvalue() {
        return this.m_ReturnvalueStr;
    }

    String getThreadsafe() {
        return this.m_ThreadsafeStr;
    }

    int getEpCcsid() {
        return this.m_EpCcsid;
    }

    String[] getAttributeList() {
        int returnCount = 0;
        if (this.getDoc().getVersion().compareTo("2.0") < 0) {
            returnCount = 3;
        } else if (this.getDoc().getVersion().compareTo("3.0") < 0) {
            returnCount = 5;
        } else if (this.getDoc().getVersion().compareTo("4.0") < 0) {
            returnCount = 6;
        } else {
            return PROGRAMATTRIBUTES;
        }
        String[] returnArray = new String[returnCount];
        System.arraycopy(PROGRAMATTRIBUTES, 0, returnArray, 0, returnCount);
        return returnArray;
    }

    boolean getThreadsafeOverride() {
        return this.m_ThreadsafeOverride;
    }

    void setEntrypoint(String entrypoint) {
        if (entrypoint == null || entrypoint.equals("")) {
            this.m_EntrypointStr = null;
            return;
        }
        this.m_EntrypointStr = entrypoint;
    }

    void setEpCcsid(String ccsid) {
        if (ccsid == null || ccsid.equals("")) {
            this.m_EpCcsidStr = null;
            this.m_EpCcsid = 0;
            return;
        }
        this.m_EpCcsidStr = ccsid;
        this.m_EpCcsid = Integer.parseInt(ccsid);
    }

    void setPath(String path) {
        this.m_Path = path;
    }

    void setParseorder(String parseorder) {
        if (parseorder == null || parseorder.equals("")) {
            this.m_Parseorder = null;
            return;
        }
        this.m_Parseorder = parseorder;
    }

    ProgramCall getProgramCall() {
        return this.m_pgmCall;
    }

    void setReturnvalue(String returnvalue) {
        if (returnvalue == null || returnvalue.equals("")) {
            this.m_ReturnvalueStr = null;
            return;
        }
        this.m_ReturnvalueStr = returnvalue;
    }

    void setThreadsafe(String threadsafe) {
        if (threadsafe == null || threadsafe.equals("")) {
            this.m_ThreadsafeStr = null;
            this.m_ThreadsafeOverride = false;
            return;
        }
        this.m_ThreadsafeOverride = threadsafe.equals("true");
        this.m_ThreadsafeStr = threadsafe;
    }

    void setThreadsafeOverride(boolean threadsafe) {
        this.m_ThreadsafeOverrideCalled = true;
        this.m_ThreadsafeOverride = threadsafe;
    }

    protected void checkAttributes() {
        super.checkAttributes();
        String parseorder = this.getParseorder();
        if (parseorder != null) {
            StringTokenizer tokens = new StringTokenizer(parseorder);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                String nodeName = this.getQualifiedName() + "." + token;
                PcmlNode node = this.getRootNode().getElement(nodeName);
                if (node == null) {
                    this.getDoc().addPcmlSpecificationError("PARSEORDER_NOT_FOUND", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", parseorder), nodeName, this.getBracketedTagName(), this.getNameForException()});
                    continue;
                }
                if (node.getParent() == this) continue;
                this.getDoc().addPcmlSpecificationError("PARSEORDER_NOT_CHILD", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", parseorder), nodeName, this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_EntrypointStr != null && this.getDoc().getVersion().compareTo("2.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), "2.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_ReturnvalueStr != null && this.getDoc().getVersion().compareTo("2.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("returnvalue", this.m_ReturnvalueStr), "2.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_ThreadsafeStr != null && this.getDoc().getVersion().compareTo("3.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("threadsafe", this.m_ThreadsafeStr), "3.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_EpCcsidStr != null && this.getDoc().getVersion().compareTo("4.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("epccsid", this.m_EpCcsidStr), "4.0", this.getBracketedTagName(), this.getNameForException()});
        }
    }

    public boolean callProgram(AS400 as400) throws AS400SecurityException, ObjectDoesNotExistException, InterruptedException, ErrorCompletingRequestException, IOException, PcmlException {
        String parseorder;
        byte[] bytes;
        PcmlDocNode child;
        PcmlDimensions noDimensions = new PcmlDimensions();
        Hashtable offsetStack = new Hashtable();
        if (this.getReturnvalue() != null && !this.getPath().toUpperCase().endsWith(".SRVPGM")) {
            throw new PcmlException("NOT_SRVPGM", new Object[]{PcmlProgram.makeQuotedAttr("returnvalue", this.m_ReturnvalueStr), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.getPath().toUpperCase().endsWith(".SRVPGM")) {
            if (this.getEntrypoint() == null) {
                throw new PcmlException("NO_ENTRYPOINT", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), this.getBracketedTagName(), this.getNameForException()});
            }
            if (this.getNbrChildren() > 7) {
                throw new PcmlException("TOO_MANY_PARMS", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), new Integer(7), this.getBracketedTagName(), this.getNameForException()});
            }
        } else if (this.getEntrypoint() != null) {
            throw new PcmlException("NOT_SRVPGM", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), this.getBracketedTagName(), this.getNameForException()});
        }
        this.m_pgmRc = false;
        this.msgList = null;
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        this.m_pgmCCSID = as400.getCcsid();
        int childNbr = 0;
        Enumeration children = this.getChildren();
        int nbrSupportedParms = 0;
        int passby = 2;
        ProgramParameter[] childParms = new ProgramParameter[this.getNbrChildren()];
        while (children.hasMoreElements()) {
            child = (PcmlDocNode)children.nextElement();
            int usage = child.getUsage();
            int outputSize = 0;
            boolean bSupportedAtVRM = false;
            bytes = null;
            switch (child.getNodeType()) {
                case 3: {
                    PcmlStruct structNode = (PcmlStruct)child;
                    if (!structNode.isSupportedAtHostVRM()) break;
                    bSupportedAtVRM = true;
                    passby = 2;
                    outputSize = structNode.getOutputsize(noDimensions);
                    if (usage != 2 && usage != 4) break;
                    ByteArrayOutputStream buf = new ByteArrayOutputStream(outputSize);
                    structNode.toBytes(buf, 0, noDimensions);
                    bytes = buf.toByteArray();
                    PcmlMessageLog.traceParameter(this.getPath(), child.getNameForException(), bytes);
                    break;
                }
                case 4: {
                    PcmlData dataNode = (PcmlData)child;
                    if (!dataNode.isSupportedAtHostVRM()) break;
                    bSupportedAtVRM = true;
                    passby = dataNode.getPassby();
                    outputSize = dataNode.getOutputsize(noDimensions);
                    if (usage != 2 && usage != 4) break;
                    ByteArrayOutputStream buf = new ByteArrayOutputStream(outputSize);
                    dataNode.toBytes(buf, 0, noDimensions);
                    bytes = buf.toByteArray();
                    PcmlMessageLog.traceParameter(this.getPath(), child.getNameForException(), bytes);
                    break;
                }
                default: {
                    throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(child.getNodeType()), child.getNameForException()});
                }
            }
            if (bSupportedAtVRM) {
                switch (usage) {
                    case 2: {
                        childParms[childNbr] = new ProgramParameter(passby, bytes);
                        break;
                    }
                    case 3: {
                        childParms[childNbr] = new ProgramParameter(passby, outputSize);
                        break;
                    }
                    case 4: {
                        childParms[childNbr] = new ProgramParameter(passby, bytes, outputSize);
                    }
                }
                ++nbrSupportedParms;
            } else {
                childParms[childNbr] = null;
            }
            ++childNbr;
        }
        ProgramParameter[] supportedParms = new ProgramParameter[nbrSupportedParms];
        int supportedParmNbr = 0;
        for (childNbr = 0; childNbr < this.getNbrChildren(); ++childNbr) {
            if (childParms[childNbr] == null) continue;
            supportedParms[supportedParmNbr++] = childParms[childNbr];
        }
        if (this.isServiceProgram()) {
            int rtnValType = this.m_ReturnvalueStr != null && this.m_ReturnvalueStr.equals("integer") ? 1 : 0;
            this.m_pgmCall = new ServiceProgramCall(as400, this.getPath(), this.getEntrypoint(), rtnValType, supportedParms);
            if (this.getEpCcsid() != 0) {
                try {
                    ((ServiceProgramCall)this.m_pgmCall).setProcedureName(this.getEntrypoint(), this.getEpCcsid());
                }
                catch (PropertyVetoException e) {}
            }
        } else {
            this.m_pgmCall = new ProgramCall(as400, this.getPath(), supportedParms);
        }
        if (this.m_ThreadsafeOverrideCalled || this.getThreadsafe() != null) {
            this.m_pgmCall.setThreadSafe(this.getThreadsafeOverride());
        }
        if (Trace.isTraceOn()) {
            Trace.log(7, "Submitting program call: " + this.m_pgmCall.getProgram() + " ...");
        }
        this.m_pgmRc = this.m_pgmCall.run();
        if (Trace.isTraceOn()) {
            Trace.log(7, "Completed program call: " + this.m_pgmCall.getProgram());
        }
        if (!this.m_pgmRc) {
            this.msgList = this.m_pgmCall.getMessageList();
            return this.m_pgmRc;
        }
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        if (this.isServiceProgram() && this.m_ReturnvalueStr != null && this.m_ReturnvalueStr.equals("integer")) {
            this.m_IntReturnValue = ((ServiceProgramCall)this.m_pgmCall).getIntegerReturnValue();
            this.m_Errno = ((ServiceProgramCall)this.m_pgmCall).getErrno();
        }
        if ((parseorder = this.getParseorder()) != null) {
            StringTokenizer tokens = new StringTokenizer(parseorder);
            Vector<PcmlNode> orderVector = new Vector<PcmlNode>(tokens.countTokens());
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                PcmlNode node = this.getRootNode().getElement(this.getQualifiedName() + "." + token);
                if (node == null) {
                    throw new PcmlException("PARSEORDER_NOT_FOUND", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", parseorder), token, this.getBracketedTagName(), this.getNameForException()});
                }
                if (node.getParent() != this) {
                    throw new PcmlException("PARSEORDER_NOT_CHILD", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", parseorder), token, this.getBracketedTagName(), this.getNameForException()});
                }
                if (node instanceof PcmlStruct) {
                    if (!((PcmlStruct)node).isSupportedAtHostVRM()) continue;
                    orderVector.addElement(node);
                    continue;
                }
                if (node instanceof PcmlData) {
                    if (!((PcmlData)node).isSupportedAtHostVRM()) continue;
                    orderVector.addElement(node);
                    continue;
                }
                orderVector.addElement(node);
            }
            children = orderVector.elements();
        } else {
            children = this.getChildren();
        }
        block18: while (children.hasMoreElements()) {
            child = (PcmlDocNode)children.nextElement();
            childNbr = child.getChildNbr();
            if (childParms[childNbr] == null || childParms[childNbr].getOutputDataLength() <= 0) continue;
            bytes = childParms[childNbr].getOutputData();
            PcmlMessageLog.traceParameter(this.getPath(), child.getNameForException(), bytes);
            switch (child.getNodeType()) {
                case 3: {
                    ((PcmlStruct)child).parseBytes(bytes, 0, offsetStack, new PcmlDimensions());
                    continue block18;
                }
                case 4: {
                    ((PcmlData)child).parseBytes(bytes, 0, offsetStack, new PcmlDimensions());
                    continue block18;
                }
            }
            throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(child.getNodeType()), child.getNameForException()});
        }
        return true;
    }

    int getProgramCCSID() {
        if (this.m_pgmCCSID == -1) {
            return 65535;
        }
        return this.m_pgmCCSID;
    }

    int getErrno() throws PcmlException {
        if (this.isServiceProgram()) {
            if (this.m_ReturnvalueStr.equals("integer")) {
                return this.m_Errno;
            }
            throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("returnvalue", "integer"), this.getBracketedTagName(), this.getNameForException()});
        }
        throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("entrypoint", ""), this.getBracketedTagName(), this.getNameForException()});
    }

    int getIntReturnValue() throws PcmlException {
        if (this.isServiceProgram()) {
            if (this.m_ReturnvalueStr.equals("integer")) {
                return this.m_IntReturnValue;
            }
            throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("returnvalue", "integer"), this.getBracketedTagName(), this.getNameForException()});
        }
        throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("entrypoint", ""), this.getBracketedTagName(), this.getNameForException()});
    }

    AS400Message[] getMessageList() {
        return this.msgList;
    }

    private boolean isServiceProgram() {
        return this.getEntrypoint() != null;
    }
}

