/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.resource.PagedListBuffer;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BufferedResourceList
extends ResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int numberOfPages_ = 5;
    private int pageSize_ = 20;
    private transient PagedListBuffer buffer_ = null;

    public BufferedResourceList() {
        this.initializeTransient();
    }

    public BufferedResourceList(Presentation presentation, ResourceMetaData[] attributeMetaData, ResourceMetaData[] selectionMetaData, ResourceMetaData[] sortMetaData) {
        super(presentation, attributeMetaData, selectionMetaData, sortMetaData);
        this.initializeTransient();
    }

    BufferedResourceList(Presentation presentation, ResourceMetaDataTable attributes, ResourceMetaDataTable selections, ResourceMetaDataTable sorts) {
        super(presentation, attributes, selections, sorts);
        this.initializeTransient();
    }

    public void close() throws ResourceException {
        super.close();
        this.buffer_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResourceAdded(Resource resource, long index) {
        BufferedResourceList bufferedResourceList = this;
        synchronized (bufferedResourceList) {
            this.buffer_.setResource(index, resource);
        }
        super.fireResourceAdded(resource, index);
    }

    public int getNumberOfPages() {
        return this.numberOfPages_;
    }

    public int getPageSize() {
        return this.pageSize_;
    }

    private void initializeTransient() {
    }

    public boolean isResourceAvailable(long index) throws ResourceException {
        boolean isAvailable = super.isResourceAvailable(index);
        return isAvailable && this.buffer_.getResource(index) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        super.open();
        BufferedResourceList bufferedResourceList = this;
        synchronized (bufferedResourceList) {
            this.buffer_ = new PagedListBuffer(this.numberOfPages_, this.pageSize_);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshContents() throws ResourceException {
        if (this.isOpen()) {
            this.buffer_.clear();
        }
        super.refreshContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resourceAt(long index) throws ResourceException {
        BufferedResourceList bufferedResourceList = this;
        synchronized (bufferedResourceList) {
            Resource resource = super.resourceAt(index);
            if (resource == null) {
                BufferedResourceList bufferedResourceList2 = this;
                synchronized (bufferedResourceList2) {
                    return this.buffer_.getResource(index);
                }
            }
            return resource;
        }
    }

    public void setNumberOfPages(int numberOfPages) {
        if (this.isOpen()) {
            throw new ExtendedIllegalStateException("open", 2);
        }
        if (numberOfPages <= 0) {
            throw new ExtendedIllegalArgumentException("numberOfPages", 2);
        }
        this.numberOfPages_ = numberOfPages;
    }

    public void setPageSize(int pageSize) {
        if (this.isOpen()) {
            throw new ExtendedIllegalStateException("open", 2);
        }
        if (pageSize <= 0) {
            throw new ExtendedIllegalArgumentException("pageSize", 2);
        }
        this.pageSize_ = pageSize;
    }
}

