/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramKeys;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

class ProgramKeyAttributeSetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String numberOfKeysDataName_ = "numberOfKeys";
    private static final String contentsDataName_ = "contents";
    private ProgramKeys attributeKeys_;
    private CharConverter charConverter_;
    private ProgramCallDocument document_;
    private String keysDataName_;
    private String programName_;
    private AS400 system_;

    public ProgramKeyAttributeSetter(AS400 system, ProgramCallDocument document, String programName, String keysDataName, ProgramKeys attributeKeys) {
        block7: {
            this.attributeKeys_ = null;
            this.charConverter_ = null;
            this.document_ = null;
            this.keysDataName_ = null;
            this.programName_ = null;
            this.system_ = null;
            if (system == null) {
                throw new NullPointerException("system");
            }
            if (document == null) {
                throw new NullPointerException("document");
            }
            if (programName == null) {
                throw new NullPointerException("programName");
            }
            if (keysDataName == null) {
                throw new NullPointerException("keysDataName");
            }
            if (attributeKeys == null) {
                throw new NullPointerException("attributeKeys");
            }
            this.document_ = document;
            this.keysDataName_ = keysDataName;
            this.programName_ = programName;
            this.attributeKeys_ = attributeKeys;
            this.system_ = system;
            try {
                this.charConverter_ = new CharConverter(system.getCcsid(), system);
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTraceOn()) break block7;
                Trace.log(2, "Error setting system on program attribute setter", (Throwable)e);
            }
        }
    }

    private static String pad(String value, int length) {
        StringBuffer buffer = new StringBuffer(value);
        for (int i = value.length(); i < length; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] attributeIDs, Object[] values, int[] bidiStringTypes) throws ResourceException {
        if (attributeIDs == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (attributeIDs.length != values.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (this.charConverter_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (attributeIDs.length == 0) {
            return;
        }
        try {
            ProgramKeyAttributeSetter programKeyAttributeSetter = this;
            synchronized (programKeyAttributeSetter) {
                Object value;
                Hashtable<Integer, Object> actualValues = new Hashtable<Integer, Object>();
                Hashtable<Integer, Integer> stringTypes = new Hashtable<Integer, Integer>();
                for (int i = 0; i < attributeIDs.length; ++i) {
                    int[] keys = this.attributeKeys_.getKeys(attributeIDs[i]);
                    int[] types = this.attributeKeys_.getTypes(attributeIDs[i]);
                    int[] lengths = this.attributeKeys_.getLengths(attributeIDs[i]);
                    ValueMap[] valueMaps = this.attributeKeys_.getValueMaps(attributeIDs[i]);
                    block10: for (int j = 0; j < keys.length; ++j) {
                        value = values[i];
                        if (valueMaps != null && valueMaps[j] != null) {
                            value = valueMaps[j].ltop(values[i], this.system_);
                        }
                        switch (types[j]) {
                            case 0: {
                                actualValues.put(new Integer(keys[j]), value);
                                continue block10;
                            }
                            case 1: {
                                Integer key = new Integer(keys[j]);
                                actualValues.put(key, ProgramKeyAttributeSetter.pad((String)value, lengths[j]));
                                stringTypes.put(key, new Integer(bidiStringTypes[i]));
                                continue block10;
                            }
                            default: {
                                if (!Trace.isTraceOn()) continue block10;
                                Trace.log(2, "Error setting attribute " + attributeIDs[i] + ", type = " + types[i]);
                            }
                        }
                    }
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.programName_);
                buffer.append('.');
                buffer.append(this.keysDataName_);
                buffer.append('.');
                this.document_.setIntValue(buffer.toString() + numberOfKeysDataName_, actualValues.size());
                String programAndContentsDataName = buffer.toString() + contentsDataName_;
                Enumeration keys = actualValues.keys();
                int i = 0;
                while (keys.hasMoreElements()) {
                    Integer key = (Integer)keys.nextElement();
                    int[] indices = new int[]{i};
                    value = actualValues.get(key);
                    Integer stringType = (Integer)stringTypes.get(key);
                    this.document_.setIntValue(programAndContentsDataName + ".key", indices, key);
                    if (value instanceof Integer) {
                        this.document_.setIntValue(programAndContentsDataName + ".lengthOfAttributeInformation", indices, 20);
                        this.document_.setValue(programAndContentsDataName + ".type", indices, "B");
                        this.document_.setIntValue(programAndContentsDataName + ".length", indices, 4);
                        this.document_.setValue(programAndContentsDataName + ".data", indices, BinaryConverter.intToByteArray((Integer)value));
                    } else if (value instanceof String) {
                        int length = ((String)value).length();
                        this.document_.setIntValue(programAndContentsDataName + ".lengthOfAttributeInformation", indices, length + 16);
                        this.document_.setValue(programAndContentsDataName + ".type", indices, "C");
                        this.document_.setIntValue(programAndContentsDataName + ".length", indices, length);
                        this.document_.setValue(programAndContentsDataName + ".data", indices, this.charConverter_.stringToByteArray((String)value, stringType));
                    } else if (Trace.isTraceOn()) {
                        Trace.log(2, "Error setting attribute with key " + key + ", value class = " + value.getClass());
                    }
                    ++i;
                }
            }
            boolean success = this.document_.callProgram(this.programName_);
            if (!success) {
                throw new ResourceException(this.document_.getMessageList(this.programName_));
            }
        }
        catch (PcmlException e) {
            throw new ResourceException(e);
        }
    }
}

