/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ReturnCodeException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import java.io.IOException;
import java.util.ResourceBundle;

public class ResourceException
extends Exception
implements ReturnCodeException {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static ResourceBundle resourceBundle_ = ResourceBundle.getBundle("com.ibm.as400.resource.ResourceMRI");
    private Throwable exception_ = null;
    private boolean expected_ = false;
    private AS400Message[] messageList_ = null;
    private int returnCode_ = 6;
    public static final int ATTRIBUTES_NOT_RETURNED = 1;
    public static final int ATTRIBUTES_NOT_SET = 2;
    public static final int MESSAGES_RETURNED = 3;
    public static final int OPERATION_FAILED = 4;
    public static final int OPERATION_NOT_SUPPORTED = 5;
    public static final int UNKNOWN_ERROR = 6;
    public static final int AUTHORITY_INSUFFICIENT = 7;
    public static final int ATTRIBUTE_READ_ONLY = 8;

    public ResourceException() {
    }

    public ResourceException(int returnCode) {
        super(ResourceException.buildMessage(returnCode, null));
        this.returnCode_ = returnCode;
    }

    public ResourceException(Throwable exception) {
        super(exception instanceof PcmlException ? ((PcmlException)exception).getLocalizedMessage() : exception.getMessage());
        this.exception_ = exception;
        if (Trace.isTraceOn()) {
            Trace.log(2, "ResourceException was thrown", exception);
        }
    }

    public ResourceException(AS400Message[] messageList) {
        super(ResourceException.buildMessage(3, messageList));
        this.returnCode_ = 3;
        this.messageList_ = messageList;
        if (Trace.isTraceOn()) {
            for (int i = 0; i < messageList.length; ++i) {
                Trace.log(2, messageList[i].toString());
            }
        }
    }

    public ResourceException(int returnCode, Throwable exception) {
        super(ResourceException.buildMessage(returnCode, null));
        this.exception_ = exception;
        this.returnCode_ = returnCode;
        if (Trace.isTraceOn()) {
            Trace.log(2, "ResourceException was thrown", exception);
        }
    }

    public ResourceException(int returnCode, Throwable exception, boolean expected) {
        super(ResourceException.buildMessage(returnCode, null));
        this.exception_ = exception;
        this.expected_ = expected;
        this.returnCode_ = returnCode;
    }

    private static String buildMessage(int returnCode, AS400Message[] messageList) {
        String mriKey;
        switch (returnCode) {
            case 1: {
                mriKey = "EXC_ATTRIBUTES_NOT_RETURNED";
                break;
            }
            case 2: {
                mriKey = "EXC_ATTRIBUTES_NOT_SET";
                break;
            }
            case 3: {
                if (messageList != null && messageList.length > 0) {
                    return messageList[0].getText();
                }
                mriKey = "EXC_MESSAGES_RETURNED";
                break;
            }
            case 4: {
                mriKey = "EXC_OPERATION_FAILED";
                break;
            }
            case 5: {
                mriKey = "EXC_OPERATION_NOT_SUPPORTED";
                break;
            }
            case 7: {
                mriKey = "EXC_AUTHORITY_INSUFFICIENT";
                break;
            }
            case 8: {
                mriKey = "EXC_ATTRIBUTE_READ_ONLY";
                break;
            }
            default: {
                mriKey = "EXC_UNKNOWN_ERROR";
            }
        }
        return resourceBundle_.getString(mriKey);
    }

    public Throwable getException() {
        return this.exception_;
    }

    public AS400Message[] getMessageList() {
        if (this.exception_ instanceof ResourceException) {
            return ((ResourceException)this.exception_).getMessageList();
        }
        return this.messageList_;
    }

    public int getReturnCode() {
        if (this.exception_ instanceof ResourceException) {
            return ((ResourceException)this.exception_).getReturnCode();
        }
        return this.returnCode_;
    }

    public boolean isExpected() {
        return this.expected_;
    }

    public void unwrap() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Throwable x = this.exception_;
        while (x != null && x instanceof PcmlException) {
            x = ((PcmlException)x).getException();
        }
        if (x == null) {
            x = this.exception_;
        }
        if (x instanceof AS400SecurityException) {
            throw (AS400SecurityException)x;
        }
        if (x instanceof ErrorCompletingRequestException) {
            throw (ErrorCompletingRequestException)x;
        }
        if (x instanceof InterruptedException) {
            throw (InterruptedException)x;
        }
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (x instanceof ObjectDoesNotExistException) {
            throw (ObjectDoesNotExistException)x;
        }
        if (x instanceof ResourceException) {
            ((ResourceException)this.exception_).unwrap();
        }
        if (x instanceof RuntimeException) {
            throw (RuntimeException)x;
        }
        if (this.messageList_ != null) {
            throw new AS400Exception(this.messageList_);
        }
        throw new InternalErrorException(10);
    }
}

