/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class Find
extends WindowAdapter
implements KeyListener {
    private JTextArea ta;
    private JFrame find;
    private JButton fnext;
    private JButton cancel;
    private boolean isClosed = false;
    private JCheckBox casebox;
    private JCheckBox wrapbox;
    private JCheckBox reverse;
    private JTextField input;
    private int index = 0;
    private String search = "";

    public Find(JTextArea ta) {
        this.ta = ta;
        this.createDialog();
    }

    public void toFront() {
        this.find.toFront();
    }

    private void createDialog() {
        if (this.find != null) {
            this.find.toFront();
            return;
        }
        this.find = new JFrame(ResourceBundleLoader_ct.getText("Find"));
        JPanel pnl = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        pnl.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.input = new JTextField(30);
        this.fnext = new JButton(ResourceBundleLoader_ct.getText("FindNext"));
        this.fnext.addKeyListener(this);
        this.cancel = new JButton(ResourceBundleLoader_ct.getText("Cancel"));
        this.cancel.addKeyListener(this);
        this.casebox = new JCheckBox(ResourceBundleLoader_ct.getText("MatchCase"), true);
        this.wrapbox = new JCheckBox(ResourceBundleLoader_ct.getText("WrapSearch"), true);
        this.reverse = new JCheckBox(ResourceBundleLoader_ct.getText("Reverse"), false);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = -1;
        c.gridheight = -1;
        gridbag.setConstraints(this.input, c);
        pnl.add(this.input);
        c.fill = 1;
        c.gridheight = 2;
        c.gridwidth = 0;
        c.gridheight = -1;
        gridbag.setConstraints(this.fnext, c);
        pnl.add(this.fnext);
        this.fnext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Find.this.findnext(Find.this.input.getText());
            }
        });
        pnl.add(this.wrapbox);
        pnl.add(this.casebox);
        c.gridwidth = -1;
        c.gridheight = 0;
        gridbag.setConstraints(this.reverse, c);
        pnl.add(this.reverse);
        c.gridheight = 2;
        c.gridwidth = 0;
        c.gridheight = 0;
        gridbag.setConstraints(this.cancel, c);
        pnl.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Find.this.close();
            }
        });
        this.find.getContentPane().add(pnl);
        this.find.addWindowListener(this);
        this.find.setSize(400, 100);
        this.find.setVisible(true);
        this.find.invalidate();
        this.find.validate();
        this.find.repaint();
    }

    public void findnext(String search) {
        int tmp = 0;
        this.search = search;
        String searchText = this.ta.getText();
        if (!this.casebox.isSelected()) {
            searchText = searchText.toLowerCase();
            search = search.toLowerCase();
        }
        if (search != null) {
            if (search.length() == 0) {
                CommTrace.error(this.find, "Error", "No String specified");
            } else {
                tmp = this.reverse.isSelected() ? searchText.lastIndexOf(search, this.index - search.length()) : searchText.indexOf(search, this.index + search.length());
                if (tmp != -1) {
                    this.ta.select(tmp, tmp + search.length());
                    this.index = tmp;
                } else {
                    if (this.index != 0 && this.wrapbox.isSelected()) {
                        this.index = 0;
                        this.findnext(search);
                    } else {
                        CommTrace.error(this.find, "Error", "Text not found");
                    }
                    tmp = 0;
                }
            }
        }
        this.index = tmp;
        this.find.invalidate();
        this.find.validate();
        this.find.repaint();
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this.find) {
            this.close();
        }
    }

    public void close() {
        this.isClosed = true;
        this.find.setVisible(false);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (e.getSource() == this.fnext) {
            if (keyCode == 10) {
                this.findnext(this.input.getText());
            }
        } else if (e.getSource() == this.cancel && keyCode == 10) {
            this.isClosed = true;
            this.find.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

