/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import java.awt.Toolkit;
import javax.swing.ProgressMonitor;

class Progress
implements Runnable {
    private ProgressMonitor progressMonitor;
    private String msg;
    private String file;
    private String endmsg;
    private int total;
    private Thread progThread_;
    private static final String CLASS = "Progress";

    public Progress(String action, int total, String description) {
        this.total = total;
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Progress.Progress() Initializing Progress Dialog");
        }
        this.progressMonitor = new ProgressMonitor(null, action, "", 0, total);
        this.msg = action;
        this.endmsg = "% of " + total + description;
    }

    public void updateProgress(int num) {
        this.progressMonitor.setProgress(num);
        this.progressMonitor.setNote((int)((long)num * 100L / (long)this.total) + this.endmsg);
    }

    public Thread getThread() {
        return this.progThread_;
    }

    public void setThread(Thread tr) {
        this.progThread_ = tr;
    }

    public void run() {
        Thread myThread = Thread.currentThread();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Progress.run() Progress Dialog.getMillisToPopup():" + this.progressMonitor.getMillisToPopup());
        }
        while (this.progThread_ == myThread) {
            if (this.progressMonitor.isCanceled()) {
                this.progressMonitor.close();
                this.progThread_ = null;
                Toolkit.getDefaultToolkit().beep();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.progThread_ = null;
        this.progressMonitor.close();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Progress.run() Closing Progress Dialog");
        }
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }
}

