/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AS400ListModel;
import com.ibm.as400.vaccess.DoubleClickAdapter;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PopupMenuAdapter;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class AS400ListPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    boolean allowActions_ = false;
    boolean confirm_ = true;
    JList list_ = null;
    AS400ListModel model_ = new AS400ListModel();
    private transient VActionContext actionContext_;
    private transient DoubleClickAdapter doubleClickAdapter_;
    private transient PopupMenuAdapter popupMenuAdapter_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public AS400ListPane() {
        this.list_ = new JList(this.model_);
        this.list_.setCellRenderer(new VObjectCellRenderer());
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.list_));
        this.initializeTransient();
    }

    public AS400ListPane(VNode root) {
        this();
        if (root == null) {
            throw new NullPointerException("root");
        }
        try {
            this.model_.setRoot(root);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.addListSelectionListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public VActionContext getActionContext() {
        return this.actionContext_;
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public boolean getConfirm() {
        return this.confirm_;
    }

    public ListModel getModel() {
        return this.model_;
    }

    public VNode getRoot() {
        return this.model_.getRoot();
    }

    public VObject getSelectedObject() {
        VObject selectedObject = null;
        int selectedIndex = this.list_.getSelectedIndex();
        if (selectedIndex >= 0) {
            selectedObject = (VObject)this.model_.getElementAt(selectedIndex);
        }
        return selectedObject;
    }

    public VObject[] getSelectedObjects() {
        int[] selectedIndices = this.list_.getSelectedIndices();
        int selectedCount = selectedIndices.length;
        VObject[] selectedObjects = new VObject[selectedCount];
        for (int i = 0; i < selectedCount; ++i) {
            selectedObjects[i] = (VObject)this.model_.getElementAt(selectedIndices[i]);
        }
        return selectedObjects;
    }

    public ListSelectionModel getSelectionModel() {
        return this.list_.getSelectionModel();
    }

    public int getVisibleRowCount() {
        return this.list_.getVisibleRowCount();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.model_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.list_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.actionContext_ = new VActionContext_();
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.list_));
        VPane_ pane = new VPane_();
        this.doubleClickAdapter_ = new DoubleClickAdapter(pane, this.actionContext_);
        this.popupMenuAdapter_ = new PopupMenuAdapter(pane, this.actionContext_);
    }

    public boolean isSelected(VObject object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        Object[] selectedObjects = this.list_.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            if ((VObject)selectedObjects[i] != object) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.list_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void setAllowActions(boolean allowActions) {
        if (this.allowActions_ != allowActions) {
            this.allowActions_ = allowActions;
            if (this.allowActions_) {
                this.list_.addMouseListener(this.popupMenuAdapter_);
                this.list_.addMouseListener(this.doubleClickAdapter_);
            } else {
                this.list_.removeMouseListener(this.popupMenuAdapter_);
                this.list_.removeMouseListener(this.doubleClickAdapter_);
            }
        }
    }

    public void setConfirm(boolean confirm) {
        this.confirm_ = confirm;
    }

    public void setRoot(VNode root) throws PropertyVetoException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.list_.clearSelection();
        this.model_.setRoot(root);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel oldSelectionModel = this.list_.getSelectionModel();
        oldSelectionModel.removeListSelectionListener(this.listSelectionEventSupport_);
        this.list_.setSelectionModel(selectionModel);
        selectionModel.addListSelectionListener(this.listSelectionEventSupport_);
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.list_.setVisibleRowCount(visibleRowCount);
    }

    public void sort(Object[] propertyIdentifiers, boolean[] orders) {
        if (propertyIdentifiers == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (orders == null) {
            throw new NullPointerException("orders");
        }
        this.model_.sort(propertyIdentifiers, orders);
    }

    private class VPane_
    implements VPane,
    Serializable {
        private VPane_() {
        }

        public VObject getObjectAt(Point point) {
            VObject object = null;
            int row = AS400ListPane.this.list_.locationToIndex(point);
            if (row != -1) {
                object = (VObject)AS400ListPane.this.model_.getElementAt(row);
            }
            return object;
        }

        public VNode getRoot() {
            return AS400ListPane.this.getRoot();
        }

        public void setRoot(VNode root) throws PropertyVetoException {
            AS400ListPane.this.setRoot(root);
        }
    }

    private class VActionContext_
    implements VActionContext,
    Serializable {
        private VActionContext_() {
        }

        public boolean getConfirm() {
            return AS400ListPane.this.confirm_;
        }

        public Frame getFrame() {
            return VUtilities.getFrame(AS400ListPane.this);
        }

        public CellEditor startEditing(VObject object, Object propertyIdentifier) {
            if (object == null) {
                throw new NullPointerException("object");
            }
            if (propertyIdentifier == null) {
                throw new NullPointerException("propertyIdentifier");
            }
            return null;
        }
    }
}

