/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.TreeModelEventSupport;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AS400TreeModel
implements TreeModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    VNode root_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectListener objectListener_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    transient TreeModelEventSupport treeModelEventSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public AS400TreeModel() {
        this.initializeTransient();
    }

    public AS400TreeModel(VNode root) {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.root_ = root;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.treeModelEventSupport_.addTreeModelListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Object getChild(Object parent, int index) {
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof VNode)) {
            return null;
        }
        int childCount = ((VNode)parent).getChildCount();
        if (index < 0 || index >= childCount) {
            return null;
        }
        return ((VNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        if (!(parent instanceof VNode)) {
            return 0;
        }
        return ((VNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        if (!(parent instanceof VNode)) {
            return -1;
        }
        if (child == null) {
            return -1;
        }
        if (!(child instanceof VNode)) {
            return -1;
        }
        return ((VNode)parent).getIndex((VNode)child);
    }

    public TreePath getPath(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof VNode)) {
            return null;
        }
        Vector<VNode> pathV = new Vector<VNode>();
        for (TreeNode i = (VNode)object; i != null; i = i.getParent()) {
            pathV.insertElementAt((VNode)i, 0);
        }
        Object[] path = new TreeNode[pathV.size()];
        pathV.copyInto(path);
        return new TreePath(path);
    }

    public Object getRoot() {
        return this.root_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.treeModelEventSupport_ = new TreeModelEventSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.root_ != null) {
            this.root_.addErrorListener(this.errorEventSupport_);
            this.root_.addVObjectListener(this.objectListener_);
            this.root_.addWorkingListener(this.workingEventSupport_);
        }
    }

    public boolean isLeaf(Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof VNode)) {
            return true;
        }
        return ((VNode)object).isLeaf();
    }

    public void load() {
        if (this.root_ != null) {
            this.root_.load();
        }
        this.treeModelEventSupport_.fireTreeStructureChanged(this.getPath(this.root_));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.treeModelEventSupport_.removeTreeModelListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setRoot(Object root) throws PropertyVetoException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        VNode oldValue = this.root_;
        VNode newValue = (VNode)root;
        this.vetoableChangeSupport_.fireVetoableChange("root", oldValue, newValue);
        if (oldValue != newValue) {
            if (oldValue != null) {
                oldValue.removeErrorListener(this.errorEventSupport_);
                oldValue.removeVObjectListener(this.objectListener_);
                oldValue.removeWorkingListener(this.workingEventSupport_);
            }
            newValue.addErrorListener(this.errorEventSupport_);
            newValue.addVObjectListener(this.objectListener_);
            newValue.addWorkingListener(this.workingEventSupport_);
            this.root_ = newValue;
            this.treeModelEventSupport_.fireTreeStructureChanged(this.getPath(this.root_));
        }
        this.propertyChangeSupport_.firePropertyChange("root", oldValue, newValue);
    }

    public void valueForPathChanged(TreePath path, Object value) {
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent event) {
            VObject object = event.getObject();
            if (object != null) {
                if (!event.isDuringLoad()) {
                    object.load();
                }
                if (object instanceof VNode) {
                    AS400TreeModel.this.treeModelEventSupport_.fireTreeStructureChanged(AS400TreeModel.this.getPath(object));
                    VNode parent = (VNode)((VNode)object).getParent();
                    if (parent != null) {
                        TreePath path = AS400TreeModel.this.getPath(parent);
                        int index = parent.getIndex((VNode)object);
                        if (index >= 0) {
                            AS400TreeModel.this.treeModelEventSupport_.fireTreeNodesChanged(path, index, object);
                        }
                    }
                }
            }
        }

        public void objectCreated(VObjectEvent event) {
            VObject object = event.getObject();
            VNode parent = event.getParent();
            if (parent != null && object instanceof VNode) {
                int index = parent.getIndex((VNode)object);
                AS400TreeModel.this.treeModelEventSupport_.fireTreeNodesInserted(AS400TreeModel.this.getPath(parent), index, object);
            }
        }

        public void objectDeleted(VObjectEvent event) {
            VObject object = event.getObject();
            if (object instanceof VNode) {
                VNode parent = (VNode)((VNode)object).getParent();
                if (parent == null) {
                    AS400TreeModel.this.treeModelEventSupport_.fireTreeNodesRemoved(null, 0, object);
                } else {
                    int index = parent.getIndex((VNode)object);
                    if (index >= 0) {
                        AS400TreeModel.this.treeModelEventSupport_.fireTreeNodesRemoved(AS400TreeModel.this.getPath(parent), index, object);
                    }
                }
            }
        }
    }
}

