/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class IFSFileSystemView
extends FileSystemView {
    private static final boolean DEBUG = false;
    private AS400 system_;
    private static final String ROOT_PATH = IFSJavaFile.separator;
    private static final String DEFAULT_FOLDER_NAME = "NewFolder";
    private static final String NEW_FOLDER_STRING0 = UIManager.getString("FileChooser.other.newFolder");
    private static final String NEW_FOLDER_NEXT_STRING0 = UIManager.getString("FileChooser.other.newFolder.subsequent");
    private static final String NEW_FOLDER_STRING = NEW_FOLDER_STRING0 == null || NEW_FOLDER_STRING0.length() == 0 ? "NewFolder" : NEW_FOLDER_STRING0;
    private static final String NEW_FOLDER_NEXT_STRING = NEW_FOLDER_NEXT_STRING0 == null || NEW_FOLDER_NEXT_STRING0.length() == 0 ? "NewFolder.{0}" : NEW_FOLDER_NEXT_STRING0;
    private static Icon serverIcon32_ = ResourceLoader.getIcon("AS40032.gif");

    public IFSFileSystemView(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public File createFileObject(File containingDir, String name) {
        IFSJavaFile file;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (containingDir != null) {
            IFSJavaFile ifsDir = this.convertToIFSJavaFile(containingDir);
            file = new IFSJavaFile(ifsDir, name);
        } else {
            file = new IFSJavaFile(this.system_, name);
        }
        if (this.isFileSystemRoot(file)) {
            return this.createFileSystemRoot(file);
        }
        return file;
    }

    public File createFileObject(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        IFSJavaFile file = new IFSJavaFile(this.system_, path);
        if (this.isFileSystemRoot(file)) {
            return this.createFileSystemRoot(file);
        }
        return file;
    }

    protected File createFileSystemRoot(File f) {
        try {
            return super.createFileSystemRoot(f);
        }
        catch (NoSuchMethodError e) {
            if (Trace.isTraceOn()) {
                Trace.log(1, e);
            }
            return f;
        }
    }

    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        IFSJavaFile ifsDir = this.convertToIFSJavaFile(containingDir);
        IFSJavaFile newFolder = new IFSJavaFile(ifsDir, NEW_FOLDER_STRING);
        int i = 1;
        while (newFolder.exists() && i < 100) {
            newFolder = new IFSJavaFile(ifsDir, MessageFormat.format(NEW_FOLDER_NEXT_STRING, new Integer(i++)));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    public File getDefaultDirectory() {
        return this.createFileSystemRoot(new IFSJavaFile(this.system_, ROOT_PATH));
    }

    public File[] getFiles(File directory, boolean useFileHiding) {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        IFSJavaFile ifsDir = this.convertToIFSJavaFile(directory);
        return ifsDir.listFiles();
    }

    public File getHomeDirectory() {
        return new IFSJavaFile(this.system_, ROOT_PATH);
    }

    public File getParentDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        IFSJavaFile ifsDir = this.convertToIFSJavaFile(dir);
        IFSJavaFile parent = (IFSJavaFile)ifsDir.getParentFile();
        if (this.isFileSystemRoot(parent)) {
            return this.createFileSystemRoot(parent);
        }
        return parent;
    }

    public File[] getRoots() {
        return new File[]{this.createFileSystemRoot(new IFSJavaFile(this.system_, ROOT_PATH))};
    }

    public String getSystemDisplayName(File f) {
        if (f == null) {
            return null;
        }
        return f.getName();
    }

    public Icon getSystemIcon(File f) {
        return serverIcon32_;
    }

    public String getSystemTypeDescription(File f) {
        return this.system_.getSystemName();
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isFileSystemRoot(File f) {
        if (f == null) {
            return false;
        }
        return f.getAbsolutePath().equals(ROOT_PATH);
    }

    public boolean isRoot(File file) {
        if (file == null || !file.isAbsolute()) {
            return false;
        }
        return file.getAbsolutePath().equals(ROOT_PATH);
    }

    private IFSJavaFile convertToIFSJavaFile(File file) {
        if (file instanceof IFSJavaFile) {
            return (IFSJavaFile)file;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "File is not an IFSJavaFile.  File is of type " + file.getClass().getName());
        }
        return new IFSJavaFile(this.system_, file.getPath());
    }

    private IFSJavaFile convertToIFSJavaFile(File file, String methodName) {
        return this.convertToIFSJavaFile(file);
    }
}

