/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

class IFSRenameAction
implements VAction,
CellEditorListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String text_ = ResourceLoader.getText("ACTION_RENAME");
    private boolean enabled_ = true;
    private IFSFile file_ = null;
    private VObject object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSRenameAction(VObject object, IFSFile file) {
        this.object_ = object;
        this.file_ = file;
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void editingCanceled(ChangeEvent event) {
    }

    public void editingStopped(ChangeEvent event) {
        CellEditor editor = (CellEditor)event.getSource();
        editor.removeCellEditorListener(this);
        String newName = editor.getCellEditorValue().toString();
        if (Trace.isTraceOn()) {
            Trace.log(3, "Renaming file or directory [" + this.file_.getName() + "] to [" + newName + "].");
        }
        this.workingEventSupport_.fireStartWorking();
        boolean firedStopWorking = false;
        try {
            if (!this.file_.exists()) {
                this.errorEventSupport_.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_FOUND")));
                this.workingEventSupport_.fireStopWorking();
                firedStopWorking = true;
                this.objectEventSupport_.fireObjectDeleted(this.object_);
            } else if (this.file_.renameTo(new IFSFile(this.file_.getSystem(), this.file_.getParent(), newName))) {
                this.objectEventSupport_.fireObjectChanged(this.object_);
            } else {
                this.errorEventSupport_.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_RENAMED")));
            }
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        if (!firedStopWorking) {
            this.workingEventSupport_.fireStopWorking();
        }
    }

    public String getText() {
        return text_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext context) {
        CellEditor editor = context.startEditing(this.object_, VObject.NAME_PROPERTY);
        if (editor != null) {
            editor.addCellEditorListener(this);
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public String toString() {
        return text_;
    }
}

