/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class OutputReplyAction
extends DialogAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_REPLY");
    private static final String replyText_ = ResourceLoader.getPrintText("REPLY") + ":";
    private static final String messageIDText_ = ResourceLoader.getPrintText("MESSAGE_ID") + ":";
    private static final String dateSentText_ = ResourceLoader.getPrintText("DATE_SENT") + ":";
    private static final String messageText_ = ResourceLoader.getPrintText("MESSAGE") + ":";
    private static final String messageHelpText_ = ResourceLoader.getPrintText("MESSAGE_HELP") + ":";
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private SpooledFile splF_ = null;
    private AS400Message msg_ = null;
    private JTextField replyField_ = null;

    public OutputReplyAction(VObject object, SpooledFile splF) {
        super(object);
        this.splF_ = splF;
    }

    public JComponent getInputComponent() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            this.msg_ = this.splF_.getMessage();
            VUtilities.constrain(new JLabel(messageIDText_), panel, layout, 0, 0, 1, 1);
            VUtilities.constrain(new JLabel(this.msg_.getID().trim()), panel, layout, 1, 0, 1, 1);
            VUtilities.constrain(new JLabel(dateSentText_), panel, layout, 0, 2, 1, 1);
            Date newDate = this.msg_.getDate().getTime();
            VUtilities.constrain(new JLabel(dateFormat_.format(newDate)), panel, layout, 1, 2, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 3, 2, 1);
            VUtilities.constrain(new JLabel(messageText_), panel, layout, 0, 4, 1, 1);
            VUtilities.constrain(new JLabel(this.msg_.getText().trim()), panel, layout, 1, 4, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 5, 2, 1);
            String msgHelp = this.msg_.getHelp().trim();
            if (msgHelp != null) {
                VUtilities.constrain(new JLabel(messageHelpText_), panel, layout, 0, 6, 1, 1);
                JTextArea helpText = new JTextArea(msgHelp);
                helpText.setEditable(false);
                helpText.setColumns(80);
                helpText.setLineWrap(true);
                helpText.setWrapStyleWord(true);
                VUtilities.constrain(helpText, panel, layout, 1, 6, 1, 1);
            }
            VUtilities.constrain(new JLabel(replyText_), panel, layout, 0, 7, 1, 1);
            this.replyField_ = new JTextField(this.msg_.getDefaultReply().trim());
            this.replyField_.setEditable(true);
            VUtilities.constrain(this.replyField_, panel, layout, 1, 7, 1, 1);
        }
        catch (Exception e) {
            panel = null;
            this.fireError(e);
        }
        return panel;
    }

    public String getText() {
        return displayName_;
    }

    public void perform2() {
        try {
            String reply = this.replyField_.getText().trim();
            this.fireStartWorking();
            this.splF_.answerMessage(reply);
            this.fireStopWorking();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Replied to file [" + this.splF_.getName() + "].");
            }
            this.fireObjectChanged();
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR repling to file [" + this.splF_.getName() + "].");
            }
            this.fireError(e);
        }
    }
}

