/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFileList;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPrinterOutput;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class PrinterOutputPropertiesPane
implements VPropertiesPane,
ItemListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VPrinterOutput object_;
    private SpooledFileList list_;
    private JComboBox userFilter_;
    JComboBox outQFilter_;
    JComboBox outQLibFilter_;
    private JComboBox formTypeFilter_;
    private JComboBox userDataFilter_;
    private boolean disableFeature_;
    ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);
    private static final String includeText_ = ResourceLoader.getPrintText("INCLUDE");
    private static final String userText_ = ResourceLoader.getPrintText("USER") + ":";
    private static final String currentUserText_ = ResourceLoader.getPrintText("CURRENT_USER");
    static final String allText_ = ResourceLoader.getPrintText("ALL");
    static final String liblText_ = ResourceLoader.getPrintText("LIBRARY_LIST");
    private static final String outQText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE") + ":";
    private static final String outQLibText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE_LIB") + ":";
    private static final String formTypeText_ = ResourceLoader.getPrintText("FORM_TYPE") + ":";
    private static final String standardText_ = ResourceLoader.getPrintText("STANDARD");
    private static final String userSpecDataText_ = ResourceLoader.getPrintText("USER_SPEC_DATA") + ":";
    boolean fChanges_;

    public PrinterOutputPropertiesPane(VPrinterOutput object, SpooledFileList list) {
        this.object_ = object;
        this.list_ = list;
        this.disableFeature_ = false;
        this.fChanges_ = false;
    }

    PrinterOutputPropertiesPane(VPrinterOutput object, SpooledFileList list, boolean disable) {
        this.object_ = object;
        this.list_ = list;
        this.disableFeature_ = disable;
        this.fChanges_ = false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void applyChanges() throws Exception {
        this.fChanges_ = false;
        String oldUser = this.list_.getUserFilter().trim();
        String newUser = (String)this.userFilter_.getSelectedItem();
        if ((newUser = newUser.trim()).equals(currentUserText_)) {
            newUser = "*CURRENT";
        } else if (newUser.equals(allText_)) {
            newUser = "*ALL";
        }
        if (!oldUser.equals(newUser)) {
            this.list_.setUserFilter(newUser);
            this.fChanges_ = true;
        }
        if (!this.disableFeature_) {
            String oldOutQ = this.list_.getQueueFilter().trim();
            String newOutQ = (String)this.outQFilter_.getSelectedItem();
            String newOutQLib = (String)this.outQLibFilter_.getSelectedItem();
            newOutQ = newOutQ.trim();
            newOutQLib = newOutQLib.trim();
            if (newOutQ.equals("") || newOutQLib.equals("")) {
                this.list_.setQueueFilter("");
                this.fChanges_ = true;
            } else {
                if (newOutQ.equals(allText_)) {
                    newOutQ = "%ALL%";
                }
                if (newOutQLib.equals(allText_)) {
                    newOutQLib = "%ALL%";
                } else if (newOutQLib.equals(liblText_)) {
                    newOutQLib = "%LIBL%";
                }
                QSYSObjectPathName newOutQPath = new QSYSObjectPathName(newOutQLib, newOutQ, "OUTQ");
                if (!oldOutQ.equals(newOutQPath.getPath().trim())) {
                    this.list_.setQueueFilter(newOutQPath.getPath());
                    this.fChanges_ = true;
                }
            }
        }
        String oldFormType = this.list_.getFormTypeFilter().trim();
        String newFormType = (String)this.formTypeFilter_.getSelectedItem();
        if ((newFormType = newFormType.trim()).equals(standardText_)) {
            newFormType = "*STD";
        } else if (newFormType.equals(allText_)) {
            newFormType = "*ALL";
        }
        if (!oldFormType.equals(newFormType)) {
            this.list_.setFormTypeFilter(newFormType);
            this.fChanges_ = true;
        }
        String oldUserData = this.list_.getUserDataFilter().trim();
        String newUserData = (String)this.userDataFilter_.getSelectedItem();
        if ((newUserData = newUserData.trim()).equals(allText_)) {
            newUserData = "*ALL";
        }
        if (!oldUserData.equals(newUserData)) {
            this.list_.setUserDataFilter(newUserData);
            this.fChanges_ = true;
        }
        if (this.fChanges_) {
            this.objectEventSupport_.fireObjectChanged(this.object_);
        }
    }

    public JPanel buildIncludePane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(userText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            this.userFilter_ = new JComboBox();
            this.userFilter_.setEditable(true);
            this.userFilter_.addItem(currentUserText_);
            this.userFilter_.addItem(allText_);
            String curUserFilter = this.list_.getUserFilter().trim();
            if (curUserFilter.equals("*CURRENT") || curUserFilter.equals("")) {
                this.userFilter_.setSelectedItem(currentUserText_);
            } else if (curUserFilter.equals("*ALL")) {
                this.userFilter_.setSelectedItem(allText_);
            } else {
                this.userFilter_.addItem(curUserFilter);
                this.userFilter_.setSelectedItem(curUserFilter);
            }
            this.userFilter_.addItemListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.userFilter_, thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(outQText_), thePane, layout, constraints, 0, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(outQLibText_), thePane, layout, constraints, 0, 1, 1, 2, 1, 1, 2, 17);
            this.outQFilter_ = new JComboBox();
            this.outQFilter_.setEditable(true);
            this.outQFilter_.addItem(allText_);
            this.outQLibFilter_ = new JComboBox();
            this.outQLibFilter_.setEditable(true);
            this.outQLibFilter_.addItem(allText_);
            this.outQLibFilter_.addItem(liblText_);
            String queueFilter = this.list_.getQueueFilter().trim();
            if (!queueFilter.equals("")) {
                QSYSObjectPathName outQPath = new QSYSObjectPathName(queueFilter);
                String curQueueFilter = outQPath.getObjectName();
                if (curQueueFilter.equals("*ALL")) {
                    this.outQFilter_.setSelectedItem(allText_);
                } else {
                    this.outQFilter_.addItem(curQueueFilter);
                    this.outQFilter_.setSelectedItem(curQueueFilter);
                }
                String curQueueLibFilter = outQPath.getLibraryName();
                if (curQueueLibFilter.equals("*ALL")) {
                    this.outQLibFilter_.setSelectedItem(allText_);
                } else if (curQueueLibFilter.equals("*LIBL")) {
                    this.outQLibFilter_.setSelectedItem(liblText_);
                } else {
                    this.outQLibFilter_.addItem(curQueueLibFilter);
                    this.outQLibFilter_.setSelectedItem(curQueueLibFilter);
                }
            } else {
                this.outQFilter_.setSelectedItem(allText_);
                this.outQLibFilter_.setSelectedItem(allText_);
            }
            if (this.disableFeature_) {
                this.outQFilter_.setEnabled(false);
            } else {
                this.outQFilter_.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        String newOutQ = (String)PrinterOutputPropertiesPane.this.outQFilter_.getSelectedItem();
                        if (newOutQ.trim().equals(allText_) && !PrinterOutputPropertiesPane.this.outQLibFilter_.getSelectedItem().equals(allText_)) {
                            PrinterOutputPropertiesPane.this.outQLibFilter_.setSelectedItem(allText_);
                        } else if (!newOutQ.trim().equals(allText_) && PrinterOutputPropertiesPane.this.outQLibFilter_.getSelectedItem().equals(allText_)) {
                            PrinterOutputPropertiesPane.this.outQLibFilter_.setSelectedItem(liblText_);
                        }
                        PrinterOutputPropertiesPane.this.changeEventSupport_.fireStateChanged();
                    }
                });
            }
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.outQFilter_, thePane, layout, constraints, 1, 1, 1, 1, 1, 1, 2, 17);
            if (this.disableFeature_) {
                this.outQLibFilter_.setEnabled(false);
            } else {
                this.outQLibFilter_.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        String newOutQLib = (String)PrinterOutputPropertiesPane.this.outQLibFilter_.getSelectedItem();
                        if (newOutQLib.trim().equals(allText_) && !PrinterOutputPropertiesPane.this.outQFilter_.getSelectedItem().equals(allText_)) {
                            PrinterOutputPropertiesPane.this.outQFilter_.setSelectedItem(allText_);
                        }
                        PrinterOutputPropertiesPane.this.changeEventSupport_.fireStateChanged();
                    }
                });
            }
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.outQLibFilter_, thePane, layout, constraints, 1, 1, 1, 2, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(formTypeText_), thePane, layout, constraints, 0, 1, 1, 3, 1, 1, 2, 17);
            this.formTypeFilter_ = new JComboBox();
            this.formTypeFilter_.setEditable(true);
            this.formTypeFilter_.addItem(allText_);
            this.formTypeFilter_.addItem(standardText_);
            String curFormTypeFilter = this.list_.getFormTypeFilter().trim();
            if (curFormTypeFilter.equals("*ALL") || curFormTypeFilter.equals("")) {
                this.formTypeFilter_.setSelectedItem(allText_);
            } else if (curFormTypeFilter.equals("*STD")) {
                this.formTypeFilter_.setSelectedItem(standardText_);
            } else {
                this.formTypeFilter_.addItem(curFormTypeFilter);
                this.formTypeFilter_.setSelectedItem(curFormTypeFilter);
            }
            this.formTypeFilter_.addItemListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.formTypeFilter_, thePane, layout, constraints, 1, 1, 1, 3, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(userSpecDataText_), thePane, layout, constraints, 0, 1, 1, 4, 1, 1, 2, 17);
            this.userDataFilter_ = new JComboBox();
            this.userDataFilter_.setEditable(true);
            this.userDataFilter_.addItem(allText_);
            String curUserDataFilter = this.list_.getUserDataFilter().trim();
            if (curUserDataFilter.equals("*ALL") || curUserDataFilter.equals("")) {
                this.userDataFilter_.setSelectedItem(allText_);
            } else {
                this.userDataFilter_.addItem(curUserDataFilter);
                this.userDataFilter_.setSelectedItem(curUserDataFilter);
            }
            this.userDataFilter_.addItemListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.userDataFilter_, thePane, layout, constraints, 1, 1, 1, 4, 1, 1, 2, 17);
        }
        catch (Exception e) {
            thePane = null;
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    public Component getComponent() {
        JTabbedPane tabbedPane = null;
        tabbedPane = new JTabbedPane();
        tabbedPane.addTab(includeText_, null, this.buildIncludePane());
        tabbedPane.setSelectedIndex(0);
        return tabbedPane;
    }

    public void itemStateChanged(ItemEvent e) {
        this.changeEventSupport_.fireStateChanged();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }
}

