/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class PrinterStopAction
extends DialogAction {
    static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_STOP");
    private static String prtrToStopText_ = ResourceLoader.getPrintText("PRINTER_TO_STOP") + ":";
    private static String stopPrinterText_ = ResourceLoader.getPrintText("STOP_PRINTING") + ":";
    private static String immediatelyText_ = ResourceLoader.getPrintText("IMMEDIATELY");
    private static String pageEndText_ = ResourceLoader.getPrintText("AT_PAGE_END");
    private static String copyEndText_ = ResourceLoader.getPrintText("AT_COPY_END");
    private static boolean stringsLoaded_ = false;
    private Object stringsLock_ = new Object();
    private Printer printer_ = null;
    private JRadioButton immedButton_ = null;
    private JRadioButton endPageButton_ = null;
    private JRadioButton endCopyButton_ = null;

    public PrinterStopAction(VObject object, Printer printer) {
        super(object);
        this.printer_ = printer;
    }

    public JComponent getInputComponent() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            if (!stringsLoaded_) {
                this.loadMRI();
            }
            VUtilities.constrain(new JLabel(prtrToStopText_), panel, layout, 0, 0, 1, 1);
            JTextField text = new JTextField(this.printer_.getName().trim());
            text.setEditable(false);
            VUtilities.constrain(text, panel, layout, 1, 0, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 1, 2, 1);
            VUtilities.constrain(new JLabel(stopPrinterText_), panel, layout, 0, 2, 1, 1);
            this.immedButton_ = new JRadioButton(immediatelyText_);
            this.immedButton_.setHorizontalAlignment(2);
            this.immedButton_.setSelected(true);
            this.endPageButton_ = new JRadioButton(pageEndText_);
            this.endPageButton_.setHorizontalAlignment(2);
            this.endCopyButton_ = new JRadioButton(copyEndText_);
            this.endCopyButton_.setHorizontalAlignment(2);
            ButtonGroup group = new ButtonGroup();
            group.add(this.immedButton_);
            group.add(this.endPageButton_);
            group.add(this.endCopyButton_);
            VUtilities.constrain(this.immedButton_, panel, layout, 0, 3, 1, 1);
            VUtilities.constrain(this.endPageButton_, panel, layout, 0, 4, 1, 1);
            VUtilities.constrain(this.endCopyButton_, panel, layout, 0, 5, 1, 1);
        }
        catch (Exception e) {
            panel = null;
            this.fireError(e);
        }
        return panel;
    }

    public String getText() {
        return displayName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMRI() {
        Object object = this.stringsLock_;
        synchronized (object) {
            prtrToStopText_ = ResourceLoader.getPrintText("PRINTER_TO_STOP") + ":";
            stopPrinterText_ = ResourceLoader.getPrintText("STOP_PRINTING") + ":";
            immediatelyText_ = ResourceLoader.getPrintText("IMMEDIATELY");
            pageEndText_ = ResourceLoader.getPrintText("AT_PAGE_END");
            copyEndText_ = ResourceLoader.getPrintText("AT_COPY_END");
            stringsLoaded_ = true;
        }
    }

    public void perform2() {
        try {
            this.fireStartWorking();
            String status_ = this.printer_.getStringAttribute(121).trim();
            if (status_ == null || status_.equals("")) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "ERROR No writer for [" + this.printer_.getName() + "].");
                }
                Exception e = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                this.fireError(e);
            } else {
                CommandCall cmd = new CommandCall(this.printer_.getSystem());
                String cmdString = "ENDWTR WTR(" + this.printer_.getName() + ") OPTION(";
                try {
                    if (this.immedButton_.isSelected()) {
                        cmdString = cmdString + "*IMMED)";
                    } else if (this.endPageButton_.isSelected()) {
                        cmdString = cmdString + "*PAGEEND)";
                    } else if (this.endCopyButton_.isSelected()) {
                        cmdString = cmdString + "*CNTRLD)";
                    }
                    if (!cmd.run(cmdString)) {
                        if (Trace.isTraceOn()) {
                            Trace.log(2, "ERROR ENDWTR cmd for [" + this.printer_.getName() + "].");
                        }
                        Exception e = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                        this.fireError(e);
                    } else {
                        if (Trace.isTraceOn()) {
                            Trace.log(3, "Stopped printer [" + this.printer_.getName() + "].");
                        }
                        this.fireObjectChanged();
                    }
                    if (Trace.isTraceOn()) {
                        AS400Message[] messagelist = cmd.getMessageList();
                        for (int i = 0; i < messagelist.length; ++i) {
                            Trace.log(3, messagelist[i].getText());
                        }
                    }
                }
                catch (Exception e) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "ERROR CommandCall exception for [" + this.printer_.getName() + "].");
                    }
                    this.fireError(e);
                }
            }
            this.fireStopWorking();
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR Stopping printer [" + this.printer_.getName() + "].");
            }
            this.fireError(e);
        }
    }
}

