/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.AbstractVAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;

class PrinterUnavailableAction
extends AbstractVAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_UNAVAILABLE");
    private Printer printer_ = null;

    public PrinterUnavailableAction(VObject object, Printer printer) {
        super(object);
        this.printer_ = printer;
    }

    public String getText() {
        return displayName_;
    }

    public void perform(VActionContext context) {
        try {
            this.fireStartWorking();
            CommandCall cmd = new CommandCall(this.printer_.getSystem());
            String cmdString = "VRYCFG CFGOBJ(" + this.printer_.getName() + ") ";
            cmdString = cmdString + "CFGTYPE(*DEV) STATUS(*OFF) RANGE(*OBJ)";
            try {
                if (!cmd.run(cmdString)) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "ERROR VRYCFG cmd for [" + this.printer_.getName() + "].");
                    }
                    Exception e = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                    this.fireError(e);
                } else {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Varied Off printer [" + this.printer_.getName() + "].");
                    }
                    this.fireObjectChanged();
                }
                if (Trace.isTraceOn()) {
                    AS400Message[] messagelist = cmd.getMessageList();
                    for (int i = 0; i < messagelist.length; ++i) {
                        Trace.log(3, messagelist[i].getText());
                    }
                }
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "ERROR CommandCall exception for [" + this.printer_.getName() + "].");
                }
                this.fireError(e);
            }
            this.fireStopWorking();
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR Varied Off printer [" + this.printer_.getName() + "].");
            }
            this.fireError(e);
        }
    }
}

