/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.PrinterList;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPrinters;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class PrintersPropertiesPane
implements VPropertiesPane,
ItemListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VPrinters object_;
    private PrinterList list_;
    private JComboBox printerFilter_;
    private String printerFilterString_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);
    private static final String includeText_ = ResourceLoader.getPrintText("INCLUDE");
    private static final String printerText_ = ResourceLoader.getPrintText("PRINTER") + ":";
    private static final String allText_ = ResourceLoader.getPrintText("ALL");

    public PrintersPropertiesPane(VPrinters object, PrinterList list) {
        this.object_ = object;
        this.list_ = list;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void applyChanges() throws Exception {
        String oldPrinter = this.list_.getPrinterFilter().trim();
        String newPrinter = (String)this.printerFilter_.getModel().getSelectedItem();
        if (newPrinter.trim().equals(allText_)) {
            newPrinter = "*ALL";
        }
        if (!oldPrinter.equals(newPrinter.trim())) {
            this.list_.setPrinterFilter(newPrinter);
            this.objectEventSupport_.fireObjectChanged(this.object_);
        }
    }

    private JPanel buildIncludePane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(printerText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            this.printerFilter_ = new JComboBox();
            this.printerFilter_.setEditable(true);
            this.printerFilter_.addItem(allText_);
            this.printerFilter_.addItemListener(this);
            String curPrinterFilter = this.list_.getPrinterFilter().trim();
            if (curPrinterFilter.equals("*ALL") || curPrinterFilter.equals("")) {
                this.printerFilter_.setSelectedItem(allText_);
            } else {
                this.printerFilter_.addItem(curPrinterFilter);
                this.printerFilter_.setSelectedItem(curPrinterFilter);
            }
            this.printerFilter_.addItemListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.printerFilter_, thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
        }
        catch (Exception e) {
            thePane = null;
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    public Component getComponent() {
        JTabbedPane tabbedPane = null;
        tabbedPane = new JTabbedPane();
        tabbedPane.addTab(includeText_, null, this.buildIncludePane());
        tabbedPane.setSelectedIndex(0);
        return tabbedPane;
    }

    public void itemStateChanged(ItemEvent e) {
        this.changeEventSupport_.fireStateChanged();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }
}

