/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.LabelledComponent;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLQueryClause;
import com.ibm.as400.vaccess.ScrollingTextPane;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

class SQLQueryTablePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private JButton tableButton_ = null;
    private JLabel catalog_ = null;
    private transient JTable tablesTable_;
    private boolean tablesShown_ = false;
    private JScrollPane tablesPane_;
    SQLQueryClause clause_;
    JDialog dialog_;
    private String catalogName_ = "";
    private DefaultTableModel tablesTableModel_;
    private String[] tables_;
    String[] schemas_;
    boolean userSelectTableSchemas_;
    private DefaultListModel schemaListModel_;
    private transient Connection connection_;
    boolean changes_ = false;
    private transient DocumentListener_ docListener_;
    private transient ErrorEventSupport errors_ = new ErrorEventSupport(this);
    private transient WorkingCursorAdapter worker_ = null;
    private transient WorkingEvent workEvent_ = null;
    SQLQueryBuilderPane parent_;
    private boolean enabled_ = true;
    private boolean buttonEnabled_;
    private boolean inited_ = false;

    public SQLQueryTablePane(SQLQueryBuilderPane parent, Connection connection, String[] tables, String[] schemas, boolean userSelectTableSchemas) {
        this.parent_ = parent;
        this.connection_ = connection;
        this.tables_ = tables;
        this.schemas_ = schemas;
        this.userSelectTableSchemas_ = userSelectTableSchemas;
        this.tablesTableModel_ = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.addFocusListener(new SerializationListener(this));
    }

    public void addErrorListener(ErrorListener listener) {
        this.errors_.addErrorListener(listener);
    }

    public void complete() {
        if (this.changes_) {
            if (this.clause_ != null) {
                StringTokenizer clause = new StringTokenizer(this.clause_.getText(), ",");
                Vector<String> tables = new Vector<String>();
                while (clause.hasMoreTokens()) {
                    tables.addElement(clause.nextToken().trim());
                }
                Object[] newTables = new String[tables.size()];
                tables.copyInto(newTables);
                boolean different = false;
                if (this.tables_.length == newTables.length) {
                    for (int i = 0; i < this.tables_.length; ++i) {
                        if (this.tables_[i].equals(newTables[i])) continue;
                        different = true;
                        break;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    this.tables_ = newTables;
                }
            }
            this.changes_ = false;
        }
    }

    private void enableButton(boolean enable) {
        this.buttonEnabled_ = enable;
        if (this.enabled_) {
            this.tableButton_.setEnabled(enable);
        }
    }

    private void fillClause() {
        if (this.clause_ != null) {
            if (this.tables_.length > 0) {
                StringBuffer temp = new StringBuffer(this.tables_[0]);
                for (int i = 1; i < this.tables_.length; ++i) {
                    temp.append(", ");
                    temp.append(this.tables_[i]);
                }
                this.clause_.setText(temp.toString());
            } else {
                this.clause_.setText("");
            }
        }
    }

    public String[] getSchemas() {
        return this.schemas_;
    }

    public String[] getTables() {
        return this.tables_;
    }

    public void init() {
        this.setupPane();
        this.inited_ = true;
    }

    public void load() {
        if (this.tablesShown_) {
            this.tableButton_.setText(ResourceLoader.getQueryText("DBQUERY_BUTTON_DISPLAY_TABLES"));
            int i = this.tablesTableModel_.getRowCount();
            while (i > 0) {
                this.tablesTableModel_.removeRow(--i);
            }
            this.tablesShown_ = false;
        }
        if (this.connection_ != null) {
            this.enableButton(true);
            try {
                this.catalog_.setText(this.connection_.getCatalog());
            }
            catch (SQLException e) {
                this.errors_.fireError(e);
            }
        } else {
            this.enableButton(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadTables() {
        this.worker_.startWorking(this.workEvent_);
        if (!this.tablesShown_) {
            this.tableButton_.setText(ResourceLoader.getQueryText("DBQUERY_BUTTON_CHANGE_SCHEMAS"));
            if (this.userSelectTableSchemas_) {
                this.enableButton(true);
            } else {
                this.enableButton(false);
            }
            this.tablesShown_ = true;
        }
        int i = this.tablesTableModel_.getRowCount();
        while (i > 0) {
            this.tablesTableModel_.removeRow(--i);
        }
        ResultSet results = null;
        DatabaseMetaData meta = this.connection_.getMetaData();
        results = meta.getTableTypes();
        Vector<String> types1 = new Vector<String>();
        while (results.next()) {
            types1.addElement(results.getString(1));
        }
        Object[] types = new String[types1.size()];
        types1.copyInto(types);
        for (int i2 = 0; i2 < this.schemas_.length; ++i2) {
            String schema = this.schemas_[i2];
            results = meta.getTables(null, schema, "%", (String[])types);
            Object[] row = new String[4];
            while (results.next()) {
                row[0] = results.getString(2) != null ? results.getString(2).trim() : "";
                row[1] = results.getString(3).trim();
                row[2] = results.getString(4);
                row[3] = results.getString(5) != null ? results.getString(5).trim() : "";
                this.tablesTableModel_.addRow(row);
            }
        }
        Object var9_10 = null;
        this.worker_.stopWorking(this.workEvent_);
        if (results == null) return;
        try {
            results.close();
            return;
        }
        catch (SQLException e2) {
            this.errors_.fireError(e2);
        }
        return;
        {
            catch (SQLException e) {
                this.errors_.fireError(e);
                Object var9_11 = null;
                this.worker_.stopWorking(this.workEvent_);
                if (results == null) return;
                try {
                    results.close();
                    return;
                }
                catch (SQLException e2) {
                    this.errors_.fireError(e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.worker_.stopWorking(this.workEvent_);
            if (results == null) throw throwable;
            try {
                results.close();
                throw throwable;
            }
            catch (SQLException e2) {
                this.errors_.fireError(e2);
            }
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.errors_ = new ErrorEventSupport(this);
        this.connection_ = null;
        this.addFocusListener(new SerializationListener(this));
        if (this.inited_) {
            this.init();
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errors_.removeErrorListener(listener);
    }

    protected void rowPicked(int index) {
        String text = this.tablesTable_.getValueAt(index, 0) + "." + this.tablesTable_.getValueAt(index, 1);
        if (this.clause_ != null) {
            this.clause_.appendTextWithComma(text);
        }
    }

    public void setConnection(Connection connection) {
        this.connection_ = connection;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
        if (this.clause_ != null) {
            this.clause_.setEditable(enabled);
        }
        this.tablesTable_.setEnabled(enabled);
        if (this.buttonEnabled_) {
            this.tableButton_.setEnabled(enabled);
        }
    }

    public void setTables(String[] tables) {
        this.tables_ = tables;
        this.fillClause();
    }

    public void setSchemas(String[] schemas) {
        this.schemas_ = schemas;
        if (this.dialog_ != null) {
            this.schemaListModel_.removeAllElements();
            for (int i = 0; i < this.schemas_.length; ++i) {
                this.schemaListModel_.addElement(this.schemas_[i]);
            }
        }
    }

    public void setUserSelectTableSchemas(boolean flag) {
        this.userSelectTableSchemas_ = flag;
        if (this.tablesShown_ && this.tableButton_ != null) {
            if (this.userSelectTableSchemas_) {
                this.enableButton(true);
            } else {
                this.enableButton(false);
            }
        }
    }

    private void setupPane() {
        JLabel catalogLabel = new JLabel(ResourceLoader.getQueryText("DBQUERY_LABEL_CATALOG"));
        this.catalog_ = new JLabel(this.catalogName_);
        Box catalogBox = Box.createHorizontalBox();
        catalogBox.add(Box.createHorizontalStrut(5));
        catalogBox.add(catalogLabel);
        catalogBox.add(Box.createHorizontalStrut(5));
        catalogBox.add(this.catalog_);
        catalogBox.add(Box.createHorizontalGlue());
        this.tableButton_ = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_DISPLAY_TABLES"));
        if (this.connection_ != null) {
            this.enableButton(true);
        } else {
            this.enableButton(false);
        }
        this.tableButton_.addActionListener(new ButtonListener_());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(this.tableButton_);
        buttonBox.add(Box.createHorizontalGlue());
        this.worker_ = new WorkingCursorAdapter(this);
        this.workEvent_ = new WorkingEvent(this);
        String header = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_SCHEMA");
        this.tablesTableModel_.addColumn(header);
        header = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_NAME");
        this.tablesTableModel_.addColumn(header);
        header = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_TYPE");
        this.tablesTableModel_.addColumn(header);
        header = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_TEXT");
        this.tablesTableModel_.addColumn(header);
        this.tablesTable_ = new JTable(this.tablesTableModel_);
        this.tablesTable_.setName("tableTableTable");
        this.tablesTable_.setAutoResizeMode(3);
        this.tablesTable_.setShowGrid(false);
        this.tablesTable_.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tablesTable_.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.tablesTable_.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tablesTable_.getColumnModel().getColumn(3).setPreferredWidth(180);
        this.tablesPane_ = new JScrollPane(this.tablesTable_);
        this.tablesPane_.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), this.tablesPane_.getBorder()));
        final JTable table2 = this.tablesTable_;
        table2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                int tablerow;
                if (event.getClickCount() > 1 && (tablerow = table2.rowAtPoint(event.getPoint())) != -1) {
                    SQLQueryTablePane.this.rowPicked(tablerow);
                }
            }
        });
        this.clause_ = new SQLQueryClause(5);
        this.fillClause();
        boolean otherPanesEnabled = this.tables_.length != 0;
        boolean enableOrder = this.parent_.getSelectedItems().length != 0;
        this.docListener_ = new DocumentListener_(otherPanesEnabled, enableOrder);
        this.clause_.getDocument().addDocumentListener(this.docListener_);
        Box overallBox = Box.createVerticalBox();
        overallBox.add(Box.createVerticalStrut(10));
        overallBox.add(catalogBox);
        overallBox.add(Box.createVerticalStrut(10));
        overallBox.add(buttonBox);
        overallBox.add(Box.createVerticalStrut(10));
        overallBox.add(this.tablesPane_);
        overallBox.add(Box.createVerticalStrut(10));
        overallBox.add(new LabelledComponent("DBQUERY_LABEL_TABLES", new ScrollingTextPane(this.clause_)));
        this.setLayout(new BorderLayout());
        this.add("Center", overallBox);
    }

    void setupSchemaDialog() {
        JLabel prompt = new JLabel(ResourceLoader.getQueryText("DBQUERY_TEXT_SCHEMAS"));
        JLabel prompt2 = new JLabel(ResourceLoader.getQueryText("DBQUERY_TEXT_SCHEMAS2"));
        prompt.setBorder(new EmptyBorder(10, 10, 5, 10));
        prompt2.setBorder(new EmptyBorder(5, 10, 10, 10));
        JPanel promptPanel = new JPanel(new BorderLayout());
        promptPanel.add("North", prompt);
        promptPanel.add("South", prompt2);
        promptPanel.getAccessibleContext().setAccessibleName("PROMPT");
        final JTextField entry = new JTextField(12);
        this.schemaListModel_ = new DefaultListModel();
        for (int i = 0; i < this.schemas_.length; ++i) {
            this.schemaListModel_.addElement(this.schemas_[i]);
        }
        final JList schemas = new JList(this.schemaListModel_);
        JScrollPane listScroll = new JScrollPane(schemas);
        schemas.setSelectionMode(2);
        final DefaultListModel model = this.schemaListModel_;
        JButton add = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_ADD"));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String s = entry.getText();
                if (!s.equals("")) {
                    model.addElement(s);
                    entry.setText("");
                }
            }
        });
        JButton remove = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_REMOVE"));
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int[] selected = schemas.getSelectedIndices();
                int i = selected.length;
                while (i > 0) {
                    model.removeElementAt(selected[--i]);
                }
            }
        });
        JButton okButton = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Object[] items = model.toArray();
                String[] libs = new String[items.length];
                for (int i = 0; i < items.length; ++i) {
                    libs[i] = (String)items[i];
                }
                SQLQueryTablePane.this.schemas_ = libs;
                SQLQueryTablePane.this.loadTables();
                SQLQueryTablePane.this.dialog_.dispose();
            }
        });
        JButton cancelButton = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                model.removeAllElements();
                for (int i = 0; i < SQLQueryTablePane.this.schemas_.length; ++i) {
                    model.addElement(SQLQueryTablePane.this.schemas_[i]);
                }
                SQLQueryTablePane.this.dialog_.dispose();
            }
        });
        GridBagLayout layout = new GridBagLayout();
        JPanel body = new JPanel(layout);
        body.getAccessibleContext().setAccessibleName("BODY");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        VUtilities.constrain(entry, body, layout, constraints, 0, 1, 100, 0, 1, 0, 1, 10);
        VUtilities.constrain(add, body, layout, constraints, 1, 1, 0, 0, 1, 0, 2, 10);
        VUtilities.constrain(listScroll, body, layout, constraints, 0, 1, 100, 1, 1, 100, 1, 10);
        VUtilities.constrain(remove, body, layout, constraints, 1, 1, 0, 1, 1, 100, 2, 10);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.getAccessibleContext().setAccessibleName("BUTTON");
        this.dialog_ = new JDialog(VUtilities.getFrame(this), ResourceLoader.getQueryText("DBQUERY_TITLE_SCHEMAS"), true);
        this.dialog_.getContentPane().setLayout(new BorderLayout());
        this.dialog_.getContentPane().add("North", promptPanel);
        this.dialog_.getContentPane().add("Center", body);
        this.dialog_.getContentPane().add("South", buttonPanel);
        this.dialog_.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                SQLQueryTablePane.this.dialog_.dispose();
            }
        });
        this.dialog_.pack();
        this.dialog_.setLocationRelativeTo(this);
        this.dialog_.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                for (int index = 0; index < SQLQueryTablePane.this.dialog_.getContentPane().getComponentCount(); ++index) {
                    JComponent inputPanel = (JComponent)SQLQueryTablePane.this.dialog_.getContentPane().getComponent(index);
                    if (!inputPanel.getAccessibleContext().getAccessibleName().equals("BODY")) continue;
                    for (int i = 0; i < inputPanel.getComponentCount(); ++i) {
                        if (!(inputPanel.getComponent(i) instanceof JTextField)) continue;
                        inputPanel.getComponent(i).requestFocus();
                        return;
                    }
                    return;
                }
            }
        });
    }

    void update() {
        boolean bl = this.docListener_.enableOrder_ = this.parent_.getSelectedItems().length != 0;
        if (this.docListener_.enableOrder_) {
            this.parent_.notebook_.setEnabledAt(6, true);
        }
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        public void actionPerformed(ActionEvent ev) {
            if (SQLQueryTablePane.this.userSelectTableSchemas_) {
                if (SQLQueryTablePane.this.dialog_ == null) {
                    SQLQueryTablePane.this.setupSchemaDialog();
                }
                SQLQueryTablePane.this.dialog_.setVisible(true);
            } else {
                SQLQueryTablePane.this.loadTables();
            }
        }
    }

    private class DocumentListener_
    implements DocumentListener {
        boolean enableOrder_;
        boolean enabled_;

        public DocumentListener_(boolean enabled, boolean enableOrder) {
            this.enabled_ = enabled;
            this.enableOrder_ = enableOrder;
        }

        public void insertUpdate(DocumentEvent e) {
            int comma;
            SQLQueryTablePane.this.changes_ = true;
            String text = SQLQueryTablePane.this.clause_.getText();
            if (!this.enabled_ && !text.equals("")) {
                this.enabled_ = true;
                SQLQueryBuilderPane cfr_ignored_0 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(1, true);
                SQLQueryBuilderPane cfr_ignored_1 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(3, true);
                SQLQueryBuilderPane cfr_ignored_2 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(4, true);
                SQLQueryBuilderPane cfr_ignored_3 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(5, true);
                SQLQueryBuilderPane cfr_ignored_4 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, true);
                if (this.enableOrder_) {
                    SQLQueryBuilderPane cfr_ignored_5 = SQLQueryTablePane.this.parent_;
                    SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(6, true);
                }
            }
            if ((comma = text.indexOf(",")) == -1 || comma == text.length() - 1) {
                SQLQueryBuilderPane cfr_ignored_6 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, false);
            } else {
                SQLQueryBuilderPane cfr_ignored_7 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, true);
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void removeUpdate(DocumentEvent e) {
            SQLQueryTablePane.this.changes_ = true;
            String text = SQLQueryTablePane.this.clause_.getText();
            if (text.equals("")) {
                this.enabled_ = false;
                SQLQueryBuilderPane cfr_ignored_0 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(1, false);
                SQLQueryBuilderPane cfr_ignored_1 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(3, false);
                SQLQueryBuilderPane cfr_ignored_2 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(4, false);
                SQLQueryBuilderPane cfr_ignored_3 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(5, false);
                SQLQueryBuilderPane cfr_ignored_4 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, false);
                SQLQueryBuilderPane cfr_ignored_5 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(6, false);
            } else {
                int comma = text.indexOf(",");
                if (comma == -1 || comma == text.length() - 1) {
                    SQLQueryBuilderPane cfr_ignored_6 = SQLQueryTablePane.this.parent_;
                    SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, false);
                }
            }
        }
    }
}

