/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.resource.RJob;
import com.ibm.as400.resource.RJobList;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VJob;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VResourceListPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VJobList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("JOB_LIST_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VJobList16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VJobList32.gif", description_);
    private static String cpuUsedColumnHeader_ = ResourceLoader.getText("JOB_CPU_USED");
    private static String dateColumnHeader_ = ResourceLoader.getText("JOB_DATE");
    private static String functionColumnHeader_ = ResourceLoader.getText("JOB_FUNCTION");
    private static String nameColumnHeader_ = ResourceLoader.getText("JOB_NAME");
    private static String numberColumnHeader_ = ResourceLoader.getText("JOB_NUMBER");
    private static String statusColumnHeader_ = ResourceLoader.getText("JOB_STATUS");
    private static String subsystemColumnHeader_ = ResourceLoader.getText("JOB_SUBSYSTEM");
    private static String subtypeColumnHeader_ = ResourceLoader.getText("JOB_SUBTYPE");
    private static String typeColumnHeader_ = ResourceLoader.getText("JOB_TYPE");
    private static String userColumnHeader_ = ResourceLoader.getText("JOB_USER");
    private RJobList jobList_ = null;
    private String name_ = null;
    private String number_ = null;
    private VNode parent_ = null;
    private String user_ = null;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VNode[] children_;
    private transient Object childrenLock_;
    private transient boolean loaded_ = false;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VJobList() {
        this.jobList_ = new RJobList();
        try {
            this.jobList_.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
            this.jobList_.setSortValue(new Object[]{"JOB_NAME", "USER_NAME", "JOB_NUMBER"});
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.initializeTransient();
    }

    public VJobList(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.jobList_ = new RJobList(system);
        try {
            this.jobList_.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
            this.jobList_.setSortValue(new Object[]{"JOB_NAME", "USER_NAME", "JOB_NUMBER"});
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.initializeTransient();
    }

    public VJobList(VNode parent, AS400 system) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.parent_ = parent;
        this.jobList_ = new RJobList(system);
        try {
            this.jobList_.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
            this.jobList_.setSortValue(new Object[]{"JOB_NAME", "USER_NAME", "JOB_NUMBER"});
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        if (!this.loaded_) {
            return null;
        }
        if (this.children_ == null) {
            this.loadFirst();
        }
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        if (this.children_[index] == null) {
            this.loadSingle(index);
        }
        return this.children_[index];
    }

    public int getChildCount() {
        if (!this.loaded_) {
            return 0;
        }
        if (this.children_ == null) {
            this.loadFirst();
        }
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int index) {
        return (VObject)((Object)this.getChildAt(index));
    }

    public int getDetailsChildCount() {
        return this.getChildCount();
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject detailsChild) {
        if (detailsChild instanceof TreeNode) {
            return this.getIndex((TreeNode)((Object)detailsChild));
        }
        return -1;
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode child) {
        if (!this.loaded_) {
            return -1;
        }
        if (child == null) {
            return -1;
        }
        if (this.children_ == null) {
            this.loadFirst();
        }
        for (int i = 0; i < this.children_.length; ++i) {
            if (this.children_[i] != child) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        if (this.name_ == null) {
            return "*ALL";
        }
        return this.name_;
    }

    public String getNumber() {
        if (this.number_ == null) {
            return "*ALL";
        }
        return this.number_;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.jobList_.getSystem();
    }

    public String getText() {
        return description_;
    }

    public String getUser() {
        if (this.user_ == null) {
            return "*ALL";
        }
        return this.user_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.jobList_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.jobList_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.children_ = new VNode[0];
        this.childrenLock_ = new Object();
        this.propertiesPane_ = new VResourceListPropertiesPane(this, this.jobList_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.childrenLock_;
        synchronized (object) {
            if (this.children_ != null) {
                for (int i = 0; i < this.children_.length; ++i) {
                    if (this.children_[i] == null) continue;
                    this.children_[i].removeErrorListener(this.errorEventSupport_);
                    this.children_[i].removeVObjectListener(this.objectEventSupport_);
                    this.children_[i].removeWorkingListener(this.workingEventSupport_);
                }
            }
            this.children_ = null;
            this.loaded_ = true;
        }
        this.objectEventSupport_.fireObjectChanged(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFirst() {
        this.workingEventSupport_.fireStartWorking();
        Exception e = null;
        Object object = this.childrenLock_;
        synchronized (object) {
            if (this.children_ == null) {
                try {
                    this.jobList_.refreshContents();
                    this.jobList_.waitForComplete();
                    this.children_ = new VJob[(int)this.jobList_.getListLength()];
                }
                catch (Exception e2) {
                    e = e2;
                    this.children_ = new VJob[0];
                }
            }
        }
        if (e != null) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSingle(int index) {
        this.workingEventSupport_.fireStartWorking();
        Exception e = null;
        Object object = this.childrenLock_;
        synchronized (object) {
            if (this.children_[index] == null) {
                try {
                    RJob job = (RJob)this.jobList_.resourceAt(index);
                    this.children_[index] = new VJob((VNode)this, this.jobList_.getSystem(), job);
                    this.children_[index].addErrorListener(this.errorEventSupport_);
                    this.children_[index].addVObjectListener(this.objectEventSupport_);
                    this.children_[index].addWorkingListener(this.workingEventSupport_);
                    this.children_[index].load();
                }
                catch (Exception e2) {
                    e = e2;
                    this.children_ = new VJob[0];
                }
            }
        }
        if (e != null) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String oldValue = this.name_;
        this.vetoableChangeSupport_.fireVetoableChange("name", oldValue, name);
        this.name_ = name;
        try {
            this.jobList_.setSelectionValue("JOB_NAME", this.name_);
        }
        catch (ResourceException e) {
            this.errorEventSupport_.fireError(e);
        }
        this.propertyChangeSupport_.firePropertyChange("name", oldValue, name);
    }

    public void setNumber(String number) throws PropertyVetoException {
        if (number == null) {
            throw new NullPointerException("number");
        }
        String oldValue = this.number_;
        this.vetoableChangeSupport_.fireVetoableChange("number", oldValue, number);
        this.number_ = number;
        try {
            this.jobList_.setSelectionValue("JOB_NUMBER", this.number_);
        }
        catch (ResourceException e) {
            this.errorEventSupport_.fireError(e);
        }
        this.propertyChangeSupport_.firePropertyChange("number", oldValue, number);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 oldValue = this.jobList_.getSystem();
        this.vetoableChangeSupport_.fireVetoableChange("system", oldValue, system);
        this.jobList_.setSystem(system);
        this.propertyChangeSupport_.firePropertyChange("system", oldValue, system);
    }

    public void setUser(String user) throws PropertyVetoException {
        if (user == null) {
            throw new NullPointerException("user");
        }
        String oldValue = this.user_;
        this.vetoableChangeSupport_.fireVetoableChange("user", oldValue, user);
        this.user_ = user;
        try {
            this.jobList_.setSelectionValue("USER_NAME", this.user_);
        }
        catch (ResourceException e) {
            this.errorEventSupport_.fireError(e);
        }
        this.propertyChangeSupport_.firePropertyChange("user", oldValue, user);
    }

    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
        if (propertyIdentifiers == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (orders == null) {
            throw new NullPointerException("orders");
        }
    }

    public String toString() {
        return description_;
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int columnIndex = 0;
        VTableColumn nameColumn = new VTableColumn(columnIndex++, VJob.NAME_PROPERTY);
        nameColumn.setCellRenderer(new VObjectCellRenderer());
        nameColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        nameColumn.setHeaderValue(nameColumnHeader_);
        nameColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(nameColumn);
        VTableColumn userColumn = new VTableColumn(columnIndex++, VJob.USER_PROPERTY);
        userColumn.setCellRenderer(new VObjectCellRenderer());
        userColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        userColumn.setHeaderValue(userColumnHeader_);
        userColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(userColumn);
        VTableColumn typeColumn = new VTableColumn(columnIndex++, VJob.TYPE_PROPERTY);
        typeColumn.setCellRenderer(new VObjectCellRenderer());
        typeColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        typeColumn.setHeaderValue(typeColumnHeader_);
        typeColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(typeColumn);
        VTableColumn statusColumn = new VTableColumn(columnIndex++, VJob.STATUS_PROPERTY);
        statusColumn.setCellRenderer(new VObjectCellRenderer());
        statusColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        statusColumn.setHeaderValue(statusColumnHeader_);
        statusColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(statusColumn);
        VTableColumn numberColumn = new VTableColumn(columnIndex++, VJob.NUMBER_PROPERTY);
        numberColumn.setCellRenderer(new VObjectCellRenderer());
        numberColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        numberColumn.setHeaderValue(numberColumnHeader_);
        numberColumn.setPreferredCharWidth(6);
        detailsColumnModel_.addColumn(numberColumn);
    }
}

