/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageQueueClearAction;
import com.ibm.as400.vaccess.MessageQueuePropertiesPane;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VQueuedMessage;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VMessageQueue
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("MESSAGE_QUEUE_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VMessageList16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VMessageList32.gif", description_);
    private static String dateColumnHeader_ = ResourceLoader.getText("MESSAGE_DATE");
    private static String fromJobColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_JOB");
    private static String fromJobNumberColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_JOB_NUMBER");
    private static String fromProgramColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_PROGRAM");
    private static String fromUserColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_USER");
    private static String messageQueueColumnHeader_ = ResourceLoader.getText("MESSAGE_QUEUE");
    private static String nameColumnHeader_ = ResourceLoader.getText("MESSAGE_ID");
    private static String textColumnHeader_ = ResourceLoader.getText("MESSAGE_TEXT");
    private static String typeColumnHeader_ = ResourceLoader.getText("MESSAGE_TYPE");
    private static String severityColumnHeader_ = ResourceLoader.getText("MESSAGE_SEVERITY");
    private VNode parent_ = null;
    private MessageQueue queue_ = null;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VAction[] actions_;
    transient VObject[] detailsChildren_;
    private transient Enumeration enum_;
    private transient int loaded_;
    private transient VPropertiesPane propertiesPane_;
    transient ErrorEventSupport errorEventSupport_;
    transient VObjectEventSupport objectEventSupport_;
    transient VObjectListener_ objectListener_;
    transient PropertyChangeSupport propertyChangeSupport_;
    transient VetoableChangeSupport vetoableChangeSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public VMessageQueue() {
        this.queue_ = new MessageQueue();
        this.initializeTransient();
    }

    public VMessageQueue(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.queue_ = new MessageQueue(system);
        this.initializeTransient();
    }

    public VMessageQueue(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.queue_ = new MessageQueue(system, path);
        this.initializeTransient();
    }

    public VMessageQueue(VNode parent, AS400 system, String path) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.parent_ = parent;
        this.queue_ = new MessageQueue(system, path);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return this.actions_;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int index) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int index) {
        if (index < 0 || index >= this.detailsChildren_.length) {
            return null;
        }
        this.loadMore(index);
        return this.detailsChildren_[index];
    }

    public synchronized int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public synchronized int getDetailsIndex(VObject detailsChild) {
        for (int i = 0; i < this.loaded_; ++i) {
            if (this.detailsChildren_[i] != detailsChild) continue;
            return i;
        }
        return -1;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode child) {
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public String getPath() {
        return this.queue_.getPath();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public String getSelection() {
        return this.queue_.getSelection();
    }

    public int getSeverity() {
        return this.queue_.getSeverity();
    }

    public AS400 getSystem() {
        return this.queue_.getSystem();
    }

    public String getText() {
        String pathName = this.queue_.getPath();
        if (pathName.equals("*CURRENT")) {
            AS400 system = this.queue_.getSystem();
            if (system != null) {
                return system.getUserId();
            }
            return "";
        }
        QSYSObjectPathName path = new QSYSObjectPathName(pathName);
        return path.getObjectName();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.queue_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.queue_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.detailsChildren_ = new VObject[0];
        this.enum_ = null;
        this.loaded_ = -1;
        this.actions_ = new VAction[]{new MessageQueueClearAction(this, this.queue_)};
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addVObjectListener(this.objectListener_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new MessageQueuePropertiesPane(this);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectListener_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Loading messages from message queue " + this + ".");
        }
        this.workingEventSupport_.fireStartWorking();
        Exception error = null;
        try {
            this.enum_ = this.queue_.getMessages();
        }
        catch (Exception e) {
            error = e;
        }
        VMessageQueue vMessageQueue = this;
        synchronized (vMessageQueue) {
            for (int i = 0; i < this.loaded_; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectListener_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = 0;
            this.detailsChildren_ = error == null ? new VQueuedMessage[this.queue_.getLength()] : new VQueuedMessage[0];
        }
        if (error != null) {
            this.errorEventSupport_.fireError(error);
        }
        this.objectEventSupport_.fireObjectChanged(this, true);
        this.workingEventSupport_.fireStopWorking();
    }

    private void loadMore(int index) {
        if (index >= this.loaded_) {
            this.workingEventSupport_.fireStartWorking();
            Exception error = null;
            for (int i = this.loaded_; i <= index; ++i) {
                QueuedMessage message = (QueuedMessage)this.enum_.nextElement();
                this.detailsChildren_[i] = new VQueuedMessage(message, this.queue_);
                this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectListener_);
                this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = index + 1;
            if (error != null) {
                this.errorEventSupport_.fireError(error);
            }
            this.workingEventSupport_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.queue_.setPath(path);
    }

    public void setSelection(String selection) throws PropertyVetoException {
        if (selection == null) {
            throw new NullPointerException("selection");
        }
        this.queue_.setSelection(selection);
    }

    public void setSeverity(int severity) throws PropertyVetoException {
        this.queue_.setSeverity(severity);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.queue_.setSystem(system);
    }

    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
    }

    public String toString() {
        return this.getText();
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int columnIndex = 0;
        VTableColumn nameColumn = new VTableColumn(columnIndex++, VQueuedMessage.NAME_PROPERTY);
        nameColumn.setCellRenderer(new VObjectCellRenderer());
        nameColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        nameColumn.setHeaderValue(nameColumnHeader_);
        nameColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(nameColumn);
        VTableColumn textColumn = new VTableColumn(columnIndex++, VQueuedMessage.TEXT_PROPERTY);
        textColumn.setCellRenderer(new VObjectCellRenderer());
        textColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        textColumn.setHeaderValue(textColumnHeader_);
        textColumn.setPreferredCharWidth(40);
        detailsColumnModel_.addColumn(textColumn);
        VTableColumn severityColumn = new VTableColumn(columnIndex++, VQueuedMessage.SEVERITY_PROPERTY);
        severityColumn.setCellRenderer(new VObjectCellRenderer(4));
        severityColumn.setHeaderRenderer(new VObjectHeaderRenderer(4));
        severityColumn.setHeaderValue(severityColumnHeader_);
        severityColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(severityColumn);
        VTableColumn typeColumn = new VTableColumn(columnIndex++, VQueuedMessage.TYPE_PROPERTY);
        typeColumn.setCellRenderer(new VObjectCellRenderer());
        typeColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        typeColumn.setHeaderValue(typeColumnHeader_);
        typeColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(typeColumn);
        VTableColumn dateColumn = new VTableColumn(columnIndex++, VQueuedMessage.DATE_PROPERTY);
        dateColumn.setCellRenderer(new VObjectCellRenderer());
        dateColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        dateColumn.setHeaderValue(dateColumnHeader_);
        dateColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(dateColumn);
        VTableColumn fromJobColumn = new VTableColumn(columnIndex++, VQueuedMessage.FROM_JOB_PROPERTY);
        fromJobColumn.setCellRenderer(new VObjectCellRenderer());
        fromJobColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        fromJobColumn.setHeaderValue(fromJobColumnHeader_);
        fromJobColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(fromJobColumn);
        VTableColumn fromUserColumn = new VTableColumn(columnIndex++, VQueuedMessage.FROM_USER_PROPERTY);
        fromUserColumn.setCellRenderer(new VObjectCellRenderer());
        fromUserColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        fromUserColumn.setHeaderValue(fromUserColumnHeader_);
        fromUserColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(fromUserColumn);
        VTableColumn fromJobNumberColumn = new VTableColumn(columnIndex++, VQueuedMessage.FROM_JOB_NUMBER_PROPERTY);
        fromJobNumberColumn.setCellRenderer(new VObjectCellRenderer());
        fromJobNumberColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        fromJobNumberColumn.setHeaderValue(fromJobNumberColumnHeader_);
        fromJobNumberColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(fromJobNumberColumn);
        VTableColumn fromProgramColumn = new VTableColumn(columnIndex++, VQueuedMessage.FROM_PROGRAM_PROPERTY);
        fromProgramColumn.setCellRenderer(new VObjectCellRenderer());
        fromProgramColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        fromProgramColumn.setHeaderValue(fromProgramColumnHeader_);
        fromProgramColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(fromProgramColumn);
        VTableColumn messageQueueColumn = new VTableColumn(columnIndex++, VQueuedMessage.MESSAGE_QUEUE_PROPERTY);
        messageQueueColumn.setCellRenderer(new VObjectCellRenderer());
        messageQueueColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        messageQueueColumn.setHeaderValue(messageQueueColumnHeader_);
        messageQueueColumn.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(messageQueueColumn);
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent event) {
        }

        public void objectCreated(VObjectEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectDeleted(VObjectEvent event) {
            VObject object = event.getObject();
            VMessageQueue.this.objectEventSupport_.objectDeleted(event);
            VMessageQueue vMessageQueue = VMessageQueue.this;
            synchronized (vMessageQueue) {
                int index = VMessageQueue.this.getDetailsIndex(object);
                if (index >= 0) {
                    VObject[] oldDetailsChildren = VMessageQueue.this.detailsChildren_;
                    int count = VMessageQueue.this.detailsChildren_.length;
                    VMessageQueue.this.detailsChildren_ = new VObject[count - 1];
                    System.arraycopy(oldDetailsChildren, 0, VMessageQueue.this.detailsChildren_, 0, index);
                    System.arraycopy(oldDetailsChildren, index + 1, VMessageQueue.this.detailsChildren_, index, count - index - 1);
                    --VMessageQueue.this.loaded_;
                }
            }
            object.removeErrorListener(VMessageQueue.this.errorEventSupport_);
            object.removeVObjectListener(VMessageQueue.this.objectEventSupport_);
            object.removeVObjectListener(VMessageQueue.this.objectListener_);
            object.removeWorkingListener(VMessageQueue.this.workingEventSupport_);
        }
    }
}

