/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.VObject;
import java.awt.Component;
import java.io.Serializable;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class VObjectCellRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
TreeCellRenderer,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static DateFormat dateTimeFormat_ = DateFormat.getDateTimeInstance();
    private static DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static DateFormat timeFormat_ = DateFormat.getTimeInstance();
    private static EmptyBorder emptyBorder_ = new EmptyBorder(1, 2, 1, 2);
    private static EmptyBorder emptyBorder2_ = new EmptyBorder(0, 5, 0, 5);

    public VObjectCellRenderer() {
        this.initialize();
        this.setHorizontalAlignment(2);
    }

    public VObjectCellRenderer(int horizontalAlignment) {
        this.initialize();
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public Component getListCellRendererComponent(JList list, Object value, int rowIndex, boolean selected, boolean hasFocus) {
        this.normalize(value, false);
        if (selected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder(list.getForeground()));
        } else {
            this.setBorder(emptyBorder_);
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int rowIndex, int columnIndex) {
        this.normalize(value, false);
        if (selected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder(table.getForeground()));
        } else {
            this.setBorder(emptyBorder_);
        }
        return this;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int index, boolean hasFocus) {
        this.normalize(value, false);
        if (selected) {
            this.setForeground(tree.getBackground());
            this.setBackground(tree.getForeground());
            if (hasFocus) {
                this.setBorder(new LineBorder(tree.getForeground()));
            } else {
                this.setBorder(emptyBorder_);
            }
        } else {
            this.setBorder(emptyBorder_);
            this.setForeground(tree.getForeground());
            this.setBackground(tree.getBackground());
        }
        return this;
    }

    private void initialize() {
        this.setBorder(emptyBorder2_);
        this.setOpaque(true);
    }

    private void normalize(Object value, boolean open) {
        if (value instanceof VObject) {
            VObject object = (VObject)value;
            this.setText(object.getText());
            this.setIcon(object.getIcon(16, open));
        } else if (value instanceof java.sql.Date) {
            this.setText(dateFormat_.format((Date)value));
            this.setIcon(null);
        } else if (value instanceof Time) {
            this.setText(timeFormat_.format((Date)value));
            this.setIcon(null);
        } else if (value instanceof Date) {
            this.setText(dateTimeFormat_.format((Date)value));
            this.setIcon(null);
        } else if (value instanceof PermissionNameCellObject) {
            this.setText(((PermissionNameCellObject)value).getText());
            this.setIcon(((PermissionNameCellObject)value).getIcon(16, open));
        } else if (value != null) {
            this.setText(value.toString());
            this.setIcon(null);
        } else {
            this.setText(null);
            this.setIcon(null);
        }
    }

    static {
        dateTimeFormat_.setTimeZone(TimeZone.getDefault());
        dateFormat_.setTimeZone(TimeZone.getDefault());
        timeFormat_.setTimeZone(TimeZone.getDefault());
    }
}

