/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.PrinterList;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PrintersPropertiesPane;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPrinter;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VPrinters
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getPrintText("AS400_PRINTERS");
    private static String descriptionColumnHeader_ = ResourceLoader.getPrintText("DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VPrinters16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VPrinters32.gif", description_);
    private static String name_ = ResourceLoader.getPrintText("PRINTERS");
    private static String outputQueueColumnHeader_ = ResourceLoader.getPrintText("OUTPUT_QUEUE");
    private static String printerColumnHeader_ = ResourceLoader.getPrintText("PRINTER");
    private static String statusColumnHeader_ = ResourceLoader.getPrintText("STATUS");
    private static TableColumnModel detailsColumnModel_ = null;
    private static Object detailsColumnModelLock_ = new Object();
    private static final int dfltPrinterColWidth = 15;
    private static final int dfltStatusColWidth = 25;
    private static final int dfltDescriptionColWidth = 25;
    private static final int dfltOutputQueueColWidth = 12;
    private static int[] attrsToRetrieve = new int[]{10, 190, 12, 191, 109, 199, 40, 42, 89, 44, 48, -5, -6, 75, 200, 90, 197, 120, 121, 122, 123, 124, 193, 187, 202, 208, 204, 209, 207, 206, 203, 201, 205};
    private PrinterList list_ = null;
    private transient VObject[] children_;
    private transient boolean childrenLoaded_;
    private transient boolean childrenLoading_;
    private transient VNode parent_;
    private transient VPropertiesPane propertiesPane_;
    private transient VPrinters thisPointer_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VPrinters() {
        this.list_ = new PrinterList();
        this.parent_ = null;
        this.initializeTransient();
    }

    public VPrinters(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.list_ = new PrinterList(system);
        this.parent_ = null;
        this.initializeTransient();
    }

    public VPrinters(VNode parent, AS400 system) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.list_ = new PrinterList(system);
        this.parent_ = parent;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public synchronized TreeNode getChildAt(int index) {
        this.updateChildren();
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return (TreeNode)((Object)this.children_[index]);
    }

    public synchronized int getChildCount() {
        this.updateChildren();
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public synchronized VObject getDetailsChildAt(int index) {
        this.updateChildren();
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return this.children_[index];
    }

    public int getDetailsChildCount() {
        this.updateChildren();
        return this.children_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableColumnModel getDetailsColumnModel() {
        Object object = detailsColumnModelLock_;
        synchronized (object) {
            if (detailsColumnModel_ == null) {
                detailsColumnModel_ = new DefaultTableColumnModel();
                VTableColumn printerColumn = new VTableColumn(0, VPrinter.PRINTER_PROPERTY);
                printerColumn.setCellRenderer(new VObjectCellRenderer());
                printerColumn.setHeaderRenderer(new VObjectHeaderRenderer());
                printerColumn.setHeaderValue(printerColumnHeader_);
                int iLen = printerColumnHeader_.length();
                if (iLen < 15) {
                    iLen = 15;
                }
                printerColumn.setPreferredCharWidth(iLen);
                detailsColumnModel_.addColumn(printerColumn);
                VTableColumn statusColumn = new VTableColumn(1, VPrinter.STATUS_PROPERTY);
                statusColumn.setCellRenderer(new VObjectCellRenderer());
                statusColumn.setHeaderRenderer(new VObjectHeaderRenderer());
                statusColumn.setHeaderValue(statusColumnHeader_);
                iLen = statusColumnHeader_.length();
                if (iLen < 25) {
                    iLen = 25;
                }
                statusColumn.setPreferredCharWidth(iLen);
                detailsColumnModel_.addColumn(statusColumn);
                VTableColumn descriptionColumn = new VTableColumn(2, VPrinter.DESCRIPTION_PROPERTY);
                descriptionColumn.setCellRenderer(new VObjectCellRenderer());
                descriptionColumn.setHeaderRenderer(new VObjectHeaderRenderer());
                descriptionColumn.setHeaderValue(descriptionColumnHeader_);
                iLen = descriptionColumnHeader_.length();
                if (iLen < 25) {
                    iLen = 25;
                }
                descriptionColumn.setPreferredCharWidth(iLen);
                detailsColumnModel_.addColumn(descriptionColumn);
                VTableColumn outputQueueColumn = new VTableColumn(3, VPrinter.OUTPUTQUEUE_PROPERTY);
                outputQueueColumn.setCellRenderer(new VObjectCellRenderer());
                outputQueueColumn.setHeaderRenderer(new VObjectHeaderRenderer());
                outputQueueColumn.setHeaderValue(outputQueueColumnHeader_);
                iLen = outputQueueColumnHeader_.length();
                if (iLen < 12) {
                    iLen = 12;
                }
                outputQueueColumn.setPreferredCharWidth(iLen);
                detailsColumnModel_.addColumn(outputQueueColumn);
            }
        }
        return detailsColumnModel_;
    }

    public synchronized int getDetailsIndex(VObject detailsChild) {
        this.updateChildren();
        for (int i = 0; i < this.children_.length; ++i) {
            if (this.children_[i] != detailsChild) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public synchronized int getIndex(TreeNode child) {
        this.updateChildren();
        for (int i = 0; i < this.children_.length; ++i) {
            if (this.children_[i] != child) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public String getPrinterFilter() {
        return this.list_.getPrinterFilter();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public synchronized Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.list_.getSystem();
    }

    public String getText() {
        return name_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.children_ = new VNode[0];
        this.propertiesPane_ = new PrintersPropertiesPane(this, this.list_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.thisPointer_ = this;
        this.childrenLoaded_ = true;
        this.childrenLoading_ = false;
        this.list_.setAttributesToRetrieve(attrsToRetrieve);
        this.list_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.list_.addVetoableChangeListener(this.vetoableChangeSupport_);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isSortable() {
        return false;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        this.childrenLoaded_ = false;
        this.workingEventSupport_.fireStopWorking();
    }

    private void loadChildren() throws Exception {
        if (!this.childrenLoading_) {
            this.childrenLoading_ = true;
            if (this.children_ != null) {
                for (int i = 0; i < this.children_.length; ++i) {
                    this.children_[i].removeErrorListener(this.errorEventSupport_);
                    this.children_[i].removeVObjectListener(this.objectEventSupport_);
                    this.children_[i].removeWorkingListener(this.workingEventSupport_);
                }
            }
            this.list_.openSynchronously();
            int listSize = this.list_.size();
            if (Trace.isTraceOn()) {
                Trace.log(3, "ListSize:" + listSize);
            }
            this.children_ = new VObject[listSize];
            Printer prtD = null;
            VPrinter child = null;
            for (int i = 0; i < listSize; ++i) {
                prtD = (Printer)this.list_.getObject(i);
                child = new VPrinter(this.thisPointer_, prtD);
                this.children_[i] = child;
                child.addErrorListener(this.errorEventSupport_);
                child.addVObjectListener(this.objectEventSupport_);
                child.addWorkingListener(this.workingEventSupport_);
            }
            this.list_.close();
            this.childrenLoaded_ = true;
            this.childrenLoading_ = false;
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setPrinterFilter(String printerFilter) throws PropertyVetoException {
        this.list_.setPrinterFilter(printerFilter);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        this.list_.setSystem(system);
    }

    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
    }

    public String toString() {
        return name_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChildren() {
        if (!this.childrenLoaded_) {
            try {
                try {
                    this.workingEventSupport_.fireStartWorking();
                    this.loadChildren();
                }
                catch (Exception e) {
                    this.errorEventSupport_.fireError(e);
                    Object var3_2 = null;
                    this.workingEventSupport_.fireStopWorking();
                }
                Object var3_1 = null;
                this.workingEventSupport_.fireStopWorking();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.workingEventSupport_.fireStopWorking();
                throw throwable;
            }
        }
    }
}

