/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemValue;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class VSystemValueDetailsPropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VSystemValue object_;
    private SystemValue systemValue_;
    private ChangeEventSupport changeEventSupport_;
    private ErrorEventSupport errorEventSupport_;
    private VObjectEventSupport objectEventSupport_;
    private WorkingEventSupport workingEventSupport_;
    private static final String valueDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION") + ": ";
    private static final String valueInformation_ = ResourceLoader.getText("COLUMN_VALUE") + ": ";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static DateFormat timeFormat_ = DateFormat.getTimeInstance();

    public VSystemValueDetailsPropertiesPane(VSystemValue vSystemValue, SystemValue systemValue) {
        if (systemValue != null) {
            this.systemValue_ = systemValue;
        }
        this.changeEventSupport_ = new ChangeEventSupport(this);
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.object_ = vSystemValue;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void applyChanges() throws Exception {
    }

    private Component getArrayTab() {
        JPanel generalTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        generalTab.setLayout(layout);
        generalTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), generalTab, layout, 0, row++, 2, 1);
        VUtilities.constrain(valueDescription_, this.object_.getDescription(), generalTab, layout, row++);
        try {
            Object[] objs = (Object[])this.systemValue_.getValue();
            int count = objs.length;
            String[] values = new String[count];
            for (int i = 0; i < count; ++i) {
                values[i] = (String)objs[i];
            }
            VUtilities.constrain(new JLabel(valueInformation_), new JList<String>(values), generalTab, layout, row++);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return generalTab;
    }

    public Component getComponent() {
        JTabbedPane pane = new JTabbedPane();
        switch (this.systemValue_.getType()) {
            case 1: 
            case 2: 
            case 3: {
                pane.addTab(generalTabText_, this.getDisplayTab());
                break;
            }
            case 4: {
                pane.addTab(generalTabText_, this.getArrayTab());
                break;
            }
            case 5: {
                pane.addTab(generalTabText_, this.getDateTab());
            }
        }
        pane.setSelectedIndex(0);
        return pane;
    }

    private Component getDateTab() {
        JPanel generalTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        generalTab.setLayout(layout);
        generalTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        DateFormat formatter = null;
        if (this.systemValue_.getName().equals("QDATE")) {
            formatter = dateFormat_;
        } else if (this.systemValue_.getName().equals("QTIME")) {
            formatter = timeFormat_;
        } else {
            Trace.log(2, "Unexpected system value name: " + this.systemValue_.getName());
            formatter = timeFormat_;
        }
        int row = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), generalTab, layout, 0, row++, 2, 1);
        VUtilities.constrain(valueDescription_, this.object_.getDescription(), generalTab, layout, row++);
        try {
            VUtilities.constrain(valueInformation_, formatter.format(this.systemValue_.getValue()), generalTab, layout, row++);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return generalTab;
    }

    private Component getDisplayTab() {
        JPanel generalTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        generalTab.setLayout(layout);
        generalTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), generalTab, layout, 0, row++, 2, 1);
        VUtilities.constrain(valueDescription_, this.object_.getDescription(), generalTab, layout, row++);
        VUtilities.constrain(valueInformation_, this.object_.getValue().toString(), generalTab, layout, row++);
        return generalTab;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
        timeFormat_.setTimeZone(TimeZone.getDefault());
    }
}

